package Locales::DB::Language::bn;

# Auto generated from CLDR

$Locales::DB::Language::bn::VERSION = '0.06';

$Locales::DB::Language::bn::cldr_version = '1.7.2';

%Locales::DB::Language::bn::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#\,\#\#0\.\#\#\#",
        'language'                => "ভাষা\:\ \{0\}",
        'locale'                  => "\{0\}\ \(\{1\}\)",
        'percent'                 => "\#\,\#\#\,\#\#0\%",
        'territory'               => "অঞ্চল\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => 'না',
        'yesstr' => 'হাঁ'
    },
);

%Locales::DB::Language::bn::code_to_name = (
    'aa'    => 'আফার',
    'ab'    => 'অ্যাবকেজিয়ান',
    'ace'   => 'আচাইনিজ',
    'ach'   => 'আকোলী',
    'ada'   => 'আদাংমে',
    'ady'   => 'এ্যাডাইঘে',
    'ae'    => 'আবেস্তান',
    'af'    => 'আফ্রিকান্স',
    'afa'   => "অফ্রো\-এশিয়াটিক\ ভাষা",
    'afh'   => 'আফ্রিহিলি',
    'ain'   => 'আইনু',
    'ak'    => 'আকান',
    'akk'   => 'আক্কাদিয়ান',
    'ale'   => 'এলেউট',
    'alg'   => "আলগোঙকুইআন\ ভাযা",
    'alt'   => "দক্ষিণাঞ্চলীয়\ আলতাই",
    'am'    => 'আমহারিক',
    'an'    => 'আরাগোনিজ',
    'ang'   => "প্রাচীন\ ইংরেজী",
    'anp'   => 'অঙ্গিকা',
    'apa'   => "অ্যাপাচি\ ভাযা",
    'ar'    => 'আব়বি',
    'arc'   => 'আরামাইক',
    'arn'   => 'অ্যারকেনিয়ান',
    'arp'   => 'আরাপাহো',
    'art'   => "কৃত্রিম\ ভাযা",
    'arw'   => 'আরাওয়াক',
    'as'    => 'অসমীয়া',
    'ast'   => 'আস্তুরিয়ান',
    'ath'   => "আথাপাস্কান\ ভাষা",
    'aus'   => "অস্ট্রেলিয়\ ভাযা",
    'av'    => 'আভেরিক',
    'awa'   => 'অবধী',
    'ay'    => 'আয়মারা',
    'az'    => 'আজারবাইজানি',
    'ba'    => 'বাশকির',
    'bad'   => 'বান্দা',
    'bai'   => "বামিলেকে\ ভাষা",
    'bal'   => 'বেলুচী',
    'ban'   => 'বালিনীস',
    'bas'   => 'বাসা',
    'bat'   => "বাল্টিক\ ভাষা",
    'be'    => 'বেলারুশিয়ান',
    'bej'   => 'বেজা',
    'bem'   => 'বেম্বা',
    'ber'   => 'বেরবের',
    'bg'    => 'বুলগেরিয়ান',
    'bh'    => 'বিহারি',
    'bho'   => 'ভোজপুরি',
    'bi'    => 'বিসলামা',
    'bik'   => 'বিকোল',
    'bin'   => 'বিনি',
    'bla'   => 'সিকসিকা',
    'bm'    => 'বামবারা',
    'bn'    => 'বাংলা',
    'bnt'   => 'বান্টু',
    'bo'    => 'তিব্বতি',
    'br'    => 'ব্রেটোন',
    'bra'   => 'ব্রাজ',
    'bs'    => 'বসনীয়ান',
    'btk'   => 'বাটাক',
    'bua'   => 'বুরিয়াত',
    'bug'   => 'বাগিনিজ',
    'byn'   => 'ব্লিন',
    'ca'    => 'ক্যাটালান',
    'cad'   => 'কাড্ডো',
    'cai'   => "মধ্য\ আমেরিকান\ ইন্ডিয়ান\ ভাষা",
    'car'   => 'ক্যারিব',
    'cau'   => "ককেশীয়ান\ ভাষা",
    'cch'   => 'আত্সাম',
    'ce'    => 'চেচেন',
    'ceb'   => 'সেবুয়ানো',
    'cel'   => 'কেলটিক',
    'ch'    => 'চ্যামোর্রো',
    'chb'   => 'চিবচা',
    'chg'   => 'চ্যাগাতাই',
    'chk'   => 'চুকিসে',
    'chm'   => 'মারি',
    'chn'   => "চিনুক\ জারগন",
    'cho'   => 'চোক্টাও',
    'chp'   => 'চিপেওয়ান',
    'chr'   => 'চেরোকি',
    'chy'   => 'চেয়েনি',
    'cmc'   => "চামিক\ ভাষা",
    'co'    => 'কোর্সিকান',
    'cop'   => 'কোপটিক',
    'cpe'   => "ইংরেজি\ ভিত্তিক\ ক্রেওল\ অথবা\ পিজিন",
    'cpf'   => "ফরাসি\ ভিত্তিক\ ক্রেওল\ অথবা\ পিজিন",
    'cpp'   => "পোর্তুগিজ\-ভিত্তিক\ ক্রেওল\ বা\ পিজন",
    'cr'    => 'ক্রি',
    'crh'   => "ক্রিমিয়ান\ তুর্কি",
    'crp'   => "ক্রেওল\ অথবা\ পিজিন",
    'cs'    => 'চেক',
    'csb'   => 'কাশুবিয়ান',
    'cu'    => "চার্চ\ স্লাভিক",
    'cus'   => "কুশিতিক\ ভাষা",
    'cv'    => 'চুভাশ',
    'cy'    => 'ওয়েলশ',
    'da'    => 'ডেনিশ',
    'dak'   => 'ডাকোটা',
    'dar'   => 'দার্গওয়া',
    'day'   => 'ডায়াক',
    'de'    => 'জার্মান',
    'de_at' => "অস্ট্রিয়ান\ জার্মানি",
    'de_ch' => "সুইস\ উচ্চ\ জার্মানি",
    'del'   => 'ডেলাওয়ারে',
    'den'   => 'স্ল্যাভ',
    'dgr'   => 'দোগ্রীব',
    'din'   => 'ডিঙ্কা',
    'doi'   => 'ডোগরি',
    'dra'   => "দ্রাবীড়\ ভাষা",
    'dsb'   => "লোয়ার\ সোর্বিয়ান",
    'dua'   => 'দুয়ালা',
    'dum'   => "মধ্য\ ডাচ",
    'dv'    => 'দিবেহি',
    'dyu'   => 'ডিউলা',
    'dz'    => '‌জোঙ্খা',
    'ee'    => 'ইওয়ে',
    'efi'   => 'এফিক',
    'egy'   => "প্রাচীন\ মিশরীয়",
    'eka'   => 'একাজুক',
    'el'    => 'গ্রিক',
    'elx'   => 'এলামাইট',
    'en'    => 'ইংরেজি',
    'en_au' => "অস্ট্রেলীয়\ ইংরেজি",
    'en_ca' => "কানাডীয়\ ইংরেজি",
    'en_gb' => "ব্রিটিশ\ ইংরেজি",
    'en_us' => "যুক্তরাষ্ট্র\ ইংরেজি",
    'enm'   => "মধ্য\ ইংরেজি",
    'eo'    => 'এস্পেরান্তো',
    'es'    => 'স্পেনীয়',
    'es_es' => "আইবেরিয়ান\ স্প্যানিশ",
    'et'    => 'এস্তোনিয়ান',
    'eu'    => 'বাস্ক',
    'ewo'   => 'ইয়োন্ডো',
    'fa'    => 'ফার্সি',
    'fan'   => 'ফ্যাঙ',
    'fat'   => 'ফান্তি',
    'ff'    => 'ফুলা',
    'fi'    => 'ফিনিশ',
    'fil'   => 'ফিলিপিনো',
    'fiu'   => "ফিনো\-উগ্রিয়ান\ ভাষা",
    'fj'    => 'ফিজি',
    'fo'    => 'ফ্যারোয়েজ',
    'fon'   => 'ফোন',
    'fr'    => 'ফরাসি',
    'fr_ca' => "কানাডীয়\ ফরাসি",
    'fr_ch' => "সুইস\ ফরাসি",
    'frm'   => "মধ্য\ ফরাসি",
    'fro'   => "প্রাচীন\ ফরাসি",
    'frr'   => "উত্তরাঞ্চলীয়\ ফ্রিসিয়ান",
    'frs'   => "পূর্ব\ ফ্রিসিয়ান",
    'fur'   => 'ফ্রিউলিয়ান',
    'fy'    => "পশ্চিম\ ফ্রিসিয়ান",
    'ga'    => 'আইরিশ',
    'gaa'   => 'গা',
    'gay'   => 'গায়ো',
    'gba'   => 'গ্‌বায়া',
    'gd'    => "স্কটস\-গ্যেলিক",
    'gem'   => "জার্মানিক\ ভাষা",
    'gez'   => 'গিজ',
    'gil'   => 'গিলবার্টিজ',
    'gl'    => 'গ্যালিসিয়ান',
    'gmh'   => "মিডল\ হাই\ জার্মানি",
    'gn'    => 'গুয়ারানি',
    'goh'   => "প্রাচীন\ হাই\ জার্মানি",
    'gon'   => 'গোন্ডি',
    'gor'   => 'গোরোন্টালো',
    'got'   => 'গথিক',
    'grb'   => 'গ্রেবো',
    'grc'   => "প্রাচীন\ গ্রীক",
    'gsw'   => "সুইস\ জার্মান",
    'gu'    => 'গুজরাটি',
    'gv'    => 'ম্যাঙ্কস',
    'gwi'   => 'গওইচ্’ইন',
    'ha'    => 'হাউসা',
    'hai'   => 'হাইডা',
    'haw'   => 'হাওয়াইয়ান',
    'he'    => 'হিব্রু',
    'hi'    => 'হিন্দি',
    'hil'   => 'হিলিগ্যায়নোন',
    'him'   => 'হিমাচালি',
    'hit'   => 'হিট্টাইট',
    'hmn'   => 'মঙো',
    'ho'    => "হিরি\ মোতু",
    'hr'    => 'ক্রোয়েশিয়ান',
    'hsb'   => "উচ্চ\ সোর্বিয়ান",
    'ht'    => 'হেইশন',
    'hu'    => 'হাঙ্গেরিয়ান',
    'hup'   => 'হুপা',
    'hy'    => 'আর্মেনিয়ান',
    'hz'    => 'হেরেরো',
    'ia'    => "আন্তর্জাতিক\-ভাষা",
    'iba'   => 'ইবান',
    'id'    => 'ইন্দোনেশিয়ান',
    'ie'    => 'ইন্টারলিঙ্গ',
    'ig'    => 'ইগ্‌বো',
    'ii'    => "সিচুয়ান\ য়ি",
    'ijo'   => 'ইজো',
    'ik'    => 'ইনুপিয়াক',
    'ilo'   => 'ইলোকো',
    'inc'   => "ভারতীয়\ ভাষা",
    'ine'   => "ইন্দো\-ইউরোপীয়\ ভাষা",
    'inh'   => 'ইঙ্গুশ',
    'io'    => 'ইডো',
    'ira'   => "ইরানী\ ভাষা",
    'iro'   => "ইরোকোইয়ান\ ভাষা",
    'is'    => 'আইসল্যান্ডিক',
    'it'    => 'ইতালিয়ান',
    'iu'    => 'ইনুক্টিটুট',
    'ja'    => 'জাপানি',
    'jbo'   => 'লোজবান',
    'jpr'   => "জুদেও\ ফার্সি",
    'jrb'   => "জুদেও\ আরবি",
    'jv'    => 'জাভানিজ',
    'ka'    => 'জর্জিয়ান',
    'kaa'   => "কারা\-কাল্পাক",
    'kab'   => 'কাবাইল',
    'kac'   => 'কাচিন',
    'kaj'   => 'জ্‌জু',
    'kam'   => 'কাম্বা',
    'kar'   => 'কারেন',
    'kaw'   => 'কাউই',
    'kbd'   => 'কাবার্ডিয়ান',
    'kcg'   => 'টিয়াপ',
    'kfo'   => 'কোরো',
    'kg'    => 'কোঙ্গো',
    'kha'   => 'খাশি',
    'khi'   => "খোয়িশান\ ভাষা",
    'kho'   => 'খোটানিজ',
    'ki'    => 'কিকু্ইয়ু',
    'kj'    => 'কোয়ানিয়ামা',
    'kk'    => 'কাজাখ',
    'kl'    => 'ক্যালাল্লিসুট',
    'km'    => 'খমের',
    'kmb'   => 'কিম্বুন্দু',
    'kn'    => 'কানাড়া',
    'ko'    => 'কোরিয়ান',
    'kok'   => 'কোঙ্কানি',
    'kos'   => 'কোস্রাইয়ান',
    'kpe'   => 'ক্‌পেল্লে',
    'kr'    => 'কানুরি',
    'krc'   => "কারচে\-বাল্কার",
    'krl'   => 'কারেলিয়ান',
    'kro'   => 'ক্রু',
    'kru'   => 'কুরুখ',
    'ks'    => 'কাশ্মীরি',
    'ku'    => 'কুর্দিশ',
    'kum'   => 'কুমিক',
    'kut'   => 'কুটেনাই',
    'kv'    => 'কোমি',
    'kw'    => 'কোর্নিশ',
    'ky'    => 'কির্‌ঘিজ',
    'la'    => 'লাটিন',
    'lad'   => 'ল্যাডিনো',
    'lah'   => 'লান্ডা',
    'lam'   => 'লাম্বা',
    'lb'    => 'লুক্সেমবার্গীস',
    'lez'   => 'লেজঘিয়ান',
    'lg'    => 'গন্ডা',
    'li'    => 'লিম্বুর্গিশ',
    'ln'    => 'লিঙ্গালা',
    'lo'    => 'লাও',
    'lol'   => 'মোঙ্গো',
    'loz'   => 'লোজি',
    'lt'    => 'লিথুনিয়ান',
    'lu'    => "লুবা\-কাটাঙ্গা",
    'lua'   => "লুবা\-লুলুয়া",
    'lui'   => 'লুইসেনো',
    'lun'   => 'লুন্ডা',
    'luo'   => 'লুয়ো',
    'lus'   => 'লুশাই',
    'lv'    => 'ল্যাটভিয়ান',
    'mad'   => 'মাদুরেসে',
    'mag'   => 'মাগাহি',
    'mai'   => 'মৈথিলি',
    'mak'   => 'ম্যাকাসার',
    'man'   => 'ম্যান্ডিঙ্গো',
    'map'   => 'অস্ট্রোনেশীয়ান',
    'mas'   => 'মাসাই',
    'mdf'   => 'মোকশা',
    'mdr'   => 'ম্যান্ডার',
    'men'   => 'মেন্ডে',
    'mfe'   => 'Morisyen',
    'mg'    => 'মালাগাছি',
    'mga'   => "মধ্য\ আইরিশ",
    'mh'    => 'মার্শালিজ',
    'mi'    => 'মাওরি',
    'mic'   => 'মিকম্যাক',
    'min'   => 'মিনাঙ্কাবাউ',
    'mis'   => "বিবিধ\ ভাষা",
    'mk'    => 'ম্যাসেডোনীয়',
    'mkh'   => "মন\-খমের\ ভাষা",
    'ml'    => 'মালায়ালাম',
    'mn'    => 'মঙ্গোলিয়ান',
    'mnc'   => 'মাঞ্চু',
    'mni'   => 'মণিপুরী',
    'mno'   => "ম্যানোবো\ ভাষা",
    'mo'    => 'মলদাভিয়',
    'moh'   => 'মোহাওক',
    'mos'   => 'মসি',
    'mr'    => 'মারাঠি',
    'ms'    => 'মালয়',
    'mt'    => 'মাল্টিজ',
    'mul'   => "বহুগুণিতক\ ভাষাসমূহ",
    'mun'   => "মুণ্ডা\ ভাষা",
    'mus'   => 'ক্রিক',
    'mwl'   => 'মিরান্ডিজ',
    'mwr'   => 'মারওয়ারি',
    'my'    => 'বর্মি',
    'myn'   => "মায়ান\ ভাষা",
    'myv'   => 'এর্জয়া',
    'na'    => 'নাউরু',
    'nah'   => 'নাহুআল',
    'nai'   => "উত্তর\ আমেরিকার\ ভারতীয়\ ভাষা",
    'nap'   => 'নেয়াপোলিটান',
    'nb'    => "নরওয়ে\ বোকমাল",
    'nd'    => "উত্তর\ দেবেলে",
    'nds'   => "লো\ জার্মানি",
    'ne'    => 'নেপালী',
    'new'   => 'নেওয়ারি',
    'ng'    => 'দোঙ্গা',
    'nia'   => 'নিয়াস',
    'nic'   => "নাইজার\-কোর্ডোফানিয়ান\ ভাষা",
    'niu'   => 'নিউয়ান',
    'nl'    => 'ডাচ',
    'nl_be' => 'ফ্লেমিশ',
    'nn'    => "নরওয়েজীয়\ \(নিনর্স্ক\)",
    'no'    => 'নরওয়েজীয়ান',
    'nog'   => 'নোগাই',
    'non'   => "প্রাচীন\ নর্স",
    'nqo'   => 'এন’কো',
    'nr'    => "দক্ষিণ\ এনডেবেলে",
    'nso'   => "উত্তরাঞ্চলীয়\ সোথো",
    'nub'   => "নুবিয়ান\ ভাষা",
    'nv'    => 'নাভাজো',
    'nwc'   => "পারম্পরিক\ নেওয়ারী",
    'ny'    => 'নায়াঞ্জা',
    'nym'   => 'ন্যায়ামওয়েজি',
    'nyn'   => 'ন্যায়াঙ্কোলে',
    'nyo'   => 'ন্যোরো',
    'nzi'   => 'ন্জিমা',
    'oc'    => 'অক্সিটান',
    'oj'    => 'ওজিবওয়ে',
    'om'    => 'অরোমো',
    'or'    => 'উড়িয়া',
    'os'    => 'ওসেটিক',
    'osa'   => 'ওসেজ',
    'ota'   => "অটোমান\ তুর্কি",
    'oto'   => "অটোমিয়ান\ ভাষা",
    'pa'    => 'পাঞ্জাবী',
    'paa'   => "পাপুয়ান\ ভাষা",
    'pag'   => 'পাঙ্গাসিনান',
    'pal'   => 'পালভি',
    'pam'   => 'পাম্পাঙ্গা',
    'pap'   => 'পাপিয়ামেন্টো',
    'pau'   => 'পালায়ুয়ান',
    'peo'   => "প্রাচীন\ ফার্সি",
    'phi'   => "ফিলিপাইন\ ভাষা",
    'phn'   => 'ফোনিশীয়ান',
    'pi'    => 'পালি',
    'pl'    => 'পোলিশ',
    'pon'   => 'পোহ্নপেইয়ান',
    'pra'   => "প্রাকৃত\ ভাষা",
    'pro'   => "প্রাচীন\ প্রোভেনসাল",
    'ps'    => 'পাস্থো',
    'pt'    => 'পর্তুগীজ',
    'pt_br' => "ব্রাজিলীয়\ পর্তুগীজ",
    'pt_pt' => "আইবেরিয়ান\ পর্তুগিজ",
    'qu'    => 'কেচুয়া',
    'raj'   => 'রাজস্থানী',
    'rap'   => 'রাপানুই',
    'rar'   => 'রারোটোংগান',
    'rm'    => "রেটো\-রোমানীয়",
    'rn'    => 'রুন্দি',
    'ro'    => 'রোমানীয়',
    'roa'   => "রোমান\ ভাষা",
    'rom'   => 'রোমানি',
    'ru'    => 'রুশ',
    'rup'   => 'আরোমানিয়ান',
    'rw'    => 'কিনয়ারোয়ান্ডা',
    'sa'    => 'সংষ্কৃত',
    'sad'   => 'স্যান্ডাওয়ে',
    'sah'   => 'ইয়াকুট',
    'sai'   => "দক্ষিণ\ আমেরিকান\ ইন্ডিয়ান\ ভাষা",
    'sal'   => "শালিশান\ ভাষা",
    'sam'   => "সামারিটান\ আরামিক",
    'sas'   => 'সাসাক',
    'sat'   => 'সাঁওতালি',
    'sc'    => 'সার্ডিনিয়ান',
    'scn'   => 'সিসিলিয়ান',
    'sco'   => 'স্কটস',
    'sd'    => 'সিন্ধি',
    'se'    => "উত্তরাঞ্চলীয়\ সামি",
    'sel'   => 'সেল্কুপ',
    'sem'   => "সেমেটিক\ ভাষা",
    'sg'    => 'সাঙ্গো',
    'sga'   => "প্রাচীন\ আইরিশ",
    'sgn'   => "চিহ্ন\ ভাষা",
    'sh'    => "সার্বো\-ক্রোয়েশিয়",
    'shn'   => 'শান',
    'si'    => 'সিংহলী',
    'sid'   => 'সিডামো',
    'sio'   => "সিওয়ুয়ান\ ভাষা",
    'sit'   => "সিনো\-তিব্বোতীয়\ ভাষা",
    'sk'    => 'স্লোভাক',
    'sl'    => 'স্লোভেনীয়ান',
    'sla'   => "স্ল্যাভিক\ ভাষা",
    'sm'    => 'সামোয়ান',
    'sma'   => "দক্ষিণাঞ্চলীয়\ সামি",
    'smi'   => "সামি\ ভাষা",
    'smj'   => "লুলে\ সামি",
    'smn'   => "ইনারি\ সামি",
    'sms'   => "স্কোল্ট\ সামি",
    'sn'    => 'শোনা',
    'snk'   => 'সোনিঙ্কে',
    'so'    => 'সোমালী',
    'sog'   => 'সোগডিয়ান',
    'son'   => 'সোঙ্গহাই',
    'sq'    => 'আলবেনিয়ান',
    'sr'    => 'সার্বীয়',
    'srn'   => "স্রানান\ টোঙ্গো",
    'srr'   => 'সেরের',
    'ss'    => 'সোয়াতি',
    'ssa'   => "নিলো\-সাহারান\ ভাষা",
    'st'    => "দক্ষিণাঞ্চলীয়\ সোথো",
    'su'    => 'সুদানী',
    'suk'   => 'সুকুমা',
    'sus'   => 'সুসু',
    'sux'   => 'সুমেরীয়',
    'sv'    => 'সুইডিশ',
    'sw'    => 'সোয়াহিলি',
    'syc'   => "প্রাচীন\ সিরিও",
    'syr'   => 'সিরিয়াক',
    'ta'    => 'তামিল',
    'tai'   => "তাই\ ভাষা",
    'te'    => 'তেলেগু',
    'tem'   => 'টিম্নে',
    'ter'   => 'তেরেনো',
    'tet'   => 'তেতুম',
    'tg'    => 'তাজিক',
    'th'    => 'থাই',
    'ti'    => 'তিগরিনিয়া',
    'tig'   => 'টাইগ্রে',
    'tiv'   => 'টিভ',
    'tk'    => 'তুর্কমেন',
    'tkl'   => 'টোকেলাউ',
    'tl'    => 'তাগালগ',
    'tlh'   => 'ক্লিঙ্গন',
    'tli'   => 'ত্লিঙ্গিট',
    'tmh'   => 'তামাশেক',
    'tn'    => 'সোয়ানা',
    'to'    => 'টঙ্গা',
    'tog'   => "নায়াসা\ টোঙ্গা",
    'tpi'   => "টোক\ পিসিন",
    'tr'    => 'তুর্কী',
    'trv'   => 'Taroko',
    'ts'    => 'সঙ্গা',
    'tsi'   => 'সিমশিয়ান',
    'tt'    => 'তাতার',
    'tum'   => 'তুম্বুকা',
    'tup'   => "তুপি\ ভাষা",
    'tut'   => "আলটেয়ীক\ ভাষা",
    'tvl'   => 'টুভালু',
    'tw'    => 'টোয়াই',
    'ty'    => 'তাহিতিয়ান',
    'tyv'   => 'টুভিনিয়ান',
    'udm'   => 'উদ্‌মুর্ত',
    'ug'    => 'উইঘুর',
    'uga'   => 'উগারিটিক',
    'uk'    => 'ইউক্রেইনিয়ান',
    'umb'   => 'উম্বুন্দু',
    'und'   => "অজানা\ বা\ ভুল\ ভাষা",
    'ur'    => 'উর্দু',
    'uz'    => 'উজবেক',
    'vai'   => 'ভাই',
    've'    => 'ভেন্ডা',
    'vi'    => 'ভিয়েতনামিজ',
    'vo'    => 'ভোলাপুক',
    'vot'   => 'ভোটিক',
    'wa'    => 'ওয়ালুন',
    'wak'   => "ওয়াকাশান\ ভাষা",
    'wal'   => 'ওয়ালামো',
    'war'   => 'ওয়ারে',
    'was'   => 'ওয়াশো',
    'wen'   => "সোরবিয়ান\ ভাষা",
    'wo'    => 'উওলোফ',
    'xal'   => 'কাল্মইক',
    'xh'    => 'জোসা',
    'yao'   => 'ইয়াও',
    'yap'   => 'ইয়াপিজ',
    'yi'    => 'ইদ্দিশ',
    'yo'    => 'ইওরুবা',
    'ypk'   => "ইয়ুপিক\ ভাষা",
    'za'    => 'ঝুয়াং',
    'zap'   => 'জাপোটেক',
    'zbl'   => "চিত্র\ ভাষা",
    'zen'   => 'জেনাগা',
    'zh'    => 'চীনা',
    'znd'   => 'জান্দে',
    'zu'    => 'জুলু',
    'zun'   => 'জুনি',
    'zxx'   => "ভাষাতাত্তিক\ বিষয়সূচী\ বহির্ভুত",
    'zza'   => 'জাজা',
);

%Locales::DB::Language::bn::name_to_code = (
    'morisyen'                                                                             => 'mfe',
    'taroko'                                                                               => 'trv',
    'অক্সিটান'                                                             => 'oc',
    'অঙ্গিকা'                                                                => 'anp',
    'অজানাবাভুলভাষা'                                           => 'und',
    'অটোমানতুর্কি'                                                 => 'ota',
    'অটোমিয়ানভাষা'                                              => 'oto',
    'অফ্রোএশিয়াটিকভাষা'                               => 'afa',
    'অবধী'                                                                         => 'awa',
    'অরোমো'                                                                      => 'om',
    'অসমীয়া'                                                                => 'as',
    'অস্ট্রিয়ানজার্মানি'                            => 'de_at',
    'অস্ট্রেলিয়ভাযা'                                        => 'aus',
    'অস্ট্রেলীয়ইংরেজি'                                  => 'en_au',
    'অস্ট্রোনেশীয়ান'                                        => 'map',
    'অ্যাপাচিভাযা'                                                 => 'apa',
    'অ্যাবকেজিয়ান'                                              => 'ab',
    'অ্যারকেনিয়ান'                                              => 'arn',
    'আইনু'                                                                         => 'ain',
    'আইবেরিয়ানপর্তুগিজ'                               => 'pt_pt',
    'আইবেরিয়ানস্প্যানিশ'                            => 'es_es',
    'আইরিশ'                                                                      => 'ga',
    'আইসল্যান্ডিক'                                                 => 'is',
    'আকান'                                                                         => 'ak',
    'আকোলী'                                                                      => 'ach',
    'আক্কাদিয়ান'                                                    => 'akk',
    'আচাইনিজ'                                                                => 'ace',
    'আজারবাইজানি'                                                    => 'az',
    'আত্সাম'                                                                   => 'cch',
    'আথাপাস্কানভাষা'                                           => 'ath',
    'আদাংমে'                                                                   => 'ada',
    'আন্তর্জাতিকভাষা'                                        => 'ia',
    'আফার'                                                                         => 'aa',
    'আফ্রিকান্স'                                                       => 'af',
    'আফ্রিহিলি'                                                          => 'afh',
    'আব়বি'                                                                      => 'ar',
    'আবেস্তান'                                                             => 'ae',
    'আভেরিক'                                                                   => 'av',
    'আমহারিক'                                                                => 'am',
    'আয়মারা'                                                                => 'ay',
    'আরাওয়াক'                                                             => 'arw',
    'আরাগোনিজ'                                                             => 'an',
    'আরাপাহো'                                                                => 'arp',
    'আরামাইক'                                                                => 'arc',
    'আরোমানিয়ান'                                                    => 'rup',
    'আর্মেনিয়ান'                                                    => 'hy',
    'আলগোঙকুইআনভাযা'                                           => 'alg',
    'আলটেয়ীকভাষা'                                                 => 'tut',
    'আলবেনিয়ান'                                                       => 'sq',
    'আস্তুরিয়ান'                                                    => 'ast',
    'ইংরেজি'                                                                   => 'en',
    'ইংরেজিভিত্তিকক্রেওলঅথবাপিজিন' => 'cpe',
    'ইউক্রেইনিয়ান'                                              => 'uk',
    'ইওয়ে'                                                                      => 'ee',
    'ইওরুবা'                                                                   => 'yo',
    'ইগ্‌বো'                                                                   => 'ig',
    'ইঙ্গুশ'                                                                   => 'inh',
    'ইজো'                                                                            => 'ijo',
    'ইডো'                                                                            => 'io',
    'ইতালিয়ান'                                                          => 'it',
    'ইদ্দিশ'                                                                   => 'yi',
    'ইনারিসামি'                                                          => 'smn',
    'ইনুক্টিটুট'                                                       => 'iu',
    'ইনুপিয়াক'                                                          => 'ik',
    'ইন্টারলিঙ্গ'                                                    => 'ie',
    'ইন্দোইউরোপীয়ভাষা'                                  => 'ine',
    'ইন্দোনেশিয়ান'                                              => 'id',
    'ইবান'                                                                         => 'iba',
    'ইয়াও'                                                                      => 'yao',
    'ইয়াকুট'                                                                => 'sah',
    'ইয়াপিজ'                                                                => 'yap',
    'ইয়ুপিকভাষা'                                                    => 'ypk',
    'ইয়োন্ডো'                                                             => 'ewo',
    'ইরানীভাষা'                                                          => 'ira',
    'ইরোকোইয়ানভাষা'                                           => 'iro',
    'ইলোকো'                                                                      => 'ilo',
    'উইঘুর'                                                                      => 'ug',
    'উওলোফ'                                                                      => 'wo',
    'উগারিটিক'                                                             => 'uga',
    'উচ্চসোর্বিয়ান'                                           => 'hsb',
    'উজবেক'                                                                      => 'uz',
    'উড়িয়া'                                                                => 'or',
    'উত্তরআমেরিকারভারতীয়ভাষা'             => 'nai',
    'উত্তরদেবেলে'                                                    => 'nd',
    'উত্তরাঞ্চলীয়ফ্রিসিয়ান'                => 'frr',
    'উত্তরাঞ্চলীয়সামি'                                  => 'se',
    'উত্তরাঞ্চলীয়সোথো'                                  => 'nso',
    'উদ্‌মুর্ত'                                                          => 'udm',
    'উম্বুন্দু'                                                          => 'umb',
    'উর্দু'                                                                      => 'ur',
    'একাজুক'                                                                   => 'eka',
    'এন’কো'                                                                      => 'nqo',
    'এফিক'                                                                         => 'efi',
    'এর্জয়া'                                                                => 'myv',
    'এলামাইট'                                                                => 'elx',
    'এলেউট'                                                                      => 'ale',
    'এস্তোনিয়ান'                                                    => 'et',
    'এস্পেরান্তো'                                                    => 'eo',
    'এ্যাডাইঘে'                                                          => 'ady',
    'ওজিবওয়ে'                                                             => 'oj',
    'ওয়াকাশানভাষা'                                              => 'wak',
    'ওয়ারে'                                                                   => 'war',
    'ওয়ালামো'                                                             => 'wal',
    'ওয়ালুন'                                                                => 'wa',
    'ওয়াশো'                                                                   => 'was',
    'ওয়েলশ'                                                                   => 'cy',
    'ওসেজ'                                                                         => 'osa',
    'ওসেটিক'                                                                   => 'os',
    'ককেশীয়ানভাষা'                                              => 'cau',
    'কাউই'                                                                         => 'kaw',
    'কাচিন'                                                                      => 'kac',
    'কাজাখ'                                                                      => 'kk',
    'কাড্ডো'                                                                   => 'cad',
    'কানাড়া'                                                                => 'kn',
    'কানাডীয়ইংরেজি'                                           => 'en_ca',
    'কানাডীয়ফরাসি'                                              => 'fr_ca',
    'কানুরি'                                                                   => 'kr',
    'কাবাইল'                                                                   => 'kab',
    'কাবার্ডিয়ান'                                                 => 'kbd',
    'কাম্বা'                                                                   => 'kam',
    'কারচেবাল্কার'                                                 => 'krc',
    'কারাকাল্পাক'                                                    => 'kaa',
    'কারেন'                                                                      => 'kar',
    'কারেলিয়ান'                                                       => 'krl',
    'কাল্মইক'                                                                => 'xal',
    'কাশুবিয়ান'                                                       => 'csb',
    'কাশ্মীরি'                                                             => 'ks',
    'কিকু্ইয়ু'                                                          => 'ki',
    'কিনয়ারোয়ান্ডা'                                        => 'rw',
    'কিম্বুন্দু'                                                       => 'kmb',
    'কির্‌ঘিজ'                                                             => 'ky',
    'কুটেনাই'                                                                => 'kut',
    'কুমিক'                                                                      => 'kum',
    'কুরুখ'                                                                      => 'kru',
    'কুর্দিশ'                                                                => 'ku',
    'কুশিতিকভাষা'                                                    => 'cus',
    'কৃত্রিমভাযা'                                                    => 'art',
    'কেচুয়া'                                                                => 'qu',
    'কেলটিক'                                                                   => 'cel',
    'কোঙ্কানি'                                                             => 'kok',
    'কোঙ্গো'                                                                   => 'kg',
    'কোপটিক'                                                                   => 'cop',
    'কোমি'                                                                         => 'kv',
    'কোয়ানিয়ামা'                                                 => 'kj',
    'কোরিয়ান'                                                             => 'ko',
    'কোরো'                                                                         => 'kfo',
    'কোর্নিশ'                                                                => 'kw',
    'কোর্সিকান'                                                          => 'co',
    'কোস্রাইয়ান'                                                    => 'kos',
    'ক্যাটালান'                                                          => 'ca',
    'ক্যারিব'                                                                => 'car',
    'ক্যালাল্লিসুট'                                              => 'kl',
    'ক্রি'                                                                         => 'cr',
    'ক্রিক'                                                                      => 'mus',
    'ক্রিমিয়ানতুর্কি'                                     => 'crh',
    'ক্রু'                                                                         => 'kro',
    'ক্রেওলঅথবাপিজিন'                                        => 'crp',
    'ক্রোয়েশিয়ান'                                              => 'hr',
    'ক্লিঙ্গন'                                                             => 'tlh',
    'ক্‌পেল্লে'                                                          => 'kpe',
    'খমের'                                                                         => 'km',
    'খাশি'                                                                         => 'kha',
    'খোটানিজ'                                                                => 'kho',
    'খোয়িশানভাষা'                                                 => 'khi',
    'গওইচ্’ইন'                                                             => 'gwi',
    'গথিক'                                                                         => 'got',
    'গন্ডা'                                                                      => 'lg',
    'গা'                                                                               => 'gaa',
    'গায়ো'                                                                      => 'gay',
    'গিজ'                                                                            => 'gez',
    'গিলবার্টিজ'                                                       => 'gil',
    'গুজরাটি'                                                                => 'gu',
    'গুয়ারানি'                                                          => 'gn',
    'গোন্ডি'                                                                   => 'gon',
    'গোরোন্টালো'                                                       => 'gor',
    'গ্যালিসিয়ান'                                                 => 'gl',
    'গ্রিক'                                                                      => 'el',
    'গ্রেবো'                                                                   => 'grb',
    'গ্‌বায়া'                                                             => 'gba',
    'চামিকভাষা'                                                          => 'cmc',
    'চার্চস্লাভিক'                                                 => 'cu',
    'চিত্রভাষা'                                                          => 'zbl',
    'চিনুকজারগন'                                                       => 'chn',
    'চিপেওয়ান'                                                          => 'chp',
    'চিবচা'                                                                      => 'chb',
    'চিহ্নভাষা'                                                          => 'sgn',
    'চীনা'                                                                         => 'zh',
    'চুকিসে'                                                                   => 'chk',
    'চুভাশ'                                                                      => 'cv',
    'চেক'                                                                            => 'cs',
    'চেচেন'                                                                      => 'ce',
    'চেয়েনি'                                                                => 'chy',
    'চেরোকি'                                                                   => 'chr',
    'চোক্টাও'                                                                => 'cho',
    'চ্যাগাতাই'                                                          => 'chg',
    'চ্যামোর্রো'                                                       => 'ch',
    'জর্জিয়ান'                                                          => 'ka',
    'জাজা'                                                                         => 'zza',
    'জান্দে'                                                                   => 'znd',
    'জাপানি'                                                                   => 'ja',
    'জাপোটেক'                                                                => 'zap',
    'জাভানিজ'                                                                => 'jv',
    'জার্মান'                                                                => 'de',
    'জার্মানিকভাষা'                                              => 'gem',
    'জুদেওআরবি'                                                          => 'jrb',
    'জুদেওফার্সি'                                                    => 'jpr',
    'জুনি'                                                                         => 'zun',
    'জুলু'                                                                         => 'zu',
    'জেনাগা'                                                                   => 'zen',
    'জোসা'                                                                         => 'xh',
    'জ্‌জু'                                                                      => 'kaj',
    'ঝুয়াং'                                                                   => 'za',
    'টঙ্গা'                                                                      => 'to',
    'টাইগ্রে'                                                                => 'tig',
    'টিভ'                                                                            => 'tiv',
    'টিম্নে'                                                                   => 'tem',
    'টিয়াপ'                                                                   => 'kcg',
    'টুভালু'                                                                   => 'tvl',
    'টুভিনিয়ান'                                                       => 'tyv',
    'টোকপিসিন'                                                             => 'tpi',
    'টোকেলাউ'                                                                => 'tkl',
    'টোয়াই'                                                                   => 'tw',
    'ডাকোটা'                                                                   => 'dak',
    'ডাচ'                                                                            => 'nl',
    'ডায়াক'                                                                   => 'day',
    'ডিউলা'                                                                      => 'dyu',
    'ডিঙ্কা'                                                                   => 'din',
    'ডেনিশ'                                                                      => 'da',
    'ডেলাওয়ারে'                                                       => 'del',
    'ডোগরি'                                                                      => 'doi',
    'তাইভাষা'                                                                => 'tai',
    'তাগালগ'                                                                   => 'tl',
    'তাজিক'                                                                      => 'tg',
    'তাতার'                                                                      => 'tt',
    'তামাশেক'                                                                => 'tmh',
    'তামিল'                                                                      => 'ta',
    'তাহিতিয়ান'                                                       => 'ty',
    'তিগরিনিয়া'                                                       => 'ti',
    'তিব্বতি'                                                                => 'bo',
    'তুপিভাষা'                                                             => 'tup',
    'তুম্বুকা'                                                             => 'tum',
    'তুর্কমেন'                                                             => 'tk',
    'তুর্কী'                                                                   => 'tr',
    'তেতুম'                                                                      => 'tet',
    'তেরেনো'                                                                   => 'ter',
    'তেলেগু'                                                                   => 'te',
    'ত্লিঙ্গিট'                                                          => 'tli',
    'থাই'                                                                            => 'th',
    'দক্ষিণআমেরিকানইন্ডিয়ানভাষা'    => 'sai',
    'দক্ষিণএনডেবেলে'                                           => 'nr',
    'দক্ষিণাঞ্চলীয়আলতাই'                            => 'alt',
    'দক্ষিণাঞ্চলীয়সামি'                               => 'sma',
    'দক্ষিণাঞ্চলীয়সোথো'                               => 'st',
    'দার্গওয়া'                                                          => 'dar',
    'দিবেহি'                                                                   => 'dv',
    'দুয়ালা'                                                                => 'dua',
    'দোগ্রীব'                                                                => 'dgr',
    'দোঙ্গা'                                                                   => 'ng',
    'দ্রাবীড়ভাষা'                                                 => 'dra',
    'নরওয়েজীয়নিনর্স্ক'                               => 'nn',
    'নরওয়েজীয়ান'                                                 => 'no',
    'নরওয়েবোকমাল'                                                 => 'nb',
    'নাইজারকোর্ডোফানিয়ানভাষা'             => 'nic',
    'নাউরু'                                                                      => 'na',
    'নাভাজো'                                                                   => 'nv',
    'নায়াঞ্জা'                                                          => 'ny',
    'নায়াসাটোঙ্গা'                                              => 'tog',
    'নাহুআল'                                                                   => 'nah',
    'নিউয়ান'                                                                => 'niu',
    'নিয়াস'                                                                   => 'nia',
    'নিলোসাহারানভাষা'                                        => 'ssa',
    'নুবিয়ানভাষা'                                                 => 'nub',
    'নেওয়ারি'                                                             => 'new',
    'নেপালী'                                                                   => 'ne',
    'নেয়াপোলিটান'                                                 => 'nap',
    'নোগাই'                                                                      => 'nog',
    'ন্জিমা'                                                                   => 'nzi',
    'ন্যায়াঙ্কোলে'                                              => 'nyn',
    'ন্যায়ামওয়েজি'                                           => 'nym',
    'ন্যোরো'                                                                   => 'nyo',
    'পর্তুগীজ'                                                             => 'pt',
    'পশ্চিমফ্রিসিয়ান'                                     => 'fy',
    'পাঙ্গাসিনান'                                                    => 'pag',
    'পাঞ্জাবী'                                                             => 'pa',
    'পাপিয়ামেন্টো'                                              => 'pap',
    'পাপুয়ানভাষা'                                                 => 'paa',
    'পাম্পাঙ্গা'                                                       => 'pam',
    'পারম্পরিকনেওয়ারী'                                  => 'nwc',
    'পালভি'                                                                      => 'pal',
    'পালায়ুয়ান'                                                    => 'pau',
    'পালি'                                                                         => 'pi',
    'পাস্থো'                                                                   => 'ps',
    'পূর্বফ্রিসিয়ান'                                        => 'frs',
    'পোর্তুগিজভিত্তিকক্রেওলবাপিজন' => 'cpp',
    'পোলিশ'                                                                      => 'pl',
    'পোহ্নপেইয়ান'                                                 => 'pon',
    'প্রাকৃতভাষা'                                                    => 'pra',
    'প্রাচীনআইরিশ'                                                 => 'sga',
    'প্রাচীনইংরেজী'                                              => 'ang',
    'প্রাচীনগ্রীক'                                                 => 'grc',
    'প্রাচীননর্স'                                                    => 'non',
    'প্রাচীনপ্রোভেনসাল'                                  => 'pro',
    'প্রাচীনফরাসি'                                                 => 'fro',
    'প্রাচীনফার্সি'                                              => 'peo',
    'প্রাচীনমিশরীয়'                                           => 'egy',
    'প্রাচীনসিরিও'                                                 => 'syc',
    'প্রাচীনহাইজার্মানি'                               => 'goh',
    'ফরাসি'                                                                      => 'fr',
    'ফরাসিভিত্তিকক্রেওলঅথবাপিজিন'    => 'cpf',
    'ফান্তি'                                                                   => 'fat',
    'ফার্সি'                                                                   => 'fa',
    'ফিজি'                                                                         => 'fj',
    'ফিনিশ'                                                                      => 'fi',
    'ফিনোউগ্রিয়ানভাষা'                                  => 'fiu',
    'ফিলিপাইনভাষা'                                                 => 'phi',
    'ফিলিপিনো'                                                             => 'fil',
    'ফুলা'                                                                         => 'ff',
    'ফোন'                                                                            => 'fon',
    'ফোনিশীয়ান'                                                       => 'phn',
    'ফ্যাঙ'                                                                      => 'fan',
    'ফ্যারোয়েজ'                                                       => 'fo',
    'ফ্রিউলিয়ান'                                                    => 'fur',
    'ফ্লেমিশ'                                                                => 'nl_be',
    'বর্মি'                                                                      => 'my',
    'বসনীয়ান'                                                             => 'bs',
    'বহুগুণিতকভাষাসমূহ'                                  => 'mul',
    'বাংলা'                                                                      => 'bn',
    'বাগিনিজ'                                                                => 'bug',
    'বাটাক'                                                                      => 'btk',
    'বান্টু'                                                                   => 'bnt',
    'বান্দা'                                                                   => 'bad',
    'বামবারা'                                                                => 'bm',
    'বামিলেকেভাষা'                                                 => 'bai',
    'বালিনীস'                                                                => 'ban',
    'বাল্টিকভাষা'                                                    => 'bat',
    'বাশকির'                                                                   => 'ba',
    'বাসা'                                                                         => 'bas',
    'বাস্ক'                                                                      => 'eu',
    'বিকোল'                                                                      => 'bik',
    'বিনি'                                                                         => 'bin',
    'বিবিধভাষা'                                                          => 'mis',
    'বিসলামা'                                                                => 'bi',
    'বিহারি'                                                                   => 'bh',
    'বুরিয়াত'                                                             => 'bua',
    'বুলগেরিয়ান'                                                    => 'bg',
    'বেজা'                                                                         => 'bej',
    'বেম্বা'                                                                   => 'bem',
    'বেরবের'                                                                   => 'ber',
    'বেলারুশিয়ান'                                                 => 'be',
    'বেলুচী'                                                                   => 'bal',
    'ব্রাজ'                                                                      => 'bra',
    'ব্রাজিলীয়পর্তুগীজ'                               => 'pt_br',
    'ব্রিটিশইংরেজি'                                              => 'en_gb',
    'ব্রেটোন'                                                                => 'br',
    'ব্লিন'                                                                      => 'byn',
    'ভাই'                                                                            => 'vai',
    'ভারতীয়ভাষা'                                                    => 'inc',
    'ভাষাতাত্তিকবিষয়সূচীবহির্ভুত' => 'zxx',
    'ভিয়েতনামিজ'                                                    => 'vi',
    'ভেন্ডা'                                                                   => 've',
    'ভোজপুরি'                                                                => 'bho',
    'ভোটিক'                                                                      => 'vot',
    'ভোলাপুক'                                                                => 'vo',
    'মঙো'                                                                            => 'hmn',
    'মঙ্গোলিয়ান'                                                    => 'mn',
    'মণিপুরী'                                                                => 'mni',
    'মধ্যআইরিশ'                                                          => 'mga',
    'মধ্যআমেরিকানইন্ডিয়ানভাষা'          => 'cai',
    'মধ্যইংরেজি'                                                       => 'enm',
    'মধ্যডাচ'                                                                => 'dum',
    'মধ্যফরাসি'                                                          => 'frm',
    'মনখমেরভাষা'                                                       => 'mkh',
    'মলদাভিয়'                                                             => 'mo',
    'মসি'                                                                            => 'mos',
    'মাওরি'                                                                      => 'mi',
    'মাগাহি'                                                                   => 'mag',
    'মাঞ্চু'                                                                   => 'mnc',
    'মাদুরেসে'                                                             => 'mad',
    'মায়ানভাষা'                                                       => 'myn',
    'মারওয়ারি'                                                          => 'mwr',
    'মারাঠি'                                                                   => 'mr',
    'মারি'                                                                         => 'chm',
    'মার্শালিজ'                                                          => 'mh',
    'মালয়'                                                                      => 'ms',
    'মালাগাছি'                                                             => 'mg',
    'মালায়ালাম'                                                       => 'ml',
    'মাল্টিজ'                                                                => 'mt',
    'মাসাই'                                                                      => 'mas',
    'মিকম্যাক'                                                             => 'mic',
    'মিডলহাইজার্মানি'                                        => 'gmh',
    'মিনাঙ্কাবাউ'                                                    => 'min',
    'মিরান্ডিজ'                                                          => 'mwl',
    'মুণ্ডাভাষা'                                                       => 'mun',
    'মেন্ডে'                                                                   => 'men',
    'মৈথিলি'                                                                   => 'mai',
    'মোকশা'                                                                      => 'mdf',
    'মোঙ্গো'                                                                   => 'lol',
    'মোহাওক'                                                                   => 'moh',
    'ম্যাকাসার'                                                          => 'mak',
    'ম্যাঙ্কস'                                                             => 'gv',
    'ম্যানোবোভাষা'                                                 => 'mno',
    'ম্যান্ডার'                                                          => 'mdr',
    'ম্যান্ডিঙ্গো'                                                 => 'man',
    'ম্যাসেডোনীয়'                                                 => 'mk',
    'যুক্তরাষ্ট্রইংরেজি'                               => 'en_us',
    'রাজস্থানী'                                                          => 'raj',
    'রাপানুই'                                                                => 'rap',
    'রারোটোংগান'                                                       => 'rar',
    'রুন্দি'                                                                   => 'rn',
    'রুশ'                                                                            => 'ru',
    'রেটোরোমানীয়'                                                 => 'rm',
    'রোমানভাষা'                                                          => 'roa',
    'রোমানি'                                                                   => 'rom',
    'রোমানীয়'                                                             => 'ro',
    'লাও'                                                                            => 'lo',
    'লাটিন'                                                                      => 'la',
    'লান্ডা'                                                                   => 'lah',
    'লাম্বা'                                                                   => 'lam',
    'লিঙ্গালা'                                                             => 'ln',
    'লিথুনিয়ান'                                                       => 'lt',
    'লিম্বুর্গিশ'                                                    => 'li',
    'লুইসেনো'                                                                => 'lui',
    'লুক্সেমবার্গীস'                                           => 'lb',
    'লুন্ডা'                                                                   => 'lun',
    'লুবাকাটাঙ্গা'                                                 => 'lu',
    'লুবালুলুয়া'                                                    => 'lua',
    'লুয়ো'                                                                      => 'luo',
    'লুলেসামি'                                                             => 'smj',
    'লুশাই'                                                                      => 'lus',
    'লেজঘিয়ান'                                                          => 'lez',
    'লোজবান'                                                                   => 'jbo',
    'লোজার্মানি'                                                       => 'nds',
    'লোজি'                                                                         => 'loz',
    'লোয়ারসোর্বিয়ান'                                     => 'dsb',
    'ল্যাটভিয়ান'                                                    => 'lv',
    'ল্যাডিনো'                                                             => 'lad',
    'শান'                                                                            => 'shn',
    'শালিশানভাষা'                                                    => 'sal',
    'শোনা'                                                                         => 'sn',
    'সংষ্কৃত'                                                                => 'sa',
    'সঙ্গা'                                                                      => 'ts',
    'সাঁওতালি'                                                             => 'sat',
    'সাঙ্গো'                                                                   => 'sg',
    'সামারিটানআরামিক'                                        => 'sam',
    'সামিভাষা'                                                             => 'smi',
    'সামোয়ান'                                                             => 'sm',
    'সার্ডিনিয়ান'                                                 => 'sc',
    'সার্বীয়'                                                             => 'sr',
    'সার্বোক্রোয়েশিয়'                                  => 'sh',
    'সাসাক'                                                                      => 'sas',
    'সিংহলী'                                                                   => 'si',
    'সিওয়ুয়ানভাষা'                                           => 'sio',
    'সিকসিকা'                                                                => 'bla',
    'সিচুয়ানয়ি'                                                    => 'ii',
    'সিডামো'                                                                   => 'sid',
    'সিনোতিব্বোতীয়ভাষা'                               => 'sit',
    'সিন্ধি'                                                                   => 'sd',
    'সিমশিয়ান'                                                          => 'tsi',
    'সিরিয়াক'                                                             => 'syr',
    'সিসিলিয়ান'                                                       => 'scn',
    'সুইডিশ'                                                                   => 'sv',
    'সুইসউচ্চজার্মানি'                                     => 'de_ch',
    'সুইসজার্মান'                                                    => 'gsw',
    'সুইসফরাসি'                                                          => 'fr_ch',
    'সুকুমা'                                                                   => 'suk',
    'সুদানী'                                                                   => 'su',
    'সুমেরীয়'                                                             => 'sux',
    'সুসু'                                                                         => 'sus',
    'সেবুয়ানো'                                                          => 'ceb',
    'সেমেটিকভাষা'                                                    => 'sem',
    'সেরের'                                                                      => 'srr',
    'সেল্কুপ'                                                                => 'sel',
    'সোগডিয়ান'                                                          => 'sog',
    'সোঙ্গহাই'                                                             => 'son',
    'সোনিঙ্কে'                                                             => 'snk',
    'সোমালী'                                                                   => 'so',
    'সোয়াতি'                                                                => 'ss',
    'সোয়ানা'                                                                => 'tn',
    'সোয়াহিলি'                                                          => 'sw',
    'সোরবিয়ানভাষা'                                              => 'wen',
    'স্কটস'                                                                      => 'sco',
    'স্কটসগ্যেলিক'                                                 => 'gd',
    'স্কোল্টসামি'                                                    => 'sms',
    'স্পেনীয়'                                                             => 'es',
    'স্যান্ডাওয়ে'                                                 => 'sad',
    'স্রানানটোঙ্গো'                                              => 'srn',
    'স্লোভাক'                                                                => 'sk',
    'স্লোভেনীয়ান'                                                 => 'sl',
    'স্ল্যাভ'                                                                => 'den',
    'স্ল্যাভিকভাষা'                                              => 'sla',
    'হাইডা'                                                                      => 'hai',
    'হাউসা'                                                                      => 'ha',
    'হাওয়াইয়ান'                                                    => 'haw',
    'হাঙ্গেরিয়ান'                                                 => 'hu',
    'হিট্টাইট'                                                             => 'hit',
    'হিন্দি'                                                                   => 'hi',
    'হিব্রু'                                                                   => 'he',
    'হিমাচালি'                                                             => 'him',
    'হিরিমোতু'                                                             => 'ho',
    'হিলিগ্যায়নোন'                                              => 'hil',
    'হুপা'                                                                         => 'hup',
    'হেইশন'                                                                      => 'ht',
    'হেরেরো'                                                                   => 'hz',
    '‌জোঙ্খা'                                                                => 'dz',
);

1;
