# norootforbuild
# neededforbuild gcc gcc-c++

%define name ktoblzcheck

%define is_mandrake %(test -e /etc/mandrake-release && echo 1 || echo 0)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_fedora %(test -e /etc/fedora-release && echo 1 || echo 0)

%define dist redhat
%define disttag rh

%if %is_mandrake
%define dist mandrake
%define disttag mdk
%endif
%if %is_suse
%define dist suse
%define disttag suse
%endif
%if %is_fedora
%define dist fedora
%define disttag rhfc
%endif
#
%define version 1.33

%define distver %(release="`rpm -q --queryformat='%{VERSION}' %{dist}-release 2>/dev/null`" ; if test $? != 0 ; then release="" ; fi ; echo "$release")

%define release 1.%{disttag}%{distver}

Name: %{name}
Summary: A library to check account numbers and bank codes of German banks.
Version: %{version}
Release: %{release}
Source: http://download.sourceforge.net/ktoblzcheck/%{name}-%{version}.tar.gz
Group: System Environment/Libraries
License: LGPL
Packager: Christian Stimming <stimming@tuhh.de>
URL: http://ktoblzcheck.sourceforge.net
BuildRoot: %{_tmppath}/%{name}-%{version}-root
# in case it gets split sometime
Provides: ktoblzcheck-devel = %{version}-%{release}
Prereq: /sbin/ldconfig
Prefix: %{_prefix}

%description 
KtoBLZCheck is a library to check account numbers and bank codes of
German banks. Both a library for other programs as well as a short
command-line tool is available. It is possible to check pairs of
account numbers and bank codes (BLZ) of German banks, and to map bank
codes (BLZ) to the clear-text name and location of the bank.

%package devel
Summary: Ktoblzcheck developer files
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
%description devel
This package contains the development files for the account number
checking library ktoblzcheck.

%prep
%setup -q

%build
%{configure} --disable-python
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

make DESTDIR=$RPM_BUILD_ROOT install

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files
%defattr(-,root,root,0755)
%doc README TODO COPYING ChangeLog
%{_libdir}/*.so
%{_libdir}/*.so.*
%{_bindir}/ktoblzcheck
%{_datadir}/ktoblzcheck/*
%{_mandir}/man1/ktoblzcheck.1*
# %{py_sitedir}/*.py*

%files devel
%defattr(-,root,root)
%{_includedir}/iban.h
%{_includedir}/ktoblzcheck.h
%{_libdir}/*.la
%{_libdir}/pkgconfig/ktoblzcheck.pc

%changelog
