/*******************************************************************************************************************************************
 ctextview.c
*******************************************************************************************************************************************/

#include "ctextview.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//------------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CTextViewListener);

//------------------------------------------------------------------------------------------------------------------------------------------
// OnChange
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::OnChange (GtkTextBuffer *, gpointer inData)
{
	// retreive the pointer
	CTextView *inTextView = reinterpret_cast <CTextView *> (inData);

	// pointer check and notification emission
	if (inTextView != NULL && inTextView -> GetListener() != NULL)
		static_cast <CTextViewListener *> (inTextView -> GetListener()) -> OnChange (inTextView);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// OnInsert
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::OnInsert (GtkTextBuffer *, GtkTextIter *inGtkTextIter, gchar *inString, gint inOffset, gpointer inData)
{
	// retreive the pointer
	CTextView *inTextView = reinterpret_cast <CTextView *> (inData);

	// pointer check
	if (inTextView == NULL) return;

	// notification
	if (inTextView -> GetListener() != NULL)
		static_cast <CTextViewListener *> (inTextView -> GetListener()) ->
			OnInsert (inTextView, CString(inString), ::gtk_text_iter_get_offset (inGtkTextIter));
}

//------------------------------------------------------------------------------------------------------------------------------------------
// OnDelete
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::OnDelete (GtkTextBuffer *, GtkTextIter *inGtkTextIter0, GtkTextIter *inGtkTextIter1, gpointer inData)
{
	// retreive the pointer
	CTextView *inTextView = reinterpret_cast <CTextView *> (inData);

	// pointer check
	if (inTextView == NULL) return;

	// notification
	if (inTextView -> GetListener() != NULL)
		static_cast <CTextViewListener *> (inTextView -> GetListener()) ->
			OnDelete (inTextView, ::gtk_text_iter_get_offset (inGtkTextIter0), ::gtk_text_iter_get_offset (inGtkTextIter1));
}

//------------------------------------------------------------------------------------------------------------------------------------------
// OnModifiedChanged
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::OnModifiedChanged (GtkTextBuffer *, gpointer inData)
{
	// retreive the pointer
	CTextView *inTextView = reinterpret_cast <CTextView *> (inData);

	// pointer check and notification emission
	if (inTextView != NULL && inTextView -> GetListener() != NULL)
		static_cast <CTextViewListener *> (inTextView -> GetListener()) -> OnModifiedChanged (inTextView);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// OnCopyClipboard
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::OnCopyClipboard (GtkTextView *, gpointer inData)
{
	// retreive the pointer
	CTextView *inTextView = reinterpret_cast <CTextView *> (inData);

	// pointer check and notification emission
	if (inTextView != NULL && inTextView -> GetListener() != NULL)
		static_cast <CTextViewListener *> (inTextView -> GetListener()) -> OnCopyClipboard (inTextView);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// OnCutClipboard
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::OnCutClipboard (GtkTextView *, gpointer inData)
{
	// retreive the pointer
	CTextView *inTextView = reinterpret_cast <CTextView *> (inData);

	// pointer check and notification emission
	if (inTextView != NULL && inTextView -> GetListener() != NULL)
		static_cast <CTextViewListener *> (inTextView -> GetListener()) -> OnCutClipboard (inTextView);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// OnPasteClipboard
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::OnPasteClipboard (GtkTextView *, gpointer inData)
{
	// retreive the pointer
	CTextView *inTextView = reinterpret_cast <CTextView *> (inData);

	// pointer check and notification emission
	if (inTextView != NULL && inTextView -> GetListener() != NULL)
		static_cast <CTextViewListener *> (inTextView -> GetListener()) -> OnPasteClipboard (inTextView);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// OnTextTagTableAdded
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::OnTextTagTableAdded (GtkTextTagTable *, GtkTextTag *inGtkTextTag, gpointer inData)
{
	// retreive the pointer
	CTextView *inTextView = reinterpret_cast <CTextView *> (inData);

	// pointer check and notification emission
	if (inTextView != NULL && inTextView -> GetListener() != NULL)
		static_cast <CTextViewListener *> (inTextView -> GetListener()) -> OnTextTagTableAdded (inTextView, inGtkTextTag);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// OnTextTagTableRemoved
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::OnTextTagTableRemoved (GtkTextTagTable *, GtkTextTag *inGtkTextTag, gpointer inData)
{
	// retreive the pointer
	CTextView *inTextView = reinterpret_cast <CTextView *> (inData);

	// pointer check and notification emission
	if (inTextView != NULL && inTextView -> GetListener() != NULL)
		static_cast <CTextViewListener *> (inTextView -> GetListener()) -> OnTextTagTableRemoved (inTextView, inGtkTextTag);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// OnTextTagTableChanged
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::OnTextTagTableChanged (GtkTextTagTable *, GtkTextTag *inGtkTextTag, gboolean, gpointer inData)
{
	// retreive the pointer
	CTextView *inTextView = reinterpret_cast <CTextView *> (inData);

	// pointer check and notification emission
	if (inTextView != NULL && inTextView -> GetListener() != NULL)
		static_cast <CTextViewListener *> (inTextView -> GetListener()) -> OnTextTagTableChanged (inTextView, inGtkTextTag);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CTextViewListener::CTextViewListener ()
{ }

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CTextViewListener::~CTextViewListener ()
{ }

//------------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//------------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CTextView);

//------------------------------------------------------------------------------------------------------------------------------------------
// static tag attributes resolution
//------------------------------------------------------------------------------------------------------------------------------------------
GtkTextTag * CTextView::m_GtkTextTagItalic		=NULL;
GtkTextTag * CTextView::m_GtkTextTagUnderline		=NULL;
GtkTextTag * CTextView::m_GtkTextTagDoubleUnderline	=NULL;
GtkTextTag * CTextView::m_GtkTextTagStrikeThrough	=NULL;
GtkTextTag * CTextView::m_GtkTextTagWeightUltraLight	=NULL;
GtkTextTag * CTextView::m_GtkTextTagWeightLight		=NULL;
GtkTextTag * CTextView::m_GtkTextTagWeightNormal	=NULL;
GtkTextTag * CTextView::m_GtkTextTagWeightBold		=NULL;
GtkTextTag * CTextView::m_GtkTextTagWeightUltraBold	=NULL;
GtkTextTag * CTextView::m_GtkTextTagWeightHeavy		=NULL;
GtkTextTag * CTextView::m_GtkTextTagScaleXXSmall	=NULL;
GtkTextTag * CTextView::m_GtkTextTagScaleXSmall		=NULL;
GtkTextTag * CTextView::m_GtkTextTagScaleSmall		=NULL;
GtkTextTag * CTextView::m_GtkTextTagScaleMedium		=NULL;
GtkTextTag * CTextView::m_GtkTextTagScaleLarge		=NULL;
GtkTextTag * CTextView::m_GtkTextTagScaleXLarge		=NULL;
GtkTextTag * CTextView::m_GtkTextTagScaleXXLarge	=NULL;
GtkTextTag * CTextView::m_GtkTextTagJustificationLeft	=NULL;
GtkTextTag * CTextView::m_GtkTextTagJustificationRight	=NULL;
GtkTextTag * CTextView::m_GtkTextTagJustificationCenter	=NULL;
GtkTextTag * CTextView::m_GtkTextTagNotEditable		=NULL;
GtkTextTag * CTextView::m_GtkTextTagWrapWord		=NULL;
GtkTextTag * CTextView::m_GtkTextTagWrapChar		=NULL;
GtkTextTag * CTextView::m_GtkTextTagWrapNone		=NULL;
GtkTextTag * CTextView::m_GtkTextTagSupScript		=NULL;
GtkTextTag * CTextView::m_GtkTextTagSubScript		=NULL;
GtkTextTag * CTextView::m_GtkTextTagFgDarkBlue		=NULL;
GtkTextTag * CTextView::m_GtkTextTagFgBlue		=NULL;
GtkTextTag * CTextView::m_GtkTextTagFgLightBlue		=NULL;
GtkTextTag * CTextView::m_GtkTextTagFgRed		=NULL;
GtkTextTag * CTextView::m_GtkTextTagFgDarkRed		=NULL;
GtkTextTag * CTextView::m_GtkTextTagFgDarkGreen		=NULL;
GtkTextTag * CTextView::m_GtkTextTagFgGreen		=NULL;
GtkTextTag * CTextView::m_GtkTextTagFgLightGreen	=NULL;
GtkTextTag * CTextView::m_GtkTextTagFgBlack		=NULL;
GtkTextTag * CTextView::m_GtkTextTagFgWhite		=NULL;
GtkTextTag * CTextView::m_GtkTextTagBgDarkBlue		=NULL;
GtkTextTag * CTextView::m_GtkTextTagBgBlue		=NULL;
GtkTextTag * CTextView::m_GtkTextTagBgLightBlue		=NULL;
GtkTextTag * CTextView::m_GtkTextTagBgRed		=NULL;
GtkTextTag * CTextView::m_GtkTextTagBgDarkRed		=NULL;
GtkTextTag * CTextView::m_GtkTextTagBgDarkGreen		=NULL;
GtkTextTag * CTextView::m_GtkTextTagBgGreen		=NULL;
GtkTextTag * CTextView::m_GtkTextTagBgLightGreen	=NULL;
GtkTextTag * CTextView::m_GtkTextTagBgBlack		=NULL;
GtkTextTag * CTextView::m_GtkTextTagBgWhite		=NULL;
GtkTextTag * CTextView::m_GtkTextTagMonospace		=NULL;

//------------------------------------------------------------------------------------------------------------------------------------------
// static tag attributes array resolution
//------------------------------------------------------------------------------------------------------------------------------------------
GtkTextTagTable * CTextView::m_GtkTextTagTable		=NULL;

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CTextView::CTextView	     (CContainer *inOwner, const CTextViewListener *inListener)
	  :CContainer 	     (inOwner, inListener),
	   m_GtkTextBuffer   (NULL)
{
	// instanciation process requested
	if (inOwner != NULL) CWidget::CreateWidget (this);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CTextView::CTextView	     (CContainer *inOwner, const GtkTextBuffer *inGtkTextBuffer, const CTextViewListener *inListener)
	  :CContainer	     (inOwner, inListener),
	   m_GtkTextBuffer   (const_cast <GtkTextBuffer *> (inGtkTextBuffer))
{
	// instanciation process requested
	if (inOwner != NULL) CWidget::CreateWidget (this);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CTextView::~CTextView ()
{
	// deletion coherence requested
	CWidget::DestroyWidget (this);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// gtk widget instanciation
//------------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CTextView::PerformWidgetInstanciate ()
{
	// instanciate the tag table
	if (CTextView::m_GtkTextTagTable == NULL) 
		 CTextView::m_GtkTextTagTable = (m_GtkTextBuffer == NULL) ? ::gtk_text_tag_table_new () :
						::gtk_text_buffer_get_tag_table (m_GtkTextBuffer);

	// static commodity attributes instanciation 
	if (CTextView::m_GtkTextTagItalic == NULL)
	{
		CTextView::m_GtkTextTagItalic 			= ::gtk_text_tag_new ("m_GtkTextTagItalic");
		CTextView::m_GtkTextTagUnderline		= ::gtk_text_tag_new ("m_GtkTextTagUnderline");
		CTextView::m_GtkTextTagDoubleUnderline		= ::gtk_text_tag_new ("m_GtkTextTagDoubleUnderline");
		CTextView::m_GtkTextTagStrikeThrough		= ::gtk_text_tag_new ("m_GtkTextTagStrikeThrough");
		CTextView::m_GtkTextTagWeightUltraLight		= ::gtk_text_tag_new ("m_GtkTextTagWeightUltraLight");
		CTextView::m_GtkTextTagWeightLight		= ::gtk_text_tag_new ("m_GtkTextTagWeightLight");
		CTextView::m_GtkTextTagWeightNormal		= ::gtk_text_tag_new ("m_GtkTextTagWeightNormal");
		CTextView::m_GtkTextTagWeightBold		= ::gtk_text_tag_new ("m_GtkTextTagWeightBold");
		CTextView::m_GtkTextTagWeightUltraBold		= ::gtk_text_tag_new ("m_GtkTextTagWeightUltraBold");
		CTextView::m_GtkTextTagWeightHeavy		= ::gtk_text_tag_new ("m_GtkTextTagWeightHeavy");
		CTextView::m_GtkTextTagScaleXXSmall		= ::gtk_text_tag_new ("m_GtkTextTagScaleXXSmall");
		CTextView::m_GtkTextTagScaleXSmall		= ::gtk_text_tag_new ("m_GtkTextTagScaleXSmall");
		CTextView::m_GtkTextTagScaleSmall		= ::gtk_text_tag_new ("m_GtkTextTagScaleSmall");
		CTextView::m_GtkTextTagScaleMedium		= ::gtk_text_tag_new ("m_GtkTextTagScaleMedium");
		CTextView::m_GtkTextTagScaleLarge		= ::gtk_text_tag_new ("m_GtkTextTagScaleLarge");
		CTextView::m_GtkTextTagScaleXLarge		= ::gtk_text_tag_new ("m_GtkTextTagScaleXLarge");
		CTextView::m_GtkTextTagScaleXXLarge		= ::gtk_text_tag_new ("m_GtkTextTagScaleXXLarge");
		CTextView::m_GtkTextTagJustificationLeft	= ::gtk_text_tag_new ("m_GtkTextTagJustificationLeft");
		CTextView::m_GtkTextTagJustificationRight	= ::gtk_text_tag_new ("m_GtkTextTagJustificationRight");
		CTextView::m_GtkTextTagJustificationCenter	= ::gtk_text_tag_new ("m_GtkTextTagJustificationCenter");
		CTextView::m_GtkTextTagNotEditable		= ::gtk_text_tag_new ("m_GtkTextTagNotEditable");
		CTextView::m_GtkTextTagWrapWord			= ::gtk_text_tag_new ("m_GtkTextTagWrapWord");
		CTextView::m_GtkTextTagWrapChar			= ::gtk_text_tag_new ("m_GtkTextTagWrapChar");
		CTextView::m_GtkTextTagWrapNone			= ::gtk_text_tag_new ("m_GtkTextTagWrapNone");
		CTextView::m_GtkTextTagSupScript		= ::gtk_text_tag_new ("m_GtkTextTagSupScript");
		CTextView::m_GtkTextTagSubScript		= ::gtk_text_tag_new ("m_GtkTextTagSubScript");
		CTextView::m_GtkTextTagFgDarkBlue		= ::gtk_text_tag_new ("m_GtkTextTagFgDarkBlue");
		CTextView::m_GtkTextTagFgBlue			= ::gtk_text_tag_new ("m_GtkTextTagFgBlue");
		CTextView::m_GtkTextTagFgLightBlue		= ::gtk_text_tag_new ("m_GtkTextTagFgLightBlue");
		CTextView::m_GtkTextTagFgRed			= ::gtk_text_tag_new ("m_GtkTextTagFgRed");
		CTextView::m_GtkTextTagFgDarkRed		= ::gtk_text_tag_new ("m_GtkTextTagFgDarkRed");
		CTextView::m_GtkTextTagFgDarkGreen		= ::gtk_text_tag_new ("m_GtkTextTagFgDarkGreen");
		CTextView::m_GtkTextTagFgGreen			= ::gtk_text_tag_new ("m_GtkTextTagFgGreen");
		CTextView::m_GtkTextTagFgLightGreen		= ::gtk_text_tag_new ("m_GtkTextTagFgLightGreen");
		CTextView::m_GtkTextTagFgBlack			= ::gtk_text_tag_new ("m_GtkTextTagFgBlack");
		CTextView::m_GtkTextTagFgWhite			= ::gtk_text_tag_new ("m_GtkTextTagFgWhite");
		CTextView::m_GtkTextTagBgDarkBlue		= ::gtk_text_tag_new ("m_GtkTextTagBgDarkBlue");
		CTextView::m_GtkTextTagBgBlue			= ::gtk_text_tag_new ("m_GtkTextTagBgBlue");
		CTextView::m_GtkTextTagBgLightBlue		= ::gtk_text_tag_new ("m_GtkTextTagBgLightBlue");
		CTextView::m_GtkTextTagBgRed			= ::gtk_text_tag_new ("m_GtkTextTagBgRed");
		CTextView::m_GtkTextTagBgDarkRed		= ::gtk_text_tag_new ("m_GtkTextTagBgDarkRed");
		CTextView::m_GtkTextTagBgDarkGreen		= ::gtk_text_tag_new ("m_GtkTextTagBgDarkGreen");
		CTextView::m_GtkTextTagBgGreen			= ::gtk_text_tag_new ("m_GtkTextTagBgGreen");
		CTextView::m_GtkTextTagBgLightGreen		= ::gtk_text_tag_new ("m_GtkTextTagBgLightGreen");
		CTextView::m_GtkTextTagBgBlack			= ::gtk_text_tag_new ("m_GtkTextTagBgBlack");
		CTextView::m_GtkTextTagBgWhite			= ::gtk_text_tag_new ("m_GtkTextTagBgWhite");
		CTextView::m_GtkTextTagMonospace		= ::gtk_text_tag_new ("m_GtkTextTagMonospace");

		// initialize the tag attributes
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagItalic), "style", PANGO_STYLE_ITALIC, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagUnderline), "underline", PANGO_UNDERLINE_SINGLE, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagDoubleUnderline), "underline", PANGO_UNDERLINE_DOUBLE, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagStrikeThrough), "strikethrough", true, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagWeightUltraLight), "weight", PANGO_WEIGHT_ULTRALIGHT, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagWeightLight), "weight", PANGO_WEIGHT_LIGHT, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagWeightNormal), "weight", PANGO_WEIGHT_NORMAL, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagWeightBold), "weight", PANGO_WEIGHT_BOLD, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagWeightUltraBold), "weight", PANGO_WEIGHT_ULTRABOLD, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagWeightHeavy), "weight", PANGO_WEIGHT_HEAVY, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagScaleXXSmall), "scale", PANGO_SCALE_XX_SMALL, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagScaleXSmall), "scale", PANGO_SCALE_X_SMALL, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagScaleSmall), "scale", PANGO_SCALE_SMALL, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagScaleMedium), "scale", PANGO_SCALE_MEDIUM, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagScaleLarge), "scale", PANGO_SCALE_LARGE, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagScaleXLarge), "scale", PANGO_SCALE_X_LARGE, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagScaleXXLarge), "scale", PANGO_SCALE_XX_LARGE, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagJustificationLeft), "justification", GTK_JUSTIFY_LEFT, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagJustificationRight), "justification", GTK_JUSTIFY_RIGHT, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagJustificationCenter), "justification", GTK_JUSTIFY_CENTER, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagNotEditable), "editable", false, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagWrapWord), "wrap_mode", GTK_WRAP_WORD, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagWrapChar), "wrap_mode", GTK_WRAP_CHAR, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagWrapNone), "wrap_mode", GTK_WRAP_NONE, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagSupScript), "rise",  10 * PANGO_SCALE, "size", 8 * PANGO_SCALE, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagSubScript), "rise", -10 * PANGO_SCALE, "size", 8 * PANGO_SCALE, NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagFgDarkBlue), "foreground", "dark blue", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagFgBlue), "foreground", "blue", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagFgLightBlue), "foreground", "light blue", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagFgRed), "foreground", "red", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagFgDarkRed), "foreground", "dark red", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagFgDarkGreen), "foreground", "dark green", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagFgGreen), "foreground", "green", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagFgLightGreen), "foreground", "light green", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagFgBlack), "foreground", "black", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagFgWhite), "foreground", "white", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagBgDarkBlue), "background", "dark blue", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagBgBlue), "background", "blue", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagBgLightBlue), "background", "light blue", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagBgRed), "background", "red", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagBgDarkRed), "background", "dark red", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagBgDarkGreen), "background", "dark green", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagBgGreen), "background", "green", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagBgLightGreen), "background", "light green", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagBgBlack), "background", "black", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagBgWhite), "background", "white", NULL);
		::g_object_set (G_OBJECT(CTextView::m_GtkTextTagMonospace), "family", "monospace", NULL);
	}

	// add the tags to the tag table
	if (::gtk_text_tag_table_lookup (CTextView::m_GtkTextTagTable, "m_GtkTextTagItalic") == NULL)
	{
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagItalic);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagUnderline);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagDoubleUnderline);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagStrikeThrough);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagWeightUltraLight);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagWeightLight);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagWeightNormal);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagWeightBold);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagWeightUltraBold);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagWeightHeavy);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagScaleXXSmall);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagScaleXSmall);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagScaleSmall);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagScaleMedium);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagScaleLarge);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagScaleXLarge);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagScaleXXLarge);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagJustificationLeft);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagJustificationRight);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagJustificationCenter);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagNotEditable);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagWrapWord);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagWrapChar);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagWrapNone);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagSupScript);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagSubScript);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagFgDarkBlue);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagFgBlue);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagFgLightBlue);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagFgRed);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagFgDarkRed);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagFgDarkGreen);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagFgGreen);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagFgLightGreen);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagFgBlack);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagFgWhite);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagBgDarkBlue);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagBgBlue);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagBgLightBlue);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagBgRed);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagBgDarkRed);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagBgDarkGreen);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagBgGreen);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagBgLightGreen);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagBgBlack);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagBgWhite);
		::gtk_text_tag_table_add (CTextView::m_GtkTextTagTable, CTextView::m_GtkTextTagMonospace);
	}

	// instanciate the text buffer on the given tag table
	if (m_GtkTextBuffer == NULL) m_GtkTextBuffer = ::gtk_text_buffer_new (CTextView::m_GtkTextTagTable);

	// ok, instanciate the text view on the given text buffer
	return ::gtk_text_view_new_with_buffer (m_GtkTextBuffer);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// gtk widget initialization
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::PerformWidgetInitialize ()
{
	// get our widget
	GtkWidget *inGtkWidget (GetGtkWidget());
	
	// check pointer
	if (inGtkWidget == NULL || m_GtkTextBuffer == NULL || m_GtkTextTagTable == NULL) return;

	// signal connections
	::g_signal_connect (G_OBJECT(m_GtkTextBuffer),   "changed",  		G_CALLBACK(CTextView::OnChange),		this);
	::g_signal_connect (G_OBJECT(m_GtkTextBuffer),   "insert-text", 	G_CALLBACK(CTextView::OnInsert),  		this);
	::g_signal_connect (G_OBJECT(m_GtkTextBuffer),   "delete-range",	G_CALLBACK(CTextView::OnDelete),  		this); 
	::g_signal_connect (G_OBJECT(m_GtkTextBuffer),   "modified-changed",  	G_CALLBACK(CTextView::OnModifiedChanged),	this);
	::g_signal_connect (G_OBJECT(inGtkWidget),       "copy-clipboard",  	G_CALLBACK(CTextView::OnCopyClipboard),		this);
	::g_signal_connect (G_OBJECT(inGtkWidget),       "cut-clipboard",  	G_CALLBACK(CTextView::OnCutClipboard),		this);
	::g_signal_connect (G_OBJECT(inGtkWidget),       "paste-clipboard",  	G_CALLBACK(CTextView::OnPasteClipboard),	this);
	::g_signal_connect (G_OBJECT(m_GtkTextTagTable), "tag-added",  		G_CALLBACK(CTextView::OnTextTagTableAdded),	this);
	::g_signal_connect (G_OBJECT(m_GtkTextTagTable), "tag-removed",  	G_CALLBACK(CTextView::OnTextTagTableRemoved),	this);
	::g_signal_connect (G_OBJECT(m_GtkTextTagTable), "tag-changed",  	G_CALLBACK(CTextView::OnTextTagTableChanged),	this);

	// show the job
	Show ();
}

//------------------------------------------------------------------------------------------------------------------------------------------
// container add
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::PerformContainerAdd (CWidget *inChild)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointers
	if (inGtkWidget == NULL || m_GtkTextBuffer == NULL || inChild == NULL || inChild -> GetGtkWidget() == NULL) return;

	// get the current insert mark
	GtkTextMark *inGtkTextMark = ::gtk_text_buffer_get_insert (m_GtkTextBuffer);

	// get the text iter of the buffer at the insertion mark
	GtkTextIter inGtkTextIter; ::gtk_text_buffer_get_iter_at_mark (m_GtkTextBuffer, &inGtkTextIter, inGtkTextMark);

	// create an anchor to hold the specified child widget
	GtkTextChildAnchor *inGtkTextChildAnchor = ::gtk_text_child_anchor_new ();

	// insert the anchor at the current position
	::gtk_text_buffer_insert_child_anchor (m_GtkTextBuffer, &inGtkTextIter, inGtkTextChildAnchor);

	// insert the widget into the newly allocated anchor
	::gtk_text_view_add_child_at_anchor (GTK_TEXT_VIEW(inGtkWidget), inChild -> GetGtkWidget(), inGtkTextChildAnchor);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// container remove
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::PerformContainerRemove (CWidget *inChild)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// check pointers
	if (inGtkWidget == NULL || m_GtkTextBuffer == NULL || inChild == NULL || inChild -> GetGtkWidget() == NULL) return;

	// get the first iter of the buffer
	GtkTextIter inGtkTextIter; ::gtk_text_buffer_get_start_iter (m_GtkTextBuffer, &inGtkTextIter);

	// go through the buffer iters
	GtkTextChildAnchor *inGtkTextChildAnchor = NULL; bool found = false; while (!found)
	{
		// get the potential associated anchor
		if ((inGtkTextChildAnchor = ::gtk_text_iter_get_child_anchor (&inGtkTextIter)) != NULL)
		{
			// get the anchor child[ren]
			GList *inGList = ::gtk_text_child_anchor_get_widgets (inGtkTextChildAnchor);

			// go through the children list
			while (inGList != NULL && !found)
			{
				// check list instance value
				if (inGList -> data == inChild -> GetGtkWidget()) found = true; 

				// next child
				inGList = inGList -> next;
			}

			// free the list
			::g_list_free (inGList);
		}

		// next char
		if (!::gtk_text_iter_forward_char (&inGtkTextIter)) break;
	}

	// be paranoïd...
	if (found && inGtkTextChildAnchor != NULL)
	{
		// generic call
		CContainer::PerformContainerRemove (inChild);
		
		// delete the anchor iter i.e. simulate a backspace hit on the previous iter char
		::gtk_text_buffer_backspace (m_GtkTextBuffer, &inGtkTextIter, false, true);
	}
}

//------------------------------------------------------------------------------------------------------------------------------------------
// listener affectation
//------------------------------------------------------------------------------------------------------------------------------------------
const CMetaClass * CTextView::ListenerMustBe () const
{
	return __metaclass(CTextViewListener);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// expected owner type
//------------------------------------------------------------------------------------------------------------------------------------------
CMetaClasses CTextView::OwnerMustBe () const
{
	return __metaclasses(CContainer);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// children handling number
//------------------------------------------------------------------------------------------------------------------------------------------
SInt16 CTextView::GetGtkChildrenNumberLeft () const
{
	// no restriction about the handled children number in the gtkol spine
	return -1;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// get the buffer associated gtk table tags
//------------------------------------------------------------------------------------------------------------------------------------------
GtkTextTagTable * CTextView::GetGtkTextTable () const
{
	// ok
	return CTextView::m_GtkTextTagTable;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// get the associated gtk buffer
//------------------------------------------------------------------------------------------------------------------------------------------
GtkTextBuffer *	CTextView::GetGtkTextBuffer () const
{
	// ok
	return m_GtkTextBuffer;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// text affectation
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::SetText (const CString &inString)
{
	// pointer check
	if (m_GtkTextBuffer == NULL) return;

	// text affectation
	::gtk_text_buffer_set_text (m_GtkTextBuffer, inString.Get(), -1);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// text insertion
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::InsertText (const CString &inText, const SInt32 inOffset)
{
	// check pointer
	if (m_GtkTextBuffer == NULL) return;

	// retreive the associated text iter
	GtkTextIter inGtkTextIter; ::gtk_text_buffer_get_iter_at_offset (m_GtkTextBuffer, &inGtkTextIter, inOffset);

	// insert the text
	::gtk_text_buffer_insert (m_GtkTextBuffer, &inGtkTextIter, inText.Get(), -1);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// text access
//------------------------------------------------------------------------------------------------------------------------------------------
CString CTextView::GetText (const SInt32 inStart, const SInt32 inEnd, const bool inIncludeHiddenChars) const
{
	// pointer check
	if (m_GtkTextBuffer == NULL) return CString();

	// get the corresponding text iter
	GtkTextIter inGtkTextIter0; ::gtk_text_buffer_get_iter_at_offset (m_GtkTextBuffer, &inGtkTextIter0, inStart);
	GtkTextIter inGtkTextIter1; ::gtk_text_buffer_get_iter_at_offset (m_GtkTextBuffer, &inGtkTextIter1, inEnd);

	// perform the request
	gchar *inString = ::gtk_text_buffer_get_text (m_GtkTextBuffer, &inGtkTextIter0, &inGtkTextIter1, inIncludeHiddenChars);

	// save the returned value as a string object
	CString outString (inString);

	// delete the string array
	if (inString != NULL) ::g_free (inString);

	// ok
	return outString;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// text slice access
//------------------------------------------------------------------------------------------------------------------------------------------
CString CTextView::GetSlice (const SInt32 inStart, const SInt32 inEnd, const bool inIncludeHiddenChars) const
{
	// pointer check
	if (m_GtkTextBuffer == NULL) return CString();

	// get the corresponding text iter
	GtkTextIter inGtkTextIter0; ::gtk_text_buffer_get_iter_at_offset (m_GtkTextBuffer, &inGtkTextIter0, inStart);
	GtkTextIter inGtkTextIter1; ::gtk_text_buffer_get_iter_at_offset (m_GtkTextBuffer, &inGtkTextIter1, inEnd);

	// perform the request
	gchar *inString = ::gtk_text_buffer_get_slice (m_GtkTextBuffer, &inGtkTextIter0, &inGtkTextIter1, inIncludeHiddenChars);

	// save the returned value as a string object
	CString outString (inString);

	// delete the string array
	if (inString != NULL) ::g_free (inString);

	// ok
	return outString;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// tag affectation
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::ApplyTag (const GtkTextTag *inGtkTextTag, const SInt32 inStart, const SInt32 inEnd)
{
	// pointer check
	if (m_GtkTextBuffer == NULL) return;

	// get the corresponding text iter
	GtkTextIter inGtkTextIter0; ::gtk_text_buffer_get_iter_at_offset (m_GtkTextBuffer, &inGtkTextIter0, inStart);
	GtkTextIter inGtkTextIter1; ::gtk_text_buffer_get_iter_at_offset (m_GtkTextBuffer, &inGtkTextIter1, inEnd);

	// property affectation
	::gtk_text_buffer_apply_tag (m_GtkTextBuffer, const_cast <GtkTextTag *> (inGtkTextTag), &inGtkTextIter0, &inGtkTextIter1);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// tag removal
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::RemoveTag (const GtkTextTag *inGtkTextTag, const SInt32 inStart, const SInt32 inEnd)
{
	// pointer check
	if (m_GtkTextBuffer == NULL) return;

	// get the corresponding text iter
	GtkTextIter inGtkTextIter0; ::gtk_text_buffer_get_iter_at_offset (m_GtkTextBuffer, &inGtkTextIter0, inStart);
	GtkTextIter inGtkTextIter1; ::gtk_text_buffer_get_iter_at_offset (m_GtkTextBuffer, &inGtkTextIter1, inEnd);

	// property removal
	::gtk_text_buffer_remove_tag (m_GtkTextBuffer, const_cast <GtkTextTag *> (inGtkTextTag), &inGtkTextIter0, &inGtkTextIter1);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// set modified
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::SetModified (const bool inModified)
{
	// pointer check
	if (m_GtkTextBuffer == NULL) return;

	// property affectation
	::gtk_text_buffer_set_modified (m_GtkTextBuffer, inModified);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// get modified
//------------------------------------------------------------------------------------------------------------------------------------------
bool CTextView::GetModified () const
{
	// ok
	return m_GtkTextBuffer == NULL ? false : ::gtk_text_buffer_get_modified (m_GtkTextBuffer);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// copy
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::Copy () const
{
	// get our widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL || m_GtkTextBuffer == NULL) return;

	// get the clipboard
	GtkClipboard *inGtkClipboard = ::gtk_widget_get_clipboard (inGtkWidget, GDK_SELECTION_CLIPBOARD);

	// copy
	::gtk_text_buffer_copy_clipboard (m_GtkTextBuffer, inGtkClipboard);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// cut
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::Cut ()
{
	// get our widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL || m_GtkTextBuffer == NULL) return;

	// get the clipboard
	GtkClipboard *inGtkClipboard = ::gtk_widget_get_clipboard (inGtkWidget, GDK_SELECTION_CLIPBOARD);

	// cut
	::gtk_text_buffer_cut_clipboard (m_GtkTextBuffer, inGtkClipboard, true);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// paste
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::Paste ()
{
	// get our widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL || m_GtkTextBuffer == NULL) return;

	// get the clipboard
	GtkClipboard *inGtkClipboard = ::gtk_widget_get_clipboard (inGtkWidget, GDK_SELECTION_CLIPBOARD);

	// paste
	::gtk_text_buffer_paste_clipboard (m_GtkTextBuffer, inGtkClipboard, NULL, true);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// serialization
//------------------------------------------------------------------------------------------------------------------------------------------
void CTextView::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// generic call first
	CContainer::Serialize (ioXMLElementNode, inMode);

	// request analyse
	switch (inMode)
	{
		// xml dump
		case XML_WRITE :
		{
			// instanciate a new xml element under the current one
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_TEXTVIEW_ELEMENT, GetText());

			// modify the input output pointer so that the overwritten serialization process continues under this element
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;

		// xml load
		case XML_READ :
		{
			// get the child node this serialization process is interested in
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_TEXTVIEW_ELEMENT);

			// check we got an expected cbutton node
			if (inXMLNode == NULL)
				throw new CException (CString("CTextView::Serialize, specified xml node is not a \"") + 
							      XML_TEXTVIEW_ELEMENT + CString("\" element one."), __exception(XMLPARSE));

			// set the text from the expected value if the associated buffer is available
			InsertText (::xml_node_get_value (inXMLNode));

			// modify the in/out element node pointer so that the serialization process will continue under the cbutton node
			ioXMLElementNode = inXMLNode;
		}
		break;
	}
}

//------------------------------------------------------------------------------------------------------------------------------------------
// operator =
//------------------------------------------------------------------------------------------------------------------------------------------
CTextView & CTextView::operator = (const CString &inString)
{
	SetText (inString);
	return *this;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// operator +=
//------------------------------------------------------------------------------------------------------------------------------------------
CTextView & CTextView::operator += (const CString &inString)
{
	InsertText (inString, -1);
	return *this;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// operator <<
//------------------------------------------------------------------------------------------------------------------------------------------
CTextView & CTextView::operator << (CFile &inFile)
{
	char *inData = new char [inFile.GetSize()+1]; 
	inFile.Read (inData, sizeof(char), inFile.GetSize()); inData[inFile.GetSize()] = '\0';
	SetText (CString(inData));
	if (inData != NULL) delete [] inData;
	return *this;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// operator >>
//------------------------------------------------------------------------------------------------------------------------------------------
CTextView & CTextView::operator >> (CFile &inFile)
{
	CString outData (GetText());
	inFile.Write (outData.Get(), sizeof(char), outData.GetLength());
	return *this;
}
