/*******************************************************************************************************************************************
 cexpander.c
*******************************************************************************************************************************************/

#include "cexpander.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CExpanderListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CExpanderListener::CExpanderListener ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CExpanderListener::~CExpanderListener ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CExpander);

//-----------------------------------------------------------------------------------------------------------------------------------------
// OnActivate event linker
//-----------------------------------------------------------------------------------------------------------------------------------------
void CExpander::OnActivate (GtkExpander *, gpointer inData)
{
	// retreive our gtkol instance
	CExpander *inExpander = reinterpret_cast <CExpander *> (inData);

	// event notification if any listener to do so
	if (inExpander != NULL && inExpander -> GetListener() != NULL)
		static_cast <CExpanderListener *> (inExpander -> GetListener()) -> OnClick (inExpander);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CExpander::CExpander  (CContainer *inOwner, const CExpanderListener *inListener)
	  :CContainer (inOwner, inListener)
{
	// instanciation process launch
	if (inOwner != NULL) CWidget:CreateWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CExpander::~CExpander ()
{
	// deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// widget instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CExpander::PerformWidgetInstanciate ()
{
	// ok
	return ::gtk_expander_new (("id"+CString(GetId())).Get());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// widget initialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CExpander::PerformWidgetInitialize ()
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check...
	if (inGtkWidget == NULL) return;

	// specific event connection
	::g_signal_connect (G_OBJECT(inGtkWidget), "activate", G_CALLBACK(CExpander::OnActivate), this);

	// show the job
	Show();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// expected listener
//-----------------------------------------------------------------------------------------------------------------------------------------
const CMetaClass * CExpander::ListenerMustBe () const
{
	return __metaclass(CExpanderListener);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// expected owner
//-----------------------------------------------------------------------------------------------------------------------------------------
CMetaClasses CExpander::OwnerMustBe () const
{
	return __metaclasses(CContainer);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// caption affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CExpander::SetCaption (const CString &inCaption)
{
	// retreive the handled gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// property affectation
	::gtk_expander_set_label (GTK_EXPANDER(inGtkWidget), inCaption.Get());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// caption reader
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CExpander::GetCaption () const
{
	// retreive the handled gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_expander_get_label (GTK_EXPANDER(inGtkWidget)) : CString();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// spacing affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CExpander::SetSpacing (const UInt32 inSpacing)
{
	// retreive the handled gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// property affectation
	::gtk_expander_set_spacing (GTK_EXPANDER(inGtkWidget), inSpacing);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// spacing reader
//-----------------------------------------------------------------------------------------------------------------------------------------
UInt32 CExpander::GetSpacing () const
{
	// retreive the handled gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_expander_get_spacing (GTK_EXPANDER(inGtkWidget)) : 0L;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// expand
//-----------------------------------------------------------------------------------------------------------------------------------------
void CExpander::Expand ()
{
	// retreive the handled gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// property affectation
	::gtk_expander_set_expanded (GTK_EXPANDER(inGtkWidget), true);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// collapse
//-----------------------------------------------------------------------------------------------------------------------------------------
void CExpander::Collapse ()
{
	// retreive the handled gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// property affectation
	::gtk_expander_set_expanded (GTK_EXPANDER(inGtkWidget), false);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// is expanded ?
//-----------------------------------------------------------------------------------------------------------------------------------------
bool CExpander::IsExpanded () const
{
	// retreive the handled gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? ::gtk_expander_get_expanded (GTK_EXPANDER(inGtkWidget)) : false;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// click simulation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CExpander::Click ()
{
	if (!IsExpanded()) Expand(); else Collapse();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// serialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CExpander::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// generic call first
	CContainer::Serialize (ioXMLElementNode, inMode);

	// request analyse
	switch (inMode)
	{
		// xml dump
		case XML_WRITE :
		{
			// instanciate a new xml element under the current one
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_CEXPANDER_ELEMENT);

			// add the cbutton attributes
			newXMLElement -> AddAttribute (XML_CEXPANDER_ATTR_CAPTION,  GetCaption());
			newXMLElement -> AddAttribute (XML_CEXPANDER_ATTR_EXPANDED, CString(IsExpanded()?"true":"false"));
			newXMLElement -> AddAttribute (XML_CEXPANDER_ATTR_SPACING,  CString(GetSpacing()));

			// modify the input output pointer so that the overwritten serialization process continues under this element
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;

		// xml load
		case XML_READ :
		{
			// get the child node this serialization process is interested in
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_CEXPANDER_ELEMENT);

			// check we got an expected cexpander node
			if (inXMLNode == NULL)
				throw new CException (CString("CButton::Serialize, specified xml node is not a \"") + 
							      XML_CEXPANDER_ELEMENT + CString("\" element one."), __exception(XMLPARSE));

			// modify the in/out element node pointer so that the serialization process will continue under the current node
			ioXMLElementNode = inXMLNode;

			// set the caption from the expected attribute
			SetCaption (::xml_node_get_attribute (inXMLNode, XML_CEXPANDER_ATTR_CAPTION).GetValue());
			SetSpacing (::xml_node_get_attribute (inXMLNode, XML_CEXPANDER_ATTR_SPACING).GetValue().ToULong());

			// get the expanded state
			if (::xml_node_get_attribute (inXMLNode, XML_CEXPANDER_ATTR_EXPANDED).GetValue().ToBool()) Expand(); 
		}
		break;
	}
}

