/******************************************************************************************************************************************
 ccombobox.c
******************************************************************************************************************************************/

#include "ccomboboxentry.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CComboBoxEntryListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CComboBoxEntryListener::CComboBoxEntryListener ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CComboBoxEntryListener::~CComboBoxEntryListener ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// CComboBoxEntry::OnEntryQueryInsert
//-----------------------------------------------------------------------------------------------------------------------------------------
void CComboBoxEntry::OnEntryQueryInsert (GtkEditable *inGtkEditable, gchar *ioText, gint, gint *ioPosition, gpointer inData)
{
	// get the text as a string
	CString ioString (ioText);

	// default to accept...
        Bool doAccept = true;

	// retreive our instance
        CComboBoxEntry *theComboBoxEntry = reinterpret_cast <CComboBoxEntry *> (inData);

	// listener function call if any
        if (theComboBoxEntry != NULL && theComboBoxEntry -> GetListener() != NULL)
		static_cast <CComboBoxEntryListener *> (theComboBoxEntry -> GetListener()) ->
                	OnEntryQueryInsert (theComboBoxEntry, ioString, (UInt16&)*ioPosition, doAccept);

	// check the query result
        if (doAccept)
        {
		// disconnect the signal
                ::g_signal_handlers_disconnect_by_func (G_OBJECT(inGtkEditable), 
				(void*)G_CALLBACK(CComboBoxEntry::OnEntryQueryInsert), theComboBoxEntry);

		// set the property
                ::gtk_editable_insert_text (inGtkEditable, ioString.Get(), ioString.GetLength(), ioPosition);

		// reconnect the signal
                ::g_signal_connect (G_OBJECT(inGtkEditable), "insert-text", 
				G_CALLBACK(CComboBoxEntry::OnEntryQueryInsert), theComboBoxEntry);
        }

	// stop
        ::g_signal_stop_emission_by_name (GTK_OBJECT(inGtkEditable), "insert_text");
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CComboBoxEntry::OnEntryQueryDelete
//-----------------------------------------------------------------------------------------------------------------------------------------
void CComboBoxEntry::OnEntryQueryDelete	(GtkEditable *inGtkEditable, gint inStart, gint inEnd, gpointer inData)
{
	// retreive the instance
	CComboBoxEntry *theComboBoxEntry = reinterpret_cast <CComboBoxEntry *> (inData);
	
	// default to accept...
        Bool doAccept = true;

	// send the request to the listener if any
        if (theComboBoxEntry != NULL && theComboBoxEntry -> GetListener() != NULL)
		static_cast <CComboBoxEntryListener *> (theComboBoxEntry -> GetListener()) ->
                	OnEntryQueryDelete (theComboBoxEntry, (UInt16&)inStart, (UInt16&)inEnd, doAccept);

	// check result
        if (doAccept)
        {
		// disconnect the function
                ::g_signal_handlers_disconnect_by_func (G_OBJECT(inGtkEditable), 
				(void*)G_CALLBACK(CComboBoxEntry::OnEntryQueryDelete), theComboBoxEntry);

		// set the associated property
                ::gtk_editable_delete_text (inGtkEditable, inStart, inEnd);

		// reconnect the signal
                ::g_signal_connect (G_OBJECT(inGtkEditable), "delete-text", 
				G_CALLBACK(CComboBoxEntry::OnEntryQueryDelete), theComboBoxEntry);
        }

	// stop the signal emission
        ::g_signal_stop_emission_by_name (GTK_OBJECT(inGtkEditable), "delete_text");
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CComboBoxEntry::OnEntryChange
//-----------------------------------------------------------------------------------------------------------------------------------------
void CComboBoxEntry::OnEntryChange (GtkEditable *, gpointer inData)
{
	// retreive our instance
	CComboBoxEntry *theComboBoxEntry = reinterpret_cast <CComboBoxEntry *> (inData);

	// send the notification to the listener if any
	if (theComboBoxEntry != NULL && theComboBoxEntry -> GetListener() != NULL)
		static_cast <CComboBoxEntryListener *> (theComboBoxEntry -> GetListener()) -> OnEntryChange (theComboBoxEntry);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CComboBoxEntry::OnEntryEditingDone
//-----------------------------------------------------------------------------------------------------------------------------------------
void CComboBoxEntry::OnEntryEditingDone	(GtkCellEditable *, gpointer inData)
{
	// retreive our instance
	CComboBoxEntry *theComboBoxEntry = reinterpret_cast <CComboBoxEntry *> (inData);

	// send the notification to the listener if any
	if (theComboBoxEntry != NULL && theComboBoxEntry -> GetListener() != NULL)
		static_cast <CComboBoxEntryListener *> (theComboBoxEntry -> GetListener()) -> OnEntryEditingDone (theComboBoxEntry);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CComboBoxEntry::OnKeyPress
//-----------------------------------------------------------------------------------------------------------------------------------------
gboolean CComboBoxEntry::OnKeyPress (GtkWidget *, GdkEventKey *ioGdkEventKey, gpointer inData)
{
        // retreive the gtkol instance
        CComboBoxEntry *theComboBoxEntry = reinterpret_cast <CComboBoxEntry *> (inData);

        // check pointer
        if (theComboBoxEntry != NULL)
        {
                // key value reference
                UInt16 &ioKey = reinterpret_cast <UInt16 &> (ioGdkEventKey -> keyval);

                // get shift states
                int inShiftStates = 0;
                if (ioGdkEventKey -> state & GDK_SHIFT_MASK  ) inShiftStates |= SHIFTSTATE_SHIFT;
                if (ioGdkEventKey -> state & GDK_LOCK_MASK   ) inShiftStates |= SHIFTSTATE_LOCK;
                if (ioGdkEventKey -> state & GDK_CONTROL_MASK) inShiftStates |= SHIFTSTATE_CONTROL;
                if (ioGdkEventKey -> state & GDK_MOD1_MASK   ) inShiftStates |= SHIFTSTATE_ALT;

                // send notification
                if (theComboBoxEntry -> GetListener() != NULL)
                        static_cast <CComboBoxEntryListener *> (theComboBoxEntry -> GetListener()) -> 
				OnKeyPress (theComboBoxEntry, inShiftStates, ioKey);

		// check the entry key code, entry validation ?
		if (ioKey == GDK_Return)
		{
			// get the combo box entry model
			CMetaClasses inModel (theComboBoxEntry->GetModel());

			// get the combo box entry instance
			GtkWidget *inGtkEntry (::gtk_bin_get_child (GTK_BIN(theComboBoxEntry->GetGtkWidget())));

			// get the entry value
			CString inNewString (::gtk_entry_get_text (GTK_ENTRY(inGtkEntry)));

			// find the text column
			bool ok=false; size_t i=0; for (; i<inModel.GetLength() && !ok; i++)
               			if (CMetaClass::MetaClassIs (__metaclass(CItemFieldValueString), *inModel[i])) ok=true;
			if (!ok) return false;

			// get the existing items	
			CComponents inComponents (theComboBoxEntry -> GetSubComponents (__metaclass(CComboBoxItem)));

			// check the field value does not exist yet
			for (size_t j=inComponents.GetLength(); j>0; j--)
			{
				// get the combo box item field values
				CItemFieldValues inFieldValues (static_cast <CComboBoxItem *> (*inComponents[j-1]) -> GetItemFieldValues());
			
				// check string field value
				if (static_cast <CItemFieldValueString *> (*inFieldValues
					[::gtk_combo_box_entry_get_text_column (GTK_COMBO_BOX_ENTRY(theComboBoxEntry->GetGtkWidget()))]) ->
					 m_FieldValue == inNewString) return false;
			}

			// append specification as an index
			SInt32 ioIndex=-1;

			// check the model, is it the simpliest one ?
			if (inModel.GetLength() == 1 && CMetaClass::MetaClassIs (__metaclass(CItemFieldValueString), *inModel[0]))
			{
				// instanciate a new combo box item
				CComboBoxItem *ioNewComboBoxItem = new CComboBoxItem ((CComboBoxEntry*)NULL, 
							CItemFieldValues (1, new CItemFieldValueString (inNewString)));

				// send the request to listener if any
				if (theComboBoxEntry -> GetListener() != NULL)
					static_cast <CComboBoxEntryListener *> (theComboBoxEntry -> GetListener()) -> 
						OnQueryAppendItem (theComboBoxEntry, ioNewComboBoxItem, inNewString, ioIndex);

				// check result
				if (ioNewComboBoxItem != NULL)
				{
					ioNewComboBoxItem -> SetOwner (theComboBoxEntry, ioIndex);
					ioNewComboBoxItem -> Select   ();
				}
			}
			// the model cannot be automaticaly handled
			else
			{
				// no default item...
				CComboBoxItem *ioNewComboBoxItem = NULL;

				// send the request to listener if any
                                if (theComboBoxEntry -> GetListener() != NULL)
                                        static_cast <CComboBoxEntryListener *> (theComboBoxEntry -> GetListener()) ->
                                                OnQueryAppendItem (theComboBoxEntry, ioNewComboBoxItem, inNewString, ioIndex);

                                // check result
                                if (ioNewComboBoxItem != NULL)
				{
					ioNewComboBoxItem -> SetOwner (theComboBoxEntry, ioIndex);
					ioNewComboBoxItem -> Select   ();
				}
			}
		}
        }

        // propagate the event further
	return false;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CComboBoxEntry);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CComboBoxEntry::CComboBoxEntry (CContainer *inOwner, const CMetaClasses &inModel, const CComboBoxEntryListener *inListener) THROWABLE
	       :CComboBox      (NULL, inModel, inListener)
{
	// check the input model...
	for (size_t i=m_Model.GetLength(), j=0; i>0; i--, j++)
		if (!CMetaClass::MetaClassIs (__metaclass(CItemFieldValue), *m_Model[j]) || *m_Model[j] == __metaclass(CItemFieldValue))
			throw new CException ("CComboBoxEntry : the input model is not handled; the specified class type \"" + 
					      (*m_Model[j])->ClassName + "\" is not a handled CItemFieldValue derived one. Aborting...");

	// check we got at least a string item field value specification
	bool ok=false; size_t i=0; for (; i<m_Model.GetLength() && !ok; i++)
                if (CMetaClass::MetaClassIs (__metaclass(CItemFieldValueString), *m_Model[i])) ok=true;
        if (!ok) throw new CException ("CComboBoxEntry : the input model is not handled; At least one CItemFieldValueString should" +
			CString("be specified. Aborting..."));

	// widget instanciation request
	if (inOwner != NULL) SetOwner (inOwner);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CComboBoxEntry::~CComboBoxEntry ()
{
	// deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CComboBoxEntry::PerformWidgetInstanciate ()
{
	// ok
	return ::gtk_combo_box_entry_new();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget initialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CComboBoxEntry::PerformWidgetInitialize ()
{
	// get the entry child
	GtkWidget *inGtkWidget (::gtk_bin_get_child (GTK_BIN(GetGtkWidget())));

	// extra signal connections
	::g_signal_handlers_disconnect_by_func (G_OBJECT(GetGtkWidget()), (void*)G_CALLBACK(CWidget::OnKeyPress), 	this);
	::g_signal_handlers_disconnect_by_func (G_OBJECT(GetGtkWidget()), (void*)G_CALLBACK(CWidget::OnKeyRelease), 	this);
	::g_signal_connect (G_OBJECT(inGtkWidget), "insert-text",  	G_CALLBACK(CComboBoxEntry::OnEntryQueryInsert), this);
        ::g_signal_connect (G_OBJECT(inGtkWidget), "delete-text",  	G_CALLBACK(CComboBoxEntry::OnEntryQueryDelete), this);
        ::g_signal_connect (G_OBJECT(inGtkWidget), "changed",     	G_CALLBACK(CComboBoxEntry::OnEntryChange),      this);
	::g_signal_connect (G_OBJECT(inGtkWidget), "editing-done", 	G_CALLBACK(CComboBoxEntry::OnEntryEditingDone), this);
	::g_signal_connect (G_OBJECT(inGtkWidget), "key-press-event",   G_CALLBACK(CComboBoxEntry::OnKeyPress),       	this);
        ::g_signal_connect (G_OBJECT(inGtkWidget), "key-release-event", G_CALLBACK(CWidget::OnKeyRelease),       	this);

	// generic handling (model affectation request, general signal attachment and widget exposure)
	CComboBox::PerformWidgetInitialize();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// listener affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
const CMetaClass * CComboBoxEntry::ListenerMustBe () const
{
	return __metaclass(CComboBoxEntryListener);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// model affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
Bool CComboBoxEntry::SetModel (const CMetaClasses &inModel)
{
	// check we got at least one CItemFieldValueString as model specification...
	bool ok=false; size_t i=0; for (; i<inModel.GetLength() && !ok; i++)
		if (CMetaClass::MetaClassIs (__metaclass(CItemFieldValueString), *inModel[i])) ok=true;
	if (!ok) return false;

	// generic call
	if (!CComboBox::SetModel (inModel)) return false;

	// get our gtk widget (pointer check made by generic call that would result in a false return code above)
	GtkWidget *inGtkWidget (GetGtkWidget());

	// text column affectation
	::gtk_combo_box_entry_set_text_column (GTK_COMBO_BOX_ENTRY(inGtkWidget), (i>0)?i-1:i);

	// ok
	return true;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// text displayed
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CComboBoxEntry::GetText () const
{
	// get our widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check and return
	return inGtkWidget != NULL ? ::gtk_entry_get_text (GTK_ENTRY(::gtk_bin_get_child (GTK_BIN(inGtkWidget)))) : CString();
}

