/*****************************************************************************************************************************************
 gtkol-treeview.c

 Simple gtkol tree view !
*****************************************************************************************************************************************/

#include "capplication.h"

//----------------------------------------------------------------------------------------------------------------------------------------
// demonstration entry point
//----------------------------------------------------------------------------------------------------------------------------------------
int main (int argc, char **argv)
{
	// be proper, catch any potential exception
	try
	{
		// declare a gtkol application instance giving it the command line arguments; those arguments are used to 
		// initialize the gtk library (there won't be any initilization if you do not specify those arguments).
		CApplication Application (argc, argv);

		CForm *Form = new CForm (&Application);
		Form -> SetCaption (CString("Gtkol Tree View"));
		Form -> Show ();

		CTreeView *TreeView = new CTreeView (Form, _IFVPixbuf_ + _IFVPack_ + _IFVString_ + _IFVString_);
		new CTreeViewItem (TreeView, CItemFieldValues (3, 
							new CItemFieldValuePixbuf(new CPixbuf(GTK_STOCK_COPY)),
							new CItemFieldValueString(CString("GRemi"), true), 
							new CItemFieldValueString(CString("Lili" ), true)));
		CTreeViewItem *tvi0 = new CTreeViewItem (TreeView, CItemFieldValues (3, 
							new CItemFieldValuePixbuf(new CPixbuf(GTK_STOCK_CUT)),
							new CItemFieldValueString(CString("Mike"), true), 
							new CItemFieldValueString(CString("Christelle" ), true)));
		CTreeViewItem *tvi1 = new CTreeViewItem (tvi0, CItemFieldValues (3, 
							new CItemFieldValuePixbuf(new CPixbuf(GTK_STOCK_PASTE)),
							new CItemFieldValueString(CString("Manu"), true), 
							new CItemFieldValueString(CString("Maeva" ), true)));

		// launch the application event queue dispatching
		Application.Run ();
	}
	// an exception occurred, just print it and return
	catch (CException *e)
	{
		fprintf (stderr, "%s\n", e->GetMessage().Get());
		return -1;
	}

	// ok
	return 0;
}

