#include "capplication.h"

class CMyButtonListener : public CButtonListener
{
	virtual void OnDragDrop (CObject *inSender, CObject *inReceiver, CObject *&ioTarget, SInt16 &ioIndex, TPoint p, Bool &)
	{
		printf ("OnDragDrop sender %s, receiver %s, target %s, index %d (x : %d,  y : %d)\n", metaclass_cast(inSender)->ClassName.Get(),
			metaclass_cast(inReceiver)->ClassName.Get(), metaclass_cast(ioTarget)->ClassName.Get(), ioIndex, p.x, p.y);
	}
};

int main (int argc, char **argv)
{
	CApplication Application (argc, argv);

	CForm *MainForm = new CForm (&Application);
	MainForm -> Show ();
	CPaned *Paned = new CVPaned (MainForm);
	Paned -> SetDropSite (true);

	CButton *b = new CButton (NULL, new CMyButtonListener());
	b -> SetOwner (Paned, 0);
	b -> SetDraggable (true);

	CForm *Form = new CForm (&Application);
	Form -> Show ();
	Form -> SetDropSite (true);
	b = new CButton (NULL, new CMyButtonListener());
	b -> SetOwner (Paned, 0);
	b -> SetDraggable (true);

	Application.Run ();

	return 0;
}
