/*****************************************************************************************************************************************
 gtkol-dnd.c

 Simple gtkol d&d sample.
*****************************************************************************************************************************************/

#include "capplication.h"

//----------------------------------------------------------------------------------------------------------------------------------------
// CCloseButtonListener
//----------------------------------------------------------------------------------------------------------------------------------------
class CCloseButtonListener : public CButtonListener
{
        // called when the button is clicked
        virtual void OnClick (CObject *inSender)
        {
                // close the form the button instance belongs to
                static_cast <CForm *> (static_cast <CButton *> (inSender) -> GetOwner (__metaclass(CForm))) -> Close ();
        }

	virtual void OnDragStart (CObject *&ioSender, TPoint &, CPixbuf *&)
	{
		printf ("OnDragStart %s %s\n", metaclass_cast(ioSender)->ClassName.Get(), 
			static_cast <CButton *> (ioSender) -> GetCaption().Get());
	}

	virtual void OnDragOver	(CObject *inDragged, CObject *inReceiver, CObject *inTargeted, TPoint inRelativePoint, Bool &ioAccept)
	{
		printf ("OnDragOver : dragged %s, receiver %s, target %s\n", metaclass_cast(inDragged)->ClassName.Get(), 
			metaclass_cast(inReceiver)->ClassName.Get(),
			metaclass_cast(inTargeted)->ClassName.Get());
	}

	virtual void OnDragDrop	(CObject *inDragged, CObject *inReceiver, CObject *&ioTargeted, SInt16 &ioIndex, 
				 TPoint inRelativePoint, Bool &ioDoDrop)
	{
		printf ("OnDragDrop : dragged %s, receiver %s, target %s, index %d\n", metaclass_cast(inDragged)->ClassName.Get(), 
			metaclass_cast(inReceiver)->ClassName.Get(),
			metaclass_cast(ioTargeted)->ClassName.Get(), ioIndex);
		if (inReceiver -> ClassIs (__metaclass(CTableLayout)))
		{
			TPoint p (static_cast <CTableLayout *> (inReceiver) -> GetTablePackFromPoint (inRelativePoint));
			static_cast <CTableLayout *> (inReceiver) -> SetTablePack (p.x, p.x+1, p.y, p.y+1);
		}
	}
};

class CMyRadioButtonListener : public CButtonListener
{
	virtual void OnClick (CObject *inSender)
	{
		printf ("CRadioButton::OnClick %d %d\n", CString(static_cast <CComponent *> (inSender) -> GetId()).ToULong(),
			static_cast <CRadioButton *> (inSender) -> IsChecked());
	}
};

//----------------------------------------------------------------------------------------------------------------------------------------
// demonstration entry point
//----------------------------------------------------------------------------------------------------------------------------------------
int main (int argc, char **argv)
{
	// be proper, catch any potential exception
	try
	{
		// declare a gtkol application instance giving it the command line arguments; those arguments are used to 
		// initialize the gtk library (there won't be any initilization if you do not specify those arguments).
		CApplication Application (argc, argv);

		// instanciate a main form and set its caption
		CForm *MainForm = new CForm (&Application);
		MainForm -> SetCaption  (CString("Gtkol d&d"));
		MainForm -> SetBounds   (TBounds (150, 150, 180, 80));

		CHPaned *HPaned = new CHPaned (MainForm);
		
		CVBoxLayout *VBoxLayout = new CVBoxLayout (HPaned);
		VBoxLayout -> SetDropSite (true);

		// instanciate a button whose purpose is to close the form when clicked, associate it to our specific listener to
		// do so and set its caption
		CButton *Button = new CButton (VBoxLayout, new CCloseButtonListener());
		Button -> SetCaption   (CString("_Drag or Click !"));
		Button -> SetDraggable (true);
		Button = new CButton (VBoxLayout, new CCloseButtonListener());
		Button -> SetCaption   (CString("Dr_ag 1"));
		Button -> SetDraggable (true);

		CHBoxLayout *HBoxLayout = new CHBoxLayout (HPaned);
		HBoxLayout -> SetDropSite (true);
		Button = new CButton (HBoxLayout, new CCloseButtonListener());
		Button -> SetCaption   (CString("Dr_ag 3"));
		Button -> SetDraggable (true);

		CRadioButton *rb0 = new CRadioButton (HBoxLayout, new CMyRadioButtonListener());
		rb0 -> SetDraggable (true);
		CRadioButton *rb1 = new CRadioButton (HBoxLayout, new CMyRadioButtonListener());
		rb1 -> SetDraggable (true);
		CRadioButton *rb2 = new CRadioButton (HBoxLayout, new CMyRadioButtonListener());
		rb2 -> SetDraggable (true);
		CRadioButton *rb5 = new CRadioButton (HBoxLayout, new CMyRadioButtonListener());
		rb5 -> SetDraggable (true);

		CRadioButton *rb3 = new CRadioButton (VBoxLayout, new CMyRadioButtonListener());
		rb3 -> SetDraggable (true);
		CRadioButton *rb4 = new CRadioButton (VBoxLayout, new CMyRadioButtonListener());
		rb4 -> SetDraggable (true);

		// instanciate another form
		CForm *Form = new CForm (&Application);
		Form -> SetCaption  (CString("Gtkol d&d"));
		Form -> SetBounds   (TBounds (350, 150, 200, 100));
		Form -> SetDropSite (true);
		
		Button = new CButton (Form, new CCloseButtonListener());
		Button -> SetCaption   (CString("Dra_g 2"));
		Button -> SetDraggable (true);

		// show our job (the form is the only gtkol widget that is not shown by default)
		Form -> Show ();
		MainForm -> Show ();



		Form = new CForm (&Application);
		CTableLayout *TableLayout = new CTableLayout (Form);
		TableLayout -> SetTableSize (4, 5);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		TableLayout -> SetTablePack (1, 3, 1, 3);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		(new CButton (TableLayout, new CCloseButtonListener())) -> SetDraggable (true);
		TableLayout -> SetDropSite (true);
		Form -> Show ();




		// launch the application event queue dispatching
		Application.Run ();
	}
	// an exception occurred, just print it and return
	catch (CException *e)
	{
		fprintf (stderr, "%s\n", e->GetMessage().Get());
		return -1;
	}

	// ok
	return 0;
}

