/*******************************************************************************************************************************************
 chboxlayout.h
 
 CClass	
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
	     |--CControl
	        |--CWidget
		   |--CContainer
		      |--CLayout
		         |--CBoxLayout
			    |--CVBoxLayout

 Vertical Box layout definition.
*******************************************************************************************************************************************/

#ifndef __CVBOXLAYOUT_H__
#define __CVBOXLAYOUT_H__

#include "cboxlayout.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// CVBoxLayout class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CVBoxLayout : public CBoxLayout
{
	// instanciation section
	public :

		CVBoxLayout			(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CVBoxLayout		();

	// specific widget instanciation
	protected :

		// widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();

	// CLayout redefinition
	public :

		// this function returns the insertion index of a given potential new child from the layout's relative coordinates
		// specifications; checks if a control has to be inserted before or after the widget referenced at the given position
		virtual SInt16			GetDropIndexAtPoint		(const TPoint &inRelativePoint, 
										 const CControl *inCandidate) const;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('vbly', CVBoxLayout, CBoxLayout);

#endif
