#include <gdk_imlib.h>
#include <gtk/gtk.h>
#include <stdio.h>

#include "../gtk/gtkimreg.h"
#include "../gtk/gtkimmov.h"

#define FIX_W  200
#define FIX_H  100

/*----------------------------------------------------------------
 *  cut image
 *----------------------------------------------------------------*/

static void 
show_image(GdkWindow *win, GdkImlibImage *im)
{
  GdkPixmap *p, *m;

  g_return_if_fail ( win );
  g_return_if_fail ( im );
   
  gdk_imlib_render(im, im->rgb_width, im->rgb_height);
  p = gdk_imlib_move_image(im);
  m = gdk_imlib_move_mask(im);
  gdk_window_resize(win, im->rgb_width, im->rgb_height);
  gdk_window_set_back_pixmap(win, p, 0);
  if (m) gdk_window_shape_combine_mask(win, m, 0, 0);
  gdk_window_show(win);
  gdk_flush();
}

static void 
message(GtkWidget *button)
{
  g_warning("You will have misfortune at next Friday, 13th!");
}

static void
cut_image(GtkWidget *widget, GtkImReg *imreg)
/*
 * --- Parameter: ---
 * GtkWidget *widget : OK-button inside GtkImReg widget, drawing GdkWindow set as user data
 * GtkImReg  *imreg  : imreg widget, *im set as user_data
 */
{
  gint           le, to, ri, bo;
  GdkImlibImage *im;
  GdkWindow     *win;

  g_return_if_fail ( GTK_IS_IMREG(imreg) ) ;
  g_return_if_fail ( (im = gtk_object_get_user_data(GTK_OBJECT(imreg)) ) ) ;
  g_return_if_fail ( GTK_IS_BUTTON(widget) ) ;
  g_return_if_fail ( (win = gtk_object_get_user_data(GTK_OBJECT(widget)) ) ) ;

  gtk_imreg_get(imreg, &le, &to, &ri, &bo);
  gtk_widget_destroy(GTK_WIDGET(imreg));
  if ( ( le == 0                 && to == 0 &&
         ri == im->rgb_width - 1 && bo == im->rgb_height - 1 ) ||
       le == ri                  || bo == to ) {
    g_warning("Nothing to cut");
    return;
  }
  gdk_imlib_crop_image(im, le, to, ri - le, bo - to);
  show_image(win, im);
}

static void
moved_images(GtkWidget *widget, GtkImMov *immov)
/*
 * --- Parameter: ---
 * GtkWidget *widget : OK-button inside GtkImReg widget, drawing GdkWindow set as user data
 * GtkImMov  *immov  : immov widget, *im set as user_data
 */
{
  GList *movl;
   
  g_message("Images moved successfully\n");
  gtk_immov_free_struct(immov->fix);
  for ( movl = immov->iml; movl; movl = movl->next ) 
    gtk_immov_free_struct((GtkImMovPic *)(movl->data));
  
  gtk_widget_destroy(GTK_WIDGET(immov));
}

static GdkImlibImage
*image_load_from_selection(GtkFileSelection *fs, char **filename)
{
  GdkImlibImage *im;

  g_return_val_if_fail ( fs, NULL );
  g_return_val_if_fail ( GTK_IS_FILE_SELECTION(fs), NULL );
  
  *filename = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
  gtk_widget_destroy(GTK_WIDGET(fs));
  if ( !*filename ) {
    g_warning("Invalid filename.");
    return NULL ;
  }

  if ( !(im = gdk_imlib_load_image(*filename)) ) {
    g_warning("Please select a valid image file.");
    g_free(*filename);
    *filename = NULL;
    return NULL;
  }
  return im;
}

static   GtkWidget
*common_load(GtkFileSelection *fs, GdkWindow **win, gchar *tit, gint w, gint h)
{
  GdkWindowAttr  attr;
  GtkWidget     *widget, *button;
  GdkImlibImage *im;
  gchar         *filename, *cut_title;

  g_return_val_if_fail ( fs, NULL );
  g_return_val_if_fail ( GTK_IS_FILE_SELECTION(fs), NULL );
  
  g_return_val_if_fail ( (im = image_load_from_selection(fs, &filename)), NULL) ;

  attr.window_type = GDK_WINDOW_TOPLEVEL;
  attr.wclass      = GDK_INPUT_OUTPUT;
  attr.event_mask  = GDK_STRUCTURE_MASK;
  attr.colormap    = gdk_imlib_get_colormap();
  attr.visual      = gdk_imlib_get_visual();
  *win             = gdk_window_new(NULL, &attr,  GDK_WA_COLORMAP | GDK_WA_VISUAL);
  gdk_window_set_title(*win, filename);
  show_image(*win, im);
  if ( w >= im->rgb_width  ) w = im->rgb_width / 2;
  if ( h >= im->rgb_height ) h = im->rgb_height / 2;  

  button = gtk_button_new_with_label("Whatever happens, do\n >>> NOT <<<\n press this button");
  gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(message), NULL);
  
  cut_title = g_strdup_printf("%s %s", tit, filename);
  widget    = gtk_imreg_new(cut_title, im, w, h, button);
  g_free(filename);
  g_free(cut_title);

  gtk_window_position(GTK_WINDOW(widget), GTK_WIN_POS_MOUSE);
  gtk_signal_connect(GTK_OBJECT(widget), 
                     "destroy", 
                     GTK_SIGNAL_FUNC(gtk_widget_destroyed), &widget);

  gtk_object_set_user_data(GTK_OBJECT(widget), im);
  gtk_object_set_user_data(GTK_OBJECT(GTK_IMREG(widget)->ok_button), *win);
  gtk_signal_connect(GTK_OBJECT(GTK_IMREG(widget)->ok_button), "clicked", 
                     GTK_SIGNAL_FUNC(cut_image), widget);
  gtk_signal_connect_object(GTK_OBJECT(GTK_IMREG(widget)->cancel_button), "clicked", 
                            GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(widget));
  
  gtk_widget_show(widget);    
  return widget;
}

char *file_to_load = "paul.jpg";

static void
create_cut_or_sel(GtkSignalFunc func, GtkWidget **widget, GdkWindow **win)
{
  static GtkWidget *window = NULL;
  gint              ret = 0;

  if ( *widget && GTK_IS_WIDGET(*widget) ) {
    gtk_widget_destroy (*widget);
    *widget = NULL;
    ret     = 1;
  }
  if ( *win ) {
    gdk_window_destroy (*win);
    *win = NULL;
    return;
  }
  if ( ret ) return;
     
  if (!window) {
    window = gtk_file_selection_new("Load any image");
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(window), file_to_load);
    gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
    gtk_signal_connect(GTK_OBJECT(window), 
                       "destroy", 
                       GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);

    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window)->ok_button), 
                       "clicked", 
                       GTK_SIGNAL_FUNC(func), window);
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window)->cancel_button), 
                       "clicked", 
                       GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);
  }
  
  if (!GTK_WIDGET_VISIBLE (window))
    gtk_widget_show_all (window);
  else {
    gtk_widget_destroy (window);
  }
}

static GdkWindow *CutWin = NULL, *SelWin = NULL, *MovWin = NULL;
static GtkWidget *CutImreg = NULL, *SelImreg = NULL, *ImMov = NULL;
static void       create_cut(void), create_sel(void), create_mov(void);

static void
create_imreg_cut(GtkWidget *widget, GtkFileSelection *fs)
{
  if ( !( CutImreg = common_load(fs, &CutWin, "Cut", 0, 0) ) ) create_cut();
}

static void
create_imreg_sel(GtkWidget *widget, GtkFileSelection *fs)
{
  if ( !( SelImreg = common_load(fs, &SelWin, "Select region from", FIX_W, FIX_H) ) ) create_sel();
}

static void
create_immov(GtkWidget *widget, GtkFileSelection *fs)
{
  GdkImlibImage *iml = NULL;
  gchar         *fixfile = NULL;
  
  GtkImMovPic   *fix;
  GList         *movl;

  g_return_if_fail ( (iml = image_load_from_selection(fs, &fixfile)) ) ;

  fix = gtk_immov_copy_struct (iml->rgb_width, iml->rgb_height, iml->rgb_data, iml->filename);

  gdk_imlib_crop_image(iml, 200, 50, 250, 140);

  movl = g_list_append(NULL, 
                gtk_immov_copy_struct (iml->rgb_width, iml->rgb_height, 
                                      iml->rgb_data, "Section 1") );

  gdk_imlib_crop_image(iml, 8, 11, 234, 115);
  movl = g_list_append(movl, 
                gtk_immov_copy_struct (iml->rgb_width, iml->rgb_height, 
                                      iml->rgb_data, "Section 2") ); 
  gdk_imlib_kill_image(iml);

  widget    = gtk_immov_new(NULL, fix, movl, 0);

  gtk_window_position(GTK_WINDOW(widget), GTK_WIN_POS_MOUSE);
  gtk_signal_connect(GTK_OBJECT(widget), 
                     "destroy", 
                     GTK_SIGNAL_FUNC(gtk_widget_destroyed), &widget);

  gtk_object_set_user_data(GTK_OBJECT(widget), fix);
  gtk_signal_connect(GTK_OBJECT(GTK_IMMOV(widget)->ok_button), "clicked", 
                     GTK_SIGNAL_FUNC(moved_images), widget);
  gtk_signal_connect_object(GTK_OBJECT(GTK_IMMOV(widget)->cancel_button), "clicked", 
                            GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(widget));
  
  gtk_widget_show(widget);    
}

static void
create_cut(void)
{
  create_cut_or_sel(create_imreg_cut, &CutImreg, &CutWin);
}

static void
create_sel(void)
{
  create_cut_or_sel(create_imreg_sel, &SelImreg, &SelWin);
}

static void
create_mov(void)
{
  create_cut_or_sel(create_immov, &ImMov, &MovWin);
}

/*----------------------------------------------------------------
 *  general functions (from testgtk)
 *----------------------------------------------------------------*/

static void
do_exit (GtkWidget *widget, GtkWidget *window)
{
  gtk_widget_destroy (window);
  gtk_main_quit ();
}

static void
create_main_window (void)
{
  struct {
    char *label;
    void (*func) ();
  } buttons[] =
    {
      { "cut image", create_cut },
      { "select image region", create_sel },
      { "move images", create_mov },
    };
  int nbuttons = sizeof (buttons) / sizeof (buttons[0]);
  GtkWidget *window;
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *scrolled_window;
  GtkWidget *button;
  GtkWidget *label;
  GtkWidget *separator;
  int i;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
  gtk_widget_set_name (window, "main window");
  gtk_widget_set_usize (window, 200, 250); 
  gtk_widget_set_uposition (window, 20, 20);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC(gtk_main_quit),
		      NULL);
  gtk_signal_connect (GTK_OBJECT (window), "delete-event",
		      GTK_SIGNAL_FUNC (gtk_false),
		      NULL);

  box1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box1);

  label = gtk_label_new ("GtkImreg");
  gtk_box_pack_start (GTK_BOX (box1), label, FALSE, FALSE, 0);

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_set_border_width (GTK_CONTAINER (scrolled_window), 10);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
     		                  GTK_POLICY_AUTOMATIC, 
                                  GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (box1), scrolled_window, TRUE, TRUE, 0);

  box2 = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window), box2);
  gtk_container_set_focus_vadjustment (GTK_CONTAINER (box2),
				       gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (scrolled_window)));
  gtk_widget_show (box2);

  for (i = 0; i < nbuttons; i++)
    {
      button = gtk_button_new_with_label (buttons[i].label);
      if (buttons[i].func)
        gtk_signal_connect (GTK_OBJECT (button), 
			    "clicked", 
			    buttons[i].func,
                            NULL);
      else
        gtk_widget_set_sensitive (button, FALSE);
      gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
    }

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);

  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
  gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);

  button = gtk_button_new_with_label ("close");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (do_exit),
		      window);
  gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);

  gtk_widget_show_all (window);
}

gint 
main(gint argc, char *argv[])
{
  gtk_init(&argc, &argv);
  gdk_imlib_init();
  
  create_main_window();
  
  gtk_main();

  return 0;
}

