#!/usr/bin/env ruby
# encoding: UTF-8

=begin
Copyright 2010 Vincent Carmona
vinc4mai@gmail.com

This file is part of rghk.

    rghk is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    rghk is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ZiK; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
=end

require 'gtk2'
require 'rghk'

class GHLabel < Gtk::Label
	def initialize(text)
		@n=0
		super(text)
	end

	def update
		@n+=1
		self.text="<Ctrl>+<a> hit #{@n} times."
	end
end

kb=GlobalHotKeys::KeyBinder.new

label=GHLabel.new('Clik on bind button to set a global hotkey (<Ctrl>+<a>).')
b1=Gtk::Button.new("\n\n\t\tBind\t\t\n\n")
b1.signal_connect('clicked'){
	kb.bind(Gdk::Keyval::GDK_a,  GlobalHotKeys::Modifier::CONTROL_MASK){label.update}
	label.text="Hit <Ctrl>+<a> keys from a window."
}
b2=Gtk::Button.new("\n\n\t\tUnbind\t\t\n\n")
b2.signal_connect('clicked'){
	kb.unbind
	label.text="Global hotkey (<Ctrl>+<a>) is unset."
}

box=Gtk::VBox.new
box.pack_start(b1)
box.pack_start(b2)
box.pack_start(label)

w=Gtk::Window.new
w.add(box)
w.show_all
w.signal_connect("delete_event"){GlobalHotKeys::KeyBinder.unbind_all; Gtk.main_quit}

Gtk.main
