<?xml version="1.0" encoding="ISO-8859-1"?>
<!--Es mssen immer mindestens drei Jahre im Stylesheet mglich sein, wegen der Verzinsung nach  233a AO. d.h. das aktuelle + die beiden vorangegangenen -->
<!--Beispiel: Voranmeldungen fr 12/2004 knnen bis zum 31.03.2006 abgegeben werden -->
<!-- Version 1.2.1  A.M.-->
<xsl:stylesheet version="1.0" xmlns:elster="http://www.elster.de/2002/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="html" indent="yes" encoding="ISO-8859-1"/>
	<xsl:template match="elster:Elster">
		<html>
			<head>
				<title>StylesheetLStA</title>
				<STYLE TYPE="text/css">
				body {   	color: #000000;                   margin: 8px 8px;   background: #FFFFFF;    padding: 0px;  font-family:helvetica;    font-style:normal;         font-size:10pt;          }     
				td {        	background: #FFFFFF;        padding: 0px;       font-family:helvetica;   	font-style:normal;   	font-size:10pt;          }     
				td.kz {    	background: #FFFFFF;        padding: 2px;       font-family:helvetica;       font-style:normal;    font-size:10pt;          }      
				small {		background: #FFFFFF;        padding: 0px;       font-family:helvetica;       font-style:normal;    font-size:8pt;          }   
				big {		background: #FFFFFF;        padding: 0px;       font-family:helvetica;       font-weight:bold;     font-size:12pt;          }     
				b {			background: #FFFFFF;        padding: 0px;       font-family:helvetica;       font-weight:bold;      font-size:10pt;          }     
			
				</STYLE>

			</head>
			<body>
				<table width="645" cellspacing="2">
					
				<tr>
					<td align="left">		
					<small>bermittelt von:</small>
					</td>
				</tr>
				<tr>
					<td align="left" >
						<small><xsl:value-of select="elster:DatenTeil/elster:Nutzdatenblock/elster:Nutzdaten/elster:Anmeldungssteuern/elster:DatenLieferant/elster:Name"/></small>
					</td>
					<td  align="right">
						<xsl:choose>
							<xsl:when test="elster:TransferHeader/elster:EingangsDatum">
								<xsl:text>Eingang auf Server </xsl:text>
								<xsl:apply-templates select="elster:TransferHeader/elster:EingangsDatum"/>
							</xsl:when>
							<xsl:otherwise>Ausdruck vor bermittlung </xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<tr>
					<td align="left">
						<small><xsl:value-of select="elster:DatenTeil/elster:Nutzdatenblock/elster:Nutzdaten/elster:Anmeldungssteuern/elster:DatenLieferant/elster:Strasse"/></small>
					</td>
					<td align="right">
							<xsl:if test="elster:TransferHeader/elster:TransferTicket">
								Transferticket  
								<xsl:value-of select="elster:TransferHeader/elster:TransferTicket"/>
							</xsl:if>
						</td>
					</tr>
					<tr>
						<td align="left" colspan="1">
							<small><xsl:value-of select="elster:DatenTeil/elster:Nutzdatenblock/elster:Nutzdaten/elster:Anmeldungssteuern/elster:DatenLieferant/elster:PLZ"/> &#160;
							<xsl:value-of select="elster:DatenTeil/elster:Nutzdatenblock/elster:Nutzdaten/elster:Anmeldungssteuern/elster:DatenLieferant/elster:Ort"/></small>
						</td>
						<td align="right" >
							Erstellungsdatum    
							<xsl:apply-templates select="elster:DatenTeil/elster:Nutzdatenblock/elster:Nutzdaten/elster:Anmeldungssteuern/elster:Erstellungsdatum"/>
						</td>
					</tr>
					<tr>
						<td align="left">
							<small><xsl:value-of select="elster:DatenTeil/elster:Nutzdatenblock/elster:Nutzdaten/elster:Anmeldungssteuern/elster:DatenLieferant/elster:Telefon"/></small>
						</td>
					</tr>
					<tr>
						<td align="left">
							<small><xsl:value-of select="elster:DatenTeil/elster:Nutzdatenblock/elster:Nutzdaten/elster:Anmeldungssteuern/elster:DatenLieferant/elster:Email"/>	</small>									</td>
					</tr>
			</table>
			<table width="645">
					<tr>
						<td align="left"><br/>
							<big><xsl:if test="elster:TransferHeader[starts-with(elster:Testmerker,'7')]">
								*** TESTFALL ***
							</xsl:if></big>
						</td>
						<td align="center"><br/>
							<xsl:if test="elster:TransferHeader[starts-with(elster:Testmerker,'7')]">
								<big>*** TESTFALL ***</big>
							</xsl:if>
						</td>

						<td align="right"><br/>
							<xsl:if test="elster:TransferHeader[starts-with(elster:Testmerker,'7')]">
								<big>*** TESTFALL ***</big>
							</xsl:if>
						</td>
					</tr> 
				</table>
				<xsl:apply-templates select="//elster:Steuerfall/*"/>
			</body>
		</html>
	</xsl:template>
	<!-- **************** STEUERFALL ********************************* -->
	<xsl:template match="//elster:Steuerfall/*">
		<html>
			<body>
				<table width="645">
					<tr>
						<td align="center" colspan="2">
							<hr/>				<!-- ***********************************************************-->
							<hr/>				<!-- *********************************************************** -->
						</td>
					</tr>
					<tr>
						<td align="left">
							<small>
								<xsl:call-template name="Erstellt_von"/>
							</small>
							<br/>
							<p/>
						</td>
					</tr>
					<tr>
						<td align="left">
							<br/>
							<xsl:if test="substring-after((substring-after(substring-after(substring-after(substring-after(normalize-space(elster:Kz09),'*'),'*'),'*'),'*')),'*')">
								<xsl:text>Unternehmer: </xsl:text>
							</xsl:if>
						</td>
						<td align="right">
							<br/>
							<xsl:call-template name="Steuernummer"/>
						</td>
					</tr>
					<tr>
						<td align="left">
							<xsl:if test="substring-after((substring-after(substring-after(substring-after(substring-after(normalize-space(elster:Kz09),'*'),'*'),'*'),'*')),'*')">												<xsl:call-template name="Unternehmer"/>
							</xsl:if>
							<br/>
						</td>
					</tr>
					<tr>
						<td align="center" colspan="2">
							<br/>							
								<p>
									<big>
										<xsl:text>Lohnsteuer-Anmeldung</xsl:text>
									</big>		
								</p>
								<p>
									<big>
										<xsl:call-template name="Zeitraum"/>
										<xsl:value-of select="elster:Jahr"/>
									</big>
								</p>
								<br/>
						</td>
					</tr>
				</table>
				<table width="645">
					<tr>
						<xsl:call-template name="BearbeitungsKennzahlen"/>
					</tr>
				
				</table>
				
				<table width="645">
					<tr>
						<xsl:call-template name="LStA"/>
					</tr>
				</table>
				<table width="645">					
						<xsl:call-template name="Hinweise"/>
				</table>
			</body>
		</html>
	</xsl:template>
	<!--*****    ERSTELLUNGSDATUM    *******************************-->
	<xsl:template match="elster:Erstellungsdatum">
		<xsl:value-of select="substring(.,7)"/>
		<xsl:text>.</xsl:text>
		<xsl:value-of select="substring(.,5,2)"/>
		<xsl:text>.</xsl:text>
		<xsl:value-of select="substring(.,1,4)"/>
	</xsl:template>
	<!--******   EINGANGSDATUM   *******************************-->
	<xsl:template match="elster:TransferHeader/elster:EingangsDatum">
		<xsl:value-of select="substring(.,7,2)"/>
		<xsl:text>.</xsl:text>
		<xsl:value-of select="substring(.,5,2)"/>
		<xsl:text>.</xsl:text>
		<xsl:value-of select="substring(.,1,4)"/>
		<xsl:text>,</xsl:text>
		<xsl:value-of select="substring(.,9,2)"/>
		<xsl:text>:</xsl:text>
		<xsl:value-of select="substring(.,11,2)"/>
		<xsl:text>:</xsl:text>
		<xsl:value-of select="substring(.,13,2)"/>
	</xsl:template>
	<!--*******   ERSTELLT VON   *******************************-->
	<xsl:template name="Erstellt_von">
		<!-- aus Kz09 -->
		<xsl:if test="contains(elster:Kz09,'*')">
			<xsl:if test="not(starts-with(normalize-space(substring-after(elster:Kz09,'*')),'*'))">
				<xsl:text>Erstellt von: </xsl:text>
			</xsl:if>
		</xsl:if>
		&#160;
		<!-- NameBerater -->
		<xsl:value-of select="substring-before(substring-after(elster:Kz09,'*'),'*')"/>
		&#160;&#160;&#160;&#160;&#160;&#160;
		<!-- Berufsbezeichung -->
		<xsl:value-of select="substring-before((substring-after(substring-after(elster:Kz09,'*'),'*')),'*')"/>
		&#160;&#160;&#160;&#160;&#160;&#160;
		<!-- Vorwahl -->
		<xsl:value-of select="substring-before(substring-after((substring-after(substring-after(elster:Kz09,'*'),'*')),'*'),'*')"/>
		&#160;
		<!-- Rufnummer -->
		<xsl:value-of select="substring-before(substring-after((substring-after(substring-after(substring-after(elster:Kz09,'*'),'*'),'*')),'*') ,'*')"/>
	</xsl:template>
	<!--****  UNTERNEHMER    *****************-->
	<xsl:template name="Unternehmer">
		<xsl:value-of select="substring-after((substring-after(substring-after(substring-after(substring-after(elster:Kz09,'*'),'*'),'*'),'*')),'*')"/>
	</xsl:template>
	<!--****  STEUERNUMMER    *****************-->
	<xsl:template name="Steuernummer">
		<xsl:text>Steuernummer:  </xsl:text>
		<xsl:if test="elster:Steuernummer[starts-with(.,'10')]">
			<xsl:call-template name="StNr335"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'11')]">
			<xsl:call-template name="StNr235"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'21')]">
			<xsl:call-template name="StNr235a"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'22')]">
			<xsl:call-template name="StNr235"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'23')]">
			<xsl:call-template name="StNr235"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'24')]">
			<xsl:call-template name="StNr235a"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'26')]">
			<xsl:call-template name="StNr0235"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'27')]">
			<xsl:call-template name="StNr2341"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'28')]">
			<xsl:call-template name="StNr55"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'3')]">
			<xsl:call-template name="StNr335"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'4')]">
			<xsl:call-template name="StNr335"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'5')]">
			<xsl:call-template name="StNr344"/>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'9')]">
			<xsl:call-template name="StNr335"/>
		</xsl:if>
	</xsl:template>
	<!-- Steuernummern formatieren -->
	<xsl:template name="StNr0235">
		<xsl:text>0</xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,3,2)"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,6,3)"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,9,5)"/>
	</xsl:template>
	<xsl:template name="StNr2341">
		<xsl:value-of select="substring(elster:Steuernummer,3,2)"/>
		<xsl:text>/</xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,6,3)"/>
		<xsl:text>/</xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,9,4)"/>
		<xsl:text>/</xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,13,1)"/>
	</xsl:template>
	<xsl:template name="StNr235">
		<xsl:value-of select="substring(elster:Steuernummer,3,2)"/>
		<xsl:text>/</xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,6,3)"/>
		<xsl:text>/</xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,9,5)"/>
	</xsl:template>
	<xsl:template name="StNr235a">
		<xsl:value-of select="substring(elster:Steuernummer,3,2)"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,6,3)"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,9,5)"/>
	</xsl:template>
	<xsl:template name="StNr344">
		<xsl:value-of select="substring(elster:Steuernummer,2,3)"/>
		<xsl:text>/</xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,6,4)"/>
		<xsl:text>/</xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,10,4)"/>
	</xsl:template>
	<xsl:template name="StNr335">
		<xsl:value-of select="substring(elster:Steuernummer,2,3)"/>
		<xsl:text>/</xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,6,3)"/>
		<xsl:text>/</xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,9,5)"/>
	</xsl:template>
	<xsl:template name="StNr55">
		<xsl:value-of select="substring(elster:Steuernummer,3,2)"/>
		<xsl:value-of select="substring(elster:Steuernummer,6,3)"/>
		<xsl:text>/</xsl:text>
		<xsl:value-of select="substring(elster:Steuernummer,9,5)"/>
	</xsl:template>
	<!-- Zeitraume aufloesen -->
	<xsl:template name="Zeitraum">
		<xsl:if test="elster:Zeitraum[starts-with(.,'41')]">
			1. Kalendervierteljahr 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'42')]">
			2. Kalendervierteljahr 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'43')]">
			3. Kalendervierteljahr 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'44')]">
			4. Kalendervierteljahr 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'01')]">
			Januar 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'02')]">
			Februar 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'03')]">
			Mrz  
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'04')]">
			April  
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'05')]">
			Mai 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'06')]">
			Juni 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'07')]">
			Juli 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'08')]">
			August 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'09')]">
			September 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'10')]">
			Oktober 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'11')]">
			November 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'12')]">
			Dezember 
		</xsl:if>
		<xsl:if test="elster:Zeitraum[starts-with(.,'19')]">
			Kalenderjahr 
		</xsl:if>

			</xsl:template>
	<!-- **************** BearbeitungsKennzahlen ********************************* -->
	<xsl:template name="BearbeitungsKennzahlen">
		
		<tr>
			<td colspan="2">
				<table align="right" width="645" cellspacing="3">
					<tr>
						<td width="70%"/>
						<td width="5%" align="center">Kz</td>
						<td width="25%" align="right">Wert</td>
					</tr>
					<tr>
						<xsl:if test="elster:Kz10">
							<td colspan="1" align="left">
								<br/>
								<xsl:text>  Berichtigte Anmeldung </xsl:text>
							</td>
							<td colspan="1" align="center" valign="bottom">10</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz10"/>
							</td>
						</xsl:if>
					</tr>					
					<tr>
						
						<xsl:if test="elster:Kz86">
							<td colspan="1" align="left">
								<br/>
								<xsl:text>Zahl der Arbeitnehmer  </xsl:text>
								
							</td>
							<td colspan="1" align="center" valign="bottom">86</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz86"/>
							</td>
						</xsl:if>
					</tr>
					
				</table>
			</td>
		</tr>
	</xsl:template>
	<!-- **************** LStA ********************************* -->
	<xsl:template name="LStA">
		<br/>
		<hr/>
		<tr>
			<td colspan="2">
				<table align="right" width="645" cellspacing="3">
					<tr>
						<td width="70%"/>
						<td width="5%" align="center">Kz</td>
						<td width="25%" align="right">Betrag</td>
					</tr>
					<xsl:choose>
						<xsl:when test="elster:Jahr[starts-with(.,'2007')]">
							<tr>
								<xsl:if test="elster:Kz42">
									<td colspan="1" align="left">
										<br/>Summe der einzubehaltenen Lohnsteuer								
									</td>
									<td colspan="1" align="center" valign="bottom">42</td>
									<td colspan="1" align="right" valign="bottom">
										<xsl:value-of select="elster:Kz42"/>
									</td>
								</xsl:if>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<tr>
								<xsl:if test="elster:Kz42">
									<td colspan="1" align="left">
										<br/>Lohnsteuer									
									</td>
									<td colspan="1" align="center" valign="bottom">42</td>
									<td colspan="1" align="right" valign="bottom">
										<xsl:value-of select="elster:Kz42"/>
									</td>
								</xsl:if>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
					<tr>
						<xsl:if test="elster:Kz41">
							<td colspan="1" align="left">
								<br/>
								Summe der pauschalen Lohnsteuer
							</td>
							<td colspan="1" align="center" valign="bottom">41</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz41"/>
							</td>
						</xsl:if>
					</tr>

					<tr>
						<xsl:if test="elster:Kz43">
							<td colspan="1" align="left">
								<br/>
								abzglich an Arbeitnehmer ausgezahltes Kindergeld
							</td>
							<td colspan="1" align="center" valign="bottom">43</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz43"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz46">
							<td colspan="1" align="left">
								<br/>
								abzglich an Arbeitnehmer ausgezahlte Bergmannsprmien
							</td>
							<td colspan="1" align="center" valign="bottom">46</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz46"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz33">
							<td colspan="1" align="left">
								<br/>
								abzglich Krzungsbetrag fr Besatzungsmitglieder von Handelsschiffen
							</td>
							<td colspan="1" align="center" valign="bottom">33</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz33"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz48">
							<td colspan="1" align="left">
								<br/>
								<b>
									verbleiben
								</b>
							</td>
							<td colspan="1" align="center" valign="bottom">48</td>
							<td colspan="1" align="right" valign="bottom">
								<b><xsl:value-of select="elster:Kz48"/></b>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz49">
							<td colspan="1" align="left">
								<br/>
								Solidarittszuschlag
							</td>
							<td colspan="1" align="center" valign="bottom">49</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz49"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz47">
							<td colspan="1" align="left">
								<br/>
								pauschale Kirchensteuer im vereinfachten Verfahren
							</td>
							<td colspan="1" align="center" valign="bottom">47</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz47"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz61">
							<td colspan="1" align="left">
								<br/>
								Evangelische Kirchensteuer
							</td>
							<td colspan="1" align="center" valign="bottom">61</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz61"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz62">
							<td colspan="1" align="left">
								<br/>
								Rmisch-Katholische Kirchensteuer
							</td>
							<td colspan="1" align="center" valign="bottom">62</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz62"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz63">
							<td colspan="1" align="left">
								<br/>
								Altkatholische Kirchensteuer
							</td>
							<td colspan="1" align="center" valign="bottom">63</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz63"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz64">
							<xsl:call-template name="Kz64"/>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz65">
							<td colspan="1" align="left">
								<br/>
								Freireligise Gemeinde Mainz
							</td>
							<td colspan="1" align="center" valign="bottom">65</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz65"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz66">
							<td colspan="1" align="left">
								<br/>
								Freireligise Gemeinde Offenbach/M.
							</td>
							<td colspan="1" align="center" valign="bottom">66</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz66"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz67">
							<td colspan="1" align="left">
								<br/>
								Kirchensteuer der Freireligisen Landesgemeinde Baden
							</td>
							<td colspan="1" align="center" valign="bottom">67</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz67"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz68">
							<xsl:call-template name="Kz68"/>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz69">
							<td colspan="1" align="left">
								<br/>
								Beitrge zur Angestelltenkammer
							</td>
							<td colspan="1" align="center" valign="bottom">69</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz69"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz70">
							<td colspan="1" align="left">
								<br/>
								Beitrge zur Arbeitskammer
							</td>
							<td colspan="1" align="center" valign="bottom">70</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz70"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz72">
							<td colspan="1" align="left">
								<br/>
								Freie Religionsgemeinschaft Alzey
							</td>
							<td colspan="1" align="center" valign="bottom">72</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz72"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz73">
							<td colspan="1" align="left">
								<br/>
								Kirchensteuer der Israelitischen Religionsgemeinschaft Wrttembergs
							</td>
							<td colspan="1" align="center" valign="bottom">73</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz73"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz74">
							<td colspan="1" align="left">
								<br/>
								Israelitische Kultussteuer der kultusberechtigten Gemeinden
							</td>
							<td colspan="1" align="center" valign="bottom">74</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz74"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz76">
							<td colspan="1" align="left">
								<br/>
								Kirchensteuer-lt/rf (ev)
							</td>
							<td colspan="1" align="center" valign="bottom">76</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz76"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz77">
							<td colspan="1" align="left">
								<br/>
								Kirchensteuer-rk/ak
							</td>
							<td colspan="1" align="center" valign="bottom">77</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz77"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz78">
							<td colspan="1" align="left">
								<br/>
								Kirchensteuer der Israelischen Religionsgemeinschaft Baden
							</td>
							<td colspan="1" align="center" valign="bottom">78</td>
							<td colspan="1" align="right" valign="bottom">
								<xsl:value-of select="elster:Kz78"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz83">
							<td colspan="1" align="left">
								<b>
									Gesamtbetrag
								</b>
							</td>
							<td colspan="1" align="center" valign="bottom">83</td>
							<td colspan="1" align="right" valign="bottom">
								<b><xsl:value-of select="elster:Kz83"/></b>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz29   |  elster:Kz26">
							<td colspan="5" align="left">
								<br/>
								<big>
										<u>Sonstige Angaben</u>
								</big>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz29">
							<td colspan="1" align="left">
								<br/>
								Verrechnung des Erstattungsbetrages erwnscht/ Erstattungsbetrag ist abgetreten
							</td>
							<td colspan="1" align="center" valign="bottom">29</td>
							<td colspan="1" align="left" valign="bottom">
								<xsl:value-of select="elster:Kz29"/>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<xsl:if test="elster:Kz26">
							<td colspan="1" align="left">
								<br/>
								Die Einzugsermchtigung wird ausnahmsweise (z.B. wegen Verrechnungswnschen) fr diesen Anmeldungszeitraum widerrufen
							</td>
							<td colspan="1" align="center" valign="bottom">26</td>
							<td colspan="1" align="left" valign="bottom">
								<xsl:value-of select="elster:Kz26"/>
							</td>
						</xsl:if>
					</tr>
				</table>
			</td>
		</tr>
	</xsl:template>
	<!-- **************** Kz64 ********************************* -->
	<xsl:template name="Kz64">
		<xsl:if test="elster:Steuernummer[starts-with(.,'9')]">
			<td colspan="1" align="left">
				<br/>
				Israelitische Bekenntnissteuer
			</td>
			<td colspan="1" align="center" valign="bottom">64</td>
			<td colspan="1" align="right" valign="bottom">
						<xsl:value-of select="elster:Kz64"/>
			</td>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'26')]">
			<td colspan="1" align="left">
				<br/>
				Israelitische Kultussteuer Frankfurt
			</td>
			<td colspan="1" align="center" valign="bottom">64</td>
			<td colspan="1" align="right" valign="bottom">
				<xsl:value-of select="elster:Kz64"/>
			</td>
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'10')]">
			<td colspan="1" align="left">
				<br/>
				Israelitische Kultussteuer
			</td>	
			<td colspan="1" align="center" valign="bottom">64</td>
			<td colspan="1" align="right" valign="bottom">
				<xsl:value-of select="elster:Kz64"/>
			</td>						
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'27')] | elster:Steuernummer[starts-with(.,'5')] | elster:Steuernummer[starts-with(.,'22')]">
			<td colspan="1" align="left">
				<br/>
				Jdische Kultussteuer
			</td>
			<td colspan="1" align="center" valign="bottom">64</td>
			<td colspan="1" align="right" valign="bottom">
				<xsl:value-of select="elster:Kz64"/>
			</td>
		</xsl:if>
	</xsl:template>
	<!-- **************** Kz68 ********************************* -->
	<xsl:template name="Kz68">
		<xsl:if test="elster:Steuernummer[starts-with(.,'24')]">
			<td colspan="1" align="left">
				<br/>
					Beitrge zur Arbeitnehmerkammer
			</td>
			<td colspan="1" align="center" valign="bottom">68</td>
			<td colspan="1" align="right" valign="bottom">
				<xsl:value-of select="elster:Kz68"/>
			</td>			
		</xsl:if>
		<xsl:if test="elster:Steuernummer[starts-with(.,'27')]">
			<td colspan="1" align="left">
				<br/>
					Freireligise Landesgemeinde Pfalz
			</td>
			<td colspan="1" align="center" valign="bottom">68</td>
			<td colspan="1" align="right" valign="bottom">
				<xsl:value-of select="elster:Kz68"/>
			</td>				
		</xsl:if>
	</xsl:template>
	<!-- **************** Hinweise ********************************* -->
	<xsl:template name="Hinweise">
	<br/><br/>
	<big>
			<hr/>               <!-- ***********************************************************-->
			<br/><br/>
	
		<tr>				
			<u><xsl:text>Hinweis zu Sumniszuschlgen</xsl:text></u>
			<br/><br/>
		</tr>
	</big>
		<tr>
			<xsl:text>
		Wird die angemeldete Steuer durch Hingabe eines Schecks beglichen, fallen Sumniszuschlge an, wenn dieser nicht am Flligkeitstag bei der Finanzkasse vorliegt ( 240 Abs.3 Abgabenordnung). 
		Um Sumniszuschlge zu vermeiden wird empfohlen, am Lastschriftverfahren teilzunehmen. Die Teilnahme am Lastschriftverfahren ist jederzeit widerruflich und vllig risikolos. 
		Sollte einmal ein Betrag zu Unrecht abgebucht werden, knnen Sie diese Abbuchung bei der Bank innerhalb von 6 Wochen stornieren lassen. 
		Zur Teilnahme am Lastschriftverfahren setzen Sie sich bitte mit Ihrem Finanzamt in Verbindung.
			</xsl:text>
			<br/><br/><br/><br/>
		</tr>
		<tr>
			<b>
				<xsl:text>
		Dieses bertragungsprotokoll ist nicht zur bersendung an das Finanzamt bestimmt. Die Angaben sind auf ihre Richtigkeit hin zu prfen.
		Sofern eine Unrichtigkeit festgestellt wird, ist eine berichtigte Steueranmeldung abzugeben.
				</xsl:text>
				<br/><br/>
			</b>
			<br/>
		</tr>
	</xsl:template>
   <!-- ***********************************************************-->
</xsl:stylesheet>
