/** \file
 * Defines the interface for the Registrar class.
 *
 * \author Martin F. Krafft <krafft@ailab.ch>
 * \date $Date: 2004/06/01 13:03:10 $
 * \version $Revision: 1.7 $
 */

#ifndef __INCLUDE_FACTORY_REGISTRAR_H__
#define __INCLUDE_FACTORY_REGISTRAR_H__

#include <factory++/builder.hpp>
#include <factory++/factory.hpp>

namespace Factory
{
        /**
           Registrar is responsible for associating keys to Builders.

           More to say here...
        */

  template <typename _Key, typename _BaseType, typename _SubType = _BaseType,
            typename _Builder = Builder<_BaseType, _SubType> >
    class Registrar
    {
    public:

      /**
         Registers _Builder as the factory for key/type combination of
         _Key/_SubType, using a key of __KEY.

         Note that subsequent calls to the ctor will NOT register the
         second (or subsequent) Builder. Thus calling this ctor is
         only valid ONCE - the first time it is called the
         key-to-Builder registration is set in stone (or silicon, as
         the case may be).

         DUNNO: is that a bug or a feature?

         Later: this behaviour is up for discussion on the dev
         list. Will probably use a policy class to determine what to
         do.
      */
      Registrar(_Key const& __KEY, _Builder const& __BUILDER = _Builder())
        : _M_builder(__BUILDER)
      {
        typedef Factory<_BaseType, _Key> _Factory;
        _S_reg() = _S_reg() || _Factory::register_builder(__KEY, _M_builder);
      }

    private:

      static bool&
      _S_reg()
      {
        static bool __reg = false;
        return __reg;
      }

      static Registrar _S_instance;

      _Builder const _M_builder;
    };

}; // namespace Factory

#endif // include guard

/* COPYRIGHT --
 *
 * This file is part of libfactory++, a C++ template factory framework.
 * libfactory++ is (c) 2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
