/** \file
 * Defines the interface for the Destructor class.
 *
 * \author Martin F. Krafft <krafft@ailab.ch>
 * \date $Date: 2004/05/16 17:06:30 $
 * \version $Revision: 1.6 $
 */

#ifndef __INCLUDE_FACTORY_DESTRUCTOR_H__
#define __INCLUDE_FACTORY_DESTRUCTOR_H__

namespace Factory
{
  template <typename _Type>
    class Destructor
    {
    public:
      inline void
      operator()(_Type* const __P)
      {
        this->call_destructor(__P);
      }

      inline void
      operator()(_Type* const __P) const
      {
        this->call_destructor(__P);
      }

    protected:
      inline void
      call_destructor(_Type* const __P) const
      {
        __P->~_Type();
      }
    };

}; // namespace Factory

#endif // include guard

/* COPYRIGHT --
 *
 * This file is part of libfactory++, a C++ template factory framework.
 * libfactory++ is (c) 2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
