/** \file
 * Defines the interface for the BuilderRegistry class.
 *
 * \author Martin F. Krafft <krafft@ailab.ch>
 * \date $Date: 2004/05/15 22:49:24 $
 * \version $Revision: 1.7 $
 */

#ifndef __INCLUDE_FACTORY_BUILDERREGISTRY_H__
#define __INCLUDE_FACTORY_BUILDERREGISTRY_H__

#include <factory++/builderbase.hpp>

#include <map>

namespace Factory
{
  template <typename _Key, typename _Type>
    class BuilderRegistry
    {
    private:
      typedef _Builder_base<_Type> const _Builder;
      typedef std::map<_Key, _Builder*> _BuilderRegistry;
      typedef typename _BuilderRegistry::const_iterator _CIter;

    public:
      
      inline bool
      register_builder(_Key const& __KEY, _Builder* const __BUILDER)
      {
        return _M_registry.insert(std::make_pair(__KEY, __BUILDER)).second;
      }

      inline bool
      unregister_builder(_Key const& __KEY)
      {
        _CIter it;
        return (this->_M_has_builder(__KEY, it))
          ? (_M_registry.erase(it), true) : false;
      }

      inline bool
      has_builder(_Key const& __KEY) const
      {
        return this->_M_has_builder(__KEY, _CIter());
      }

      inline _Builder*
      get_builder(_Key const& __KEY) const
      {
        _CIter it;
        if (this->_M_has_builder(__KEY, it)) return it->second;
        return 0;
      }

    private:

      inline bool
      _M_has_builder(_Key const& __KEY, _CIter& __iter) const
      {
        return (__iter = _M_registry.find(__KEY)) != _M_registry.end();
      }
      
      _BuilderRegistry _M_registry;
    };
  
}; // namespace Factory

#endif // include guard

/* COPYRIGHT --
 *
 * This file is part of libfactory++, a C++ template factory framework.
 * libfactory++ is (c) 2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
