/*
 * libexplain - Explain errno values returned by libc functions
 * Copyright (C) 2009 Peter Miller
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBEXPLAIN_IOCONTROL_GENERIC_H
#define LIBEXPLAIN_IOCONTROL_GENERIC_H

#include <libexplain/iocontrol.h>

/**
  * The explain_iocontrol_generic global variable is
  * used to store information ablut the GENERIC
  * I/O control.
  *
  * @note
  *     This information is not kept in a single table for all values,
  *     like every other set of constants, because (a) some values
  *     are ambiguous, and (b) the includes files have bugs making it
  *     impossible to include all of them in the same combilation unit.
  */
extern const explain_iocontrol_t explain_iocontrol_generic;

/**
  * The explain_iocontrol_generic_print_explanation function is used to
  * print a generic (non-specific) explanation of an error return by an
  * ioctl system call.
  *
  * @param p
  *     ioctl descriptor
  * @param sb
  *     where to print the explanation
  * @param errnum
  *     the errno value to be explained
  * @param fildes
  *     original fildes, exactly as passed to the ioctl system call
  * @param request
  *     original request, exactly as passed to the ioctl system call
  * @param data
  *     original data, exactly as passed to the ioctl system call
  */
void explain_iocontrol_generic_print_explanation(const explain_iocontrol_t *p,
    struct explain_string_buffer_t *sb, int errnum, int fildes, int request,
    const void *data);

/**
  * The explain_iocontrol_fake_syscall_name function is used to
  * synthesize a "sycall name" for use in error messages that take same.
  *
  * @param output
  *     where to write the name
  * @param output_size
  *     the available output size, in bytes
  * @param p
  *     ioctl descriptor
  * @param request
  *     original request, exactly as passed to the ioctl system call
  */
void explain_iocontrol_fake_syscall_name(char *output, int output_size,
    const explain_iocontrol_t *p, int request);

#endif /* LIBEXPLAIN_IOCONTROL_GENERIC_H */
