/*
 * libexplain - Explain errno values returned by libc functions
 * Copyright (C) 2009 Peter Miller
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful,but
 * WITHOUT ANY WARRANTY; without even the implied warranty
 * ofMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNULesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <libexplain/ac/sys/mtio.h>
#include <libexplain/ac/sys/ioctl.h>

#include <libexplain/buffer/mtconfiginfo.h>
#include <libexplain/buffer/mtget.h>
#include <libexplain/buffer/mtpos.h>

#include <ioctl-scan/report.h>
#include <ioctl-scan/scan/sys_mtio.h>


#ifdef MTIOCGET

static void
mtiocget(int fildes)
{
    struct mtget    data;

    if (ioctl(fildes, MTIOCGET, &data) >= 0)
    {
        explain_string_buffer_t sb;
        char            text[1000];

        explain_string_buffer_init(&sb, text, sizeof(text));
        explain_buffer_mtget(&sb, &data);
        report("MTIOCGET", "Mag tape status", text);
    }
}

#endif

#ifdef MTIOCGETCONFIG

static void
mtiocgetconfig(int fildes)
{
    struct mtconfiginfo data;

    if (ioctl(fildes, MTIOCGETCONFIG, &data) >= 0)
    {
        explain_string_buffer_t sb;
        char            text[1000];

        explain_string_buffer_init(&sb, text, sizeof(text));
        explain_buffer_mtconfiginfo(&sb, &data);
        report("MTIOCGET", "Mag tape config", text);
    }
}

#endif

#ifdef MTIOCPOS

static void
mtiocpos(int fildes)
{
    struct mtpos    data;

    if (ioctl(fildes, MTIOCPOS, &data) >= 0)
    {
        explain_string_buffer_t sb;
        char            text[1000];

        explain_string_buffer_init(&sb, text, sizeof(text));
        explain_buffer_mtpos(&sb, &data);
        report("MTIOCPOS", "Mag tape position", text);
    }
}

#endif


void
scan_sys_mtio(int fildes)
{
#ifdef MTIOCGET
    mtiocget(fildes);
#endif
#ifdef MTIOCGETCONFIG
    mtiocgetconfig(fildes);
#endif
#ifdef MTIOCPOS
    mtiocpos(fildes);
#endif
}
