/*
 * $Id: mem_alloc.h,v 1.14 2007/05/20 13:19:12 simakov Exp $
 *
 * EPSILON - wavelet image compression library.
 * Copyright (C) 2006-2007 Alexander Simakov, <xander@entropyware.info>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://epsilon-project.sourceforge.net
 */

/** \file
 *
 *  \brief Two-dimensional memory management
 *
 *  This file contains two-dimensional memory management routines. */

#ifndef __MEM_ALLOC_H__
#define __MEM_ALLOC_H__

#ifdef __cplusplus
extern "C" {
#endif

/** \addtogroup mem_alloc Two-dimensional memory management */
/*@{*/

#include <common.h>

/** Memory allocation
 *
 *  This function allocates one-dimensional array of desired size.
 *
 *  \param size Size in bytes
 *
 *  \return Array pointer
 *
 *  \warning This function halts program if all virtual memory
 *  is exhausted. */
void *xmalloc(size_t size);

/** Two-dimensional memory allocation
 *
 *  This function allocates two-dimensional array of desired size.
 *
 *  \param width Array width
 *  \param height Array height
 *  \param size Element size
 *
 *  \return Array pointer
 *
 *  \warning This function halts program if all virtual memory
 *  is exhausted. */
void **malloc_2D(int width, int height, int size);

/** Two-dimensional memory releasing
 *
 *  This function releases two-dimensional array allocated by #malloc_2D.
 *
 *  \param ptr Array pointer
 *  \param width Array width
 *  \param height Array height
 *
 *  \return \c VOID */
void free_2D(void **ptr, int width, int height);

/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* __MEM_ALLOC_H__ */
