/*--------------------------------------------------------------------------+
$Id: SimulinkConstraints.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.constraints;

import edu.tum.cs.commons.constraint.ConstraintValidator;
import edu.tum.cs.commons.constraint.ConstraintViolationException;
import edu.tum.cs.simulink.model.SimulinkBlock;
import edu.tum.cs.simulink.model.SimulinkElementBase;
import edu.tum.cs.simulink.model.SimulinkLine;
import edu.tum.cs.simulink.model.SimulinkModel;
import edu.tum.cs.simulink.util.SimulinkModelWalker;

/**
 * Utility methods for validating the Simulink model. See package comment for
 * further details.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: DF337D5FD8A07AC0D575ECBE780A6C79
 */
public class SimulinkConstraints {

	/** Check mandatory and optional constraints. */
	public static void checkAllConstraints(SimulinkModel model)
			throws ConstraintViolationException {
		checkMandatoryConstraints(model);
		checkOptionalConstraints(model);
	}

	/** Check mandatory constraints. */
	public static void checkMandatoryConstraints(SimulinkModel model)
			throws ConstraintViolationException {
		ConstraintValidator validator = new ConstraintValidator();
		addMandatoryConstraints(validator);
		validator.validateMesh(model, new SimulinkModelWalker());
	}

	/** Check optional constraints. */
	public static void checkOptionalConstraints(SimulinkModel model)
			throws ConstraintViolationException {
		ConstraintValidator validator = new ConstraintValidator();
		addOptionalConstraints(validator);
		validator.validateMesh(model, new SimulinkModelWalker());
	}

	/** Add optional mandatory to validator. */
	public static void addMandatoryConstraints(ConstraintValidator validator) {
		validator.addConstraint(SimulinkElementBase.class,
				new SimulinkElementNameConstraint());
		validator.addConstraint(SimulinkBlock.class,
				new SimulinkBlockTypeConstraint());
	}

	/** Add optional constraints to validator. */
	public static void addOptionalConstraints(ConstraintValidator validator) {
		validator.addConstraint(SimulinkLine.class,
				new SimulinkLineConstraint());
	}

}