/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 30 "complearn-compressor-driver.gob"

/*
Copyright (c) 2003-2008 Rudi Cilibrasi, Rulers of the RHouse
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. Neither the name of the University nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE RULERS AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE RULERS OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
*/
#include <stdio.h>
#if OPENMP_ENABLED
#include <omp.h>
#endif
#define _( O ) gettext( O )
#include "complearn.h"
#include "complearn-compressor-driver.h"
#include "complearn-compressor-driver-private.h"

#line 61 "complearn-compressor-driver.c"
/* self casting macros */
#define SELF(x) COMPLEARN_COMPRESSOR_DRIVER(x)
#define SELF_CONST(x) COMPLEARN_COMPRESSOR_DRIVER_CONST(x)
#define IS_SELF(x) COMPLEARN_IS_COMPRESSOR_DRIVER(x)
#define TYPE_SELF COMPLEARN_TYPE_COMPRESSOR_DRIVER
#define SELF_CLASS(x) COMPLEARN_COMPRESSOR_DRIVER_CLASS(x)

#define SELF_GET_CLASS(x) COMPLEARN_COMPRESSOR_DRIVER_GET_CLASS(x)

/* self typedefs */
typedef CompLearnCompressorDriver Self;
typedef CompLearnCompressorDriverClass SelfClass;

/* here are local prototypes */
static void complearn_compressor_driver_init (CompLearnCompressorDriver * o) G_GNUC_UNUSED;
static void complearn_compressor_driver_class_init (CompLearnCompressorDriverClass * c) G_GNUC_UNUSED;
static void complearn_compressor_driver_check_bounds (CompLearnCompressorDriver * cd, guint32 a) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_new complearn_compressor_driver_new
#define self_set_compressor complearn_compressor_driver_set_compressor
#define self_size complearn_compressor_driver_size
#define self_is_same_block complearn_compressor_driver_is_same_block
#define self_store complearn_compressor_driver_store
#define self_check_bounds complearn_compressor_driver_check_bounds
#define self_compress_single complearn_compressor_driver_compress_single
#define self_compression_sequence_ser complearn_compressor_driver_compression_sequence_ser
#define self_compression_sequence_par complearn_compressor_driver_compression_sequence_par
#define self_compression_sequence complearn_compressor_driver_compression_sequence
#define self_command_pair complearn_compressor_driver_command_pair
#define self_command_single complearn_compressor_driver_command_single
#define self_compression_matrix complearn_compressor_driver_compression_matrix
#define self_compression_vector complearn_compressor_driver_compression_vector
#define self_execute_instruction complearn_compressor_driver_execute_instruction
#define self_compress_pair complearn_compressor_driver_compress_pair
GType
complearn_compressor_driver_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (CompLearnCompressorDriverClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) complearn_compressor_driver_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (CompLearnCompressorDriver),
			0 /* n_preallocs */,
			(GInstanceInitFunc) complearn_compressor_driver_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "CompLearnCompressorDriver", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((CompLearnCompressorDriver *)g_object_new(complearn_compressor_driver_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static CompLearnCompressorDriver * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static CompLearnCompressorDriver *
GET_NEW_VARG (const char *first, ...)
{
	CompLearnCompressorDriver *ret;
	va_list ap;
	va_start (ap, first);
	ret = (CompLearnCompressorDriver *)g_object_new_valist (complearn_compressor_driver_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::dispose"
	CompLearnCompressorDriver *self G_GNUC_UNUSED = COMPLEARN_COMPRESSOR_DRIVER (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 76 "complearn-compressor-driver.gob"
	if(self->_priv->rc) { g_object_unref ((gpointer) self->_priv->rc); self->_priv->rc = NULL; }
#line 152 "complearn-compressor-driver.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::finalize"
	CompLearnCompressorDriver *self G_GNUC_UNUSED = COMPLEARN_COMPRESSOR_DRIVER (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#define blockstore (self->_priv->blockstore)
#define VAR blockstore
	{
#line 70 "complearn-compressor-driver.gob"
	
    int i;
    for (i = 0; i < VAR->len; i += 1)
      g_string_free(g_array_index(VAR, GString *, i), TRUE);
    g_array_free(VAR, TRUE);
  }
#line 175 "complearn-compressor-driver.c"
	memset(&blockstore, 0, sizeof(blockstore));
#undef VAR
#undef blockstore
}
#undef __GOB_FUNCTION__

static void 
complearn_compressor_driver_init (CompLearnCompressorDriver * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,COMPLEARN_TYPE_COMPRESSOR_DRIVER,CompLearnCompressorDriverPrivate);
}
#undef __GOB_FUNCTION__
static void 
complearn_compressor_driver_class_init (CompLearnCompressorDriverClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(CompLearnCompressorDriverPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 77 "complearn-compressor-driver.gob"
GObject * 
complearn_compressor_driver_new (void)
#line 209 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::new"
{
#line 78 "complearn-compressor-driver.gob"
	
    GObject *ret = (GObject *) GET_NEW;
    CompLearnCompressorDriver *self = COMPLEARN_COMPRESSOR_DRIVER(ret);
    self->_priv->blockstore = g_array_new(FALSE, TRUE, sizeof(gpointer));
    return G_OBJECT (ret);
  }}
#line 220 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 84 "complearn-compressor-driver.gob"
guint32 
complearn_compressor_driver_set_compressor (CompLearnCompressorDriver * cd, CompLearnRealCompressor * rc)
#line 226 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::set_compressor"
{
#line 84 "complearn-compressor-driver.gob"
	
    if (cd->_priv->rc)
      g_object_unref(cd->_priv->rc);
    cd->_priv->rc = rc;
    g_object_ref(rc);
    return 0;
  }}
#line 238 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 91 "complearn-compressor-driver.gob"
guint32 
complearn_compressor_driver_size (CompLearnCompressorDriver * cd)
#line 244 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::size"
{
#line 91 "complearn-compressor-driver.gob"
	
    return cd->_priv->blockstore->len;
  }}
#line 252 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 94 "complearn-compressor-driver.gob"
gboolean 
complearn_compressor_driver_is_same_block (CompLearnCompressorDriver * cd, guint a, guint b)
#line 258 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::is_same_block"
{
#line 95 "complearn-compressor-driver.gob"
	
    GString *av, *bv;
    av = g_array_index(cd->_priv->blockstore, GString *, a);
    bv = g_array_index(cd->_priv->blockstore, GString *, b);
    return g_string_equal(av, bv);
  }}
#line 269 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 101 "complearn-compressor-driver.gob"
guint32 
complearn_compressor_driver_store (CompLearnCompressorDriver * cd, GString * str)
#line 275 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::store"
{
#line 101 "complearn-compressor-driver.gob"
	
    int val = complearn_compressor_driver_size(cd);
    GString *realone = g_string_new_len(str->str, str->len);
    g_array_append_vals(cd->_priv->blockstore, &realone, 1);
    return val;
  }}
#line 286 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 107 "complearn-compressor-driver.gob"
static void 
complearn_compressor_driver_check_bounds (CompLearnCompressorDriver * cd, guint32 a)
#line 292 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::check_bounds"
{
#line 107 "complearn-compressor-driver.gob"
	
    CompLearnCompressorDriver *self = COMPLEARN_COMPRESSOR_DRIVER(cd);
    if (self->_priv->rc == NULL)
      g_error(_("Must set_compressor before trying to compress."));
    if (a >= self->_priv->blockstore->len)
      g_error(_("Compressor index %d out of bounds."), a);
  }}
#line 304 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 114 "complearn-compressor-driver.gob"
gdouble 
complearn_compressor_driver_compress_single (CompLearnCompressorDriver * cd, guint32 a)
#line 310 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::compress_single"
{
#line 114 "complearn-compressor-driver.gob"
	
    CompLearnCompressorDriver *self = COMPLEARN_COMPRESSOR_DRIVER(cd);
    complearn_compressor_driver_check_bounds(self, a);
    GString *block;
    gdouble result;
    block = g_array_index(self->_priv->blockstore, GString *, a);
    result = real_compressor_compressed_size(self->_priv->rc, block);
    return result;
  }}
#line 324 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 123 "complearn-compressor-driver.gob"
gsl_vector * 
complearn_compressor_driver_compression_sequence_ser (CompLearnCompressorDriver * cd, GArray * gas)
#line 330 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::compression_sequence_ser"
{
#line 124 "complearn-compressor-driver.gob"
	
    int i = 0;
    double *fres = NULL;
    CompLearnCompressorDriverCommand cdc;
#if OPENMP_ENABLED
    if (!g_thread_supported ()) g_thread_init (NULL);
#endif
    int len = 0;
    len = gas->len;
    gsl_vector *result = gsl_vector_calloc(len);
    fres = calloc(sizeof(fres[0]), len);

    for (i = 0; i < len; i += 1) {
      cdc = g_array_index(gas, CompLearnCompressorDriverCommand, i);
      fres[i] = complearn_compressor_driver_execute_instruction(cd, cdc);
    }

    for (i = 0; i < len; i += 1)
      gsl_vector_set(result, i, fres[i]);

    free(fres);

    return result;
  }}
#line 359 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 149 "complearn-compressor-driver.gob"
gsl_vector * 
complearn_compressor_driver_compression_sequence_par (CompLearnCompressorDriver * cd, GArray * gas)
#line 365 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::compression_sequence_par"
{
#line 150 "complearn-compressor-driver.gob"
	
    int i = 0;
    double *fres = NULL;
    CompLearnCompressorDriverCommand cdc;
    int len = 0;
    len = gas->len;
    gsl_vector *result = gsl_vector_calloc(len);
    fres = calloc(sizeof(fres[0]), len);
    CompLearnRealCompressor *rc = NULL;

#if OPENMP_ENABLED
    if (!g_thread_supported ()) g_thread_init (NULL);
#pragma omp parallel shared(len, fres) private(i, rc, cdc) firstprivate(cd)
 {
#endif
    rc = real_compressor_clone(cd->_priv->rc);
#if OPENMP_ENABLED
#pragma omp for schedule (dynamic, 1)
#endif
    for (i = 0; i < len; i += 1) {
      cdc = g_array_index(gas, CompLearnCompressorDriverCommand, i);
      fres[i] = complearn_compressor_driver_execute_instruction(cd, cdc);
    }
    g_object_unref(rc);
#if OPENMP_ENABLED
  }
#endif

    for (i = 0; i < len; i += 1)
      gsl_vector_set(result, i, fres[i]);

    free(fres);

    return result;
  }}
#line 405 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 185 "complearn-compressor-driver.gob"
gsl_vector * 
complearn_compressor_driver_compression_sequence (CompLearnCompressorDriver * cd, GArray * gas)
#line 411 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::compression_sequence"
{
#line 185 "complearn-compressor-driver.gob"
	
    CompLearnRealCompressor *rc = cd->_priv->rc;

    return real_compressor_is_threadsafe(rc) ? 
                complearn_compressor_driver_compression_sequence_par(cd, gas) :
                complearn_compressor_driver_compression_sequence_ser(cd, gas) ;
  }}
#line 423 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 192 "complearn-compressor-driver.gob"
CompLearnCompressorDriverCommand 
complearn_compressor_driver_command_pair (guint32 a, guint32 b)
#line 429 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::command_pair"
{
#line 192 "complearn-compressor-driver.gob"
	
    CompLearnCompressorDriverCommand cdc;
    cdc.is_pair = TRUE;
    cdc.first = a;
    cdc.second = b;
    return cdc;
  }}
#line 441 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 199 "complearn-compressor-driver.gob"
CompLearnCompressorDriverCommand 
complearn_compressor_driver_command_single (guint32 a)
#line 447 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::command_single"
{
#line 199 "complearn-compressor-driver.gob"
	
    CompLearnCompressorDriverCommand cdc;
    cdc.is_pair = FALSE;
    cdc.first = a;
    cdc.second = 0;
    return cdc;
  }}
#line 459 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 206 "complearn-compressor-driver.gob"
gsl_matrix * 
complearn_compressor_driver_compression_matrix (CompLearnCompressorDriver * cd, GArray * dim1ind, GArray * dim2ind, int mode)
#line 465 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::compression_matrix"
{
#line 207 "complearn-compressor-driver.gob"
	
    guint32 len1 = dim1ind->len;
    guint32 len2 = dim2ind->len;
    int i, j;
    CompLearnCompressorDriverCommand cdc;
    GArray *seq = g_array_new(FALSE, TRUE, sizeof(cdc));
    GArray *inv1 = g_array_new(FALSE, TRUE, sizeof(guint32));
    GArray *inv2 = g_array_new(FALSE, TRUE, sizeof(guint32));
    gsl_matrix *result = gsl_matrix_calloc(len1, len2);
    gsl_vector *v;
    for (i = 0; i < len1; i += 1) {
      for (j = 0; j < len2; j += 1) {
        if (CL_IS_INDEX_IN(len1, len2, mode, i, j)) {
          int x1, x2;
          x1 = g_array_index(dim1ind, guint32, i);
          x2 = g_array_index(dim2ind, guint32, j);
          cdc = complearn_compressor_driver_command_pair(x1,x2);
          g_array_append_vals(seq, &cdc, 1);
          g_array_append_vals(inv1, &i, 1);
          g_array_append_vals(inv2, &j, 1);
        }
      }
    }
    v = complearn_compressor_driver_compression_sequence(cd,seq);
    for (i = 0; i < seq->len; i += 1) {
      gsl_matrix_set(result, g_array_index(inv1, guint32, i),
                             g_array_index(inv2, guint32, i),
      gsl_vector_get(v, i));
    }
    gsl_vector_free(v);
    g_array_free(seq, TRUE);
    g_array_free(inv1, TRUE);
    g_array_free(inv2, TRUE);
    return result;
  }}
#line 505 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 242 "complearn-compressor-driver.gob"
gsl_vector * 
complearn_compressor_driver_compression_vector (CompLearnCompressorDriver * cd)
#line 511 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::compression_vector"
{
#line 242 "complearn-compressor-driver.gob"
	
    int i, len;
    CompLearnCompressorDriverCommand cdc;
    GArray *seq = g_array_new(FALSE, TRUE, sizeof(cdc));
    len = cd->_priv->blockstore->len;
    for (i = 0; i < len; i += 1) {
      cdc = complearn_compressor_driver_command_single(i);
      g_array_append_vals(seq, &cdc, 1);
    }
    gsl_vector *result=complearn_compressor_driver_compression_sequence(cd,seq);
    g_array_free(seq, TRUE);
    return result;
  }}
#line 529 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 255 "complearn-compressor-driver.gob"
gdouble 
complearn_compressor_driver_execute_instruction (CompLearnCompressorDriver * cd, CompLearnCompressorDriverCommand cdc)
#line 535 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::execute_instruction"
{
#line 255 "complearn-compressor-driver.gob"
	
    return cdc.is_pair ? complearn_compressor_driver_compress_pair(cd,cdc.first,cdc.second) : complearn_compressor_driver_compress_single(cd,cdc.first);
  }}
#line 543 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__

#line 258 "complearn-compressor-driver.gob"
gdouble 
complearn_compressor_driver_compress_pair (CompLearnCompressorDriver * cd, guint32 a, guint32 b)
#line 549 "complearn-compressor-driver.c"
{
#define __GOB_FUNCTION__ "CompLearn:Compressor:Driver::compress_pair"
{
#line 258 "complearn-compressor-driver.gob"
	
    CompLearnCompressorDriver *self = COMPLEARN_COMPRESSOR_DRIVER(cd);
    complearn_compressor_driver_check_bounds(self, a);
    complearn_compressor_driver_check_bounds(self, b);
    GString *big = NULL, *b1, *b2;
    double result = -1.0;
    b1 = g_array_index(self->_priv->blockstore, GString *, a);
    b2 = g_array_index(self->_priv->blockstore, GString *, b);
    big = g_string_new_len(b1->str, b1->len);
    g_string_append_len(big, b2->str, b2->len);
    result = real_compressor_compressed_size(self->_priv->rc, big);
    g_string_free(big, TRUE);
    return result;
  }}
#line 568 "complearn-compressor-driver.c"
#undef __GOB_FUNCTION__
