/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "complearn-vcppmd.h"

#include "complearn-vcppmd-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 7 "complearn-vcppmd.gob"

/*
Copyright (c) 2003-2008 Rudi Cilibrasi, Rulers of the RHouse
Copyright (c) 2007-2008 Maarten Keijzer
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. Neither the name of the University nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE RULERS AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE RULERS OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <assert.h>
#include <math.h>
#include <gmodule.h>
#include <libintl.h>

#include <complearn/complearn-environment.h>

#include "ppmd/PPMd.h"

#define COMPRESSOR_NAME "ppmd"

#define _(O) gettext(O)

G_MODULE_EXPORT const gchar* g_module_check_init(void *gm)
{
 complearn_environment_register_compressor_and_nameable(complearn_vcppmd_new());
 return NULL;
}

static double ppmd_compress(const GString *inp, int order, int memory, int method)
{
  PPMFeed feed;
  feed.str = (guchar *) inp->str;
  feed.len = inp->len;
  feed.getc = 0;
  feed.bytes = 0;
    
  // run PPM
  StartSubAllocator(memory);
  EncodeFile(&feed, &feed, order, method == 0?MRM_RESTART: (method == 1)? MRM_CUT_OFF: MRM_FREEZE);

  return feed.bytes * 8; // need bits
}

// need to intercept this call
void _STDCALL PrintInfo(_PPMD_FILE* DecodedFile,_PPMD_FILE* EncodedFile) {}


#line 100 "complearn-vcppmd.c"
/* self casting macros */
#define SELF(x) COMPLEARN_VCPPMD(x)
#define SELF_CONST(x) COMPLEARN_VCPPMD_CONST(x)
#define IS_SELF(x) COMPLEARN_IS_VCPPMD(x)
#define TYPE_SELF COMPLEARN_TYPE_VCPPMD
#define SELF_CLASS(x) COMPLEARN_VCPPMD_CLASS(x)

#define SELF_GET_CLASS(x) COMPLEARN_VCPPMD_GET_CLASS(x)

/* self typedefs */
typedef CompLearnVCPPMd Self;
typedef CompLearnVCPPMdClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void complearn_vcppmd_init (CompLearnVCPPMd * o) G_GNUC_UNUSED;
static void complearn_vcppmd_class_init (CompLearnVCPPMdClass * c) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_MEGABYTES,
	PROP_MODEL_ORDER,
	PROP_RESTART_STRATEGY
};

/* pointer to the class of our parent */
static CompLearnRealCompressorAdaptorClass *parent_class = NULL;

/* Short form macros */
#define self_get_megabytes complearn_vcppmd_get_megabytes
#define self_set_megabytes complearn_vcppmd_set_megabytes
#define self_get_model_order complearn_vcppmd_get_model_order
#define self_set_model_order complearn_vcppmd_set_model_order
#define self_get_restart_strategy complearn_vcppmd_get_restart_strategy
#define self_set_restart_strategy complearn_vcppmd_set_restart_strategy
#define self_new complearn_vcppmd_new
#define self_compress complearn_vcppmd_compress
#define self_decompress complearn_vcppmd_decompress
#define self_blurb complearn_vcppmd_blurb
#define self_name complearn_vcppmd_name
#define self_is_operational complearn_vcppmd_is_operational
#define self_compressor_version complearn_vcppmd_compressor_version
#define self_binding_version complearn_vcppmd_binding_version
#define self_compressed_size complearn_vcppmd_compressed_size
#define self_is_just_size complearn_vcppmd_is_just_size
#define self_clone complearn_vcppmd_clone


static void
___CompLearn_Real_Compressor_init (CompLearnRealCompressorIface *iface)
{
#line 124 "complearn-vcppmd.gob"
	iface->compress = self_compress;
#line 128 "complearn-vcppmd.gob"
	iface->decompress = self_decompress;
#line 132 "complearn-vcppmd.gob"
	iface->blurb = self_blurb;
#line 136 "complearn-vcppmd.gob"
	iface->name = self_name;
#line 140 "complearn-vcppmd.gob"
	iface->is_operational = self_is_operational;
#line 144 "complearn-vcppmd.gob"
	iface->compressor_version = self_compressor_version;
#line 148 "complearn-vcppmd.gob"
	iface->binding_version = self_binding_version;
#line 152 "complearn-vcppmd.gob"
	iface->compressed_size = self_compressed_size;
#line 160 "complearn-vcppmd.gob"
	iface->is_just_size = self_is_just_size;
#line 164 "complearn-vcppmd.gob"
	iface->clone = self_clone;
#line 173 "complearn-vcppmd.c"
}

GType
complearn_vcppmd_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (CompLearnVCPPMdClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) complearn_vcppmd_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (CompLearnVCPPMd),
			0 /* n_preallocs */,
			(GInstanceInitFunc) complearn_vcppmd_init,
			NULL
		};

		static const GInterfaceInfo CompLearn_Real_Compressor_info = {
			(GInterfaceInitFunc) ___CompLearn_Real_Compressor_init,
			NULL,
			NULL
		};

		type = g_type_register_static (COMPLEARN_TYPE_REAL_COMPRESSOR_ADAPTOR, "CompLearnVCPPMd", &info, (GTypeFlags)0);
		g_type_add_interface_static (type,
			COMPLEARN_TYPE_REAL_COMPRESSOR,
			&CompLearn_Real_Compressor_info);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((CompLearnVCPPMd *)g_object_new(complearn_vcppmd_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static CompLearnVCPPMd * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static CompLearnVCPPMd *
GET_NEW_VARG (const char *first, ...)
{
	CompLearnVCPPMd *ret;
	va_list ap;
	va_start (ap, first);
	ret = (CompLearnVCPPMd *)g_object_new_valist (complearn_vcppmd_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::finalize"
	CompLearnVCPPMd *self G_GNUC_UNUSED = COMPLEARN_VCPPMD (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
complearn_vcppmd_init (CompLearnVCPPMd * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,COMPLEARN_TYPE_VCPPMD,CompLearnVCPPMdPrivate);
}
#undef __GOB_FUNCTION__
static void 
complearn_vcppmd_class_init (CompLearnVCPPMdClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(CompLearnVCPPMdPrivate));

	parent_class = g_type_class_ref (COMPLEARN_TYPE_REAL_COMPRESSOR_ADAPTOR);

	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_int
		("megabytes" /* name */,
		 _("megabytes") /* nick */,
		 _("megabytes of memory to use [1,256]") /* blurb */,
		 1 /* minimum */,
		 256 /* maximum */,
		 64 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_MEGABYTES,
		param_spec);
	param_spec = g_param_spec_int
		("model_order" /* name */,
		 _("model-order") /* nick */,
		 _("Maximum model order [2,16]") /* blurb */,
		 2 /* minimum */,
		 16 /* maximum */,
		 4 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_MODEL_ORDER,
		param_spec);
	param_spec = g_param_spec_int
		("restart_strategy" /* name */,
		 _("restart-strategy") /* nick */,
		 _("0 = restart, 1 = cut off, 2 = freeze") /* blurb */,
		 0 /* minimum */,
		 2 /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_RESTART_STRATEGY,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::set_property"
{
	CompLearnVCPPMd *self G_GNUC_UNUSED;

	self = COMPLEARN_VCPPMD (object);

	switch (property_id) {
	case PROP_MEGABYTES:
		{
#line 87 "complearn-vcppmd.gob"
self->_priv->megabytes = g_value_get_int (VAL);
#line 315 "complearn-vcppmd.c"
		}
		break;
	case PROP_MODEL_ORDER:
		{
#line 97 "complearn-vcppmd.gob"
self->_priv->model_order = g_value_get_int (VAL);
#line 322 "complearn-vcppmd.c"
		}
		break;
	case PROP_RESTART_STRATEGY:
		{
#line 107 "complearn-vcppmd.gob"
self->_priv->restart_strategy = g_value_get_int (VAL);
#line 329 "complearn-vcppmd.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::get_property"
{
	CompLearnVCPPMd *self G_GNUC_UNUSED;

	self = COMPLEARN_VCPPMD (object);

	switch (property_id) {
	case PROP_MEGABYTES:
		{
#line 87 "complearn-vcppmd.gob"
g_value_set_int (VAL, self->_priv->megabytes);
#line 360 "complearn-vcppmd.c"
		}
		break;
	case PROP_MODEL_ORDER:
		{
#line 97 "complearn-vcppmd.gob"
g_value_set_int (VAL, self->_priv->model_order);
#line 367 "complearn-vcppmd.c"
		}
		break;
	case PROP_RESTART_STRATEGY:
		{
#line 107 "complearn-vcppmd.gob"
g_value_set_int (VAL, self->_priv->restart_strategy);
#line 374 "complearn-vcppmd.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 87 "complearn-vcppmd.gob"
gint 
complearn_vcppmd_get_megabytes (CompLearnVCPPMd * self)
#line 394 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::get_megabytes"
{
#line 87 "complearn-vcppmd.gob"
		gint val; g_object_get (G_OBJECT (self), "megabytes", &val, NULL); return val;
}}
#line 401 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 87 "complearn-vcppmd.gob"
void 
complearn_vcppmd_set_megabytes (CompLearnVCPPMd * self, gint val)
#line 407 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::set_megabytes"
{
#line 87 "complearn-vcppmd.gob"
		g_object_set (G_OBJECT (self), "megabytes", val, NULL);
}}
#line 414 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 97 "complearn-vcppmd.gob"
gint 
complearn_vcppmd_get_model_order (CompLearnVCPPMd * self)
#line 420 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::get_model_order"
{
#line 97 "complearn-vcppmd.gob"
		gint val; g_object_get (G_OBJECT (self), "model_order", &val, NULL); return val;
}}
#line 427 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 97 "complearn-vcppmd.gob"
void 
complearn_vcppmd_set_model_order (CompLearnVCPPMd * self, gint val)
#line 433 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::set_model_order"
{
#line 97 "complearn-vcppmd.gob"
		g_object_set (G_OBJECT (self), "model_order", val, NULL);
}}
#line 440 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 107 "complearn-vcppmd.gob"
gint 
complearn_vcppmd_get_restart_strategy (CompLearnVCPPMd * self)
#line 446 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::get_restart_strategy"
{
#line 107 "complearn-vcppmd.gob"
		gint val; g_object_get (G_OBJECT (self), "restart_strategy", &val, NULL); return val;
}}
#line 453 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 107 "complearn-vcppmd.gob"
void 
complearn_vcppmd_set_restart_strategy (CompLearnVCPPMd * self, gint val)
#line 459 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::set_restart_strategy"
{
#line 107 "complearn-vcppmd.gob"
		g_object_set (G_OBJECT (self), "restart_strategy", val, NULL);
}}
#line 466 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 116 "complearn-vcppmd.gob"
GObject * 
complearn_vcppmd_new (void)
#line 472 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::new"
{
#line 117 "complearn-vcppmd.gob"
	
    static int must_register = 1;
    GObject *self = (GObject *) GET_NEW;
    if (must_register) { must_register = 0;
    SET_DEFAULT_PROPS(COMPRESSOR_NAME, COMPLEARN_VCPPMD_GET_CLASS, self); }
    return G_OBJECT (self);
  }}
#line 484 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 124 "complearn-vcppmd.gob"
GString * 
complearn_vcppmd_compress (CompLearnRealCompressor * rc, const GString * input)
#line 490 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::compress"
{
#line 125 "complearn-vcppmd.gob"
	
    return NULL;
  }}
#line 498 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 128 "complearn-vcppmd.gob"
GString * 
complearn_vcppmd_decompress (CompLearnRealCompressor * rc, const GString * input)
#line 504 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::decompress"
{
#line 129 "complearn-vcppmd.gob"
	
    return NULL;
  }}
#line 512 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 132 "complearn-vcppmd.gob"
GString * 
complearn_vcppmd_blurb (CompLearnRealCompressor * rc)
#line 518 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::blurb"
{
#line 133 "complearn-vcppmd.gob"
	
    return g_string_new(_("non-coding ppmd compressor"));
  }}
#line 526 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 136 "complearn-vcppmd.gob"
GString * 
complearn_vcppmd_name (CompLearnRealCompressor * rc)
#line 532 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::name"
{
#line 137 "complearn-vcppmd.gob"
	
    return g_string_new(COMPRESSOR_NAME);
  }}
#line 540 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 140 "complearn-vcppmd.gob"
gboolean 
complearn_vcppmd_is_operational (CompLearnRealCompressor * rc)
#line 546 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::is_operational"
{
#line 141 "complearn-vcppmd.gob"
	
    return sizeof(int) == 4;
  }}
#line 554 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 144 "complearn-vcppmd.gob"
GString * 
complearn_vcppmd_compressor_version (CompLearnRealCompressor * rc)
#line 560 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::compressor_version"
{
#line 145 "complearn-vcppmd.gob"
	
    return g_string_new("0.0.0");
  }}
#line 568 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 148 "complearn-vcppmd.gob"
GString * 
complearn_vcppmd_binding_version (CompLearnRealCompressor * rc)
#line 574 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::binding_version"
{
#line 149 "complearn-vcppmd.gob"
	
    return g_string_new("0.0.0");
  }}
#line 582 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 152 "complearn-vcppmd.gob"
gdouble 
complearn_vcppmd_compressed_size (CompLearnRealCompressor * rc, const GString * input)
#line 588 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::compressed_size"
{
#line 153 "complearn-vcppmd.gob"
	
    return ppmd_compress(input, 
        complearn_vcppmd_get_model_order(COMPLEARN_VCPPMD(rc)),
        complearn_vcppmd_get_megabytes(COMPLEARN_VCPPMD(rc)),
        complearn_vcppmd_get_restart_strategy(COMPLEARN_VCPPMD(rc))
        );
  }}
#line 600 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 160 "complearn-vcppmd.gob"
gboolean 
complearn_vcppmd_is_just_size (CompLearnRealCompressor * rc)
#line 606 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::is_just_size"
{
#line 161 "complearn-vcppmd.gob"
	
    return TRUE;
  }}
#line 614 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__

#line 164 "complearn-vcppmd.gob"
CompLearnRealCompressor * 
complearn_vcppmd_clone (CompLearnRealCompressor * rc)
#line 620 "complearn-vcppmd.c"
{
#define __GOB_FUNCTION__ "CompLearn:VCPPMd::clone"
{
#line 165 "complearn-vcppmd.gob"
	
    rc = rc;
    return COMPLEARN_REAL_COMPRESSOR( complearn_vcppmd_new() );
    }}
#line 629 "complearn-vcppmd.c"
#undef __GOB_FUNCTION__
