/*
  CLAW - a C++ Library Absolutely Wonderful

  CLAW is a free library without any particular aim but being useful to 
  anyone.

  Copyright (C) 2005-2010 Julien Jorge

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: julien_jorge@yahoo.fr
*/
/**
 * \file algorithm.hpp
 * \brief Generic algorithms on sequences.
 * \author Julien Jorge
 */
#ifndef __CLAW_ALGORITHM_HPP__
#define __CLAW_ALGORITHM_HPP__

namespace claw
{
  template<typename InputIterator, typename UnaryFunction>
  UnaryFunction inplace_for_each
  ( InputIterator first, InputIterator last, UnaryFunction f );

  template<typename ForwardIterator1, typename ForwardIterator2>
  ForwardIterator1 find_first_not_of
  ( ForwardIterator1 first1, ForwardIterator1 last1,
    ForwardIterator2 first2, ForwardIterator2 last2 );

  template<typename ForwardIterator1, typename ForwardIterator2,
           typename ForwardIterator3>
  std::size_t replace
  ( ForwardIterator1 first, ForwardIterator1 last,
    ForwardIterator2 e1_first, ForwardIterator2 e1_last,
    ForwardIterator3 e2_first, ForwardIterator3 e2_last );

} // namespace claw

#include <claw/impl/algorithm.tpp>

#endif // __CLAW_ALGORITHM_HPP__
