/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "s-item.h"

#include <glib/gtypes.h>

START_TEST(test_item_parent_set)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME: make sure that the parent gets set correctly */
}
END_TEST

START_TEST(test_item_parent_unset)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME: make sure that the parent gets unset correctly */
}
END_TEST

START_TEST(test_item_parent_reparent_warn)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME: make sure that we get a warning if the parent is already set */
}
END_TEST

START_TEST(test_item_parent_reparent)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME: make sure that reparenting works exactly as expected */
}
END_TEST

TCase*
tcase_item_parent (void)
{
	TCase* self = tcase_create ("Parent Relationship");
	tcase_add_test (self, test_item_parent_set);
	tcase_add_test (self, test_item_parent_unset);
	tcase_add_test (self, test_item_parent_reparent_warn);
	tcase_add_test (self, test_item_parent_reparent);
	return self;
}

