/*
* libcafix - communicates with CASIO graphing calculators.
* Copyright (C) 2001  Gran Weinholt <weinholt@linux.nu>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* $Id: io.c,v 1.2 2001/07/26 09:36:41 weinholt Exp $
*/
#include <stdio.h>
#include <termios.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>

static char rcsid[] = "$Id: io.c,v 1.2 2001/07/26 09:36:41 weinholt Exp $\n";

//struct termios oldtio, newtio;

int cafix_open(char *devfile, unsigned int timeout)
{
    struct termios newtio;
    int fd;

    if (!devfile)
	return -1;

    if ((fd = open(devfile, O_RDWR | O_NOCTTY)) < 0)
	return -1;

    /* FIXME: save the state someday maybe? */
//    tcgetattr(fd, &oldtio);    
    memset(&newtio, 0, sizeof(newtio));
    newtio.c_cflag = B9600 | CS8 | CLOCAL | CREAD | CSTOPB;
    newtio.c_iflag = IGNPAR;
    newtio.c_oflag = 0;
    newtio.c_lflag = 0;

    /* Set VMIN to 0 if there is a time-out given. */
    newtio.c_cc[VTIME] = timeout;
    newtio.c_cc[VMIN] = timeout > 0 ? 0 : 1;

    tcflush(fd, TCIFLUSH);
    tcsetattr(fd, TCSANOW, &newtio);
    
    return fd;
}

void cafix_close(int fd)
{
//    tcsetattr(fd, TCSANOW, &oldtio);
    close(fd);
}

/* Make sure all data has been written. */
void _cafix_sync(int fd)
{
    tcdrain(fd);
}
