// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

using Anculus.Core;

using NUnit.Framework;

namespace Anculus.UnitTests
{
	[TestFixture]
	public class CollectionSortedCollectionTest
	{
		[Test]
		public void AddRemove ()
		{
			SortedCollection<int> collection = new SortedCollection<int> ();
			
			collection.Add (1);
			collection.Add (20);
			collection.Add (10);
			collection.AddRange (new int[] { 3, 8, 5, 6});
			collection.Remove (20);
			collection.Remove (1);
			
			Assert.AreEqual (3, collection[0]);
			Assert.AreEqual (5, collection[1]);
			Assert.AreEqual (6, collection[2]);
			Assert.AreEqual (8, collection[3]);
			Assert.AreEqual (10, collection[4]);
		}
		
		[Test]
		public void AddRemoveReverse ()
		{
			SortedCollection<int> collection = new SortedCollection<int> (SortOrder.Descending);
			
			collection.Add (1);
			collection.Add (20);
			collection.Add (10);
			collection.AddRange (new int[] { 3, 8, 5, 6});
			collection.Remove (20);
			collection.Remove (1);
			
			Assert.AreEqual (3, collection[4]);
			Assert.AreEqual (5, collection[3]);
			Assert.AreEqual (6, collection[2]);
			Assert.AreEqual (8, collection[1]);
			Assert.AreEqual (10, collection[0]);
		}
	}
}
