// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Reflection;
using System.Diagnostics;

namespace Anculus.Core
{
	public static class SetSearch
	{
		private static AhoCorasickSearchAlgorithm _ahoCorasick;
		
		public static SearchResult[] SearchAll (string text, params string[] keywords)
		{
			if (_ahoCorasick == null)
				_ahoCorasick = new AhoCorasickSearchAlgorithm ();
			
			return _ahoCorasick.SearchAll (text, 0, int.MaxValue, keywords);
		}
		
		public static SearchResult[] SearchAll (string text, int start, params string[] keywords)
		{
			if (_ahoCorasick == null)
				_ahoCorasick = new AhoCorasickSearchAlgorithm ();
			
			return _ahoCorasick.SearchAll (text, start, int.MaxValue, keywords);
		}
		
		public static SearchResult[] SearchAll (string text, int start, int count, params string[] keywords)
		{
			if (_ahoCorasick == null)
				_ahoCorasick = new AhoCorasickSearchAlgorithm ();
			
			return _ahoCorasick.SearchAll (text, start, count, keywords);
		}

		public static SearchResult SearchFirst (string text, params string[] keywords)
		{
			if (_ahoCorasick == null)
				_ahoCorasick = new AhoCorasickSearchAlgorithm ();
			
			return _ahoCorasick.SearchFirst (text, 0, keywords);
		}
		
		public static SearchResult SearchFirst (string text, int start, params string[] keywords)
		{
			if (_ahoCorasick == null)
				_ahoCorasick = new AhoCorasickSearchAlgorithm ();
			
			return _ahoCorasick.SearchFirst (text, start, keywords);
		}

		public static bool Contains (string text, params string[] keywords)
		{
			if (_ahoCorasick == null)
				_ahoCorasick = new AhoCorasickSearchAlgorithm ();
			
			return _ahoCorasick.Contains (text, 0, keywords);
		}

		public static bool Contains (string text, int start, params string[] keywords)
		{
			if (_ahoCorasick == null)
				_ahoCorasick = new AhoCorasickSearchAlgorithm ();
			
			return _ahoCorasick.Contains (text, start, keywords);
		}
	}
}