/* Generated by GOB (v2.0.17)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "loqui-account-manager.gob"

/*
 * libloqui -- Chat/IM client library for GLib <http://launchpad.net/loqui/>
 * Copyright (C) 2005 Yoichi Imai <sunnyone41@gmail.com>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#line 29 "loqui-account-manager.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 17

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "loqui-account-manager.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 31 "loqui-account-manager.gob"

#include "loqui-account-manager-private.h"
#include "config.h"

#include <libloqui-intl.h>
#include "loqui_account.h"
#include "loqui-utils.h"
#include "loqui-profile-handle.h"

#include "loqui_account_manager_iter.h"
#include "loqui-static-core.h"

#define ACCOUNT_CONFIG_FILENAME "account.xml"


#line 64 "loqui-account-manager.c"
/* self casting macros */
#define SELF(x) LOQUI_ACCOUNT_MANAGER(x)
#define SELF_CONST(x) LOQUI_ACCOUNT_MANAGER_CONST(x)
#define IS_SELF(x) LOQUI_IS_ACCOUNT_MANAGER(x)
#define TYPE_SELF LOQUI_TYPE_ACCOUNT_MANAGER
#define SELF_CLASS(x) LOQUI_ACCOUNT_MANAGER_CLASS(x)

#define SELF_GET_CLASS(x) LOQUI_ACCOUNT_MANAGER_GET_CLASS(x)

/* self typedefs */
typedef LoquiAccountManager Self;
typedef LoquiAccountManagerClass SelfClass;

/* here are local prototypes */
#line 0 "loqui-account-manager.gob"
static void loqui_account_manager_init (LoquiAccountManager * o) G_GNUC_UNUSED;
#line 81 "loqui-account-manager.c"
#line 0 "loqui-account-manager.gob"
static void loqui_account_manager_class_init (LoquiAccountManagerClass * c) G_GNUC_UNUSED;
#line 84 "loqui-account-manager.c"
#line 54 "loqui-account-manager.gob"
static void ___1_loqui_account_manager_dispose (GObject * object) G_GNUC_UNUSED;
#line 87 "loqui-account-manager.c"
static void ___real_loqui_account_manager_add_account (LoquiAccountManager * self, LoquiAccount * account);
static void ___real_loqui_account_manager_remove_account (LoquiAccountManager * self, LoquiAccount * account);
static void ___real_loqui_account_manager_add_channel_entry (LoquiAccountManager * self, LoquiChannelEntry * chent);
static void ___real_loqui_account_manager_add_channel_entry_after (LoquiAccountManager * self, LoquiChannelEntry * chent);
static void ___real_loqui_account_manager_remove_channel_entry_after (LoquiAccountManager * self, LoquiChannelEntry * chent);
#line 131 "loqui-account-manager.gob"
static void loqui_account_manager_add_channel_cb (LoquiAccount * account, LoquiChannel * channel, LoquiAccountManager * self) G_GNUC_UNUSED;
#line 95 "loqui-account-manager.c"
#line 136 "loqui-account-manager.gob"
static void loqui_account_manager_add_channel_after_cb (LoquiAccount * account, LoquiChannel * channel, LoquiAccountManager * self) G_GNUC_UNUSED;
#line 98 "loqui-account-manager.c"
#line 141 "loqui-account-manager.gob"
static void loqui_account_manager_remove_channel_cb (LoquiAccount * account, LoquiChannel * channel, LoquiAccountManager * self) G_GNUC_UNUSED;
#line 101 "loqui-account-manager.c"
#line 146 "loqui-account-manager.gob"
static void loqui_account_manager_remove_channel_after_cb (LoquiAccount * account, LoquiChannel * channel, LoquiAccountManager * self) G_GNUC_UNUSED;
#line 104 "loqui-account-manager.c"

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__add_account(object,func,data)	loqui_account_manager_connect__add_account((object),(func),(data))
#define self_connect_after__add_account(object,func,data)	loqui_account_manager_connect_after__add_account((object),(func),(data))
#define self_connect_data__add_account(object,func,data,destroy_data,flags)	loqui_account_manager_connect_data__add_account((object),(func),(data),(destroy_data),(flags))
#define self_connect__remove_account(object,func,data)	loqui_account_manager_connect__remove_account((object),(func),(data))
#define self_connect_after__remove_account(object,func,data)	loqui_account_manager_connect_after__remove_account((object),(func),(data))
#define self_connect_data__remove_account(object,func,data,destroy_data,flags)	loqui_account_manager_connect_data__remove_account((object),(func),(data),(destroy_data),(flags))
#define self_connect__add_channel_entry(object,func,data)	loqui_account_manager_connect__add_channel_entry((object),(func),(data))
#define self_connect_after__add_channel_entry(object,func,data)	loqui_account_manager_connect_after__add_channel_entry((object),(func),(data))
#define self_connect_data__add_channel_entry(object,func,data,destroy_data,flags)	loqui_account_manager_connect_data__add_channel_entry((object),(func),(data),(destroy_data),(flags))
#define self_connect__add_channel_entry_after(object,func,data)	loqui_account_manager_connect__add_channel_entry_after((object),(func),(data))
#define self_connect_after__add_channel_entry_after(object,func,data)	loqui_account_manager_connect_after__add_channel_entry_after((object),(func),(data))
#define self_connect_data__add_channel_entry_after(object,func,data,destroy_data,flags)	loqui_account_manager_connect_data__add_channel_entry_after((object),(func),(data),(destroy_data),(flags))
#define self_connect__remove_channel_entry(object,func,data)	loqui_account_manager_connect__remove_channel_entry((object),(func),(data))
#define self_connect_after__remove_channel_entry(object,func,data)	loqui_account_manager_connect_after__remove_channel_entry((object),(func),(data))
#define self_connect_data__remove_channel_entry(object,func,data,destroy_data,flags)	loqui_account_manager_connect_data__remove_channel_entry((object),(func),(data),(destroy_data),(flags))
#define self_connect__remove_channel_entry_after(object,func,data)	loqui_account_manager_connect__remove_channel_entry_after((object),(func),(data))
#define self_connect_after__remove_channel_entry_after(object,func,data)	loqui_account_manager_connect_after__remove_channel_entry_after((object),(func),(data))
#define self_connect_data__remove_channel_entry_after(object,func,data,destroy_data,flags)	loqui_account_manager_connect_data__remove_channel_entry_after((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (LoquiAccountManager *, GObject *, gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((LoquiAccountManager *)data1,
		(GObject *) g_value_get_object (param_values + 1),
		data2);
}


enum {
	ADD_ACCOUNT_SIGNAL,
	REMOVE_ACCOUNT_SIGNAL,
	ADD_CHANNEL_ENTRY_SIGNAL,
	ADD_CHANNEL_ENTRY_AFTER_SIGNAL,
	REMOVE_CHANNEL_ENTRY_SIGNAL,
	REMOVE_CHANNEL_ENTRY_AFTER_SIGNAL,
	LAST_SIGNAL
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_add_account loqui_account_manager_add_account
#define self_remove_account loqui_account_manager_remove_account
#define self_add_channel_entry loqui_account_manager_add_channel_entry
#define self_add_channel_entry_after loqui_account_manager_add_channel_entry_after
#define self_remove_channel_entry loqui_account_manager_remove_channel_entry
#define self_remove_channel_entry_after loqui_account_manager_remove_channel_entry_after
#define self_new loqui_account_manager_new
#define self_add_channel_cb loqui_account_manager_add_channel_cb
#define self_add_channel_after_cb loqui_account_manager_add_channel_after_cb
#define self_remove_channel_cb loqui_account_manager_remove_channel_cb
#define self_remove_channel_after_cb loqui_account_manager_remove_channel_after_cb
#define self_remove_all_account loqui_account_manager_remove_all_account
#define self_load_accounts loqui_account_manager_load_accounts
#define self_save_accounts loqui_account_manager_save_accounts
#define self_disconnect_all loqui_account_manager_disconnect_all
#define self_get_account_list loqui_account_manager_get_account_list
#define self_connect_all_default loqui_account_manager_connect_all_default
#define self_get_next_channel_entry loqui_account_manager_get_next_channel_entry
#define self_get_previous_channel_entry loqui_account_manager_get_previous_channel_entry
#define self_new_channel_entry_id loqui_account_manager_new_channel_entry_id
#define self_update_positions loqui_account_manager_update_positions
GType
loqui_account_manager_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LoquiAccountManagerClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) loqui_account_manager_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LoquiAccountManager),
			0 /* n_preallocs */,
			(GInstanceInitFunc) loqui_account_manager_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LoquiAccountManager", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LoquiAccountManager *)g_object_new(loqui_account_manager_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LoquiAccountManager * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LoquiAccountManager *
GET_NEW_VARG (const char *first, ...)
{
	LoquiAccountManager *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LoquiAccountManager *)g_object_new_valist (loqui_account_manager_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Loqui:Account:Manager::dispose"
	LoquiAccountManager *self G_GNUC_UNUSED = LOQUI_ACCOUNT_MANAGER (obj_self);
#line 54 "loqui-account-manager.gob"
	___1_loqui_account_manager_dispose(obj_self);
#line 247 "loqui-account-manager.c"
#line 49 "loqui-account-manager.gob"
	if(self->protocol_manager) { g_object_unref ((gpointer) self->protocol_manager); self->protocol_manager = NULL; }
#line 250 "loqui-account-manager.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Loqui:Account:Manager::finalize"
	LoquiAccountManager *self G_GNUC_UNUSED = LOQUI_ACCOUNT_MANAGER (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
loqui_account_manager_init (LoquiAccountManager * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Account:Manager::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LOQUI_TYPE_ACCOUNT_MANAGER,LoquiAccountManagerPrivate);
#line 31 "loqui-account-manager.gob"
	o->protocol_manager = NULL;
#line 273 "loqui-account-manager.c"
}
#undef __GOB_FUNCTION__
static void 
loqui_account_manager_class_init (LoquiAccountManagerClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Account:Manager::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(LoquiAccountManagerPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[ADD_ACCOUNT_SIGNAL] =
		g_signal_new ("add_account",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LoquiAccountManagerClass, add_account),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_OBJECT);
	if ___GOB_UNLIKELY(sizeof(LoquiAccount * ) != sizeof(GObject *) || parent_class == NULL /* avoid warning */) {
		g_error("loqui-account-manager.gob line 66: Type mismatch of \"add_account\" signal signature");
	}
	object_signals[REMOVE_ACCOUNT_SIGNAL] =
		g_signal_new ("remove_account",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LoquiAccountManagerClass, remove_account),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_OBJECT);
	if ___GOB_UNLIKELY(sizeof(LoquiAccount * ) != sizeof(GObject *) || parent_class == NULL /* avoid warning */) {
		g_error("loqui-account-manager.gob line 84: Type mismatch of \"remove_account\" signal signature");
	}
	object_signals[ADD_CHANNEL_ENTRY_SIGNAL] =
		g_signal_new ("add_channel_entry",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LoquiAccountManagerClass, add_channel_entry),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_OBJECT);
	if ___GOB_UNLIKELY(sizeof(LoquiChannelEntry * ) != sizeof(GObject *) || parent_class == NULL /* avoid warning */) {
		g_error("loqui-account-manager.gob line 100: Type mismatch of \"add_channel_entry\" signal signature");
	}
	object_signals[ADD_CHANNEL_ENTRY_AFTER_SIGNAL] =
		g_signal_new ("add_channel_entry_after",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LoquiAccountManagerClass, add_channel_entry_after),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_OBJECT);
	if ___GOB_UNLIKELY(sizeof(LoquiChannelEntry * ) != sizeof(GObject *) || parent_class == NULL /* avoid warning */) {
		g_error("loqui-account-manager.gob line 105: Type mismatch of \"add_channel_entry_after\" signal signature");
	}
	object_signals[REMOVE_CHANNEL_ENTRY_SIGNAL] =
		g_signal_new ("remove_channel_entry",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LoquiAccountManagerClass, remove_channel_entry),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_OBJECT);
	if ___GOB_UNLIKELY(sizeof(LoquiChannelEntry * ) != sizeof(GObject *) || parent_class == NULL /* avoid warning */) {
		g_error("loqui-account-manager.gob line 110: Type mismatch of \"remove_channel_entry\" signal signature");
	}
	object_signals[REMOVE_CHANNEL_ENTRY_AFTER_SIGNAL] =
		g_signal_new ("remove_channel_entry_after",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LoquiAccountManagerClass, remove_channel_entry_after),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_OBJECT);
	if ___GOB_UNLIKELY(sizeof(LoquiChannelEntry * ) != sizeof(GObject *) || parent_class == NULL /* avoid warning */) {
		g_error("loqui-account-manager.gob line 114: Type mismatch of \"remove_channel_entry_after\" signal signature");
	}

#line 54 "loqui-account-manager.gob"
	g_object_class->dispose = ___dispose;
#line 66 "loqui-account-manager.gob"
	c->add_account = ___real_loqui_account_manager_add_account;
#line 84 "loqui-account-manager.gob"
	c->remove_account = ___real_loqui_account_manager_remove_account;
#line 100 "loqui-account-manager.gob"
	c->add_channel_entry = ___real_loqui_account_manager_add_channel_entry;
#line 105 "loqui-account-manager.gob"
	c->add_channel_entry_after = ___real_loqui_account_manager_add_channel_entry_after;
#line 369 "loqui-account-manager.c"
	c->remove_channel_entry = NULL;
#line 114 "loqui-account-manager.gob"
	c->remove_channel_entry_after = ___real_loqui_account_manager_remove_channel_entry_after;
#line 373 "loqui-account-manager.c"
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 54 "loqui-account-manager.gob"
static void 
___1_loqui_account_manager_dispose (GObject * object G_GNUC_UNUSED)
#line 383 "loqui-account-manager.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Loqui:Account:Manager::dispose"
{
#line 55 "loqui-account-manager.gob"
	
		Self *self;

		self = SELF(object);

		self_remove_all_account(self);

		PARENT_HANDLER(object);
	}}
#line 400 "loqui-account-manager.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 66 "loqui-account-manager.gob"
void 
loqui_account_manager_add_account (LoquiAccountManager * self, LoquiAccount * account)
{
#line 408 "loqui-account-manager.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 66 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 66 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 66 "loqui-account-manager.gob"
	g_return_if_fail (account != NULL);
#line 66 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT (account));
#line 423 "loqui-account-manager.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) account);

	g_signal_emitv (___param_values,
		object_signals[ADD_ACCOUNT_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 66 "loqui-account-manager.gob"
static void 
___real_loqui_account_manager_add_account (LoquiAccountManager * self G_GNUC_UNUSED, LoquiAccount * account)
{
#line 445 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::add_account"
{
#line 67 "loqui-account-manager.gob"
	
		self_add_channel_entry(self, LOQUI_CHANNEL_ENTRY(account));
		
        	selfp->account_list = g_list_append(selfp->account_list, g_object_ref(account));
        
        	g_signal_connect(G_OBJECT(account), "add-channel",
				 G_CALLBACK(self_add_channel_cb), self);
        	g_signal_connect_after(G_OBJECT(account), "add-channel",
        			       G_CALLBACK(self_add_channel_after_cb), self);
        	g_signal_connect(G_OBJECT(account), "remove-channel",
        			 G_CALLBACK(self_remove_channel_cb), self);
        	g_signal_connect_after(G_OBJECT(account), "remove-channel",
        			       G_CALLBACK(self_remove_channel_after_cb), self);
        
		self_add_channel_entry_after(self, LOQUI_CHANNEL_ENTRY(account));
	}}
#line 465 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 84 "loqui-account-manager.gob"
void 
loqui_account_manager_remove_account (LoquiAccountManager * self, LoquiAccount * account)
{
#line 472 "loqui-account-manager.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 84 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 84 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 84 "loqui-account-manager.gob"
	g_return_if_fail (account != NULL);
#line 84 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT (account));
#line 487 "loqui-account-manager.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) account);

	g_signal_emitv (___param_values,
		object_signals[REMOVE_ACCOUNT_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 84 "loqui-account-manager.gob"
static void 
___real_loqui_account_manager_remove_account (LoquiAccountManager * self G_GNUC_UNUSED, LoquiAccount * account)
{
#line 509 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::remove_account"
{
#line 85 "loqui-account-manager.gob"
	
		self_remove_channel_entry(self, LOQUI_CHANNEL_ENTRY(account));

        	g_signal_handlers_disconnect_by_func(G_OBJECT(account), self_add_channel_cb, self);
        	g_signal_handlers_disconnect_by_func(G_OBJECT(account), self_add_channel_after_cb, self);
        	g_signal_handlers_disconnect_by_func(G_OBJECT(account), self_remove_channel_cb, self);
        	g_signal_handlers_disconnect_by_func(G_OBJECT(account), self_remove_channel_after_cb, self);
        
        	selfp->account_list = g_list_remove(selfp->account_list, account);
        	g_object_unref(account);
        
		self_remove_channel_entry_after(self, LOQUI_CHANNEL_ENTRY(account));
        }}
#line 526 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 100 "loqui-account-manager.gob"
void 
loqui_account_manager_add_channel_entry (LoquiAccountManager * self, LoquiChannelEntry * chent)
{
#line 533 "loqui-account-manager.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 100 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 100 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 544 "loqui-account-manager.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) chent);

	g_signal_emitv (___param_values,
		object_signals[ADD_CHANNEL_ENTRY_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 100 "loqui-account-manager.gob"
static void 
___real_loqui_account_manager_add_channel_entry (LoquiAccountManager * self G_GNUC_UNUSED, LoquiChannelEntry * chent)
{
#line 566 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::add_channel_entry"
{
#line 101 "loqui-account-manager.gob"
	
        	loqui_channel_entry_set_id(chent, self_new_channel_entry_id(self));
	}}
#line 573 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 105 "loqui-account-manager.gob"
void 
loqui_account_manager_add_channel_entry_after (LoquiAccountManager * self, LoquiChannelEntry * chent)
{
#line 580 "loqui-account-manager.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 105 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 105 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 591 "loqui-account-manager.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) chent);

	g_signal_emitv (___param_values,
		object_signals[ADD_CHANNEL_ENTRY_AFTER_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 105 "loqui-account-manager.gob"
static void 
___real_loqui_account_manager_add_channel_entry_after (LoquiAccountManager * self G_GNUC_UNUSED, LoquiChannelEntry * chent)
{
#line 613 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::add_channel_entry_after"
{
#line 106 "loqui-account-manager.gob"
	
        	self_update_positions(self);
	}}
#line 620 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 110 "loqui-account-manager.gob"
void 
loqui_account_manager_remove_channel_entry (LoquiAccountManager * self, LoquiChannelEntry * chent)
{
#line 627 "loqui-account-manager.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 110 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 110 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 638 "loqui-account-manager.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) chent);

	g_signal_emitv (___param_values,
		object_signals[REMOVE_CHANNEL_ENTRY_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}

#line 114 "loqui-account-manager.gob"
void 
loqui_account_manager_remove_channel_entry_after (LoquiAccountManager * self, LoquiChannelEntry * chent)
{
#line 661 "loqui-account-manager.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 114 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 114 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 672 "loqui-account-manager.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) chent);

	g_signal_emitv (___param_values,
		object_signals[REMOVE_CHANNEL_ENTRY_AFTER_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 114 "loqui-account-manager.gob"
static void 
___real_loqui_account_manager_remove_channel_entry_after (LoquiAccountManager * self G_GNUC_UNUSED, LoquiChannelEntry * chent)
{
#line 694 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::remove_channel_entry_after"
{
#line 115 "loqui-account-manager.gob"
	
        	self_update_positions(self);
	}}
#line 701 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 120 "loqui-account-manager.gob"
LoquiAccountManager * 
loqui_account_manager_new (LoquiProtocolManager * protocol_manager)
{
#line 708 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::new"
{
#line 121 "loqui-account-manager.gob"
	
		Self *self;
        
		self = GET_NEW;
        
        	self->protocol_manager = g_object_ref(protocol_manager);
        
        	return self;
        }}
#line 721 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 131 "loqui-account-manager.gob"
static void 
loqui_account_manager_add_channel_cb (LoquiAccount * account, LoquiChannel * channel, LoquiAccountManager * self)
{
#line 728 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::add_channel_cb"
{
#line 132 "loqui-account-manager.gob"
	
		self_add_channel_entry(self, LOQUI_CHANNEL_ENTRY(channel));
	}}
#line 735 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 136 "loqui-account-manager.gob"
static void 
loqui_account_manager_add_channel_after_cb (LoquiAccount * account, LoquiChannel * channel, LoquiAccountManager * self)
{
#line 742 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::add_channel_after_cb"
{
#line 137 "loqui-account-manager.gob"
	
		self_add_channel_entry_after(self, LOQUI_CHANNEL_ENTRY(channel));
        }}
#line 749 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 141 "loqui-account-manager.gob"
static void 
loqui_account_manager_remove_channel_cb (LoquiAccount * account, LoquiChannel * channel, LoquiAccountManager * self)
{
#line 756 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::remove_channel_cb"
{
#line 142 "loqui-account-manager.gob"
	
        	self_remove_channel_entry(self, LOQUI_CHANNEL_ENTRY(channel));
        }}
#line 763 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 146 "loqui-account-manager.gob"
static void 
loqui_account_manager_remove_channel_after_cb (LoquiAccount * account, LoquiChannel * channel, LoquiAccountManager * self)
{
#line 770 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::remove_channel_after_cb"
{
#line 147 "loqui-account-manager.gob"
	
		self_remove_channel_entry_after(self, LOQUI_CHANNEL_ENTRY(channel));
        }}
#line 777 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 151 "loqui-account-manager.gob"
void 
loqui_account_manager_remove_all_account (LoquiAccountManager * self)
{
#line 784 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::remove_all_account"
#line 151 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 151 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 790 "loqui-account-manager.c"
{
#line 152 "loqui-account-manager.gob"
	
        	GList *list;
        
        	list = g_list_copy(selfp->account_list);
		loqui_utils_g_list_foreach_swapped(list, (GFunc) self_remove_account, self);
        	g_list_free(list);
        }}
#line 800 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 160 "loqui-account-manager.gob"
void 
loqui_account_manager_load_accounts (LoquiAccountManager * self)
{
#line 807 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::load_accounts"
#line 160 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 160 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 813 "loqui-account-manager.c"
{
#line 161 "loqui-account-manager.gob"
	
                GList *cur, *list = NULL;
        	gchar *path;
        	LoquiProfileHandle *handle;
        	LoquiAccount *account;
        	LoquiProfileAccount *profile;
        	GList *factory_list;
        
        	path = g_build_filename(loqui_core_get_user_dir(loqui_get_core()), ACCOUNT_CONFIG_FILENAME, NULL);
        
        	factory_list = loqui_protocol_manager_get_protocol_list(self->protocol_manager);
        	handle = loqui_profile_handle_new(factory_list);
        	g_list_free(factory_list);
        
        	loqui_profile_handle_read_from_file(handle, &list, path);
        
        	for(cur = list; cur != NULL; cur = cur->next) {
        		profile = LOQUI_PROFILE_ACCOUNT(cur->data);
        		account = loqui_protocol_create_account(profile->protocol, profile);
        
        		self_add_account(self, account);
        		g_object_unref(account);
        	}
        	g_list_free(list);
        	g_object_unref(handle);
        }}
#line 842 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 188 "loqui-account-manager.gob"
void 
loqui_account_manager_save_accounts (LoquiAccountManager * self)
{
#line 849 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::save_accounts"
#line 188 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 188 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 855 "loqui-account-manager.c"
{
#line 189 "loqui-account-manager.gob"
	
                GList *cur;
        	GList *list = NULL;
        	gchar *path;
        	LoquiProfileHandle *handle;
        	GList *factory_list;
        
        	for(cur = selfp->account_list; cur != NULL; cur = cur->next) {
        		list = g_list_append(list, loqui_account_get_profile(cur->data));
        	}
        
        	path = g_build_filename(loqui_core_get_user_dir(loqui_get_core()), ACCOUNT_CONFIG_FILENAME, NULL);
        
        	factory_list = loqui_protocol_manager_get_protocol_list(self->protocol_manager);
        	handle = loqui_profile_handle_new(factory_list);
        	g_list_free(factory_list);
        
        	loqui_profile_handle_write_to_file(handle, list, path);
        	g_object_unref(handle);
        	g_list_free(list);
        }}
#line 879 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 211 "loqui-account-manager.gob"
void 
loqui_account_manager_disconnect_all (LoquiAccountManager * self)
{
#line 886 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::disconnect_all"
#line 211 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 211 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 892 "loqui-account-manager.c"
{
#line 212 "loqui-account-manager.gob"
	
		g_list_foreach(selfp->account_list, (GFunc) loqui_account_disconnect, NULL);
	}}
#line 898 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 216 "loqui-account-manager.gob"
GList * 
loqui_account_manager_get_account_list (LoquiAccountManager * self)
{
#line 905 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::get_account_list"
#line 216 "loqui-account-manager.gob"
	g_return_val_if_fail (self != NULL, (GList * )0);
#line 216 "loqui-account-manager.gob"
	g_return_val_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self), (GList * )0);
#line 911 "loqui-account-manager.c"
{
#line 217 "loqui-account-manager.gob"
	
		return selfp->account_list;
	}}
#line 917 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 221 "loqui-account-manager.gob"
void 
loqui_account_manager_connect_all_default (LoquiAccountManager * self)
{
#line 924 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::connect_all_default"
#line 221 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 221 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 930 "loqui-account-manager.c"
{
#line 222 "loqui-account-manager.gob"
	
        	GList *cur;
        	LoquiAccount *account;
        
        	for (cur = selfp->account_list; cur != NULL; cur = cur->next) {
        		account = LOQUI_ACCOUNT(cur->data);
        		if (loqui_account_get_is_connected(account))
        			continue;
        		if (!loqui_profile_account_get_use(loqui_account_get_profile(account)))
        			continue;
        		
        		loqui_account_connect(account);
        	}
        }}
#line 947 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 245 "loqui-account-manager.gob"
LoquiChannelEntry * 
loqui_account_manager_get_next_channel_entry (LoquiAccountManager * self, LoquiChannelEntry * chent, gboolean require_unread)
{
#line 954 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::get_next_channel_entry"
#line 245 "loqui-account-manager.gob"
	g_return_val_if_fail (self != NULL, (LoquiChannelEntry * )0);
#line 245 "loqui-account-manager.gob"
	g_return_val_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self), (LoquiChannelEntry * )0);
#line 960 "loqui-account-manager.c"
{
#line 246 "loqui-account-manager.gob"
	
        	LoquiAccountManagerIter iter, iter_chent;
        	gboolean is_exist;
        	LoquiChannelEntry *tmp_chent;
        
        	loqui_account_manager_iter_init(self, &iter);
        	if (chent)
        		is_exist = loqui_account_manager_iter_set_channel_entry(&iter, chent);
        	else
        		is_exist = FALSE;
        	iter_chent = iter;
        	if (is_exist) {
        		loqui_account_manager_iter_channel_entry_next(&iter);
        		while ((tmp_chent = loqui_account_manager_iter_channel_entry_next(&iter))) {
        			if (!require_unread || loqui_channel_entry_get_whether_unread(tmp_chent))
        				return tmp_chent;
        		}
        	}
        	loqui_account_manager_iter_set_first_channel_entry(&iter);			
        	while ((tmp_chent = loqui_account_manager_iter_channel_entry_next(&iter))) {
        		if (!require_unread || loqui_channel_entry_get_whether_unread(tmp_chent))
        			return tmp_chent;
        	}
        	return NULL;
        }}
#line 988 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 272 "loqui-account-manager.gob"
LoquiChannelEntry * 
loqui_account_manager_get_previous_channel_entry (LoquiAccountManager * self, LoquiChannelEntry * chent, gboolean require_unread)
{
#line 995 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::get_previous_channel_entry"
#line 272 "loqui-account-manager.gob"
	g_return_val_if_fail (self != NULL, (LoquiChannelEntry * )0);
#line 272 "loqui-account-manager.gob"
	g_return_val_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self), (LoquiChannelEntry * )0);
#line 1001 "loqui-account-manager.c"
{
#line 273 "loqui-account-manager.gob"
	
        	LoquiAccountManagerIter iter;
        	gboolean is_exist;
        	LoquiChannelEntry *tmp_chent;
        
        	loqui_account_manager_iter_init(self, &iter);
        	if (chent)
        		is_exist = loqui_account_manager_iter_set_channel_entry(&iter, chent);
        	else
        		is_exist = FALSE;
        
        	if (is_exist) {
        		loqui_account_manager_iter_channel_entry_previous(&iter);
        		while ((tmp_chent = loqui_account_manager_iter_channel_entry_previous(&iter))) {
        			if (!require_unread || loqui_channel_entry_get_whether_unread(tmp_chent))
        				return tmp_chent;
        		}
        	}
        	loqui_account_manager_iter_set_last_channel_entry(&iter);			
        	while ((tmp_chent = loqui_account_manager_iter_channel_entry_previous(&iter))) {
        		if (!require_unread || loqui_channel_entry_get_whether_unread(tmp_chent))
        			return tmp_chent;
        	}
        	return NULL;
        }}
#line 1029 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 299 "loqui-account-manager.gob"
gint 
loqui_account_manager_new_channel_entry_id (LoquiAccountManager * self)
{
#line 1036 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::new_channel_entry_id"
#line 299 "loqui-account-manager.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 299 "loqui-account-manager.gob"
	g_return_val_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self), (gint )0);
#line 1042 "loqui-account-manager.c"
{
#line 300 "loqui-account-manager.gob"
	
        	return ++self->max_channel_entry_id;
        }}
#line 1048 "loqui-account-manager.c"
#undef __GOB_FUNCTION__

#line 304 "loqui-account-manager.gob"
void 
loqui_account_manager_update_positions (LoquiAccountManager * self)
{
#line 1055 "loqui-account-manager.c"
#define __GOB_FUNCTION__ "Loqui:Account:Manager::update_positions"
#line 304 "loqui-account-manager.gob"
	g_return_if_fail (self != NULL);
#line 304 "loqui-account-manager.gob"
	g_return_if_fail (LOQUI_IS_ACCOUNT_MANAGER (self));
#line 1061 "loqui-account-manager.c"
{
#line 305 "loqui-account-manager.gob"
	
        	LoquiAccountManagerIter iter;
        	LoquiChannelEntry *chent;
        	gint i;
        
        	i = 0;
        	loqui_account_manager_iter_init(self, &iter);
        	loqui_account_manager_iter_set_first_channel_entry(&iter);
        	while ((chent = loqui_account_manager_iter_channel_entry_next(&iter))) {
        		loqui_channel_entry_set_position(chent, i);
        		i++;
        	}
        }}
#line 1077 "loqui-account-manager.c"
#undef __GOB_FUNCTION__
