// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "EffUI.h"
//Copyright (c) 2002-2005 Nasca Octavian Paul
//License: GNU GPL version 2 or later

EQGraph::EQGraph(int x,int y, int w, int h, const char *label):Fl_Box(x,y,w,h,label) {
  eff=NULL;
maxdB=30;
}

void EQGraph::init(EffectMgr *eff_) {
  eff=eff_;
oldx=-1;
khzval=-1;
}

void EQGraph::draw_freq_line(REALTYPE freq,int type) {
  fl_color(FL_GRAY);
REALTYPE freqx=getfreqpos(freq);
switch(type){
  case 0:if (active_r()) fl_color(FL_WHITE);
            else fl_color(205,205,205);
         fl_line_style(FL_SOLID);
         break;
  case 1:fl_line_style(FL_DOT);break;
  case 2:fl_line_style(FL_DASH);break;
}; 


if ((freqx>0.0)&&(freqx<1.0))
   fl_line(x()+(int) (freqx*w()),y(),
   x()+(int) (freqx*w()),y()+h());
}

void EQGraph::draw() {
  int ox=x(),oy=y(),lx=w(),ly=h(),i,iy,oiy;
REALTYPE freqx;

if (active_r()) fl_color(0,70,150);
       else fl_color(80,120,160);
fl_rectf(ox,oy,lx,ly);


//draw the lines
fl_color(FL_GRAY);

fl_line_style(FL_SOLID);
fl_line(ox+2,oy+ly/2,ox+lx-2,oy+ly/2);

freqx=getfreqpos(1000.0);
if ((freqx>0.0)&&(freqx<1.0))
   fl_line(ox+(int) (freqx*lx),oy,
    ox+(int) (freqx*lx),oy+ly);

for (i=1;i<10;i++){
   if(i==1){
     draw_freq_line(i*100.0,0);
     draw_freq_line(i*1000.0,0);
   }else 
    if (i==5){
      draw_freq_line(i*10.0,2);
      draw_freq_line(i*100.0,2);
      draw_freq_line(i*1000.0,2);
    }else{
      draw_freq_line(i*10.0,1);
      draw_freq_line(i*100.0,1);
      draw_freq_line(i*1000.0,1);
    };
};

draw_freq_line(10000.0,0);
draw_freq_line(20000.0,1);


fl_line_style(FL_DOT);
int GY=6;if (ly<GY*3) GY=-1;
for (i=1;i<GY;i++){
   int tmp=(int)(ly/(REALTYPE)GY*i);
   fl_line(ox+2,oy+tmp,ox+lx-2,oy+tmp);
};


//draw the frequency response
if (active_r()) fl_color(FL_YELLOW);
       else fl_color(200,200,80);
fl_line_style(FL_SOLID);
oiy=getresponse(ly,getfreqx(0.0));
for (i=1;i<lx;i++){
   REALTYPE frq=getfreqx(i/(REALTYPE) lx);
   if (frq>SAMPLE_RATE/2) break;
   iy=getresponse(ly,frq);
   if ((oiy>=0) && (oiy<ly) &&
       (iy>=0) && (iy<ly) )
        fl_line(ox+i-1,oy+ly-oiy,ox+i,oy+ly-iy);
   oiy=iy;
};
}

int EQGraph::getresponse(int maxy,REALTYPE freq) {
  REALTYPE dbresp=eff->getEQfreqresponse(freq);
int idbresp=(int) ((dbresp/maxdB+1.0)*maxy/2.0);


//fprintf(stderr,"%.5f\n",(dbresp/maxdB+1.0)*maxy/2.0);


return(idbresp);
}

REALTYPE EQGraph::getfreqx(REALTYPE x) {
  if (x>1.0) x=1.0;
return(20.0*pow((REALTYPE)1000.0,x));
}

REALTYPE EQGraph::getfreqpos(REALTYPE freq) {
  if (freq<0.00001) freq=0.00001;
return(log(freq/20.0)/log(1000.0));
}

void EffUI::cb_revp_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());

refresh(eff);
}
void EffUI::cb_revp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp_i(o,v);
}

Fl_Menu_Item EffUI::menu_revp[] = {
 {"Cathedral 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Cathedral 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Cathedral 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Hall 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Hall 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Room 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Room 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Basement", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Tunnel", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Echoed 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Echoed 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Very Long 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Very Long 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_revp10_i(Fl_Choice* o, void*) {
  eff->seteffectpar(10,(int) o->value());
}
void EffUI::cb_revp10(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp10_i(o,v);
}

Fl_Menu_Item EffUI::menu_revp10[] = {
 {"Random", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Freeverb", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_revp0_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void EffUI::cb_revp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp0_i(o,v);
}

void EffUI::cb_revp1_i(WidgetPDial* o, void*) {
  eff->seteffectpar(1,(int) o->value());
}
void EffUI::cb_revp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp1_i(o,v);
}

void EffUI::cb_revp2_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void EffUI::cb_revp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp2_i(o,v);
}

void EffUI::cb_revp3_i(WidgetPDial* o, void*) {
  eff->seteffectpar(3,(int) o->value());
}
void EffUI::cb_revp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp3_i(o,v);
}

void EffUI::cb_revp4_i(WidgetPDial* o, void*) {
  eff->seteffectpar(4,(int) o->value());
}
void EffUI::cb_revp4(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp4_i(o,v);
}

void EffUI::cb_revp5_i(WidgetPDial* o, void*) {
  eff->seteffectpar(5,(int) o->value());
}
void EffUI::cb_revp5(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp5_i(o,v);
}

void EffUI::cb_revp6_i(WidgetPDial* o, void*) {
  eff->seteffectpar(6,(int) o->value());
}
void EffUI::cb_revp6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp6_i(o,v);
}

void EffUI::cb_revp7_i(WidgetPDial* o, void*) {
  eff->seteffectpar(7,(int) o->value());
}
void EffUI::cb_revp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp7_i(o,v);
}

void EffUI::cb_revp8_i(WidgetPDial* o, void*) {
  eff->seteffectpar(8,(int) o->value());
}
void EffUI::cb_revp8(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp8_i(o,v);
}

void EffUI::cb_revp9_i(WidgetPDial* o, void*) {
  eff->seteffectpar(9,(int) o->value());
}
void EffUI::cb_revp9(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp9_i(o,v);
}

void EffUI::cb_revp11_i(WidgetPDial* o, void*) {
  int x=64;
if (Fl::event_button1()) x=(int)o->value();
   else o->value(x);
eff->seteffectpar(11,x);
}
void EffUI::cb_revp11(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_revp11_i(o,v);
}

void EffUI::cb_echop_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void EffUI::cb_echop(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop_i(o,v);
}

Fl_Menu_Item EffUI::menu_echop[] = {
 {"Echo 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Echo 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Echo 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Simple Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Canyon", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Panning Echo 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Panning Echo 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Panning Echo 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Feedback Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_echop0_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void EffUI::cb_echop0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop0_i(o,v);
}

void EffUI::cb_echop1_i(WidgetPDial* o, void*) {
  eff->seteffectpar(1,(int) o->value());
}
void EffUI::cb_echop1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop1_i(o,v);
}

void EffUI::cb_echop2_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void EffUI::cb_echop2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop2_i(o,v);
}

void EffUI::cb_echop3_i(WidgetPDial* o, void*) {
  eff->seteffectpar(3,(int) o->value());
}
void EffUI::cb_echop3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop3_i(o,v);
}

void EffUI::cb_echop4_i(WidgetPDial* o, void*) {
  eff->seteffectpar(4,(int) o->value());
}
void EffUI::cb_echop4(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop4_i(o,v);
}

void EffUI::cb_echop5_i(WidgetPDial* o, void*) {
  eff->seteffectpar(5,(int) o->value());
}
void EffUI::cb_echop5(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop5_i(o,v);
}

void EffUI::cb_echop6_i(WidgetPDial* o, void*) {
  eff->seteffectpar(6,(int) o->value());
}
void EffUI::cb_echop6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_echop6_i(o,v);
}

void EffUI::cb_chorusp_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void EffUI::cb_chorusp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp_i(o,v);
}

Fl_Menu_Item EffUI::menu_chorusp[] = {
 {"Chorus 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Chorus 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Chorus 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Celeste 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Celeste 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Flange 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Flange 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Flange 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Flange 4", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Flange 5", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_chorusp0_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void EffUI::cb_chorusp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp0_i(o,v);
}

void EffUI::cb_chorusp1_i(WidgetPDial* o, void*) {
  eff->seteffectpar(1,(int) o->value());
}
void EffUI::cb_chorusp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp1_i(o,v);
}

void EffUI::cb_chorusp2_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void EffUI::cb_chorusp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp2_i(o,v);
}

void EffUI::cb_chorusp3_i(WidgetPDial* o, void*) {
  eff->seteffectpar(3,(int) o->value());
}
void EffUI::cb_chorusp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp3_i(o,v);
}

void EffUI::cb_chorusp5_i(WidgetPDial* o, void*) {
  eff->seteffectpar(5,(int) o->value());
}
void EffUI::cb_chorusp5(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp5_i(o,v);
}

void EffUI::cb_chorusp6_i(WidgetPDial* o, void*) {
  eff->seteffectpar(6,(int) o->value());
}
void EffUI::cb_chorusp6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp6_i(o,v);
}

void EffUI::cb_chorusp7_i(WidgetPDial* o, void*) {
  eff->seteffectpar(7,(int) o->value());
}
void EffUI::cb_chorusp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp7_i(o,v);
}

void EffUI::cb_chorusp8_i(WidgetPDial* o, void*) {
  eff->seteffectpar(8,(int) o->value());
}
void EffUI::cb_chorusp8(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp8_i(o,v);
}

void EffUI::cb_chorusp9_i(WidgetPDial* o, void*) {
  eff->seteffectpar(9,(int) o->value());
}
void EffUI::cb_chorusp9(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp9_i(o,v);
}

void EffUI::cb_Flange_i(Fl_Check_Button* o, void*) {
  eff->seteffectpar(10,(int) o->value());
}
void EffUI::cb_Flange(Fl_Check_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_Flange_i(o,v);
}

void EffUI::cb_chorusp11_i(Fl_Check_Button* o, void*) {
  eff->seteffectpar(11,(int) o->value());
}
void EffUI::cb_chorusp11(Fl_Check_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp11_i(o,v);
}

void EffUI::cb_chorusp4_i(Fl_Choice* o, void*) {
  eff->seteffectpar(4,(int) o->value());
}
void EffUI::cb_chorusp4(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_chorusp4_i(o,v);
}

Fl_Menu_Item EffUI::menu_chorusp4[] = {
 {"SINE", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"TRI", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_phaserp_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void EffUI::cb_phaserp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp_i(o,v);
}

Fl_Menu_Item EffUI::menu_phaserp[] = {
 {"Phaser 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Phaser 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Phaser 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Phaser 4", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Phaser 5", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Phaser 6", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_phaserp0_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void EffUI::cb_phaserp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp0_i(o,v);
}

void EffUI::cb_phaserp1_i(WidgetPDial* o, void*) {
  eff->seteffectpar(1,(int) o->value());
}
void EffUI::cb_phaserp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp1_i(o,v);
}

void EffUI::cb_phaserp2_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void EffUI::cb_phaserp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp2_i(o,v);
}

void EffUI::cb_phaserp3_i(WidgetPDial* o, void*) {
  eff->seteffectpar(3,(int) o->value());
}
void EffUI::cb_phaserp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp3_i(o,v);
}

void EffUI::cb_phaserp5_i(WidgetPDial* o, void*) {
  eff->seteffectpar(5,(int) o->value());
}
void EffUI::cb_phaserp5(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp5_i(o,v);
}

void EffUI::cb_phaserp6_i(WidgetPDial* o, void*) {
  eff->seteffectpar(6,(int) o->value());
}
void EffUI::cb_phaserp6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp6_i(o,v);
}

void EffUI::cb_phaserp7_i(WidgetPDial* o, void*) {
  eff->seteffectpar(7,(int) o->value());
}
void EffUI::cb_phaserp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp7_i(o,v);
}

void EffUI::cb_phaserp9_i(WidgetPDial* o, void*) {
  eff->seteffectpar(9,(int) o->value());
}
void EffUI::cb_phaserp9(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp9_i(o,v);
}

void EffUI::cb_phaserp10_i(Fl_Check_Button* o, void*) {
  eff->seteffectpar(10,(int) o->value());
}
void EffUI::cb_phaserp10(Fl_Check_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp10_i(o,v);
}

void EffUI::cb_phaserp4_i(Fl_Choice* o, void*) {
  eff->seteffectpar(4,(int) o->value());
}
void EffUI::cb_phaserp4(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp4_i(o,v);
}

Fl_Menu_Item EffUI::menu_phaserp4[] = {
 {"SINE", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"TRI", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_phaserp8_i(Fl_Counter* o, void*) {
  eff->seteffectpar(8,(int) o->value());
}
void EffUI::cb_phaserp8(Fl_Counter* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp8_i(o,v);
}

void EffUI::cb_phaserp11_i(WidgetPDial* o, void*) {
  eff->seteffectpar(11,(int) o->value());
}
void EffUI::cb_phaserp11(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_phaserp11_i(o,v);
}

void EffUI::cb_awp_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void EffUI::cb_awp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp_i(o,v);
}

Fl_Menu_Item EffUI::menu_awp[] = {
 {"Alienwah 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Alienwah 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Alienwah 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Alienwah 4", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_awp0_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void EffUI::cb_awp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp0_i(o,v);
}

void EffUI::cb_awp1_i(WidgetPDial* o, void*) {
  eff->seteffectpar(1,(int) o->value());
}
void EffUI::cb_awp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp1_i(o,v);
}

void EffUI::cb_awp2_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void EffUI::cb_awp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp2_i(o,v);
}

void EffUI::cb_awp3_i(WidgetPDial* o, void*) {
  eff->seteffectpar(3,(int) o->value());
}
void EffUI::cb_awp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp3_i(o,v);
}

void EffUI::cb_awp5_i(WidgetPDial* o, void*) {
  eff->seteffectpar(5,(int) o->value());
}
void EffUI::cb_awp5(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp5_i(o,v);
}

void EffUI::cb_awp6_i(WidgetPDial* o, void*) {
  eff->seteffectpar(6,(int) o->value());
}
void EffUI::cb_awp6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp6_i(o,v);
}

void EffUI::cb_awp7_i(WidgetPDial* o, void*) {
  eff->seteffectpar(7,(int) o->value());
}
void EffUI::cb_awp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp7_i(o,v);
}

void EffUI::cb_awp9_i(WidgetPDial* o, void*) {
  eff->seteffectpar(9,(int) o->value());
}
void EffUI::cb_awp9(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp9_i(o,v);
}

void EffUI::cb_awp4_i(Fl_Choice* o, void*) {
  eff->seteffectpar(4,(int) o->value());
}
void EffUI::cb_awp4(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp4_i(o,v);
}

Fl_Menu_Item EffUI::menu_awp4[] = {
 {"SINE", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"TRI", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_awp10_i(WidgetPDial* o, void*) {
  eff->seteffectpar(10,(int) o->value());
}
void EffUI::cb_awp10(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp10_i(o,v);
}

void EffUI::cb_awp8_i(Fl_Counter* o, void*) {
  eff->seteffectpar(8,(int) o->value());
}
void EffUI::cb_awp8(Fl_Counter* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_awp8_i(o,v);
}

void EffUI::cb_distp_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void EffUI::cb_distp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp_i(o,v);
}

Fl_Menu_Item EffUI::menu_distp[] = {
 {"Overdrive 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Overdrive 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"A. Exciter 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"A. Exciter 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Guitar Amp", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Quantisize", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_distp0_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void EffUI::cb_distp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp0_i(o,v);
}

void EffUI::cb_distp1_i(WidgetPDial* o, void*) {
  eff->seteffectpar(1,(int) o->value());
}
void EffUI::cb_distp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp1_i(o,v);
}

void EffUI::cb_distp2_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void EffUI::cb_distp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp2_i(o,v);
}

void EffUI::cb_distp3_i(WidgetPDial* o, void*) {
  eff->seteffectpar(3,(int) o->value());
}
void EffUI::cb_distp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp3_i(o,v);
}

void EffUI::cb_distp4_i(WidgetPDial* o, void*) {
  eff->seteffectpar(4,(int) o->value());
}
void EffUI::cb_distp4(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp4_i(o,v);
}

void EffUI::cb_distp7_i(WidgetPDial* o, void*) {
  eff->seteffectpar(7,(int) o->value());
}
void EffUI::cb_distp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp7_i(o,v);
}

void EffUI::cb_distp8_i(WidgetPDial* o, void*) {
  eff->seteffectpar(8,(int) o->value());
}
void EffUI::cb_distp8(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp8_i(o,v);
}

void EffUI::cb_distp5_i(Fl_Choice* o, void*) {
  eff->seteffectpar(5,(int) o->value());
}
void EffUI::cb_distp5(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp5_i(o,v);
}

Fl_Menu_Item EffUI::menu_distp5[] = {
 {"Atan", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Asym1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Pow", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Sine", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Qnts", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Zigzg", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Lmt", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"LmtU", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"LmtL", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"ILmt", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Clip", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Asym2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Pow2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Sgm", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_distp6_i(Fl_Check_Button* o, void*) {
  eff->seteffectpar(6,(int) o->value());
}
void EffUI::cb_distp6(Fl_Check_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp6_i(o,v);
}

void EffUI::cb_distp9_i(Fl_Check_Button* o, void*) {
  eff->seteffectpar(9,(int) o->value());
}
void EffUI::cb_distp9(Fl_Check_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp9_i(o,v);
}

void EffUI::cb_distp10_i(Fl_Check_Button* o, void*) {
  eff->seteffectpar(10,(int) o->value());
}
void EffUI::cb_distp10(Fl_Check_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_distp10_i(o,v);
}

void EffUI::cb_eqp0_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
eqgraph->redraw();
}
void EffUI::cb_eqp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_eqp0_i(o,v);
}

void EffUI::cb_bandcounter_i(Fl_Counter* o, void*) {
  eqband=(int) o->value();
int npb=eqband*5+10;

int type=eff->geteffectpar(npb);
typechoice->value(type);

if (type>6) gaindial->activate();
 else gaindial->deactivate();

if (type==0) bandgroup->deactivate();
else bandgroup->activate();

int freq=eff->geteffectpar(npb+1);
freqdial->value(freq);

int gain=eff->geteffectpar(npb+2);
gaindial->value(gain);

int q=eff->geteffectpar(npb+3);
qdial->value(q);

int dbl=eff->geteffectpar(npb+4);
stagescounter->value(dbl);
}
void EffUI::cb_bandcounter(Fl_Counter* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_bandcounter_i(o,v);
}

void EffUI::cb_freqdial_i(WidgetPDial* o, void*) {
  int np=eqband*5+11;
eff->seteffectpar(np,(int) o->value());
eqgraph->redraw();
}
void EffUI::cb_freqdial(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_freqdial_i(o,v);
}

void EffUI::cb_gaindial_i(WidgetPDial* o, void*) {
  int np=eqband*5+12;
eff->seteffectpar(np,(int) o->value());
eqgraph->redraw();
}
void EffUI::cb_gaindial(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_gaindial_i(o,v);
}

void EffUI::cb_qdial_i(WidgetPDial* o, void*) {
  int np=eqband*5+13;
eff->seteffectpar(np,(int) o->value());
eqgraph->redraw();
}
void EffUI::cb_qdial(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_qdial_i(o,v);
}

void EffUI::cb_stagescounter_i(Fl_Counter* o, void*) {
  int np=eqband*5+14;
eff->seteffectpar(np,(int) o->value());
eqgraph->redraw();
}
void EffUI::cb_stagescounter(Fl_Counter* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_stagescounter_i(o,v);
}

void EffUI::cb_typechoice_i(Fl_Choice* o, void*) {
  int np=eqband*5+10;
eff->seteffectpar(np,(int) o->value());
bandcounter->do_callback();
eqgraph->redraw();
}
void EffUI::cb_typechoice(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_typechoice_i(o,v);
}

Fl_Menu_Item EffUI::menu_typechoice[] = {
 {"OFF", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Lp1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Hp1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Lp2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Hp2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Bp2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"N2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Pk", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"LSh", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"HSh", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_dfp_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void EffUI::cb_dfp(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp_i(o,v);
}

Fl_Menu_Item EffUI::menu_dfp[] = {
 {"WahWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"AutoWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Sweep", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"VocalMorph1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"VocalMorph2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_dfp0_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void EffUI::cb_dfp0(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp0_i(o,v);
}

void EffUI::cb_dfp1_i(WidgetPDial* o, void*) {
  eff->seteffectpar(1,(int) o->value());
}
void EffUI::cb_dfp1(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp1_i(o,v);
}

void EffUI::cb_dfp2_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void EffUI::cb_dfp2(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp2_i(o,v);
}

void EffUI::cb_dfp3_i(WidgetPDial* o, void*) {
  eff->seteffectpar(3,(int) o->value());
}
void EffUI::cb_dfp3(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp3_i(o,v);
}

void EffUI::cb_dfp5_i(WidgetPDial* o, void*) {
  eff->seteffectpar(5,(int) o->value());
}
void EffUI::cb_dfp5(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp5_i(o,v);
}

void EffUI::cb_dfp6_i(WidgetPDial* o, void*) {
  eff->seteffectpar(6,(int) o->value());
}
void EffUI::cb_dfp6(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp6_i(o,v);
}

void EffUI::cb_dfp4_i(Fl_Choice* o, void*) {
  eff->seteffectpar(4,(int) o->value());
}
void EffUI::cb_dfp4(Fl_Choice* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_dfp4_i(o,v);
}

Fl_Menu_Item EffUI::menu_dfp4[] = {
 {"SINE", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"TRI", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void EffUI::cb_Filter_i(Fl_Button*, void*) {
  filterwindow->show();
}
void EffUI::cb_Filter(Fl_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_Filter_i(o,v);
}

void EffUI::cb_dfp7_i(WidgetPDial* o, void*) {
  eff->seteffectpar(7,(int) o->value());
}
void EffUI::cb_dfp7(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_dfp7_i(o,v);
}

void EffUI::cb_dfp9_i(WidgetPDial* o, void*) {
  eff->seteffectpar(9,(int) o->value());
}
void EffUI::cb_dfp9(WidgetPDial* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_dfp9_i(o,v);
}

void EffUI::cb_dfp8_i(Fl_Check_Button* o, void*) {
  eff->seteffectpar(8,(int) o->value());
}
void EffUI::cb_dfp8(Fl_Check_Button* o, void* v) {
  ((EffUI*)(o->parent()->parent()->user_data()))->cb_dfp8_i(o,v);
}

void EffUI::cb_Close_i(Fl_Button*, void*) {
  filterwindow->hide();
}
void EffUI::cb_Close(Fl_Button* o, void* v) {
  ((EffUI*)(o->parent()->user_data()))->cb_Close_i(o,v);
}

EffUI::EffUI(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  eff=NULL;
filterwindow=NULL;
}

EffUI::~EffUI() {
  effnullwindow->hide();//delete (effnullwindow);
effreverbwindow->hide();//delete (effreverbwindow);
effechowindow->hide();//delete (effechowindow);
effchoruswindow->hide();//delete (effchoruswindow);
effphaserwindow->hide();//delete (effphaserwindow);
effalienwahwindow->hide();//delete (effalienwahwindow);
effdistorsionwindow->hide();//delete (effdistorsionwindow);
effeqwindow->hide();//delete (effeqwindow);
effdynamicfilterwindow->hide();//delete (effdynamicfilterwindow);

if (filterwindow!=NULL){
	filterwindow->hide();
	delete(filterwindow);
};
}

Fl_Group* EffUI::make_null_window() {
  { effnullwindow = new Fl_Group(0, 0, 380, 95);
    effnullwindow->box(FL_PLASTIC_UP_BOX);
    effnullwindow->color((Fl_Color)221);
    effnullwindow->selection_color(FL_BACKGROUND_COLOR);
    effnullwindow->labeltype(FL_NO_LABEL);
    effnullwindow->labelfont(1);
    effnullwindow->labelsize(14);
    effnullwindow->labelcolor(FL_FOREGROUND_COLOR);
    effnullwindow->user_data((void*)(this));
    effnullwindow->align(Fl_Align(FL_ALIGN_TOP));
    effnullwindow->when(FL_WHEN_RELEASE);
    { Fl_Text_Display* o = new Fl_Text_Display(120, 35, 10, 20, "No Effect");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->labelcolor((Fl_Color)43);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    effnullwindow->end();
  } // Fl_Group* effnullwindow
  return effnullwindow;
}

Fl_Group* EffUI::make_reverb_window() {
  { effreverbwindow = new Fl_Group(0, 0, 380, 95);
    effreverbwindow->box(FL_PLASTIC_UP_BOX);
    effreverbwindow->color((Fl_Color)221);
    effreverbwindow->selection_color(FL_BACKGROUND_COLOR);
    effreverbwindow->labeltype(FL_NO_LABEL);
    effreverbwindow->labelfont(1);
    effreverbwindow->labelsize(14);
    effreverbwindow->labelcolor(FL_FOREGROUND_COLOR);
    effreverbwindow->user_data((void*)(this));
    effreverbwindow->align(Fl_Align(FL_ALIGN_TOP));
    effreverbwindow->when(FL_WHEN_RELEASE);
    { Fl_Text_Display* o = new Fl_Text_Display(275, 10, 10, 20, "Reverb ");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { revp = new Fl_Choice(10, 15, 90, 15, "Preset");
      revp->down_box(FL_BORDER_BOX);
      revp->color((Fl_Color)14);
      revp->selection_color(FL_FOREGROUND_COLOR);
      revp->labelfont(1);
      revp->labelsize(10);
      revp->textfont(1);
      revp->textsize(10);
      revp->textcolor(FL_BACKGROUND2_COLOR);
      revp->callback((Fl_Callback*)cb_revp);
      revp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      revp->menu(menu_revp);
    } // Fl_Choice* revp
    { revp10 = new Fl_Choice(110, 15, 75, 15, "Type");
      revp10->down_box(FL_BORDER_BOX);
      revp10->color((Fl_Color)14);
      revp10->labelfont(1);
      revp10->labelsize(10);
      revp10->textfont(1);
      revp10->textsize(10);
      revp10->textcolor(FL_BACKGROUND2_COLOR);
      revp10->callback((Fl_Callback*)cb_revp10);
      revp10->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      revp10->menu(menu_revp10);
    } // Fl_Choice* revp10
    { revp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      revp0->tooltip("Effect Volume");
      revp0->box(FL_ROUND_UP_BOX);
      revp0->color(FL_BACKGROUND_COLOR);
      revp0->selection_color(FL_INACTIVE_COLOR);
      revp0->labeltype(FL_NORMAL_LABEL);
      revp0->labelfont(1);
      revp0->labelsize(11);
      revp0->labelcolor(FL_FOREGROUND_COLOR);
      revp0->maximum(127);
      revp0->callback((Fl_Callback*)cb_revp0);
      revp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* revp0
    { revp1 = new WidgetPDial(45, 40, 30, 30, "Pan");
      revp1->box(FL_ROUND_UP_BOX);
      revp1->color(FL_BACKGROUND_COLOR);
      revp1->selection_color(FL_INACTIVE_COLOR);
      revp1->labeltype(FL_NORMAL_LABEL);
      revp1->labelfont(1);
      revp1->labelsize(11);
      revp1->labelcolor(FL_FOREGROUND_COLOR);
      revp1->maximum(127);
      revp1->callback((Fl_Callback*)cb_revp1);
      revp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp1->when(FL_WHEN_CHANGED);
    } // WidgetPDial* revp1
    { revp2 = new WidgetPDial(80, 40, 30, 30, "Time");
      revp2->tooltip("Duration of Effect");
      revp2->box(FL_ROUND_UP_BOX);
      revp2->color(FL_BACKGROUND_COLOR);
      revp2->selection_color(FL_INACTIVE_COLOR);
      revp2->labeltype(FL_NORMAL_LABEL);
      revp2->labelfont(1);
      revp2->labelsize(11);
      revp2->labelcolor(FL_FOREGROUND_COLOR);
      revp2->maximum(127);
      revp2->callback((Fl_Callback*)cb_revp2);
      revp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp2->when(FL_WHEN_CHANGED);
    } // WidgetPDial* revp2
    { revp3 = new WidgetPDial(120, 40, 30, 30, "I.del");
      revp3->tooltip("Initial Delay");
      revp3->box(FL_ROUND_UP_BOX);
      revp3->color(FL_BACKGROUND_COLOR);
      revp3->selection_color(FL_INACTIVE_COLOR);
      revp3->labeltype(FL_NORMAL_LABEL);
      revp3->labelfont(1);
      revp3->labelsize(11);
      revp3->labelcolor(FL_FOREGROUND_COLOR);
      revp3->maximum(127);
      revp3->callback((Fl_Callback*)cb_revp3);
      revp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp3->when(FL_WHEN_RELEASE);
    } // WidgetPDial* revp3
    { revp4 = new WidgetPDial(155, 40, 30, 30, "I.delfb");
      revp4->tooltip("Initial Delay Feedback");
      revp4->box(FL_ROUND_UP_BOX);
      revp4->color(FL_BACKGROUND_COLOR);
      revp4->selection_color(FL_INACTIVE_COLOR);
      revp4->labeltype(FL_NORMAL_LABEL);
      revp4->labelfont(1);
      revp4->labelsize(11);
      revp4->labelcolor(FL_FOREGROUND_COLOR);
      revp4->maximum(127);
      revp4->callback((Fl_Callback*)cb_revp4);
      revp4->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp4->when(FL_WHEN_CHANGED);
    } // WidgetPDial* revp4
    { revp5 = new WidgetPDial(200, 40, 30, 30, "R.delay");
      revp5->box(FL_ROUND_UP_BOX);
      revp5->color(FL_BACKGROUND_COLOR);
      revp5->selection_color(FL_INACTIVE_COLOR);
      revp5->labeltype(FL_NORMAL_LABEL);
      revp5->labelfont(1);
      revp5->labelsize(11);
      revp5->labelcolor(FL_FOREGROUND_COLOR);
      revp5->maximum(127);
      revp5->callback((Fl_Callback*)cb_revp5);
      revp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp5->when(FL_WHEN_RELEASE);
      revp5->deactivate();
    } // WidgetPDial* revp5
    { revp6 = new WidgetPDial(235, 40, 30, 30, "E/R");
      revp6->box(FL_ROUND_UP_BOX);
      revp6->color(FL_BACKGROUND_COLOR);
      revp6->selection_color(FL_INACTIVE_COLOR);
      revp6->labeltype(FL_NORMAL_LABEL);
      revp6->labelfont(1);
      revp6->labelsize(11);
      revp6->labelcolor(FL_FOREGROUND_COLOR);
      revp6->maximum(127);
      revp6->callback((Fl_Callback*)cb_revp6);
      revp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp6->when(FL_WHEN_CHANGED);
      revp6->deactivate();
    } // WidgetPDial* revp6
    { revp7 = new WidgetPDial(270, 40, 30, 30, "LPF");
      revp7->tooltip("Low Pass Filter");
      revp7->box(FL_ROUND_UP_BOX);
      revp7->color(FL_BACKGROUND_COLOR);
      revp7->selection_color(FL_INACTIVE_COLOR);
      revp7->labeltype(FL_NORMAL_LABEL);
      revp7->labelfont(1);
      revp7->labelsize(11);
      revp7->labelcolor(FL_FOREGROUND_COLOR);
      revp7->maximum(127);
      revp7->callback((Fl_Callback*)cb_revp7);
      revp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp7->when(FL_WHEN_CHANGED);
    } // WidgetPDial* revp7
    { revp8 = new WidgetPDial(305, 40, 30, 30, "HPF");
      revp8->tooltip("High Pass Filter");
      revp8->box(FL_ROUND_UP_BOX);
      revp8->color(FL_BACKGROUND_COLOR);
      revp8->selection_color(FL_INACTIVE_COLOR);
      revp8->labeltype(FL_NORMAL_LABEL);
      revp8->labelfont(1);
      revp8->labelsize(11);
      revp8->labelcolor(FL_FOREGROUND_COLOR);
      revp8->maximum(127);
      revp8->callback((Fl_Callback*)cb_revp8);
      revp8->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp8->when(FL_WHEN_CHANGED);
    } // WidgetPDial* revp8
    { revp9 = new WidgetPDial(340, 40, 30, 30, "Damp");
      revp9->tooltip("Dampening");
      revp9->box(FL_ROUND_UP_BOX);
      revp9->color(FL_BACKGROUND_COLOR);
      revp9->selection_color(FL_INACTIVE_COLOR);
      revp9->labeltype(FL_NORMAL_LABEL);
      revp9->labelfont(1);
      revp9->labelsize(11);
      revp9->labelcolor(FL_FOREGROUND_COLOR);
      revp9->minimum(64);
      revp9->maximum(127);
      revp9->step(1);
      revp9->callback((Fl_Callback*)cb_revp9);
      revp9->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp9->when(FL_WHEN_CHANGED);
    } // WidgetPDial* revp9
    { revp11 = new WidgetPDial(190, 10, 25, 25, "R.S.");
      revp11->tooltip("RoomSize");
      revp11->box(FL_ROUND_UP_BOX);
      revp11->color(FL_BACKGROUND_COLOR);
      revp11->selection_color(FL_INACTIVE_COLOR);
      revp11->labeltype(FL_NORMAL_LABEL);
      revp11->labelfont(1);
      revp11->labelsize(8);
      revp11->labelcolor(FL_FOREGROUND_COLOR);
      revp11->minimum(1);
      revp11->maximum(127);
      revp11->step(1);
      revp11->callback((Fl_Callback*)cb_revp11);
      revp11->align(Fl_Align(FL_ALIGN_RIGHT));
      revp11->when(FL_WHEN_CHANGED);
    } // WidgetPDial* revp11
    effreverbwindow->end();
  } // Fl_Group* effreverbwindow
  return effreverbwindow;
}

Fl_Group* EffUI::make_echo_window() {
  { effechowindow = new Fl_Group(0, 0, 380, 95);
    effechowindow->box(FL_PLASTIC_UP_BOX);
    effechowindow->color((Fl_Color)221);
    effechowindow->selection_color(FL_BACKGROUND_COLOR);
    effechowindow->labeltype(FL_NO_LABEL);
    effechowindow->labelfont(1);
    effechowindow->labelsize(14);
    effechowindow->labelcolor(FL_FOREGROUND_COLOR);
    effechowindow->user_data((void*)(this));
    effechowindow->align(Fl_Align(FL_ALIGN_TOP));
    effechowindow->when(FL_WHEN_RELEASE);
    { echop = new Fl_Choice(11, 15, 95, 15, "Preset");
      echop->down_box(FL_BORDER_BOX);
      echop->color((Fl_Color)14);
      echop->selection_color(FL_FOREGROUND_COLOR);
      echop->labelfont(1);
      echop->labelsize(10);
      echop->textfont(1);
      echop->textsize(10);
      echop->textcolor(FL_BACKGROUND2_COLOR);
      echop->callback((Fl_Callback*)cb_echop);
      echop->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      echop->menu(menu_echop);
    } // Fl_Choice* echop
    { Fl_Text_Display* o = new Fl_Text_Display(295, 10, 10, 20, "Echo");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { echop0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      echop0->tooltip("Effect Volume");
      echop0->box(FL_ROUND_UP_BOX);
      echop0->color(FL_BACKGROUND_COLOR);
      echop0->selection_color(FL_INACTIVE_COLOR);
      echop0->labeltype(FL_NORMAL_LABEL);
      echop0->labelfont(1);
      echop0->labelsize(11);
      echop0->labelcolor(FL_FOREGROUND_COLOR);
      echop0->maximum(127);
      echop0->callback((Fl_Callback*)cb_echop0);
      echop0->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* echop0
    { echop1 = new WidgetPDial(45, 40, 30, 30, "Pan");
      echop1->box(FL_ROUND_UP_BOX);
      echop1->color(FL_BACKGROUND_COLOR);
      echop1->selection_color(FL_INACTIVE_COLOR);
      echop1->labeltype(FL_NORMAL_LABEL);
      echop1->labelfont(1);
      echop1->labelsize(11);
      echop1->labelcolor(FL_FOREGROUND_COLOR);
      echop1->maximum(127);
      echop1->callback((Fl_Callback*)cb_echop1);
      echop1->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop1->when(FL_WHEN_CHANGED);
    } // WidgetPDial* echop1
    { echop2 = new WidgetPDial(80, 40, 30, 30, "Delay");
      echop2->box(FL_ROUND_UP_BOX);
      echop2->color(FL_BACKGROUND_COLOR);
      echop2->selection_color(FL_INACTIVE_COLOR);
      echop2->labeltype(FL_NORMAL_LABEL);
      echop2->labelfont(1);
      echop2->labelsize(11);
      echop2->labelcolor(FL_FOREGROUND_COLOR);
      echop2->maximum(127);
      echop2->callback((Fl_Callback*)cb_echop2);
      echop2->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop2->when(FL_WHEN_RELEASE);
    } // WidgetPDial* echop2
    { echop3 = new WidgetPDial(120, 40, 30, 30, "LRdl.");
      echop3->tooltip("Delay Between L/R");
      echop3->box(FL_ROUND_UP_BOX);
      echop3->color(FL_BACKGROUND_COLOR);
      echop3->selection_color(FL_INACTIVE_COLOR);
      echop3->labeltype(FL_NORMAL_LABEL);
      echop3->labelfont(1);
      echop3->labelsize(11);
      echop3->labelcolor(FL_FOREGROUND_COLOR);
      echop3->maximum(127);
      echop3->callback((Fl_Callback*)cb_echop3);
      echop3->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop3->when(FL_WHEN_RELEASE);
    } // WidgetPDial* echop3
    { echop4 = new WidgetPDial(155, 40, 30, 30, "LRc.");
      echop4->tooltip("L/R Crossover");
      echop4->box(FL_ROUND_UP_BOX);
      echop4->color(FL_BACKGROUND_COLOR);
      echop4->selection_color(FL_INACTIVE_COLOR);
      echop4->labeltype(FL_NORMAL_LABEL);
      echop4->labelfont(1);
      echop4->labelsize(11);
      echop4->labelcolor(FL_FOREGROUND_COLOR);
      echop4->maximum(127);
      echop4->callback((Fl_Callback*)cb_echop4);
      echop4->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop4->when(FL_WHEN_CHANGED);
    } // WidgetPDial* echop4
    { echop5 = new WidgetPDial(195, 40, 30, 30, "Fb.");
      echop5->tooltip("Feedback");
      echop5->box(FL_ROUND_UP_BOX);
      echop5->color(FL_BACKGROUND_COLOR);
      echop5->selection_color(FL_INACTIVE_COLOR);
      echop5->labeltype(FL_NORMAL_LABEL);
      echop5->labelfont(1);
      echop5->labelsize(11);
      echop5->labelcolor(FL_FOREGROUND_COLOR);
      echop5->maximum(127);
      echop5->callback((Fl_Callback*)cb_echop5);
      echop5->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop5->when(FL_WHEN_CHANGED);
    } // WidgetPDial* echop5
    { echop6 = new WidgetPDial(235, 40, 30, 30, "Damp");
      echop6->tooltip("Dampening");
      echop6->box(FL_ROUND_UP_BOX);
      echop6->color(FL_BACKGROUND_COLOR);
      echop6->selection_color(FL_INACTIVE_COLOR);
      echop6->labeltype(FL_NORMAL_LABEL);
      echop6->labelfont(1);
      echop6->labelsize(11);
      echop6->labelcolor(FL_FOREGROUND_COLOR);
      echop6->maximum(127);
      echop6->callback((Fl_Callback*)cb_echop6);
      echop6->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop6->when(FL_WHEN_CHANGED);
    } // WidgetPDial* echop6
    effechowindow->end();
  } // Fl_Group* effechowindow
  return effechowindow;
}

Fl_Group* EffUI::make_chorus_window() {
  { effchoruswindow = new Fl_Group(0, 0, 380, 95);
    effchoruswindow->box(FL_PLASTIC_UP_BOX);
    effchoruswindow->color((Fl_Color)221);
    effchoruswindow->selection_color(FL_BACKGROUND_COLOR);
    effchoruswindow->labeltype(FL_NO_LABEL);
    effchoruswindow->labelfont(1);
    effchoruswindow->labelsize(14);
    effchoruswindow->labelcolor(FL_FOREGROUND_COLOR);
    effchoruswindow->user_data((void*)(this));
    effchoruswindow->align(Fl_Align(FL_ALIGN_TOP));
    effchoruswindow->when(FL_WHEN_RELEASE);
    { chorusp = new Fl_Choice(10, 15, 90, 15, "Preset");
      chorusp->down_box(FL_BORDER_BOX);
      chorusp->color((Fl_Color)14);
      chorusp->selection_color(FL_FOREGROUND_COLOR);
      chorusp->labelfont(1);
      chorusp->labelsize(10);
      chorusp->textfont(1);
      chorusp->textsize(10);
      chorusp->textcolor(FL_BACKGROUND2_COLOR);
      chorusp->callback((Fl_Callback*)cb_chorusp);
      chorusp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      chorusp->menu(menu_chorusp);
    } // Fl_Choice* chorusp
    { Fl_Text_Display* o = new Fl_Text_Display(265, 10, 10, 20, "Chorus");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { chorusp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      chorusp0->box(FL_ROUND_UP_BOX);
      chorusp0->color(FL_BACKGROUND_COLOR);
      chorusp0->selection_color(FL_INACTIVE_COLOR);
      chorusp0->labeltype(FL_NORMAL_LABEL);
      chorusp0->labelfont(1);
      chorusp0->labelsize(11);
      chorusp0->labelcolor(FL_FOREGROUND_COLOR);
      chorusp0->maximum(127);
      chorusp0->callback((Fl_Callback*)cb_chorusp0);
      chorusp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp0
    { chorusp1 = new WidgetPDial(45, 40, 30, 30, "Pan");
      chorusp1->box(FL_ROUND_UP_BOX);
      chorusp1->color(FL_BACKGROUND_COLOR);
      chorusp1->selection_color(FL_INACTIVE_COLOR);
      chorusp1->labeltype(FL_NORMAL_LABEL);
      chorusp1->labelfont(1);
      chorusp1->labelsize(11);
      chorusp1->labelcolor(FL_FOREGROUND_COLOR);
      chorusp1->maximum(127);
      chorusp1->callback((Fl_Callback*)cb_chorusp1);
      chorusp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp1->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp1
    { chorusp2 = new WidgetPDial(85, 40, 30, 30, "Freq");
      chorusp2->tooltip("LFO Frequency");
      chorusp2->box(FL_ROUND_UP_BOX);
      chorusp2->color(FL_BACKGROUND_COLOR);
      chorusp2->selection_color(FL_INACTIVE_COLOR);
      chorusp2->labeltype(FL_NORMAL_LABEL);
      chorusp2->labelfont(1);
      chorusp2->labelsize(11);
      chorusp2->labelcolor(FL_FOREGROUND_COLOR);
      chorusp2->maximum(127);
      chorusp2->callback((Fl_Callback*)cb_chorusp2);
      chorusp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp2->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp2
    { chorusp3 = new WidgetPDial(120, 40, 30, 30, "Rnd");
      chorusp3->tooltip("LFO Randomness");
      chorusp3->box(FL_ROUND_UP_BOX);
      chorusp3->color(FL_BACKGROUND_COLOR);
      chorusp3->selection_color(FL_INACTIVE_COLOR);
      chorusp3->labeltype(FL_NORMAL_LABEL);
      chorusp3->labelfont(1);
      chorusp3->labelsize(11);
      chorusp3->labelcolor(FL_FOREGROUND_COLOR);
      chorusp3->maximum(127);
      chorusp3->callback((Fl_Callback*)cb_chorusp3);
      chorusp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp3->when(FL_WHEN_RELEASE);
    } // WidgetPDial* chorusp3
    { chorusp5 = new WidgetPDial(200, 40, 30, 30, "St.df");
      chorusp5->tooltip("L/R Phase Shift");
      chorusp5->box(FL_ROUND_UP_BOX);
      chorusp5->color(FL_BACKGROUND_COLOR);
      chorusp5->selection_color(FL_INACTIVE_COLOR);
      chorusp5->labeltype(FL_NORMAL_LABEL);
      chorusp5->labelfont(1);
      chorusp5->labelsize(11);
      chorusp5->labelcolor(FL_FOREGROUND_COLOR);
      chorusp5->maximum(127);
      chorusp5->callback((Fl_Callback*)cb_chorusp5);
      chorusp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp5->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp5
    { chorusp6 = new WidgetPDial(235, 40, 30, 30, "Dpth");
      chorusp6->tooltip("LFO Depth");
      chorusp6->box(FL_ROUND_UP_BOX);
      chorusp6->color(FL_BACKGROUND_COLOR);
      chorusp6->selection_color(FL_INACTIVE_COLOR);
      chorusp6->labeltype(FL_NORMAL_LABEL);
      chorusp6->labelfont(1);
      chorusp6->labelsize(11);
      chorusp6->labelcolor(FL_FOREGROUND_COLOR);
      chorusp6->maximum(127);
      chorusp6->callback((Fl_Callback*)cb_chorusp6);
      chorusp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp6->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp6
    { chorusp7 = new WidgetPDial(270, 40, 30, 30, "Delay");
      chorusp7->box(FL_ROUND_UP_BOX);
      chorusp7->color(FL_BACKGROUND_COLOR);
      chorusp7->selection_color(FL_INACTIVE_COLOR);
      chorusp7->labeltype(FL_NORMAL_LABEL);
      chorusp7->labelfont(1);
      chorusp7->labelsize(11);
      chorusp7->labelcolor(FL_FOREGROUND_COLOR);
      chorusp7->maximum(127);
      chorusp7->callback((Fl_Callback*)cb_chorusp7);
      chorusp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp7->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp7
    { chorusp8 = new WidgetPDial(305, 40, 30, 30, "Fb");
      chorusp8->tooltip("Feedback");
      chorusp8->box(FL_ROUND_UP_BOX);
      chorusp8->color(FL_BACKGROUND_COLOR);
      chorusp8->selection_color(FL_INACTIVE_COLOR);
      chorusp8->labeltype(FL_NORMAL_LABEL);
      chorusp8->labelfont(1);
      chorusp8->labelsize(11);
      chorusp8->labelcolor(FL_FOREGROUND_COLOR);
      chorusp8->maximum(127);
      chorusp8->callback((Fl_Callback*)cb_chorusp8);
      chorusp8->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp8->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp8
    { chorusp9 = new WidgetPDial(340, 40, 30, 30, "L/R");
      chorusp9->tooltip("Channel Routing");
      chorusp9->box(FL_ROUND_UP_BOX);
      chorusp9->color(FL_BACKGROUND_COLOR);
      chorusp9->selection_color(FL_INACTIVE_COLOR);
      chorusp9->labeltype(FL_NORMAL_LABEL);
      chorusp9->labelfont(1);
      chorusp9->labelsize(11);
      chorusp9->labelcolor(FL_FOREGROUND_COLOR);
      chorusp9->maximum(127);
      chorusp9->callback((Fl_Callback*)cb_chorusp9);
      chorusp9->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp9->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp9
    { Fl_Check_Button* o = new Fl_Check_Button(120, 10, 55, 20, "Flange");
      o->box(FL_THIN_UP_BOX);
      o->down_box(FL_DOWN_BOX);
      o->color((Fl_Color)230);
      o->labelfont(1);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Flange);
      o->hide();
      o->deactivate();
      o->value(eff->geteffectpar(10));
    } // Fl_Check_Button* o
    { chorusp11 = new Fl_Check_Button(185, 10, 70, 20, "Substract");
      chorusp11->tooltip("inverts the output");
      chorusp11->box(FL_THIN_UP_BOX);
      chorusp11->down_box(FL_DOWN_BOX);
      chorusp11->color((Fl_Color)230);
      chorusp11->labelfont(1);
      chorusp11->labelsize(10);
      chorusp11->callback((Fl_Callback*)cb_chorusp11);
    } // Fl_Check_Button* chorusp11
    { chorusp4 = new Fl_Choice(155, 50, 40, 15, "LFO type");
      chorusp4->tooltip("LFO function");
      chorusp4->down_box(FL_BORDER_BOX);
      chorusp4->labelfont(1);
      chorusp4->labelsize(10);
      chorusp4->textsize(8);
      chorusp4->callback((Fl_Callback*)cb_chorusp4);
      chorusp4->align(Fl_Align(130));
      chorusp4->menu(menu_chorusp4);
    } // Fl_Choice* chorusp4
    effchoruswindow->end();
  } // Fl_Group* effchoruswindow
  return effchoruswindow;
}

Fl_Group* EffUI::make_phaser_window() {
  { effphaserwindow = new Fl_Group(0, 0, 380, 95);
    effphaserwindow->box(FL_PLASTIC_UP_BOX);
    effphaserwindow->color((Fl_Color)221);
    effphaserwindow->selection_color(FL_BACKGROUND_COLOR);
    effphaserwindow->labeltype(FL_NO_LABEL);
    effphaserwindow->labelfont(1);
    effphaserwindow->labelsize(14);
    effphaserwindow->labelcolor(FL_FOREGROUND_COLOR);
    effphaserwindow->user_data((void*)(this));
    effphaserwindow->align(Fl_Align(FL_ALIGN_TOP));
    effphaserwindow->when(FL_WHEN_RELEASE);
    { phaserp = new Fl_Choice(10, 15, 90, 15, "Preset");
      phaserp->down_box(FL_BORDER_BOX);
      phaserp->color((Fl_Color)14);
      phaserp->selection_color(FL_FOREGROUND_COLOR);
      phaserp->labelfont(1);
      phaserp->labelsize(10);
      phaserp->textfont(1);
      phaserp->textsize(10);
      phaserp->textcolor(FL_BACKGROUND2_COLOR);
      phaserp->callback((Fl_Callback*)cb_phaserp);
      phaserp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      phaserp->menu(menu_phaserp);
    } // Fl_Choice* phaserp
    { Fl_Text_Display* o = new Fl_Text_Display(275, 10, 10, 20, "Phaser");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { phaserp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      phaserp0->tooltip("Effect Volume");
      phaserp0->box(FL_ROUND_UP_BOX);
      phaserp0->color(FL_BACKGROUND_COLOR);
      phaserp0->selection_color(FL_INACTIVE_COLOR);
      phaserp0->labeltype(FL_NORMAL_LABEL);
      phaserp0->labelfont(1);
      phaserp0->labelsize(11);
      phaserp0->labelcolor(FL_FOREGROUND_COLOR);
      phaserp0->maximum(127);
      phaserp0->callback((Fl_Callback*)cb_phaserp0);
      phaserp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp0
    { phaserp1 = new WidgetPDial(45, 40, 30, 30, "Pan");
      phaserp1->box(FL_ROUND_UP_BOX);
      phaserp1->color(FL_BACKGROUND_COLOR);
      phaserp1->selection_color(FL_INACTIVE_COLOR);
      phaserp1->labeltype(FL_NORMAL_LABEL);
      phaserp1->labelfont(1);
      phaserp1->labelsize(11);
      phaserp1->labelcolor(FL_FOREGROUND_COLOR);
      phaserp1->maximum(127);
      phaserp1->callback((Fl_Callback*)cb_phaserp1);
      phaserp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp1->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp1
    { phaserp2 = new WidgetPDial(85, 40, 30, 30, "Freq");
      phaserp2->tooltip("LFO frequency");
      phaserp2->box(FL_ROUND_UP_BOX);
      phaserp2->color(FL_BACKGROUND_COLOR);
      phaserp2->selection_color(FL_INACTIVE_COLOR);
      phaserp2->labeltype(FL_NORMAL_LABEL);
      phaserp2->labelfont(1);
      phaserp2->labelsize(11);
      phaserp2->labelcolor(FL_FOREGROUND_COLOR);
      phaserp2->maximum(127);
      phaserp2->callback((Fl_Callback*)cb_phaserp2);
      phaserp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp2->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp2
    { phaserp3 = new WidgetPDial(120, 40, 30, 30, "Rnd");
      phaserp3->tooltip("LFO randomness");
      phaserp3->box(FL_ROUND_UP_BOX);
      phaserp3->color(FL_BACKGROUND_COLOR);
      phaserp3->selection_color(FL_INACTIVE_COLOR);
      phaserp3->labeltype(FL_NORMAL_LABEL);
      phaserp3->labelfont(1);
      phaserp3->labelsize(11);
      phaserp3->labelcolor(FL_FOREGROUND_COLOR);
      phaserp3->maximum(127);
      phaserp3->callback((Fl_Callback*)cb_phaserp3);
      phaserp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp3->when(FL_WHEN_RELEASE);
    } // WidgetPDial* phaserp3
    { phaserp5 = new WidgetPDial(200, 40, 30, 30, "St.df");
      phaserp5->tooltip("Left/Right Channel Phase Shift");
      phaserp5->box(FL_ROUND_UP_BOX);
      phaserp5->color(FL_BACKGROUND_COLOR);
      phaserp5->selection_color(FL_INACTIVE_COLOR);
      phaserp5->labeltype(FL_NORMAL_LABEL);
      phaserp5->labelfont(1);
      phaserp5->labelsize(11);
      phaserp5->labelcolor(FL_FOREGROUND_COLOR);
      phaserp5->maximum(127);
      phaserp5->callback((Fl_Callback*)cb_phaserp5);
      phaserp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp5->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp5
    { phaserp6 = new WidgetPDial(235, 40, 30, 30, "Dpth");
      phaserp6->tooltip("LFO Depth");
      phaserp6->box(FL_ROUND_UP_BOX);
      phaserp6->color(FL_BACKGROUND_COLOR);
      phaserp6->selection_color(FL_INACTIVE_COLOR);
      phaserp6->labeltype(FL_NORMAL_LABEL);
      phaserp6->labelfont(1);
      phaserp6->labelsize(11);
      phaserp6->labelcolor(FL_FOREGROUND_COLOR);
      phaserp6->maximum(127);
      phaserp6->callback((Fl_Callback*)cb_phaserp6);
      phaserp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp6->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp6
    { phaserp7 = new WidgetPDial(270, 40, 30, 30, "Fb");
      phaserp7->tooltip("Feedback");
      phaserp7->box(FL_ROUND_UP_BOX);
      phaserp7->color(FL_BACKGROUND_COLOR);
      phaserp7->selection_color(FL_INACTIVE_COLOR);
      phaserp7->labeltype(FL_NORMAL_LABEL);
      phaserp7->labelfont(1);
      phaserp7->labelsize(11);
      phaserp7->labelcolor(FL_FOREGROUND_COLOR);
      phaserp7->maximum(127);
      phaserp7->callback((Fl_Callback*)cb_phaserp7);
      phaserp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp7->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp7
    { phaserp9 = new WidgetPDial(345, 40, 30, 30, "L/R");
      phaserp9->tooltip("Channel Routing");
      phaserp9->box(FL_ROUND_UP_BOX);
      phaserp9->color(FL_BACKGROUND_COLOR);
      phaserp9->selection_color(FL_INACTIVE_COLOR);
      phaserp9->labeltype(FL_NORMAL_LABEL);
      phaserp9->labelfont(1);
      phaserp9->labelsize(11);
      phaserp9->labelcolor(FL_FOREGROUND_COLOR);
      phaserp9->maximum(127);
      phaserp9->callback((Fl_Callback*)cb_phaserp9);
      phaserp9->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp9->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp9
    { phaserp10 = new Fl_Check_Button(185, 10, 74, 20, "Substract");
      phaserp10->tooltip("inverts output");
      phaserp10->box(FL_THIN_UP_BOX);
      phaserp10->down_box(FL_DOWN_BOX);
      phaserp10->color((Fl_Color)230);
      phaserp10->labelfont(1);
      phaserp10->labelsize(10);
      phaserp10->callback((Fl_Callback*)cb_phaserp10);
    } // Fl_Check_Button* phaserp10
    { phaserp4 = new Fl_Choice(155, 50, 40, 15, "LFO type");
      phaserp4->tooltip("LFO function");
      phaserp4->down_box(FL_BORDER_BOX);
      phaserp4->labelfont(1);
      phaserp4->labelsize(10);
      phaserp4->textsize(8);
      phaserp4->callback((Fl_Callback*)cb_phaserp4);
      phaserp4->align(Fl_Align(130));
      phaserp4->menu(menu_phaserp4);
    } // Fl_Choice* phaserp4
    { Fl_Counter* o = phaserp8 = new Fl_Counter(305, 55, 35, 15, "Stages");
      phaserp8->type(1);
      phaserp8->labelfont(1);
      phaserp8->labelsize(11);
      phaserp8->minimum(0);
      phaserp8->maximum(127);
      phaserp8->step(1);
      phaserp8->callback((Fl_Callback*)cb_phaserp8);
      o->range(1,MAX_PHASER_STAGES);
    } // Fl_Counter* phaserp8
    { phaserp11 = new WidgetPDial(155, 10, 25, 25, "Phase");
      phaserp11->box(FL_ROUND_UP_BOX);
      phaserp11->color(FL_BACKGROUND_COLOR);
      phaserp11->selection_color(FL_INACTIVE_COLOR);
      phaserp11->labeltype(FL_NORMAL_LABEL);
      phaserp11->labelfont(1);
      phaserp11->labelsize(10);
      phaserp11->labelcolor(FL_FOREGROUND_COLOR);
      phaserp11->maximum(127);
      phaserp11->callback((Fl_Callback*)cb_phaserp11);
      phaserp11->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp11->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp11
    effphaserwindow->end();
  } // Fl_Group* effphaserwindow
  return effphaserwindow;
}

Fl_Group* EffUI::make_alienwah_window() {
  { effalienwahwindow = new Fl_Group(0, 0, 380, 95);
    effalienwahwindow->box(FL_PLASTIC_UP_BOX);
    effalienwahwindow->color((Fl_Color)221);
    effalienwahwindow->selection_color(FL_BACKGROUND_COLOR);
    effalienwahwindow->labeltype(FL_NO_LABEL);
    effalienwahwindow->labelfont(1);
    effalienwahwindow->labelsize(14);
    effalienwahwindow->labelcolor(FL_FOREGROUND_COLOR);
    effalienwahwindow->user_data((void*)(this));
    effalienwahwindow->align(Fl_Align(FL_ALIGN_TOP));
    effalienwahwindow->when(FL_WHEN_RELEASE);
    { awp = new Fl_Choice(10, 15, 90, 15, "Preset");
      awp->down_box(FL_BORDER_BOX);
      awp->color((Fl_Color)14);
      awp->selection_color(FL_FOREGROUND_COLOR);
      awp->labelfont(1);
      awp->labelsize(10);
      awp->textfont(1);
      awp->textsize(10);
      awp->textcolor(FL_BACKGROUND2_COLOR);
      awp->callback((Fl_Callback*)cb_awp);
      awp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      awp->menu(menu_awp);
    } // Fl_Choice* awp
    { Fl_Text_Display* o = new Fl_Text_Display(245, 10, 10, 20, "AlienWah");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { awp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      awp0->tooltip("Effect Volume");
      awp0->box(FL_ROUND_UP_BOX);
      awp0->color(FL_BACKGROUND_COLOR);
      awp0->selection_color(FL_INACTIVE_COLOR);
      awp0->labeltype(FL_NORMAL_LABEL);
      awp0->labelfont(1);
      awp0->labelsize(11);
      awp0->labelcolor(FL_FOREGROUND_COLOR);
      awp0->maximum(127);
      awp0->callback((Fl_Callback*)cb_awp0);
      awp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp0
    { awp1 = new WidgetPDial(45, 40, 30, 30, "Pan");
      awp1->box(FL_ROUND_UP_BOX);
      awp1->color(FL_BACKGROUND_COLOR);
      awp1->selection_color(FL_INACTIVE_COLOR);
      awp1->labeltype(FL_NORMAL_LABEL);
      awp1->labelfont(1);
      awp1->labelsize(11);
      awp1->labelcolor(FL_FOREGROUND_COLOR);
      awp1->maximum(127);
      awp1->callback((Fl_Callback*)cb_awp1);
      awp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp1->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp1
    { awp2 = new WidgetPDial(85, 40, 30, 30, "Freq");
      awp2->tooltip("LFO Frequency");
      awp2->box(FL_ROUND_UP_BOX);
      awp2->color(FL_BACKGROUND_COLOR);
      awp2->selection_color(FL_INACTIVE_COLOR);
      awp2->labeltype(FL_NORMAL_LABEL);
      awp2->labelfont(1);
      awp2->labelsize(11);
      awp2->labelcolor(FL_FOREGROUND_COLOR);
      awp2->maximum(127);
      awp2->callback((Fl_Callback*)cb_awp2);
      awp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp2->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp2
    { awp3 = new WidgetPDial(120, 40, 30, 30, "Rnd");
      awp3->tooltip("LFO Randomness");
      awp3->box(FL_ROUND_UP_BOX);
      awp3->color(FL_BACKGROUND_COLOR);
      awp3->selection_color(FL_INACTIVE_COLOR);
      awp3->labeltype(FL_NORMAL_LABEL);
      awp3->labelfont(1);
      awp3->labelsize(11);
      awp3->labelcolor(FL_FOREGROUND_COLOR);
      awp3->maximum(127);
      awp3->callback((Fl_Callback*)cb_awp3);
      awp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp3->when(FL_WHEN_RELEASE);
    } // WidgetPDial* awp3
    { awp5 = new WidgetPDial(200, 40, 30, 30, "St.df");
      awp5->tooltip("Left/Right Channel Phase Shift");
      awp5->box(FL_ROUND_UP_BOX);
      awp5->color(FL_BACKGROUND_COLOR);
      awp5->selection_color(FL_INACTIVE_COLOR);
      awp5->labeltype(FL_NORMAL_LABEL);
      awp5->labelfont(1);
      awp5->labelsize(11);
      awp5->labelcolor(FL_FOREGROUND_COLOR);
      awp5->maximum(127);
      awp5->callback((Fl_Callback*)cb_awp5);
      awp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp5->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp5
    { awp6 = new WidgetPDial(235, 40, 30, 30, "Dpth");
      awp6->tooltip("Depth");
      awp6->box(FL_ROUND_UP_BOX);
      awp6->color(FL_BACKGROUND_COLOR);
      awp6->selection_color(FL_INACTIVE_COLOR);
      awp6->labeltype(FL_NORMAL_LABEL);
      awp6->labelfont(1);
      awp6->labelsize(11);
      awp6->labelcolor(FL_FOREGROUND_COLOR);
      awp6->maximum(127);
      awp6->callback((Fl_Callback*)cb_awp6);
      awp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp6->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp6
    { awp7 = new WidgetPDial(270, 40, 30, 30, "Fb");
      awp7->tooltip("Feedback");
      awp7->box(FL_ROUND_UP_BOX);
      awp7->color(FL_BACKGROUND_COLOR);
      awp7->selection_color(FL_INACTIVE_COLOR);
      awp7->labeltype(FL_NORMAL_LABEL);
      awp7->labelfont(1);
      awp7->labelsize(11);
      awp7->labelcolor(FL_FOREGROUND_COLOR);
      awp7->maximum(127);
      awp7->callback((Fl_Callback*)cb_awp7);
      awp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp7->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp7
    { awp9 = new WidgetPDial(345, 40, 30, 30, "L/R");
      awp9->box(FL_ROUND_UP_BOX);
      awp9->color(FL_BACKGROUND_COLOR);
      awp9->selection_color(FL_INACTIVE_COLOR);
      awp9->labeltype(FL_NORMAL_LABEL);
      awp9->labelfont(1);
      awp9->labelsize(11);
      awp9->labelcolor(FL_FOREGROUND_COLOR);
      awp9->maximum(127);
      awp9->callback((Fl_Callback*)cb_awp9);
      awp9->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp9->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp9
    { awp4 = new Fl_Choice(155, 50, 40, 15, "LFO type");
      awp4->tooltip("LFO function");
      awp4->down_box(FL_BORDER_BOX);
      awp4->labelfont(1);
      awp4->labelsize(10);
      awp4->textsize(8);
      awp4->callback((Fl_Callback*)cb_awp4);
      awp4->align(Fl_Align(130));
      awp4->menu(menu_awp4);
    } // Fl_Choice* awp4
    { awp10 = new WidgetPDial(160, 5, 30, 30, "Phase");
      awp10->box(FL_ROUND_UP_BOX);
      awp10->color(FL_BACKGROUND_COLOR);
      awp10->selection_color(FL_INACTIVE_COLOR);
      awp10->labeltype(FL_NORMAL_LABEL);
      awp10->labelfont(1);
      awp10->labelsize(11);
      awp10->labelcolor(FL_FOREGROUND_COLOR);
      awp10->maximum(127);
      awp10->callback((Fl_Callback*)cb_awp10);
      awp10->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp10->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp10
    { Fl_Counter* o = awp8 = new Fl_Counter(305, 55, 35, 15, "Delay");
      awp8->type(1);
      awp8->labelfont(1);
      awp8->labelsize(11);
      awp8->minimum(0);
      awp8->maximum(127);
      awp8->step(1);
      awp8->callback((Fl_Callback*)cb_awp8);
      o->range(1,MAX_ALIENWAH_DELAY);
    } // Fl_Counter* awp8
    effalienwahwindow->end();
  } // Fl_Group* effalienwahwindow
  return effalienwahwindow;
}

Fl_Group* EffUI::make_distorsion_window() {
  { effdistorsionwindow = new Fl_Group(0, 0, 380, 95);
    effdistorsionwindow->box(FL_PLASTIC_UP_BOX);
    effdistorsionwindow->color((Fl_Color)221);
    effdistorsionwindow->selection_color(FL_BACKGROUND_COLOR);
    effdistorsionwindow->labeltype(FL_NO_LABEL);
    effdistorsionwindow->labelfont(1);
    effdistorsionwindow->labelsize(14);
    effdistorsionwindow->labelcolor(FL_FOREGROUND_COLOR);
    effdistorsionwindow->user_data((void*)(this));
    effdistorsionwindow->align(Fl_Align(FL_ALIGN_TOP));
    effdistorsionwindow->when(FL_WHEN_RELEASE);
    { distp = new Fl_Choice(11, 15, 95, 15, "Preset");
      distp->down_box(FL_BORDER_BOX);
      distp->color((Fl_Color)14);
      distp->selection_color(FL_FOREGROUND_COLOR);
      distp->labelfont(1);
      distp->labelsize(10);
      distp->textfont(1);
      distp->textsize(10);
      distp->textcolor(FL_BACKGROUND2_COLOR);
      distp->callback((Fl_Callback*)cb_distp);
      distp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      distp->menu(menu_distp);
    } // Fl_Choice* distp
    { Fl_Text_Display* o = new Fl_Text_Display(230, 10, 10, 20, "Distortion");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { distp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      distp0->tooltip("Effect Volume");
      distp0->box(FL_ROUND_UP_BOX);
      distp0->color(FL_BACKGROUND_COLOR);
      distp0->selection_color(FL_INACTIVE_COLOR);
      distp0->labeltype(FL_NORMAL_LABEL);
      distp0->labelfont(1);
      distp0->labelsize(11);
      distp0->labelcolor(FL_FOREGROUND_COLOR);
      distp0->maximum(127);
      distp0->callback((Fl_Callback*)cb_distp0);
      distp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* distp0
    { distp1 = new WidgetPDial(45, 40, 30, 30, "Pan");
      distp1->box(FL_ROUND_UP_BOX);
      distp1->color(FL_BACKGROUND_COLOR);
      distp1->selection_color(FL_INACTIVE_COLOR);
      distp1->labeltype(FL_NORMAL_LABEL);
      distp1->labelfont(1);
      distp1->labelsize(11);
      distp1->labelcolor(FL_FOREGROUND_COLOR);
      distp1->maximum(127);
      distp1->callback((Fl_Callback*)cb_distp1);
      distp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp1->when(FL_WHEN_CHANGED);
    } // WidgetPDial* distp1
    { distp2 = new WidgetPDial(80, 40, 30, 30, "LRc.");
      distp2->tooltip("L/R Mix");
      distp2->box(FL_ROUND_UP_BOX);
      distp2->color(FL_BACKGROUND_COLOR);
      distp2->selection_color(FL_INACTIVE_COLOR);
      distp2->labeltype(FL_NORMAL_LABEL);
      distp2->labelfont(1);
      distp2->labelsize(11);
      distp2->labelcolor(FL_FOREGROUND_COLOR);
      distp2->maximum(127);
      distp2->callback((Fl_Callback*)cb_distp2);
      distp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp2->when(FL_WHEN_RELEASE);
    } // WidgetPDial* distp2
    { distp3 = new WidgetPDial(120, 40, 30, 30, "Drive");
      distp3->tooltip("Input Amplification");
      distp3->box(FL_ROUND_UP_BOX);
      distp3->color(FL_BACKGROUND_COLOR);
      distp3->selection_color(FL_INACTIVE_COLOR);
      distp3->labeltype(FL_NORMAL_LABEL);
      distp3->labelfont(1);
      distp3->labelsize(11);
      distp3->labelcolor(FL_FOREGROUND_COLOR);
      distp3->maximum(127);
      distp3->callback((Fl_Callback*)cb_distp3);
      distp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp3->when(FL_WHEN_RELEASE);
    } // WidgetPDial* distp3
    { distp4 = new WidgetPDial(155, 40, 30, 30, "Level");
      distp4->tooltip("Output Amplification");
      distp4->box(FL_ROUND_UP_BOX);
      distp4->color(FL_BACKGROUND_COLOR);
      distp4->selection_color(FL_INACTIVE_COLOR);
      distp4->labeltype(FL_NORMAL_LABEL);
      distp4->labelfont(1);
      distp4->labelsize(11);
      distp4->labelcolor(FL_FOREGROUND_COLOR);
      distp4->maximum(127);
      distp4->callback((Fl_Callback*)cb_distp4);
      distp4->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp4->when(FL_WHEN_CHANGED);
    } // WidgetPDial* distp4
    { distp7 = new WidgetPDial(285, 40, 30, 30, "LPF");
      distp7->tooltip("Low Pass Filter");
      distp7->box(FL_ROUND_UP_BOX);
      distp7->color(FL_BACKGROUND_COLOR);
      distp7->selection_color(FL_INACTIVE_COLOR);
      distp7->labeltype(FL_NORMAL_LABEL);
      distp7->labelfont(1);
      distp7->labelsize(11);
      distp7->labelcolor(FL_FOREGROUND_COLOR);
      distp7->maximum(127);
      distp7->callback((Fl_Callback*)cb_distp7);
      distp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp7->when(FL_WHEN_CHANGED);
    } // WidgetPDial* distp7
    { distp8 = new WidgetPDial(320, 40, 30, 30, "HPF");
      distp8->tooltip("High Pass Filter");
      distp8->box(FL_ROUND_UP_BOX);
      distp8->color(FL_BACKGROUND_COLOR);
      distp8->selection_color(FL_INACTIVE_COLOR);
      distp8->labeltype(FL_NORMAL_LABEL);
      distp8->labelfont(1);
      distp8->labelsize(11);
      distp8->labelcolor(FL_FOREGROUND_COLOR);
      distp8->maximum(127);
      distp8->callback((Fl_Callback*)cb_distp8);
      distp8->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp8->when(FL_WHEN_CHANGED);
    } // WidgetPDial* distp8
    { distp5 = new Fl_Choice(190, 50, 60, 20, "Type");
      distp5->box(FL_UP_BOX);
      distp5->down_box(FL_BORDER_BOX);
      distp5->labelfont(1);
      distp5->labelsize(11);
      distp5->textsize(10);
      distp5->callback((Fl_Callback*)cb_distp5);
      distp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp5->menu(menu_distp5);
    } // Fl_Choice* distp5
    { distp6 = new Fl_Check_Button(260, 55, 15, 15, "Neg.");
      distp6->down_box(FL_DOWN_BOX);
      distp6->labelfont(1);
      distp6->labelsize(11);
      distp6->callback((Fl_Callback*)cb_distp6);
      distp6->align(Fl_Align(FL_ALIGN_BOTTOM));
    } // Fl_Check_Button* distp6
    { distp9 = new Fl_Check_Button(355, 60, 15, 15, "St.");
      distp9->tooltip("Stereo");
      distp9->down_box(FL_DOWN_BOX);
      distp9->labelfont(1);
      distp9->labelsize(11);
      distp9->callback((Fl_Callback*)cb_distp9);
      distp9->align(Fl_Align(FL_ALIGN_BOTTOM));
    } // Fl_Check_Button* distp9
    { distp10 = new Fl_Check_Button(355, 44, 15, 15, "PF");
      distp10->tooltip("Applies the filters(before or after) the distorsion");
      distp10->down_box(FL_DOWN_BOX);
      distp10->labelfont(1);
      distp10->labelsize(11);
      distp10->callback((Fl_Callback*)cb_distp10);
      distp10->align(Fl_Align(FL_ALIGN_TOP));
    } // Fl_Check_Button* distp10
    effdistorsionwindow->end();
  } // Fl_Group* effdistorsionwindow
  return effdistorsionwindow;
}

Fl_Group* EffUI::make_eq_window() {
  { effeqwindow = new Fl_Group(0, 0, 380, 95);
    effeqwindow->box(FL_PLASTIC_UP_BOX);
    effeqwindow->color((Fl_Color)221);
    effeqwindow->selection_color(FL_BACKGROUND_COLOR);
    effeqwindow->labeltype(FL_NO_LABEL);
    effeqwindow->labelfont(1);
    effeqwindow->labelsize(14);
    effeqwindow->labelcolor(FL_FOREGROUND_COLOR);
    effeqwindow->user_data((void*)(this));
    effeqwindow->align(Fl_Align(FL_ALIGN_TOP));
    effeqwindow->when(FL_WHEN_RELEASE);
    { Fl_Text_Display* o = new Fl_Text_Display(320, 10, 15, 20, "EQ");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { eqp0 = new WidgetPDial(10, 35, 30, 30, "Gain");
      eqp0->box(FL_ROUND_UP_BOX);
      eqp0->color(FL_BACKGROUND_COLOR);
      eqp0->selection_color(FL_INACTIVE_COLOR);
      eqp0->labeltype(FL_NORMAL_LABEL);
      eqp0->labelfont(1);
      eqp0->labelsize(11);
      eqp0->labelcolor(FL_FOREGROUND_COLOR);
      eqp0->maximum(127);
      eqp0->callback((Fl_Callback*)cb_eqp0);
      eqp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      eqp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* eqp0
    { Fl_Counter* o = bandcounter = new Fl_Counter(240, 20, 45, 15, "B.");
      bandcounter->tooltip("Band no.");
      bandcounter->type(1);
      bandcounter->labelfont(1);
      bandcounter->labelsize(11);
      bandcounter->minimum(0);
      bandcounter->maximum(1);
      bandcounter->step(1);
      bandcounter->textfont(1);
      bandcounter->textsize(11);
      bandcounter->callback((Fl_Callback*)cb_bandcounter);
      bandcounter->align(Fl_Align(FL_ALIGN_TOP));
      o->bounds(0,MAX_EQ_BANDS-1);
    } // Fl_Counter* bandcounter
    { Fl_Group* o = bandgroup = new Fl_Group(245, 40, 130, 50);
      bandgroup->box(FL_ENGRAVED_FRAME);
      { freqdial = new WidgetPDial(250, 50, 25, 25, "Freq");
        freqdial->box(FL_ROUND_UP_BOX);
        freqdial->color(FL_BACKGROUND_COLOR);
        freqdial->selection_color(FL_INACTIVE_COLOR);
        freqdial->labeltype(FL_NORMAL_LABEL);
        freqdial->labelfont(1);
        freqdial->labelsize(10);
        freqdial->labelcolor(FL_FOREGROUND_COLOR);
        freqdial->maximum(127);
        freqdial->callback((Fl_Callback*)cb_freqdial);
        freqdial->align(Fl_Align(FL_ALIGN_BOTTOM));
        freqdial->when(3);
      } // WidgetPDial* freqdial
      { gaindial = new WidgetPDial(280, 50, 25, 25, "Gain");
        gaindial->box(FL_ROUND_UP_BOX);
        gaindial->color(FL_BACKGROUND_COLOR);
        gaindial->selection_color(FL_INACTIVE_COLOR);
        gaindial->labeltype(FL_NORMAL_LABEL);
        gaindial->labelfont(1);
        gaindial->labelsize(10);
        gaindial->labelcolor(FL_FOREGROUND_COLOR);
        gaindial->maximum(127);
        gaindial->step(1);
        gaindial->callback((Fl_Callback*)cb_gaindial);
        gaindial->align(Fl_Align(FL_ALIGN_BOTTOM));
        gaindial->when(3);
      } // WidgetPDial* gaindial
      { qdial = new WidgetPDial(310, 50, 25, 25, "Q");
        qdial->tooltip("Resonance/Bandwidth");
        qdial->box(FL_ROUND_UP_BOX);
        qdial->color(FL_BACKGROUND_COLOR);
        qdial->selection_color(FL_INACTIVE_COLOR);
        qdial->labeltype(FL_NORMAL_LABEL);
        qdial->labelfont(1);
        qdial->labelsize(10);
        qdial->labelcolor(FL_FOREGROUND_COLOR);
        qdial->maximum(127);
        qdial->callback((Fl_Callback*)cb_qdial);
        qdial->align(Fl_Align(FL_ALIGN_BOTTOM));
        qdial->when(3);
      } // WidgetPDial* qdial
      { Fl_Counter* o = stagescounter = new Fl_Counter(340, 60, 30, 15, "St.");
        stagescounter->tooltip("Additional filter stages");
        stagescounter->type(1);
        stagescounter->labelfont(1);
        stagescounter->labelsize(10);
        stagescounter->minimum(1);
        stagescounter->maximum(127);
        stagescounter->step(1);
        stagescounter->textfont(1);
        stagescounter->textsize(11);
        stagescounter->callback((Fl_Callback*)cb_stagescounter);
        o->bounds(0,MAX_FILTER_STAGES-1);
      } // Fl_Counter* stagescounter
      if (eff->geteffectpar(10)==0) o->deactivate();
      bandgroup->end();
    } // Fl_Group* bandgroup
    { typechoice = new Fl_Choice(290, 20, 40, 15, "T.");
      typechoice->tooltip("Type");
      typechoice->down_box(FL_BORDER_BOX);
      typechoice->labelfont(1);
      typechoice->labelsize(10);
      typechoice->textsize(10);
      typechoice->callback((Fl_Callback*)cb_typechoice);
      typechoice->align(Fl_Align(FL_ALIGN_TOP));
      typechoice->when(FL_WHEN_RELEASE_ALWAYS);
      typechoice->menu(menu_typechoice);
    } // Fl_Choice* typechoice
    { EQGraph* o = eqgraph = new EQGraph(45, 10, 190, 75);
      eqgraph->box(FL_BORDER_BOX);
      eqgraph->color((Fl_Color)178);
      eqgraph->selection_color(FL_BACKGROUND_COLOR);
      eqgraph->labeltype(FL_NORMAL_LABEL);
      eqgraph->labelfont(0);
      eqgraph->labelsize(14);
      eqgraph->labelcolor(FL_FOREGROUND_COLOR);
      eqgraph->align(Fl_Align(FL_ALIGN_CENTER));
      eqgraph->when(FL_WHEN_RELEASE);
      o->init(eff);
    } // EQGraph* eqgraph
    effeqwindow->end();
  } // Fl_Group* effeqwindow
  return effeqwindow;
}

Fl_Group* EffUI::make_dynamicfilter_window() {
  { effdynamicfilterwindow = new Fl_Group(0, 0, 380, 95);
    effdynamicfilterwindow->box(FL_PLASTIC_UP_BOX);
    effdynamicfilterwindow->color((Fl_Color)221);
    effdynamicfilterwindow->selection_color(FL_BACKGROUND_COLOR);
    effdynamicfilterwindow->labeltype(FL_NO_LABEL);
    effdynamicfilterwindow->labelfont(1);
    effdynamicfilterwindow->labelsize(14);
    effdynamicfilterwindow->labelcolor(FL_FOREGROUND_COLOR);
    effdynamicfilterwindow->user_data((void*)(this));
    effdynamicfilterwindow->align(Fl_Align(FL_ALIGN_TOP));
    effdynamicfilterwindow->when(FL_WHEN_RELEASE);
    { dfp = new Fl_Choice(10, 15, 90, 15, "Preset");
      dfp->down_box(FL_BORDER_BOX);
      dfp->color((Fl_Color)14);
      dfp->selection_color(FL_FOREGROUND_COLOR);
      dfp->labelfont(1);
      dfp->labelsize(10);
      dfp->textfont(1);
      dfp->textsize(10);
      dfp->textcolor(FL_BACKGROUND2_COLOR);
      dfp->callback((Fl_Callback*)cb_dfp);
      dfp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      dfp->menu(menu_dfp);
    } // Fl_Choice* dfp
    { Fl_Text_Display* o = new Fl_Text_Display(245, 10, 10, 20, "DynFilter");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { dfp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      dfp0->tooltip("Effect Volume");
      dfp0->box(FL_ROUND_UP_BOX);
      dfp0->color(FL_BACKGROUND_COLOR);
      dfp0->selection_color(FL_INACTIVE_COLOR);
      dfp0->labeltype(FL_NORMAL_LABEL);
      dfp0->labelfont(1);
      dfp0->labelsize(11);
      dfp0->labelcolor(FL_FOREGROUND_COLOR);
      dfp0->maximum(127);
      dfp0->callback((Fl_Callback*)cb_dfp0);
      dfp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp0
    { dfp1 = new WidgetPDial(45, 40, 30, 30, "Pan");
      dfp1->box(FL_ROUND_UP_BOX);
      dfp1->color(FL_BACKGROUND_COLOR);
      dfp1->selection_color(FL_INACTIVE_COLOR);
      dfp1->labeltype(FL_NORMAL_LABEL);
      dfp1->labelfont(1);
      dfp1->labelsize(11);
      dfp1->labelcolor(FL_FOREGROUND_COLOR);
      dfp1->maximum(127);
      dfp1->callback((Fl_Callback*)cb_dfp1);
      dfp1->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp1->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp1
    { dfp2 = new WidgetPDial(85, 40, 30, 30, "Freq");
      dfp2->tooltip("LFO Frequency");
      dfp2->box(FL_ROUND_UP_BOX);
      dfp2->color(FL_BACKGROUND_COLOR);
      dfp2->selection_color(FL_INACTIVE_COLOR);
      dfp2->labeltype(FL_NORMAL_LABEL);
      dfp2->labelfont(1);
      dfp2->labelsize(11);
      dfp2->labelcolor(FL_FOREGROUND_COLOR);
      dfp2->maximum(127);
      dfp2->callback((Fl_Callback*)cb_dfp2);
      dfp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp2->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp2
    { dfp3 = new WidgetPDial(120, 40, 30, 30, "Rnd");
      dfp3->tooltip("LFO Randomness");
      dfp3->box(FL_ROUND_UP_BOX);
      dfp3->color(FL_BACKGROUND_COLOR);
      dfp3->selection_color(FL_INACTIVE_COLOR);
      dfp3->labeltype(FL_NORMAL_LABEL);
      dfp3->labelfont(1);
      dfp3->labelsize(11);
      dfp3->labelcolor(FL_FOREGROUND_COLOR);
      dfp3->maximum(127);
      dfp3->callback((Fl_Callback*)cb_dfp3);
      dfp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp3->when(FL_WHEN_RELEASE);
    } // WidgetPDial* dfp3
    { dfp5 = new WidgetPDial(200, 40, 30, 30, "St.df");
      dfp5->tooltip("Left/Right Channel Phase Shift");
      dfp5->box(FL_ROUND_UP_BOX);
      dfp5->color(FL_BACKGROUND_COLOR);
      dfp5->selection_color(FL_INACTIVE_COLOR);
      dfp5->labeltype(FL_NORMAL_LABEL);
      dfp5->labelfont(1);
      dfp5->labelsize(11);
      dfp5->labelcolor(FL_FOREGROUND_COLOR);
      dfp5->maximum(127);
      dfp5->callback((Fl_Callback*)cb_dfp5);
      dfp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp5->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp5
    { dfp6 = new WidgetPDial(235, 40, 30, 30, "LfoD");
      dfp6->tooltip("LFO Depth");
      dfp6->box(FL_ROUND_UP_BOX);
      dfp6->color(FL_BACKGROUND_COLOR);
      dfp6->selection_color(FL_INACTIVE_COLOR);
      dfp6->labeltype(FL_NORMAL_LABEL);
      dfp6->labelfont(1);
      dfp6->labelsize(11);
      dfp6->labelcolor(FL_FOREGROUND_COLOR);
      dfp6->maximum(127);
      dfp6->callback((Fl_Callback*)cb_dfp6);
      dfp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp6->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp6
    { dfp4 = new Fl_Choice(155, 50, 40, 15, "LFO type");
      dfp4->tooltip("LFO function");
      dfp4->down_box(FL_BORDER_BOX);
      dfp4->labelfont(1);
      dfp4->labelsize(10);
      dfp4->textsize(8);
      dfp4->callback((Fl_Callback*)cb_dfp4);
      dfp4->align(Fl_Align(130));
      dfp4->menu(menu_dfp4);
    } // Fl_Choice* dfp4
    { Fl_Button* o = new Fl_Button(115, 10, 55, 25, "Filter");
      o->box(FL_PLASTIC_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Filter);
    } // Fl_Button* o
    { Fl_Group* o = new Fl_Group(270, 40, 105, 45);
      o->box(FL_BORDER_BOX);
      o->color((Fl_Color)181);
      { dfp7 = new WidgetPDial(275, 45, 25, 25, "A.S.");
        dfp7->tooltip("Filter vs Amplitude");
        dfp7->box(FL_ROUND_UP_BOX);
        dfp7->color(FL_BACKGROUND_COLOR);
        dfp7->selection_color(FL_INACTIVE_COLOR);
        dfp7->labeltype(FL_NORMAL_LABEL);
        dfp7->labelfont(1);
        dfp7->labelsize(11);
        dfp7->labelcolor(FL_FOREGROUND_COLOR);
        dfp7->maximum(127);
        dfp7->callback((Fl_Callback*)cb_dfp7);
        dfp7->align(Fl_Align(FL_ALIGN_BOTTOM));
        dfp7->when(FL_WHEN_CHANGED);
      } // WidgetPDial* dfp7
      { dfp9 = new WidgetPDial(305, 45, 25, 25, "A.M");
        dfp9->tooltip("rate that  amplitude changes the filter");
        dfp9->box(FL_ROUND_UP_BOX);
        dfp9->color(FL_BACKGROUND_COLOR);
        dfp9->selection_color(FL_INACTIVE_COLOR);
        dfp9->labeltype(FL_NORMAL_LABEL);
        dfp9->labelfont(1);
        dfp9->labelsize(11);
        dfp9->labelcolor(FL_FOREGROUND_COLOR);
        dfp9->maximum(127);
        dfp9->callback((Fl_Callback*)cb_dfp9);
        dfp9->align(Fl_Align(FL_ALIGN_BOTTOM));
        dfp9->when(FL_WHEN_CHANGED);
      } // WidgetPDial* dfp9
      { dfp8 = new Fl_Check_Button(345, 55, 15, 15, "A.Inv.");
        dfp8->tooltip("enable for filter frequency to lower with higher input amplitude");
        dfp8->down_box(FL_DOWN_BOX);
        dfp8->labelfont(1);
        dfp8->labelsize(11);
        dfp8->callback((Fl_Callback*)cb_dfp8);
        dfp8->align(Fl_Align(FL_ALIGN_BOTTOM));
      } // Fl_Check_Button* dfp8
      o->end();
    } // Fl_Group* o
    effdynamicfilterwindow->end();
  } // Fl_Group* effdynamicfilterwindow
  return effdynamicfilterwindow;
}

Fl_Double_Window* EffUI::make_filter_window() {
  { filterwindow = new Fl_Double_Window(290, 110, "Filter Parameters for DynFilter Eff.");
    filterwindow->user_data((void*)(this));
    { FilterUI* o = new FilterUI(5, 5, 275, 75, "DynFilter effect  - Filter");
      o->box(FL_FLAT_BOX);
      o->color(FL_LIGHT1);
      o->selection_color(FL_BACKGROUND_COLOR);
      o->labeltype(FL_NORMAL_LABEL);
      o->labelfont(0);
      o->labelsize(14);
      o->labelcolor(FL_FOREGROUND_COLOR);
      o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
      o->when(FL_WHEN_RELEASE);
      o->init(eff->filterpars,NULL,NULL);
      o->use_for_dynamic_filter();
      o->end();
    } // FilterUI* o
    { Fl_Button* o = new Fl_Button(105, 85, 70, 20, "Close");
      o->box(FL_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Close);
    } // Fl_Button* o
    filterwindow->end();
  } // Fl_Double_Window* filterwindow
  return filterwindow;
}

void EffUI::init(EffectMgr *eff_) {
  eff=eff_;

make_null_window();
make_reverb_window();
make_echo_window();
make_chorus_window();
make_phaser_window();
make_alienwah_window();
make_distorsion_window();
make_eq_window();
make_dynamicfilter_window();

int px=this->parent()->x();
int py=this->parent()->y();

effnullwindow->position(px,py);
effreverbwindow->position(px,py);
effechowindow->position(px,py);
effchoruswindow->position(px,py);
effphaserwindow->position(px,py);
effalienwahwindow->position(px,py);
effdistorsionwindow->position(px,py);
effeqwindow->position(px,py);
effdynamicfilterwindow->position(px,py);

refresh(eff);
}

void EffUI::refresh(EffectMgr *eff_) {
  eff=eff_;
this->hide();

effnullwindow->hide();
effreverbwindow->hide();
effechowindow->hide();
effchoruswindow->hide();
effphaserwindow->hide();
effalienwahwindow->hide();
effdistorsionwindow->hide();
effeqwindow->hide();
effdynamicfilterwindow->hide();

eqband=0;

if (filterwindow!=NULL){
	filterwindow->hide();
	delete(filterwindow);
	filterwindow=NULL;
};

switch(eff->geteffect()){
     case 1:
	revp->value(eff->getpreset());
	revp0->value(eff->geteffectpar(0));if (eff->insertion!=0) revp0->label("D/W");
	revp1->value(eff->geteffectpar(1));
	revp2->value(eff->geteffectpar(2));
	revp3->value(eff->geteffectpar(3));
	revp4->value(eff->geteffectpar(4));
	revp5->value(eff->geteffectpar(5));
	revp6->value(eff->geteffectpar(6));
	revp7->value(eff->geteffectpar(7));
	revp8->value(eff->geteffectpar(8));
	revp9->value(eff->geteffectpar(9));
	revp10->value(eff->geteffectpar(10));
	revp11->value(eff->geteffectpar(11));
            
        effreverbwindow->show();
        break; 
     case 2:
	echop->value(eff->getpreset());
	echop0->value(eff->geteffectpar(0));if (eff->insertion!=0) echop0->label("D/W");
	echop1->value(eff->geteffectpar(1));
	echop2->value(eff->geteffectpar(2));
	echop3->value(eff->geteffectpar(3));
	echop4->value(eff->geteffectpar(4));
	echop5->value(eff->geteffectpar(5));
	echop6->value(eff->geteffectpar(6));
	effechowindow->show();
        break; 
     case 3:
	chorusp->value(eff->getpreset());
	chorusp0->value(eff->geteffectpar(0));if (eff->insertion!=0) chorusp0->label("D/W");
	chorusp1->value(eff->geteffectpar(1));
	chorusp2->value(eff->geteffectpar(2));
	chorusp3->value(eff->geteffectpar(3));
	chorusp4->value(eff->geteffectpar(4));
	chorusp5->value(eff->geteffectpar(5));
	chorusp6->value(eff->geteffectpar(6));
	chorusp7->value(eff->geteffectpar(7));
	chorusp8->value(eff->geteffectpar(8));
	chorusp9->value(eff->geteffectpar(9));
	chorusp11->value(eff->geteffectpar(11));
	effchoruswindow->show();
        break; 
     case 4:
	phaserp->value(eff->getpreset());
	phaserp0->value(eff->geteffectpar(0));if (eff->insertion!=0) phaserp0->label("D/W");
	phaserp1->value(eff->geteffectpar(1));
	phaserp2->value(eff->geteffectpar(2));
	phaserp3->value(eff->geteffectpar(3));
	phaserp4->value(eff->geteffectpar(4));
	phaserp5->value(eff->geteffectpar(5));
	phaserp6->value(eff->geteffectpar(6));
	phaserp7->value(eff->geteffectpar(7));
	phaserp8->value(eff->geteffectpar(8));
	phaserp9->value(eff->geteffectpar(9));
	phaserp10->value(eff->geteffectpar(10));
	phaserp11->value(eff->geteffectpar(11));
	effphaserwindow->show();
        break; 
     case 5:
	awp->value(eff->getpreset());
	awp0->value(eff->geteffectpar(0));if (eff->insertion!=0) awp0->label("D/W");
	awp1->value(eff->geteffectpar(1));
	awp2->value(eff->geteffectpar(2));
	awp3->value(eff->geteffectpar(3));
	awp4->value(eff->geteffectpar(4));
	awp5->value(eff->geteffectpar(5));
	awp6->value(eff->geteffectpar(6));
	awp7->value(eff->geteffectpar(7));
	awp8->value(eff->geteffectpar(8));
	awp9->value(eff->geteffectpar(9));
	awp10->value(eff->geteffectpar(10));

	effalienwahwindow->show();
        break; 
     case 6:
	distp->value(eff->getpreset());
	distp0->value(eff->geteffectpar(0));if (eff->insertion!=0) distp0->label("D/W");
	distp1->value(eff->geteffectpar(1));
	distp2->value(eff->geteffectpar(2));
	distp3->value(eff->geteffectpar(3));
	distp4->value(eff->geteffectpar(4));
	distp5->value(eff->geteffectpar(5));
	distp6->value(eff->geteffectpar(6));
	distp7->value(eff->geteffectpar(7));
	distp8->value(eff->geteffectpar(8));
	distp9->value(eff->geteffectpar(9));
	distp10->value(eff->geteffectpar(10));
	effdistorsionwindow->show();
        break;
     case 7:eqband=0;
	eqp0->value(eff->geteffectpar(0));
	bandcounter->value(eqband);
	bandcounter->do_callback();
	typechoice->value(eff->geteffectpar(10));
	eqgraph->redraw();
	freqdial->value(eff->geteffectpar(11));
	gaindial->value(eff->geteffectpar(12));
	if (eff->geteffectpar(10)<6) gaindial->deactivate();
	qdial->value(eff->geteffectpar(13));
	stagescounter->value(eff->geteffectpar(14));
        eqgraph->init(eff);
	effeqwindow->show();
        break;
     case 8:make_filter_window();
	dfp->value(eff->getpreset());
	dfp0->value(eff->geteffectpar(0));if (eff->insertion!=0) dfp0->label("D/W");
	dfp1->value(eff->geteffectpar(1));
	dfp2->value(eff->geteffectpar(2));
	dfp3->value(eff->geteffectpar(3));
	dfp4->value(eff->geteffectpar(4));
	dfp5->value(eff->geteffectpar(5));
	dfp6->value(eff->geteffectpar(6));
	dfp7->value(eff->geteffectpar(7));
	dfp8->value(eff->geteffectpar(8));
	dfp9->value(eff->geteffectpar(9));

            
	effdynamicfilterwindow->show();
	break;
    default:effnullwindow->show();
            break; 
};

this->show();
}

void EffUI::refresh() {
  refresh(eff);
}

void SimpleEffUI::cb_revpa_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());

refresh(eff);
}
void SimpleEffUI::cb_revpa(Fl_Choice* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_revpa_i(o,v);
}

Fl_Menu_Item SimpleEffUI::menu_revp1[] = {
 {"Cathedral 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Cathedral 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Cathedral 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Hall 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Hall 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Room 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Room 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Basement", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Tunnel", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Echoed 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Echoed 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Very Long 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Very Long 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void SimpleEffUI::cb_revp01_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void SimpleEffUI::cb_revp01(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_revp01_i(o,v);
}

void SimpleEffUI::cb_revp21_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void SimpleEffUI::cb_revp21(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_revp21_i(o,v);
}

void SimpleEffUI::cb_revp31_i(WidgetPDial* o, void*) {
  eff->seteffectpar(3,(int) o->value());
}
void SimpleEffUI::cb_revp31(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_revp31_i(o,v);
}

void SimpleEffUI::cb_revp91_i(WidgetPDial* o, void*) {
  eff->seteffectpar(9,(int) o->value());
}
void SimpleEffUI::cb_revp91(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_revp91_i(o,v);
}

void SimpleEffUI::cb_echop7_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void SimpleEffUI::cb_echop7(Fl_Choice* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_echop7_i(o,v);
}

Fl_Menu_Item SimpleEffUI::menu_echop1[] = {
 {"Echo 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Echo 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Echo 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Simple Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Canyon", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Panning Echo 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Panning Echo 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Panning Echo 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Feedback Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void SimpleEffUI::cb_echop01_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void SimpleEffUI::cb_echop01(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_echop01_i(o,v);
}

void SimpleEffUI::cb_echop21_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void SimpleEffUI::cb_echop21(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_echop21_i(o,v);
}

void SimpleEffUI::cb_echop51_i(WidgetPDial* o, void*) {
  eff->seteffectpar(5,(int) o->value());
}
void SimpleEffUI::cb_echop51(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_echop51_i(o,v);
}

void SimpleEffUI::cb_choruspa_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void SimpleEffUI::cb_choruspa(Fl_Choice* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_choruspa_i(o,v);
}

Fl_Menu_Item SimpleEffUI::menu_chorusp1[] = {
 {"Chorus 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Chorus 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Chorus 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Celeste 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Celeste 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Flange 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Flange 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Flange 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Flange 4", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Flange 5", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void SimpleEffUI::cb_chorusp01_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void SimpleEffUI::cb_chorusp01(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_chorusp01_i(o,v);
}

void SimpleEffUI::cb_chorusp21_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void SimpleEffUI::cb_chorusp21(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_chorusp21_i(o,v);
}

void SimpleEffUI::cb_chorusp61_i(WidgetPDial* o, void*) {
  eff->seteffectpar(6,(int) o->value());
}
void SimpleEffUI::cb_chorusp61(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_chorusp61_i(o,v);
}

void SimpleEffUI::cb_chorusp71_i(WidgetPDial* o, void*) {
  eff->seteffectpar(7,(int) o->value());
}
void SimpleEffUI::cb_chorusp71(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_chorusp71_i(o,v);
}

void SimpleEffUI::cb_chorusp81_i(WidgetPDial* o, void*) {
  eff->seteffectpar(8,(int) o->value());
}
void SimpleEffUI::cb_chorusp81(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_chorusp81_i(o,v);
}

void SimpleEffUI::cb_Flange1_i(Fl_Check_Button* o, void*) {
  eff->seteffectpar(10,(int) o->value());
}
void SimpleEffUI::cb_Flange1(Fl_Check_Button* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_Flange1_i(o,v);
}

void SimpleEffUI::cb_phaserpa_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void SimpleEffUI::cb_phaserpa(Fl_Choice* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_phaserpa_i(o,v);
}

Fl_Menu_Item SimpleEffUI::menu_phaserp1[] = {
 {"Phaser 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Phaser 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Phaser 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Phaser 4", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Phaser 5", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Phaser 6", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void SimpleEffUI::cb_phaserp01_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void SimpleEffUI::cb_phaserp01(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_phaserp01_i(o,v);
}

void SimpleEffUI::cb_phaserp21_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void SimpleEffUI::cb_phaserp21(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_phaserp21_i(o,v);
}

void SimpleEffUI::cb_phaserp51_i(WidgetPDial* o, void*) {
  eff->seteffectpar(5,(int) o->value());
}
void SimpleEffUI::cb_phaserp51(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_phaserp51_i(o,v);
}

void SimpleEffUI::cb_phaserp61_i(WidgetPDial* o, void*) {
  eff->seteffectpar(6,(int) o->value());
}
void SimpleEffUI::cb_phaserp61(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_phaserp61_i(o,v);
}

void SimpleEffUI::cb_phaserp71_i(WidgetPDial* o, void*) {
  eff->seteffectpar(7,(int) o->value());
}
void SimpleEffUI::cb_phaserp71(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_phaserp71_i(o,v);
}

void SimpleEffUI::cb_phaserp81_i(Fl_Counter* o, void*) {
  eff->seteffectpar(8,(int) o->value());
}
void SimpleEffUI::cb_phaserp81(Fl_Counter* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_phaserp81_i(o,v);
}

void SimpleEffUI::cb_awpa_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void SimpleEffUI::cb_awpa(Fl_Choice* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_awpa_i(o,v);
}

Fl_Menu_Item SimpleEffUI::menu_awp1[] = {
 {"Alienwah 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Alienwah 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Alienwah 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Alienwah 4", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void SimpleEffUI::cb_awp01_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void SimpleEffUI::cb_awp01(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_awp01_i(o,v);
}

void SimpleEffUI::cb_awp21_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void SimpleEffUI::cb_awp21(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_awp21_i(o,v);
}

void SimpleEffUI::cb_awp61_i(WidgetPDial* o, void*) {
  eff->seteffectpar(6,(int) o->value());
}
void SimpleEffUI::cb_awp61(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_awp61_i(o,v);
}

void SimpleEffUI::cb_awp81_i(Fl_Counter* o, void*) {
  eff->seteffectpar(8,(int) o->value());
}
void SimpleEffUI::cb_awp81(Fl_Counter* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_awp81_i(o,v);
}

void SimpleEffUI::cb_distpa_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void SimpleEffUI::cb_distpa(Fl_Choice* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_distpa_i(o,v);
}

Fl_Menu_Item SimpleEffUI::menu_distp1[] = {
 {"Overdrive 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Overdrive 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"A. Exciter 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"A. Exciter 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Guitar Amp", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Quantisize", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void SimpleEffUI::cb_distp01_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void SimpleEffUI::cb_distp01(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_distp01_i(o,v);
}

void SimpleEffUI::cb_distp31_i(WidgetPDial* o, void*) {
  eff->seteffectpar(3,(int) o->value());
}
void SimpleEffUI::cb_distp31(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_distp31_i(o,v);
}

void SimpleEffUI::cb_distp41_i(WidgetPDial* o, void*) {
  eff->seteffectpar(4,(int) o->value());
}
void SimpleEffUI::cb_distp41(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_distp41_i(o,v);
}

void SimpleEffUI::cb_distp71_i(WidgetPDial* o, void*) {
  eff->seteffectpar(7,(int) o->value());
}
void SimpleEffUI::cb_distp71(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_distp71_i(o,v);
}

void SimpleEffUI::cb_distp51_i(Fl_Choice* o, void*) {
  eff->seteffectpar(5,(int) o->value());
}
void SimpleEffUI::cb_distp51(Fl_Choice* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_distp51_i(o,v);
}

Fl_Menu_Item SimpleEffUI::menu_distp51[] = {
 {"Atan", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Asym1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Pow", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Sine", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Qnts", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Zigzg", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Lmt", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"LmtU", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"LmtL", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"ILmt", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Clip", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Asym2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Pow2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Sgm", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void SimpleEffUI::cb_bandcounter1_i(Fl_Counter* o, void*) {
  eqband=(int) o->value();
int npb=eqband*5+10;

int type=eff->geteffectpar(npb);
typechoice->value(type);

if (type>6) gaindial->activate();
 else gaindial->deactivate();

if (type==0) bandgroup->deactivate();
else bandgroup->activate();

int freq=eff->geteffectpar(npb+1);
freqdial->value(freq);

int gain=eff->geteffectpar(npb+2);
gaindial->value(gain);

int q=eff->geteffectpar(npb+3);
qdial->value(q);

int dbl=eff->geteffectpar(npb+4);
stagescounter->value(dbl);
}
void SimpleEffUI::cb_bandcounter1(Fl_Counter* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_bandcounter1_i(o,v);
}

void SimpleEffUI::cb_freqdial1_i(WidgetPDial* o, void*) {
  int np=eqband*5+11;
eff->seteffectpar(np,(int) o->value());
eqgraph->redraw();
}
void SimpleEffUI::cb_freqdial1(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->parent()->user_data()))->cb_freqdial1_i(o,v);
}

void SimpleEffUI::cb_gaindial1_i(WidgetPDial* o, void*) {
  int np=eqband*5+12;
eff->seteffectpar(np,(int) o->value());
eqgraph->redraw();
}
void SimpleEffUI::cb_gaindial1(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->parent()->user_data()))->cb_gaindial1_i(o,v);
}

void SimpleEffUI::cb_qdial1_i(WidgetPDial* o, void*) {
  int np=eqband*5+13;
eff->seteffectpar(np,(int) o->value());
eqgraph->redraw();
}
void SimpleEffUI::cb_qdial1(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->parent()->user_data()))->cb_qdial1_i(o,v);
}

void SimpleEffUI::cb_stagescounter1_i(Fl_Counter* o, void*) {
  int np=eqband*5+14;
eff->seteffectpar(np,(int) o->value());
eqgraph->redraw();
}
void SimpleEffUI::cb_stagescounter1(Fl_Counter* o, void* v) {
  ((SimpleEffUI*)(o->parent()->parent()->user_data()))->cb_stagescounter1_i(o,v);
}

void SimpleEffUI::cb_typechoice1_i(Fl_Choice* o, void*) {
  int np=eqband*5+10;
eff->seteffectpar(np,(int) o->value());
bandcounter->do_callback();
eqgraph->redraw();
}
void SimpleEffUI::cb_typechoice1(Fl_Choice* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_typechoice1_i(o,v);
}

Fl_Menu_Item SimpleEffUI::menu_typechoice1[] = {
 {"OFF", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Lp1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Hp1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Lp2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Hp2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Bp2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"N2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Pk", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"LSh", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"HSh", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void SimpleEffUI::cb_dfpa_i(Fl_Choice* o, void*) {
  eff->changepreset((int)o->value());
refresh(eff);
}
void SimpleEffUI::cb_dfpa(Fl_Choice* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_dfpa_i(o,v);
}

Fl_Menu_Item SimpleEffUI::menu_dfp1[] = {
 {"WahWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"AutoWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"Sweep", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"VocalMorph1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {"VocalMorph2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 7},
 {0,0,0,0,0,0,0,0,0}
};

void SimpleEffUI::cb_dfp01_i(WidgetPDial* o, void*) {
  eff->seteffectpar(0,(int) o->value());
}
void SimpleEffUI::cb_dfp01(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_dfp01_i(o,v);
}

void SimpleEffUI::cb_dfp21_i(WidgetPDial* o, void*) {
  eff->seteffectpar(2,(int) o->value());
}
void SimpleEffUI::cb_dfp21(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_dfp21_i(o,v);
}

void SimpleEffUI::cb_dfp61_i(WidgetPDial* o, void*) {
  eff->seteffectpar(6,(int) o->value());
}
void SimpleEffUI::cb_dfp61(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->user_data()))->cb_dfp61_i(o,v);
}

void SimpleEffUI::cb_dfp71_i(WidgetPDial* o, void*) {
  eff->seteffectpar(7,(int) o->value());
}
void SimpleEffUI::cb_dfp71(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->parent()->user_data()))->cb_dfp71_i(o,v);
}

void SimpleEffUI::cb_dfp91_i(WidgetPDial* o, void*) {
  eff->seteffectpar(9,(int) o->value());
}
void SimpleEffUI::cb_dfp91(WidgetPDial* o, void* v) {
  ((SimpleEffUI*)(o->parent()->parent()->user_data()))->cb_dfp91_i(o,v);
}

SimpleEffUI::SimpleEffUI(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  eff=NULL;
}

SimpleEffUI::~SimpleEffUI() {
  effnullwindow->hide();//delete (effnullwindow);
effreverbwindow->hide();//delete (effreverbwindow);
effechowindow->hide();//delete (effechowindow);
effchoruswindow->hide();//delete (effchoruswindow);
effphaserwindow->hide();//delete (effphaserwindow);
effalienwahwindow->hide();//delete (effalienwahwindow);
effdistorsionwindow->hide();//delete (effdistorsionwindow);
effeqwindow->hide();//delete (effeqwindow);
effdynamicfilterwindow->hide();//delete (effdynamicfilterwindow);
}

Fl_Group* SimpleEffUI::make_null_window() {
  { effnullwindow = new Fl_Group(0, 0, 230, 95);
    effnullwindow->box(FL_PLASTIC_UP_BOX);
    effnullwindow->color((Fl_Color)221);
    effnullwindow->selection_color(FL_BACKGROUND_COLOR);
    effnullwindow->labeltype(FL_NO_LABEL);
    effnullwindow->labelfont(1);
    effnullwindow->labelsize(14);
    effnullwindow->labelcolor(FL_FOREGROUND_COLOR);
    effnullwindow->user_data((void*)(this));
    effnullwindow->align(Fl_Align(FL_ALIGN_TOP));
    effnullwindow->when(FL_WHEN_RELEASE);
    { Fl_Text_Display* o = new Fl_Text_Display(25, 35, 35, 20, "No Effect");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->labelcolor((Fl_Color)43);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    effnullwindow->end();
  } // Fl_Group* effnullwindow
  return effnullwindow;
}

Fl_Group* SimpleEffUI::make_reverb_window() {
  { effreverbwindow = new Fl_Group(0, 0, 230, 95);
    effreverbwindow->box(FL_PLASTIC_UP_BOX);
    effreverbwindow->color((Fl_Color)221);
    effreverbwindow->selection_color(FL_BACKGROUND_COLOR);
    effreverbwindow->labeltype(FL_NO_LABEL);
    effreverbwindow->labelfont(1);
    effreverbwindow->labelsize(14);
    effreverbwindow->labelcolor(FL_FOREGROUND_COLOR);
    effreverbwindow->user_data((void*)(this));
    effreverbwindow->align(Fl_Align(FL_ALIGN_TOP));
    effreverbwindow->when(FL_WHEN_RELEASE);
    { Fl_Text_Display* o = new Fl_Text_Display(115, 10, 20, 20, "Reverb ");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { revp = new Fl_Choice(10, 15, 90, 15, "Preset");
      revp->down_box(FL_BORDER_BOX);
      revp->color((Fl_Color)14);
      revp->selection_color(FL_FOREGROUND_COLOR);
      revp->labelfont(1);
      revp->labelsize(10);
      revp->textfont(1);
      revp->textsize(10);
      revp->textcolor(FL_BACKGROUND2_COLOR);
      revp->callback((Fl_Callback*)cb_revpa);
      revp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      revp->menu(menu_revp1);
    } // Fl_Choice* revp
    { revp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      revp0->tooltip("Effect Volume");
      revp0->box(FL_ROUND_UP_BOX);
      revp0->color(FL_BACKGROUND_COLOR);
      revp0->selection_color(FL_INACTIVE_COLOR);
      revp0->labeltype(FL_NORMAL_LABEL);
      revp0->labelfont(1);
      revp0->labelsize(11);
      revp0->labelcolor(FL_FOREGROUND_COLOR);
      revp0->maximum(127);
      revp0->callback((Fl_Callback*)cb_revp01);
      revp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* revp0
    { revp2 = new WidgetPDial(45, 40, 30, 30, "Time");
      revp2->tooltip("Duration of Reverb");
      revp2->box(FL_ROUND_UP_BOX);
      revp2->color(FL_BACKGROUND_COLOR);
      revp2->selection_color(FL_INACTIVE_COLOR);
      revp2->labeltype(FL_NORMAL_LABEL);
      revp2->labelfont(1);
      revp2->labelsize(11);
      revp2->labelcolor(FL_FOREGROUND_COLOR);
      revp2->maximum(127);
      revp2->callback((Fl_Callback*)cb_revp21);
      revp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp2->when(FL_WHEN_CHANGED);
    } // WidgetPDial* revp2
    { revp3 = new WidgetPDial(85, 40, 30, 30, "I.del");
      revp3->tooltip("Initial Delay");
      revp3->box(FL_ROUND_UP_BOX);
      revp3->color(FL_BACKGROUND_COLOR);
      revp3->selection_color(FL_INACTIVE_COLOR);
      revp3->labeltype(FL_NORMAL_LABEL);
      revp3->labelfont(1);
      revp3->labelsize(11);
      revp3->labelcolor(FL_FOREGROUND_COLOR);
      revp3->maximum(127);
      revp3->callback((Fl_Callback*)cb_revp31);
      revp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp3->when(FL_WHEN_RELEASE);
    } // WidgetPDial* revp3
    { revp9 = new WidgetPDial(120, 40, 30, 30, "Damp");
      revp9->tooltip("Dampening");
      revp9->box(FL_ROUND_UP_BOX);
      revp9->color(FL_BACKGROUND_COLOR);
      revp9->selection_color(FL_INACTIVE_COLOR);
      revp9->labeltype(FL_NORMAL_LABEL);
      revp9->labelfont(1);
      revp9->labelsize(11);
      revp9->labelcolor(FL_FOREGROUND_COLOR);
      revp9->minimum(64);
      revp9->maximum(127);
      revp9->step(1);
      revp9->callback((Fl_Callback*)cb_revp91);
      revp9->align(Fl_Align(FL_ALIGN_BOTTOM));
      revp9->when(FL_WHEN_CHANGED);
    } // WidgetPDial* revp9
    effreverbwindow->end();
  } // Fl_Group* effreverbwindow
  return effreverbwindow;
}

Fl_Group* SimpleEffUI::make_echo_window() {
  { effechowindow = new Fl_Group(0, 0, 230, 95);
    effechowindow->box(FL_PLASTIC_UP_BOX);
    effechowindow->color((Fl_Color)221);
    effechowindow->selection_color(FL_BACKGROUND_COLOR);
    effechowindow->labeltype(FL_NO_LABEL);
    effechowindow->labelfont(1);
    effechowindow->labelsize(14);
    effechowindow->labelcolor(FL_FOREGROUND_COLOR);
    effechowindow->user_data((void*)(this));
    effechowindow->align(Fl_Align(FL_ALIGN_TOP));
    effechowindow->when(FL_WHEN_RELEASE);
    { echop = new Fl_Choice(11, 15, 95, 15, "Preset");
      echop->down_box(FL_BORDER_BOX);
      echop->color((Fl_Color)14);
      echop->selection_color(FL_FOREGROUND_COLOR);
      echop->labelfont(1);
      echop->labelsize(10);
      echop->textfont(1);
      echop->textsize(10);
      echop->textcolor(FL_BACKGROUND2_COLOR);
      echop->callback((Fl_Callback*)cb_echop7);
      echop->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      echop->menu(menu_echop1);
    } // Fl_Choice* echop
    { Fl_Text_Display* o = new Fl_Text_Display(145, 10, 10, 20, "Echo");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { echop0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      echop0->tooltip("Effect Volume");
      echop0->box(FL_ROUND_UP_BOX);
      echop0->color(FL_BACKGROUND_COLOR);
      echop0->selection_color(FL_INACTIVE_COLOR);
      echop0->labeltype(FL_NORMAL_LABEL);
      echop0->labelfont(1);
      echop0->labelsize(11);
      echop0->labelcolor(FL_FOREGROUND_COLOR);
      echop0->maximum(127);
      echop0->callback((Fl_Callback*)cb_echop01);
      echop0->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* echop0
    { echop2 = new WidgetPDial(45, 40, 30, 30, "Delay");
      echop2->box(FL_ROUND_UP_BOX);
      echop2->color(FL_BACKGROUND_COLOR);
      echop2->selection_color(FL_INACTIVE_COLOR);
      echop2->labeltype(FL_NORMAL_LABEL);
      echop2->labelfont(1);
      echop2->labelsize(11);
      echop2->labelcolor(FL_FOREGROUND_COLOR);
      echop2->maximum(127);
      echop2->callback((Fl_Callback*)cb_echop21);
      echop2->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop2->when(FL_WHEN_RELEASE);
    } // WidgetPDial* echop2
    { echop5 = new WidgetPDial(80, 40, 30, 30, "Fb.");
      echop5->tooltip("Feedback");
      echop5->box(FL_ROUND_UP_BOX);
      echop5->color(FL_BACKGROUND_COLOR);
      echop5->selection_color(FL_INACTIVE_COLOR);
      echop5->labeltype(FL_NORMAL_LABEL);
      echop5->labelfont(1);
      echop5->labelsize(11);
      echop5->labelcolor(FL_FOREGROUND_COLOR);
      echop5->maximum(127);
      echop5->callback((Fl_Callback*)cb_echop51);
      echop5->align(Fl_Align(FL_ALIGN_BOTTOM));
      echop5->when(FL_WHEN_CHANGED);
    } // WidgetPDial* echop5
    effechowindow->end();
  } // Fl_Group* effechowindow
  return effechowindow;
}

Fl_Group* SimpleEffUI::make_chorus_window() {
  { effchoruswindow = new Fl_Group(0, 0, 230, 95);
    effchoruswindow->box(FL_PLASTIC_UP_BOX);
    effchoruswindow->color((Fl_Color)221);
    effchoruswindow->selection_color(FL_BACKGROUND_COLOR);
    effchoruswindow->labeltype(FL_NO_LABEL);
    effchoruswindow->labelfont(1);
    effchoruswindow->labelsize(14);
    effchoruswindow->labelcolor(FL_FOREGROUND_COLOR);
    effchoruswindow->user_data((void*)(this));
    effchoruswindow->align(Fl_Align(FL_ALIGN_TOP));
    effchoruswindow->when(FL_WHEN_RELEASE);
    { chorusp = new Fl_Choice(10, 15, 90, 15, "Preset");
      chorusp->down_box(FL_BORDER_BOX);
      chorusp->color((Fl_Color)14);
      chorusp->selection_color(FL_FOREGROUND_COLOR);
      chorusp->labelfont(1);
      chorusp->labelsize(10);
      chorusp->textfont(1);
      chorusp->textsize(10);
      chorusp->textcolor(FL_BACKGROUND2_COLOR);
      chorusp->callback((Fl_Callback*)cb_choruspa);
      chorusp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      chorusp->menu(menu_chorusp1);
    } // Fl_Choice* chorusp
    { Fl_Text_Display* o = new Fl_Text_Display(120, 10, 10, 20, "Chorus");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { chorusp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      chorusp0->tooltip("Effect Volume");
      chorusp0->box(FL_ROUND_UP_BOX);
      chorusp0->color(FL_BACKGROUND_COLOR);
      chorusp0->selection_color(FL_INACTIVE_COLOR);
      chorusp0->labeltype(FL_NORMAL_LABEL);
      chorusp0->labelfont(1);
      chorusp0->labelsize(11);
      chorusp0->labelcolor(FL_FOREGROUND_COLOR);
      chorusp0->maximum(127);
      chorusp0->callback((Fl_Callback*)cb_chorusp01);
      chorusp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp0
    { chorusp2 = new WidgetPDial(45, 40, 30, 30, "Freq");
      chorusp2->tooltip("LFO Frequency");
      chorusp2->box(FL_ROUND_UP_BOX);
      chorusp2->color(FL_BACKGROUND_COLOR);
      chorusp2->selection_color(FL_INACTIVE_COLOR);
      chorusp2->labeltype(FL_NORMAL_LABEL);
      chorusp2->labelfont(1);
      chorusp2->labelsize(11);
      chorusp2->labelcolor(FL_FOREGROUND_COLOR);
      chorusp2->maximum(127);
      chorusp2->callback((Fl_Callback*)cb_chorusp21);
      chorusp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp2->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp2
    { chorusp6 = new WidgetPDial(80, 40, 30, 30, "Dpth");
      chorusp6->tooltip("Depth");
      chorusp6->box(FL_ROUND_UP_BOX);
      chorusp6->color(FL_BACKGROUND_COLOR);
      chorusp6->selection_color(FL_INACTIVE_COLOR);
      chorusp6->labeltype(FL_NORMAL_LABEL);
      chorusp6->labelfont(1);
      chorusp6->labelsize(11);
      chorusp6->labelcolor(FL_FOREGROUND_COLOR);
      chorusp6->maximum(127);
      chorusp6->callback((Fl_Callback*)cb_chorusp61);
      chorusp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp6->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp6
    { chorusp7 = new WidgetPDial(115, 40, 30, 30, "Delay");
      chorusp7->box(FL_ROUND_UP_BOX);
      chorusp7->color(FL_BACKGROUND_COLOR);
      chorusp7->selection_color(FL_INACTIVE_COLOR);
      chorusp7->labeltype(FL_NORMAL_LABEL);
      chorusp7->labelfont(1);
      chorusp7->labelsize(11);
      chorusp7->labelcolor(FL_FOREGROUND_COLOR);
      chorusp7->maximum(127);
      chorusp7->callback((Fl_Callback*)cb_chorusp71);
      chorusp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp7->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp7
    { chorusp8 = new WidgetPDial(150, 40, 30, 30, "Fb");
      chorusp8->tooltip("Feedback");
      chorusp8->box(FL_ROUND_UP_BOX);
      chorusp8->color(FL_BACKGROUND_COLOR);
      chorusp8->selection_color(FL_INACTIVE_COLOR);
      chorusp8->labeltype(FL_NORMAL_LABEL);
      chorusp8->labelfont(1);
      chorusp8->labelsize(11);
      chorusp8->labelcolor(FL_FOREGROUND_COLOR);
      chorusp8->maximum(127);
      chorusp8->callback((Fl_Callback*)cb_chorusp81);
      chorusp8->align(Fl_Align(FL_ALIGN_BOTTOM));
      chorusp8->when(FL_WHEN_CHANGED);
    } // WidgetPDial* chorusp8
    { Fl_Check_Button* o = new Fl_Check_Button(120, 10, 55, 20, "Flange");
      o->box(FL_THIN_UP_BOX);
      o->down_box(FL_DOWN_BOX);
      o->color((Fl_Color)230);
      o->labelfont(1);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Flange1);
      o->hide();
      o->deactivate();
      o->value(eff->geteffectpar(10));
    } // Fl_Check_Button* o
    effchoruswindow->end();
  } // Fl_Group* effchoruswindow
  return effchoruswindow;
}

Fl_Group* SimpleEffUI::make_phaser_window() {
  { effphaserwindow = new Fl_Group(0, 0, 230, 95);
    effphaserwindow->box(FL_PLASTIC_UP_BOX);
    effphaserwindow->color((Fl_Color)221);
    effphaserwindow->selection_color(FL_BACKGROUND_COLOR);
    effphaserwindow->labeltype(FL_NO_LABEL);
    effphaserwindow->labelfont(1);
    effphaserwindow->labelsize(14);
    effphaserwindow->labelcolor(FL_FOREGROUND_COLOR);
    effphaserwindow->user_data((void*)(this));
    effphaserwindow->align(Fl_Align(FL_ALIGN_TOP));
    effphaserwindow->when(FL_WHEN_RELEASE);
    { phaserp = new Fl_Choice(10, 15, 90, 15, "Preset");
      phaserp->down_box(FL_BORDER_BOX);
      phaserp->color((Fl_Color)14);
      phaserp->selection_color(FL_FOREGROUND_COLOR);
      phaserp->labelfont(1);
      phaserp->labelsize(10);
      phaserp->textfont(1);
      phaserp->textsize(10);
      phaserp->textcolor(FL_BACKGROUND2_COLOR);
      phaserp->callback((Fl_Callback*)cb_phaserpa);
      phaserp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      phaserp->menu(menu_phaserp1);
    } // Fl_Choice* phaserp
    { Fl_Text_Display* o = new Fl_Text_Display(125, 10, 10, 20, "Phaser");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { phaserp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      phaserp0->tooltip("Effect Volume");
      phaserp0->box(FL_ROUND_UP_BOX);
      phaserp0->color(FL_BACKGROUND_COLOR);
      phaserp0->selection_color(FL_INACTIVE_COLOR);
      phaserp0->labeltype(FL_NORMAL_LABEL);
      phaserp0->labelfont(1);
      phaserp0->labelsize(11);
      phaserp0->labelcolor(FL_FOREGROUND_COLOR);
      phaserp0->maximum(127);
      phaserp0->callback((Fl_Callback*)cb_phaserp01);
      phaserp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp0
    { phaserp2 = new WidgetPDial(45, 40, 30, 30, "Freq");
      phaserp2->tooltip("LFO frequency");
      phaserp2->box(FL_ROUND_UP_BOX);
      phaserp2->color(FL_BACKGROUND_COLOR);
      phaserp2->selection_color(FL_INACTIVE_COLOR);
      phaserp2->labeltype(FL_NORMAL_LABEL);
      phaserp2->labelfont(1);
      phaserp2->labelsize(11);
      phaserp2->labelcolor(FL_FOREGROUND_COLOR);
      phaserp2->maximum(127);
      phaserp2->callback((Fl_Callback*)cb_phaserp21);
      phaserp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp2->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp2
    { phaserp5 = new WidgetPDial(80, 40, 30, 30, "St.df");
      phaserp5->tooltip("Left/Right Channel Phase Shift");
      phaserp5->box(FL_ROUND_UP_BOX);
      phaserp5->color(FL_BACKGROUND_COLOR);
      phaserp5->selection_color(FL_INACTIVE_COLOR);
      phaserp5->labeltype(FL_NORMAL_LABEL);
      phaserp5->labelfont(1);
      phaserp5->labelsize(11);
      phaserp5->labelcolor(FL_FOREGROUND_COLOR);
      phaserp5->maximum(127);
      phaserp5->callback((Fl_Callback*)cb_phaserp51);
      phaserp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp5->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp5
    { phaserp6 = new WidgetPDial(115, 40, 30, 30, "Dpth");
      phaserp6->tooltip("Depth");
      phaserp6->box(FL_ROUND_UP_BOX);
      phaserp6->color(FL_BACKGROUND_COLOR);
      phaserp6->selection_color(FL_INACTIVE_COLOR);
      phaserp6->labeltype(FL_NORMAL_LABEL);
      phaserp6->labelfont(1);
      phaserp6->labelsize(11);
      phaserp6->labelcolor(FL_FOREGROUND_COLOR);
      phaserp6->maximum(127);
      phaserp6->callback((Fl_Callback*)cb_phaserp61);
      phaserp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp6->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp6
    { phaserp7 = new WidgetPDial(150, 40, 30, 30, "Fb");
      phaserp7->tooltip("Feedback");
      phaserp7->box(FL_ROUND_UP_BOX);
      phaserp7->color(FL_BACKGROUND_COLOR);
      phaserp7->selection_color(FL_INACTIVE_COLOR);
      phaserp7->labeltype(FL_NORMAL_LABEL);
      phaserp7->labelfont(1);
      phaserp7->labelsize(11);
      phaserp7->labelcolor(FL_FOREGROUND_COLOR);
      phaserp7->maximum(127);
      phaserp7->callback((Fl_Callback*)cb_phaserp71);
      phaserp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      phaserp7->when(FL_WHEN_CHANGED);
    } // WidgetPDial* phaserp7
    { Fl_Counter* o = phaserp8 = new Fl_Counter(185, 55, 35, 15, "Stages");
      phaserp8->type(1);
      phaserp8->labelfont(1);
      phaserp8->labelsize(11);
      phaserp8->minimum(0);
      phaserp8->maximum(127);
      phaserp8->step(1);
      phaserp8->callback((Fl_Callback*)cb_phaserp81);
      o->range(1,MAX_PHASER_STAGES);
    } // Fl_Counter* phaserp8
    effphaserwindow->end();
  } // Fl_Group* effphaserwindow
  return effphaserwindow;
}

Fl_Group* SimpleEffUI::make_alienwah_window() {
  { effalienwahwindow = new Fl_Group(0, 0, 230, 95);
    effalienwahwindow->box(FL_PLASTIC_UP_BOX);
    effalienwahwindow->color((Fl_Color)221);
    effalienwahwindow->selection_color(FL_BACKGROUND_COLOR);
    effalienwahwindow->labeltype(FL_NO_LABEL);
    effalienwahwindow->labelfont(1);
    effalienwahwindow->labelsize(14);
    effalienwahwindow->labelcolor(FL_FOREGROUND_COLOR);
    effalienwahwindow->user_data((void*)(this));
    effalienwahwindow->align(Fl_Align(FL_ALIGN_TOP));
    effalienwahwindow->when(FL_WHEN_RELEASE);
    { awp = new Fl_Choice(10, 15, 90, 15, "Preset");
      awp->down_box(FL_BORDER_BOX);
      awp->color((Fl_Color)14);
      awp->selection_color(FL_FOREGROUND_COLOR);
      awp->labelfont(1);
      awp->labelsize(10);
      awp->textfont(1);
      awp->textsize(10);
      awp->textcolor(FL_BACKGROUND2_COLOR);
      awp->callback((Fl_Callback*)cb_awpa);
      awp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      awp->menu(menu_awp1);
    } // Fl_Choice* awp
    { Fl_Text_Display* o = new Fl_Text_Display(100, 10, 10, 20, "AlienWah");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { awp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      awp0->tooltip("Effect Volume");
      awp0->box(FL_ROUND_UP_BOX);
      awp0->color(FL_BACKGROUND_COLOR);
      awp0->selection_color(FL_INACTIVE_COLOR);
      awp0->labeltype(FL_NORMAL_LABEL);
      awp0->labelfont(1);
      awp0->labelsize(11);
      awp0->labelcolor(FL_FOREGROUND_COLOR);
      awp0->maximum(127);
      awp0->callback((Fl_Callback*)cb_awp01);
      awp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp0
    { awp2 = new WidgetPDial(45, 40, 30, 30, "Freq");
      awp2->tooltip("LFO frequency");
      awp2->box(FL_ROUND_UP_BOX);
      awp2->color(FL_BACKGROUND_COLOR);
      awp2->selection_color(FL_INACTIVE_COLOR);
      awp2->labeltype(FL_NORMAL_LABEL);
      awp2->labelfont(1);
      awp2->labelsize(11);
      awp2->labelcolor(FL_FOREGROUND_COLOR);
      awp2->maximum(127);
      awp2->callback((Fl_Callback*)cb_awp21);
      awp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp2->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp2
    { awp6 = new WidgetPDial(85, 40, 30, 30, "Dpth");
      awp6->tooltip("Depth");
      awp6->box(FL_ROUND_UP_BOX);
      awp6->color(FL_BACKGROUND_COLOR);
      awp6->selection_color(FL_INACTIVE_COLOR);
      awp6->labeltype(FL_NORMAL_LABEL);
      awp6->labelfont(1);
      awp6->labelsize(11);
      awp6->labelcolor(FL_FOREGROUND_COLOR);
      awp6->maximum(127);
      awp6->callback((Fl_Callback*)cb_awp61);
      awp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      awp6->when(FL_WHEN_CHANGED);
    } // WidgetPDial* awp6
    { Fl_Counter* o = awp8 = new Fl_Counter(125, 55, 35, 15, "Delay");
      awp8->type(1);
      awp8->labelfont(1);
      awp8->labelsize(11);
      awp8->minimum(0);
      awp8->maximum(127);
      awp8->step(1);
      awp8->callback((Fl_Callback*)cb_awp81);
      o->range(1,MAX_ALIENWAH_DELAY);
    } // Fl_Counter* awp8
    effalienwahwindow->end();
  } // Fl_Group* effalienwahwindow
  return effalienwahwindow;
}

Fl_Group* SimpleEffUI::make_distorsion_window() {
  { effdistorsionwindow = new Fl_Group(0, 0, 230, 95);
    effdistorsionwindow->box(FL_PLASTIC_UP_BOX);
    effdistorsionwindow->color((Fl_Color)221);
    effdistorsionwindow->selection_color(FL_BACKGROUND_COLOR);
    effdistorsionwindow->labeltype(FL_NO_LABEL);
    effdistorsionwindow->labelfont(1);
    effdistorsionwindow->labelsize(14);
    effdistorsionwindow->labelcolor(FL_FOREGROUND_COLOR);
    effdistorsionwindow->user_data((void*)(this));
    effdistorsionwindow->align(Fl_Align(FL_ALIGN_TOP));
    effdistorsionwindow->when(FL_WHEN_RELEASE);
    { distp = new Fl_Choice(11, 15, 95, 15, "Preset");
      distp->down_box(FL_BORDER_BOX);
      distp->color((Fl_Color)14);
      distp->selection_color(FL_FOREGROUND_COLOR);
      distp->labelfont(1);
      distp->labelsize(10);
      distp->textfont(1);
      distp->textsize(10);
      distp->textcolor(FL_BACKGROUND2_COLOR);
      distp->callback((Fl_Callback*)cb_distpa);
      distp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      distp->menu(menu_distp1);
    } // Fl_Choice* distp
    { Fl_Text_Display* o = new Fl_Text_Display(110, 10, 10, 20, "Distortion");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(16);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { distp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      distp0->tooltip("Effect Volume");
      distp0->box(FL_ROUND_UP_BOX);
      distp0->color(FL_BACKGROUND_COLOR);
      distp0->selection_color(FL_INACTIVE_COLOR);
      distp0->labeltype(FL_NORMAL_LABEL);
      distp0->labelfont(1);
      distp0->labelsize(11);
      distp0->labelcolor(FL_FOREGROUND_COLOR);
      distp0->maximum(127);
      distp0->callback((Fl_Callback*)cb_distp01);
      distp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* distp0
    { distp3 = new WidgetPDial(45, 40, 30, 30, "Drive");
      distp3->tooltip("Input amplification");
      distp3->box(FL_ROUND_UP_BOX);
      distp3->color(FL_BACKGROUND_COLOR);
      distp3->selection_color(FL_INACTIVE_COLOR);
      distp3->labeltype(FL_NORMAL_LABEL);
      distp3->labelfont(1);
      distp3->labelsize(11);
      distp3->labelcolor(FL_FOREGROUND_COLOR);
      distp3->maximum(127);
      distp3->callback((Fl_Callback*)cb_distp31);
      distp3->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp3->when(FL_WHEN_RELEASE);
    } // WidgetPDial* distp3
    { distp4 = new WidgetPDial(80, 40, 30, 30, "Level");
      distp4->tooltip("Output Amplification");
      distp4->box(FL_ROUND_UP_BOX);
      distp4->color(FL_BACKGROUND_COLOR);
      distp4->selection_color(FL_INACTIVE_COLOR);
      distp4->labeltype(FL_NORMAL_LABEL);
      distp4->labelfont(1);
      distp4->labelsize(11);
      distp4->labelcolor(FL_FOREGROUND_COLOR);
      distp4->maximum(127);
      distp4->callback((Fl_Callback*)cb_distp41);
      distp4->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp4->when(FL_WHEN_CHANGED);
    } // WidgetPDial* distp4
    { distp7 = new WidgetPDial(190, 40, 30, 30, "LPF");
      distp7->tooltip("Low Pass Filter");
      distp7->box(FL_ROUND_UP_BOX);
      distp7->color(FL_BACKGROUND_COLOR);
      distp7->selection_color(FL_INACTIVE_COLOR);
      distp7->labeltype(FL_NORMAL_LABEL);
      distp7->labelfont(1);
      distp7->labelsize(11);
      distp7->labelcolor(FL_FOREGROUND_COLOR);
      distp7->maximum(127);
      distp7->callback((Fl_Callback*)cb_distp71);
      distp7->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp7->when(FL_WHEN_CHANGED);
    } // WidgetPDial* distp7
    { distp5 = new Fl_Choice(120, 50, 60, 20, "Type");
      distp5->box(FL_UP_BOX);
      distp5->down_box(FL_BORDER_BOX);
      distp5->labelfont(1);
      distp5->labelsize(11);
      distp5->textsize(10);
      distp5->callback((Fl_Callback*)cb_distp51);
      distp5->align(Fl_Align(FL_ALIGN_BOTTOM));
      distp5->menu(menu_distp51);
    } // Fl_Choice* distp5
    effdistorsionwindow->end();
  } // Fl_Group* effdistorsionwindow
  return effdistorsionwindow;
}

Fl_Group* SimpleEffUI::make_eq_window() {
  { effeqwindow = new Fl_Group(0, 0, 230, 95);
    effeqwindow->box(FL_PLASTIC_UP_BOX);
    effeqwindow->color((Fl_Color)221);
    effeqwindow->selection_color(FL_BACKGROUND_COLOR);
    effeqwindow->labeltype(FL_NO_LABEL);
    effeqwindow->labelfont(1);
    effeqwindow->labelsize(14);
    effeqwindow->labelcolor(FL_FOREGROUND_COLOR);
    effeqwindow->user_data((void*)(this));
    effeqwindow->align(Fl_Align(FL_ALIGN_TOP));
    effeqwindow->when(FL_WHEN_RELEASE);
    { Fl_Text_Display* o = new Fl_Text_Display(170, 5, 15, 25, "EQ");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { Fl_Counter* o = bandcounter = new Fl_Counter(85, 15, 45, 15, "Band");
      bandcounter->tooltip("Band no.");
      bandcounter->type(1);
      bandcounter->labelfont(1);
      bandcounter->labelsize(11);
      bandcounter->minimum(0);
      bandcounter->maximum(1);
      bandcounter->step(1);
      bandcounter->textfont(1);
      bandcounter->textsize(11);
      bandcounter->callback((Fl_Callback*)cb_bandcounter1);
      bandcounter->align(Fl_Align(FL_ALIGN_TOP));
      o->bounds(0,MAX_EQ_BANDS-1);
    } // Fl_Counter* bandcounter
    { Fl_Group* o = bandgroup = new Fl_Group(5, 5, 75, 85);
      bandgroup->box(FL_ENGRAVED_FRAME);
      { freqdial = new WidgetPDial(10, 10, 25, 25, "Freq");
        freqdial->box(FL_ROUND_UP_BOX);
        freqdial->color(FL_BACKGROUND_COLOR);
        freqdial->selection_color(FL_INACTIVE_COLOR);
        freqdial->labeltype(FL_NORMAL_LABEL);
        freqdial->labelfont(1);
        freqdial->labelsize(10);
        freqdial->labelcolor(FL_FOREGROUND_COLOR);
        freqdial->maximum(127);
        freqdial->callback((Fl_Callback*)cb_freqdial1);
        freqdial->align(Fl_Align(FL_ALIGN_BOTTOM));
        freqdial->when(3);
      } // WidgetPDial* freqdial
      { gaindial = new WidgetPDial(45, 10, 25, 25, "Gain");
        gaindial->box(FL_ROUND_UP_BOX);
        gaindial->color(FL_BACKGROUND_COLOR);
        gaindial->selection_color(FL_INACTIVE_COLOR);
        gaindial->labeltype(FL_NORMAL_LABEL);
        gaindial->labelfont(1);
        gaindial->labelsize(10);
        gaindial->labelcolor(FL_FOREGROUND_COLOR);
        gaindial->maximum(127);
        gaindial->step(1);
        gaindial->callback((Fl_Callback*)cb_gaindial1);
        gaindial->align(Fl_Align(FL_ALIGN_BOTTOM));
        gaindial->when(3);
      } // WidgetPDial* gaindial
      { qdial = new WidgetPDial(10, 50, 25, 25, "Q");
        qdial->tooltip("Bandwidth/Resonance");
        qdial->box(FL_ROUND_UP_BOX);
        qdial->color(FL_BACKGROUND_COLOR);
        qdial->selection_color(FL_INACTIVE_COLOR);
        qdial->labeltype(FL_NORMAL_LABEL);
        qdial->labelfont(1);
        qdial->labelsize(10);
        qdial->labelcolor(FL_FOREGROUND_COLOR);
        qdial->maximum(127);
        qdial->callback((Fl_Callback*)cb_qdial1);
        qdial->align(Fl_Align(FL_ALIGN_BOTTOM));
        qdial->when(3);
      } // WidgetPDial* qdial
      { Fl_Counter* o = stagescounter = new Fl_Counter(40, 55, 30, 15, "Stages");
        stagescounter->tooltip("Additional filter stages");
        stagescounter->type(1);
        stagescounter->labelfont(1);
        stagescounter->labelsize(10);
        stagescounter->minimum(1);
        stagescounter->maximum(127);
        stagescounter->step(1);
        stagescounter->textfont(1);
        stagescounter->textsize(11);
        stagescounter->callback((Fl_Callback*)cb_stagescounter1);
        o->bounds(0,MAX_FILTER_STAGES-1);
      } // Fl_Counter* stagescounter
      if (eff->geteffectpar(10)==0) o->deactivate();
      bandgroup->end();
    } // Fl_Group* bandgroup
    { typechoice = new Fl_Choice(135, 15, 40, 15, "Type");
      typechoice->tooltip("Type");
      typechoice->down_box(FL_BORDER_BOX);
      typechoice->labelfont(1);
      typechoice->labelsize(10);
      typechoice->textsize(10);
      typechoice->callback((Fl_Callback*)cb_typechoice1);
      typechoice->align(Fl_Align(FL_ALIGN_TOP));
      typechoice->when(FL_WHEN_RELEASE_ALWAYS);
      typechoice->menu(menu_typechoice1);
    } // Fl_Choice* typechoice
    { EQGraph* o = eqgraph = new EQGraph(85, 35, 140, 55);
      eqgraph->box(FL_BORDER_BOX);
      eqgraph->color((Fl_Color)178);
      eqgraph->selection_color(FL_BACKGROUND_COLOR);
      eqgraph->labeltype(FL_NORMAL_LABEL);
      eqgraph->labelfont(0);
      eqgraph->labelsize(14);
      eqgraph->labelcolor(FL_FOREGROUND_COLOR);
      eqgraph->align(Fl_Align(FL_ALIGN_CENTER));
      eqgraph->when(FL_WHEN_RELEASE);
      o->init(eff);
    } // EQGraph* eqgraph
    effeqwindow->end();
  } // Fl_Group* effeqwindow
  return effeqwindow;
}

Fl_Group* SimpleEffUI::make_dynamicfilter_window() {
  { effdynamicfilterwindow = new Fl_Group(0, 0, 230, 95);
    effdynamicfilterwindow->box(FL_PLASTIC_UP_BOX);
    effdynamicfilterwindow->color((Fl_Color)221);
    effdynamicfilterwindow->selection_color(FL_BACKGROUND_COLOR);
    effdynamicfilterwindow->labeltype(FL_NO_LABEL);
    effdynamicfilterwindow->labelfont(1);
    effdynamicfilterwindow->labelsize(14);
    effdynamicfilterwindow->labelcolor(FL_FOREGROUND_COLOR);
    effdynamicfilterwindow->user_data((void*)(this));
    effdynamicfilterwindow->align(Fl_Align(FL_ALIGN_TOP));
    effdynamicfilterwindow->when(FL_WHEN_RELEASE);
    { dfp = new Fl_Choice(10, 15, 90, 15, "Preset");
      dfp->down_box(FL_BORDER_BOX);
      dfp->color((Fl_Color)14);
      dfp->selection_color(FL_FOREGROUND_COLOR);
      dfp->labelfont(1);
      dfp->labelsize(10);
      dfp->textfont(1);
      dfp->textsize(10);
      dfp->textcolor(FL_BACKGROUND2_COLOR);
      dfp->callback((Fl_Callback*)cb_dfpa);
      dfp->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      dfp->menu(menu_dfp1);
    } // Fl_Choice* dfp
    { Fl_Text_Display* o = new Fl_Text_Display(100, 10, 10, 20, "DynFilter");
      o->box(FL_NO_BOX);
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(22);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Text_Display* o
    { dfp0 = new WidgetPDial(10, 40, 30, 30, "Vol");
      dfp0->tooltip("Effect Volume");
      dfp0->box(FL_ROUND_UP_BOX);
      dfp0->color(FL_BACKGROUND_COLOR);
      dfp0->selection_color(FL_INACTIVE_COLOR);
      dfp0->labeltype(FL_NORMAL_LABEL);
      dfp0->labelfont(1);
      dfp0->labelsize(11);
      dfp0->labelcolor(FL_FOREGROUND_COLOR);
      dfp0->maximum(127);
      dfp0->callback((Fl_Callback*)cb_dfp01);
      dfp0->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp0->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp0
    { dfp2 = new WidgetPDial(45, 40, 30, 30, "Freq");
      dfp2->tooltip("LFO frequency");
      dfp2->box(FL_ROUND_UP_BOX);
      dfp2->color(FL_BACKGROUND_COLOR);
      dfp2->selection_color(FL_INACTIVE_COLOR);
      dfp2->labeltype(FL_NORMAL_LABEL);
      dfp2->labelfont(1);
      dfp2->labelsize(11);
      dfp2->labelcolor(FL_FOREGROUND_COLOR);
      dfp2->maximum(127);
      dfp2->callback((Fl_Callback*)cb_dfp21);
      dfp2->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp2->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp2
    { dfp6 = new WidgetPDial(80, 40, 30, 30, "LfoD");
      dfp6->tooltip("LFO depth");
      dfp6->box(FL_ROUND_UP_BOX);
      dfp6->color(FL_BACKGROUND_COLOR);
      dfp6->selection_color(FL_INACTIVE_COLOR);
      dfp6->labeltype(FL_NORMAL_LABEL);
      dfp6->labelfont(1);
      dfp6->labelsize(11);
      dfp6->labelcolor(FL_FOREGROUND_COLOR);
      dfp6->maximum(127);
      dfp6->callback((Fl_Callback*)cb_dfp61);
      dfp6->align(Fl_Align(FL_ALIGN_BOTTOM));
      dfp6->when(FL_WHEN_CHANGED);
    } // WidgetPDial* dfp6
    { Fl_Group* o = new Fl_Group(115, 40, 65, 45);
      o->box(FL_BORDER_BOX);
      o->color((Fl_Color)181);
      { dfp7 = new WidgetPDial(120, 45, 25, 25, "A.S.");
        dfp7->tooltip("how filter varies with amplitude");
        dfp7->box(FL_ROUND_UP_BOX);
        dfp7->color(FL_BACKGROUND_COLOR);
        dfp7->selection_color(FL_INACTIVE_COLOR);
        dfp7->labeltype(FL_NORMAL_LABEL);
        dfp7->labelfont(1);
        dfp7->labelsize(11);
        dfp7->labelcolor(FL_FOREGROUND_COLOR);
        dfp7->maximum(127);
        dfp7->callback((Fl_Callback*)cb_dfp71);
        dfp7->align(Fl_Align(FL_ALIGN_BOTTOM));
        dfp7->when(FL_WHEN_CHANGED);
      } // WidgetPDial* dfp7
      { dfp9 = new WidgetPDial(150, 45, 25, 25, "A.M");
        dfp9->tooltip("how quickly the filter varies with amplitude");
        dfp9->box(FL_ROUND_UP_BOX);
        dfp9->color(FL_BACKGROUND_COLOR);
        dfp9->selection_color(FL_INACTIVE_COLOR);
        dfp9->labeltype(FL_NORMAL_LABEL);
        dfp9->labelfont(1);
        dfp9->labelsize(11);
        dfp9->labelcolor(FL_FOREGROUND_COLOR);
        dfp9->maximum(127);
        dfp9->callback((Fl_Callback*)cb_dfp91);
        dfp9->align(Fl_Align(FL_ALIGN_BOTTOM));
        dfp9->when(FL_WHEN_CHANGED);
      } // WidgetPDial* dfp9
      o->end();
    } // Fl_Group* o
    effdynamicfilterwindow->end();
  } // Fl_Group* effdynamicfilterwindow
  return effdynamicfilterwindow;
}

void SimpleEffUI::init(EffectMgr *eff_) {
  eff=eff_;

make_null_window();
make_reverb_window();
make_echo_window();
make_chorus_window();
make_phaser_window();
make_alienwah_window();
make_distorsion_window();
make_eq_window();
make_dynamicfilter_window();

int px=this->parent()->x();
int py=this->parent()->y();

effnullwindow->position(px,py);
effreverbwindow->position(px,py);
effechowindow->position(px,py);
effchoruswindow->position(px,py);
effphaserwindow->position(px,py);
effalienwahwindow->position(px,py);
effdistorsionwindow->position(px,py);
effeqwindow->position(px,py);
effdynamicfilterwindow->position(px,py);

refresh(eff);
}

void SimpleEffUI::refresh(EffectMgr *eff_) {
  eff=eff_;
this->hide();

effnullwindow->hide();
effreverbwindow->hide();
effechowindow->hide();
effchoruswindow->hide();
effphaserwindow->hide();
effalienwahwindow->hide();
effdistorsionwindow->hide();
effeqwindow->hide();
effdynamicfilterwindow->hide();

eqband=0;


switch(eff->geteffect()){
     case 1:
	revp->value(eff->getpreset());
	revp0->value(eff->geteffectpar(0));if (eff->insertion!=0) revp0->label("D/W");
	revp2->value(eff->geteffectpar(2));
	revp3->value(eff->geteffectpar(3));
	revp9->value(eff->geteffectpar(9));          
        effreverbwindow->show();
        break; 
     case 2:
	echop->value(eff->getpreset());
	echop0->value(eff->geteffectpar(0));if (eff->insertion!=0) echop0->label("D/W");
	echop2->value(eff->geteffectpar(2));
	echop5->value(eff->geteffectpar(5));
	effechowindow->show();
        break; 
     case 3:
	chorusp->value(eff->getpreset());
	chorusp0->value(eff->geteffectpar(0));if (eff->insertion!=0) chorusp0->label("D/W");
	chorusp2->value(eff->geteffectpar(2));
	chorusp6->value(eff->geteffectpar(6));
	chorusp7->value(eff->geteffectpar(7));
	chorusp8->value(eff->geteffectpar(8));
	effchoruswindow->show();
        break; 
     case 4:
	phaserp->value(eff->getpreset());
	phaserp0->value(eff->geteffectpar(0));if (eff->insertion!=0) phaserp0->label("D/W");
	phaserp2->value(eff->geteffectpar(2));
	phaserp5->value(eff->geteffectpar(5));
	phaserp6->value(eff->geteffectpar(6));
	phaserp7->value(eff->geteffectpar(7));
	phaserp8->value(eff->geteffectpar(8));
	effphaserwindow->show();
        break; 
     case 5:
	awp->value(eff->getpreset());
	awp0->value(eff->geteffectpar(0));if (eff->insertion!=0) awp0->label("D/W");
	awp2->value(eff->geteffectpar(2));
	awp6->value(eff->geteffectpar(6));
	awp8->value(eff->geteffectpar(8));
	effalienwahwindow->show();
        break; 
     case 6:
	distp->value(eff->getpreset());
	distp0->value(eff->geteffectpar(0));if (eff->insertion!=0) distp0->label("D/W");
	distp3->value(eff->geteffectpar(3));
	distp4->value(eff->geteffectpar(4));
	distp5->value(eff->geteffectpar(5));
	distp7->value(eff->geteffectpar(7));
	effdistorsionwindow->show();
        break;
     case 7:
	bandcounter->value(eqband);
	bandcounter->do_callback();
	typechoice->value(eff->geteffectpar(10));
	eqgraph->redraw();
	freqdial->value(eff->geteffectpar(11));
	gaindial->value(eff->geteffectpar(12));
	if (eff->geteffectpar(10)<6) gaindial->deactivate();
	qdial->value(eff->geteffectpar(13));
	stagescounter->value(eff->geteffectpar(14));
        eqgraph->init(eff);
	effeqwindow->show();
        break;
     case 8:
	dfp->value(eff->getpreset());
	dfp0->value(eff->geteffectpar(0));if (eff->insertion!=0) dfp0->label("D/W");
	dfp2->value(eff->geteffectpar(2));
	dfp6->value(eff->geteffectpar(6));
	dfp7->value(eff->geteffectpar(7));
	dfp9->value(eff->geteffectpar(9));

            
	effdynamicfilterwindow->show();
	break;
    default:effnullwindow->show();
            break; 
};

this->show();
}

void SimpleEffUI::refresh() {
  refresh(eff);
}
