/*
 * ladspa_control_dialog.h - dialog for displaying and editing control port
 *                           values for LADSPA plugins
 *
 * Copyright (c) 2006-2008 Danny McRae <khjklujn/at/users.sourceforge.net>
 * 
 * This file is part of Linux MultiMedia Studio - http://lmms.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 */

#ifndef _LADSPA_CONTROL_DIALOG_H
#define _LADSPA_CONTROL_DIALOG_H

#include "effect_control_dialog.h"


class QHBoxLayout;
class ladspaControls;
class ledCheckBox;


class ladspaControlDialog : public effectControlDialog
{
	Q_OBJECT
public:
	ladspaControlDialog( ladspaControls * _ctl );
	~ladspaControlDialog();


private slots:
	void updateEffectView( ladspaControls * _ctl );


private:
	QHBoxLayout * m_effectLayout;
	ledCheckBox * m_stereoLink;

} ;

#endif
