/***************************************************************************
                          rtty2demodulator.h  -  description
                             -------------------
    begin                : Mon Jun 4 2001
    copyright            : (C) 2001 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef RTTYDEMODULATOR_H
#define RTTYDEMODULATOR_H

#define Distance 22 
#define NumberofProbes 11  // (11025 / 45.45 ) / Distance

#define SampleBufferLength  110  // Mindestens (1.5 Stop + 1Start + NumberOfBits Data +1.5 Stop) * NumberofProbes
#define MaxSamplestoProcess 200 // >=4096 / Distance

#include "fskdemodulator.h"
#include <complex>
#include "constants.h"
using namespace std;
/**Decodes RTTY 
  *@author Volker Schroer
  */
class FIRFilter;

class RTTYDemodulator : public FSKDemodulator  {
public: 
 RTTYDemodulator();
 ~RTTYDemodulator();

/** Prozess the input */
 void ProcessInput(double * input, double *);
 int getSquelchValue();
 bool Init(double,int);
 virtual double get2RxFrequency();
 virtual void setParameter(RxTxParameterType,void * );
 virtual void *getParameter(RxTxParameterType);
 virtual void *getBuffer();
 AfcMode AfcProperties();

public slots: // Public slots
/** Set RxFrequencies for RTTY */
 void setRxFrequency(double);

private: 	//Private Variables
 enum StateOfReception { WaitingForMark,WaitingForSpace, 
                         CheckingStartBit,CollectingByte,
                         CheckingParity, CheckingStopBits};

float CharacterData[SampleBufferLength];
float MarkBuffer[SampleBufferLength],SpaceBuffer[SampleBufferLength];
float DiscriminatorThreshold, StopBit1Value;
float MarkMax,SpaceMax;
float C1,C3;

int BufferPointer;
int BufferCount;
int holdCount1,holdCount2;
/** Filter for Integration (Lp) **/
//FIRFilter *Lp0,*Lp1,*Lp2;
/** Pointer for storing Data in the ellipse Display **/
int DisplayPointer;
/** Ellipse Display Data **/
complex<float> ellipseDisplay[512];


/** Status of Shift */
bool ShiftOn;

/** Baudrate */
float Baudrate;

/** Samples per bit */

unsigned int NumberOfBits;
/** Length of first Stopbit can't be local, as it might cross 
    input buffer boundary **/
int StopBit1Length,StopBit1Count;
/** Status of reception*/
StateOfReception Status;


/** Look at FSKDemodulator **/
unsigned int SymbolLength;

/** has detected Frequency changed ? */
bool FrequencyChanged;

/** Variables for Squelch computing */
float ave1,ave2;
 // Some extra paramters 
 ExtraParameter extraParameter;      

private: // Private methods
 /** returns the asci char coresponding to the baudot code */
 char baudot_code(char);
  
 /** Calc the quality of the signal for squelch */
 void CalcQuality(int);
 void CalcQuality(float);
 };

#endif
