/* $Id: event.h,v 1.4 2005/03/24 10:27:23 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LINGOTEACH_EVENT_H
#define LINGOTEACH_EVENT_H 1

/* simple event broker/listener system */


typedef void (*EventCallback) (void *object, void *data);
#define EV_CALLBACK(f) ((EventCallback) (f))

typedef struct _Listener Listener;
struct _Listener
{
     void          *object; /* the object, which should listen to the queue */
     const char    *signal; /* the signal, the object reacts on */
     EventCallback  cb;     /* The callback to emit */
     void          *data;   /* data to pass to the callback */
     Listener      *next;   /* pointer to the next listener */
};

Listener*
event_create_new_listener (void);

Listener*
event_append_listener (Listener *list, void *object, const char *signal,
                       EventCallback cb, void *data);

Listener*
event_remove_listener (Listener *list, Listener *which);

Listener*
event_remove_listener_by_object (Listener *list, void *object);

void
event_free_listener (Listener *list);

void
event_free_listener_1 (Listener *list);

unsigned int
event_emit_signal (Listener *list, const char *signal);

#endif /* LINGOTEACH_EVENT_H */
