/* $Id: errors.h,v 1.6 2005/05/10 17:18:39 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LING_ERRORS_H
#define LING_ERRORS_H 1

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef DEBUG
#define debug(x, ...) NULL
#else
void debug (const char *__restrict, ...);
#endif /* DEBUG */

/* error stuff */
#define ERR_MEM_INFO N_("Error on memory allocation!")
#define ERR_MEM_DESC N_("Memory could not be allocated.")
#define ERR_NOT_AVAILABLE N_("Not available.")

/**
 * typedef for a callback handler to connect to the general error handling
 * of LingoTeach
 */
typedef void* (*lingErrorCallback)  (const char *information,
                                     const char *description,
                                     const char *solution,
                                     char *file, int line);

/* used for the connector */
typedef enum {
     LING_ERR_WARNING = 0,
     LING_ERR_CRITICAL
} ErrorType;

/**
 * connector for the internal callback handler mechanism of the error
 * handling
 */
void
error_connect_signal (ErrorType type, lingErrorCallback callback);


/**
 * prints or shows a warning message to the user. Calls an internal callback
 * for raising another function, etc. - this has to be connected using the
 * err_connect_signal () function.
 */
void 
error_warning_full  (const char *information, const char *description,
                     const char *solution, char *file, int line);

/**
 * prints or shows a critical warning message to the user.Calls an internal
 * callback for raising another function, etc. - this has to be connected
 * using the err_connect_signal () function.
 */
void 
error_critical_full  (const char *information, const char *description,
                      const char *solution, char *file, int line);

#define error_warning(info, desc, sol) \
        error_warning_full(info,desc,sol,__FILE__,__LINE__)
#define error_critical(info, desc, sol) \
        error_critical_full(info,desc,sol,__FILE__,__LINE__)

/**
 * signal catcher for SIGSEGV, dumps anything useful to an error log for
 * inspection
 */
void
error_sigsegv (void);

/**
 * signal catcher for SIGQUIT
 */
void
error_sigquit (void);

#endif /* LING_ERRORS_H */
