#include <syslog.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "iface.h"
#include "global_vars.h"
#include "cmd.h"
#include "cmd_lcp3.h"
#include "../lcp3.h"
#include "../common.h"
#include "proc_supp.h"
#include "times.h"
#include "con.h"
#include "../config.h"
#include "mysql_backend.h"

int check_con_status()
{
#if HAVE_MYSQL
 char qbuf[160];
 char linen[20];
 int ctime;
 int ctime1 = 0;
 int ttime = 0;
 int bytesin;
#endif
 int ifa;
 struct line_t *line = (struct line_t*)lstlines.first;
 while ( line )
 {
     ifa = iface_up(server->tcp_socket, line);
     switch ( line->con_stat )
     {
         case CST_DOWN:
             if ( ifa == 0 )
             {
	         line->con_up_time = time(NULL);
		 if ( line->allow_manually )
		 {
                     set_line_status(line, CST_UP_USER);
                     cmd_broadcast(CBR_USER_UP, NULL, 0);
		 }
		 else set_line_status(line, CST_UP_SERVER);
	         init_throughput(line);
             }
             break;
         // case CST_DIALING: done by proc_con_action() in con.c
         case CST_UP_SERVER:
	 case CST_LOCKED_UP_CLT:
	     if ( ifa == -1 )
	     {
#if HAVE_MYSQL
	             time_t now = time(NULL);
                 strcpy(linen, line->linename);
                 ctime = (int)(line->con_up_time);
                 ctime1 = (int)(now);
                 ttime = (int)(now-line->con_up_time);
                 bytesin = line->bytes_recvd;
#endif
	         if ( server->logfile && line->mklog )
	         {
	             time_t now = time(NULL);
	             fprintf(server->logfile, "line: %s '%s' ", line->linename, cor_ctime(&line->con_up_time));
			     fprintf(server->logfile, "'%s' %d %u\n", cor_ctime(&now),
			             (int)(now-line->con_up_time), line->bytes_recvd);
			     fflush(server->logfile);
	         }
#if HAVE_MYSQL
            if ( line->mklog && sqlbe_available() )
			{
                 sprintf(qbuf, "INSERT INTO linesrv_con VALUES('%s', '%d', '%d', '%d', '%d')",
                         linen, ctime,
                         ctime1, ttime,
                         bytesin);
				 if ( sqlbe_query(qbuf) )
				 	syslog(LOG_WARNING, "LOG: unable to log time established for line '%s'",
							linen);
            }
#endif
	         line->con_up_time = 0;
	         set_offline(line);
                 set_line_status(line, CST_DOWN);
	         cmd_broadcast(CBR_CON_DIED, NULL, 0);
	     }
	     break;
	 case CST_LOCKED_UP_TIMED:
	 	syslog(LOG_ERR, "CST_LOCKED_UP_TIMED not supported yet. Closing line.");
		
	 	break;
     case CST_UP_USER:
	     if ( ifa == -1 )
	     {
	         if ( server->logfile && line->mklog )
	         {
	             time_t now = time(NULL);
	             fprintf(server->logfile, "manually: %s '%s' ", line->linename, cor_ctime(&line->con_up_time));
	             fprintf(server->logfile, "'%s' %d %u\n", cor_ctime(&now),
		             (int)(now-line->con_up_time), line->bytes_recvd);
			     fflush(server->logfile);
	         }
#if HAVE_MYSQL
             if ( line->mklog && sqlbe_available() )
		     {
					time_t now = time(NULL);
                     strcpy(linen, line->linename);
                     ctime = (int)(line->con_up_time);
                     ctime1 = (int)(now);
                     ttime = (int)(now-line->con_up_time);
                     bytesin = line->bytes_recvd;
                     sprintf(qbuf, "INSERT INTO linesrv_man VALUES('%s', '%d', '%d', '%d', '%d')", 
                             linen, ctime,
                             ctime1, ttime, 
                             bytesin);
					if ( sqlbe_query(qbuf) )
						syslog(LOG_WARNING, "LOG: unable to log time manually established for line '%s'",
								linen);
             }
#endif
	         line->con_up_time = 0;
	         set_offline(line);
                 set_line_status(line, CST_DOWN);
	         cmd_broadcast(CBR_USER_CLOSED, NULL, 0);
	     }
	     break;
	 case CST_LOCKED_DOWN: break; // might _seem_ to be established!!
         default:;
     }
     line = (struct line_t*)line->next;
 }
 return(0);
}

int proc_throughput(struct line_t *iline)
{
    unsigned int newest, second;
    time_t cup, delta_t;
    unsigned int tput[7]; // bytes per sec [0,2]=sent; [1,3]=recvd;
		 // [4]=total sent; [5]=total recvd; [6]=con_up_time;
    struct line_t *line = iline;
    struct t_lcp3_info_tput* lcp3_tput = malloc(sizeof(struct t_lcp3_info_tput));
	segf_indicator =  3300;
    if ( !line ) line = (struct line_t*)lstlines.first;
    while ( line )
    {
		segf_indicator =  3301;
		switch ( line->con_stat )
		{
		    case CST_UP_SERVER:
		    case CST_UP_USER:
		    case CST_LOCKED_UP_CLT:
		    case CST_LOCKED_UP_TIMED:
				break;
		    default:
				if ( !iline ) line = (struct line_t*)line->next;
			continue;
		}
		segf_indicator =  3302;
		iface_bcounts(line->interface, &(line->activity[line->activity_id].recvd),
					&(line->activity[line->activity_id].sent));
		segf_indicator =  3303;
		line->activity[line->activity_id].sent -= line->initial_bytes_sent;
		line->activity[line->activity_id].recvd -= line->initial_bytes_recvd;
		line->activity[line->activity_id].tstamp = time(NULL);
		line->bytes_recvd = line->activity[line->activity_id].recvd;
		segf_indicator =  3304;
		newest = line->activity_id;
		if ( newest > 0 ) { second = newest - 1; } else { second = LCS_ACTIVITY - 1; }
		line->activity_id++;
		if (line->activity_id >= LCS_ACTIVITY) line->activity_id = 0; // points now to the oldest
		cup = time(NULL) - line->con_up_time;
		if ( cup == 0 ) cup++;	// avoid zero-division
		segf_indicator =  3305;
		tput[0] = (unsigned int)(line->activity[newest].recvd / cup);
		tput[1] = (unsigned int)(line->activity[newest].sent / cup);
		delta_t = line->activity[newest].tstamp - line->activity[second].tstamp;
		if ( delta_t == 0 ) delta_t++;	// avoid zero-division
		tput[3] = (unsigned int)((line->activity[newest].sent - line->activity[second].sent) / delta_t);
		tput[2] = (unsigned int)((line->activity[newest].recvd - line->activity[second].recvd) / delta_t);
		tput[4] = line->activity[newest].recvd / 1024;
		tput[5] = line->activity[newest].sent / 1024;
		tput[6] = cup;
		segf_indicator =  3306;
		if ( line == (struct line_t*)lstlines.first )
		    cmd_broadcast(CBR_THROUGHPUT, (char*)tput, sizeof(tput));
		segf_indicator =  3307;
		if ( lcp3_tput )
		{ // malloc was successful
			segf_indicator =  3308;
		    lcp3_tput->dns = tput[2];
		    lcp3_tput->dnl = tput[0];
		    lcp3_tput->dnt = tput[4];
		    lcp3_tput->ups = tput[3];
		    lcp3_tput->upl = tput[1];
		    lcp3_tput->upt = tput[5];
		    lcp3_tput->client = 0;		// filled in by lcp3_cmd_broadcast()
		    lcp3_tput->line = tput[6];
		    lcp3_cmd_broadcast(CBR3_TPUT, lcp3_tput, sizeof(struct t_lcp3_info_tput), line);
			segf_indicator =  3309;
		}
		else
		{
		    syslog(LOG_ERR, "Unable to send LCP3 throughput messages: no mem");
		}
		segf_indicator =  3310;
		if ( !iline ) line = (struct line_t*)line->next;
		else break;
		segf_indicator =  3311;
    }
    if ( lcp3_tput ) free(lcp3_tput);
	segf_indicator =  3312;
    return(0);
}

int init_throughput(struct line_t *line)	// should get called when con got up.
{
    int i;
	segf_indicator =  3313;
    iface_bcounts(line->interface, &line->initial_bytes_recvd, &line->initial_bytes_sent);
	segf_indicator =  3314;
	#ifdef DEBUG
		syslog(LOG_DEBUG, "init_throughput for line '%s': sent: %u   recvd: %u",
			line->linename, line->initial_bytes_sent, line->initial_bytes_recvd);
	#endif
    for (i = 0; i < LCS_ACTIVITY; i++)
    {
		line->activity[i].recvd = line->initial_bytes_recvd;
		line->activity[i].sent = line->initial_bytes_sent;
    }
	segf_indicator =  3315;
    return(0);
}

#ifdef SHUTDOWN_OK
void shutdown_server_machine()
{
    pid_t pid;
    if ( !( pid = fork()) )
    { // child
        char *idx = server->script_shutdown + strlen(server->script_shutdown);
        while ( (*idx != '/') && (idx > server->script_shutdown) ) idx--;
        if ( *idx == '/' ) idx++;
        execlp(server->script_shutdown, idx, NULL);
        // returns only on error
        syslog(LOG_ERR, "Shutdown capabilities implemented but failed to execute.");
        exit(-1);
    }
}
#endif

void add_isdn_channel(struct client_t* who, struct line_t* line)
{
    int ret_status;
    pid_t pid;
         if (	 (!line)
	      || (line->con_type != CT_ISDN)
	      || (line->con_stat == CST_DOWN)
	      || (line->con_stat == CST_DIALING)
	      || (line->con_stat == CST_CLOSING)
	      || (line->con_stat == CST_LOCKED_DOWN))
	 {
	     switch ( who->type )
	     {
	         case LCS_CLT_LCP3:
		     lcp3_cmd_queue(CMD3_CHANFAIL, who, NULL, 0);
		     break;
		 default:
	             cmd_q(who, CMD_BADCHANOP, NULL, 0);
	     }
	     return;
	 }
         if ( !(pid = fork()) )
	 { // child
	     char *idx = line->isdn_channel_op + strlen(line->isdn_channel_op);
	     while ( (*idx != '/') && (idx > line->isdn_channel_op) ) idx--;
	     if ( *idx == '/' ) idx++;
	     execlp(line->isdn_channel_op, idx, "add", NULL);
	     // returns only on error
	     exit(-1);
	 }
	 waitpid(pid, &ret_status, WUNTRACED);
	 if ( WIFEXITED(ret_status) && (!WEXITSTATUS(ret_status)) )
	 {   // script returned 0 --> ok, channel added
	     line->used_channels++;
	     syslog(LOG_INFO, "isdn channels: %d", line->used_channels);
	 }
	 lcp3_cmd_broadcast(CBR3_LINESTAT, NULL, 0, line);
}

void remove_isdn_channel(struct client_t* who, struct line_t *line)
{
    int ret_status;
    pid_t pid;
         if (	 (!line)
	      || (line->con_type != CT_ISDN)
	      || (line->con_stat == CST_DOWN)
	      || (line->con_stat == CST_DIALING)
	      || (line->con_stat == CST_CLOSING)
	      || (line->con_stat == CST_LOCKED_DOWN))
	 {
	     switch ( who->type )
	     {
	         case LCS_CLT_LCP3:
		     lcp3_cmd_queue(CMD3_CHANFAIL, who, NULL, 0);
		     break;
		 default:
	             cmd_q(who, CMD_BADCHANOP, NULL, 0);
	     }
	     return;
	 }
	 if ( line->used_channels < 2 ) return; // we have only one channel
         if ( !( pid = fork()) )
	 { // child
	     char *idx = line->isdn_channel_op + strlen(line->isdn_channel_op);
	     while ( (*idx != '/') && (idx > line->isdn_channel_op) ) idx--;
	     if ( *idx == '/' ) idx++;
	     execlp(line->isdn_channel_op, idx, "remove", NULL);
	     // returns only on error
	     exit(-1);
	 }
	 waitpid(pid, &ret_status, WUNTRACED);
	 if ( WIFEXITED(ret_status) && (!WEXITSTATUS(ret_status)) )
	 {   // script returned 0 --> ok, channel removed
	     line->used_channels--;
	     syslog(LOG_INFO, "isdn channels: %d", line->used_channels);
	 }
	 lcp3_cmd_broadcast(CBR3_LINESTAT, NULL, 0, line);
}
