/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.ScrollView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Scroller {
    public static final int DOWN = 0;
    public static final int UP = 1;
    private final Instrumentation inst;
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final Sleeper sleeper;

    public Scroller(Instrumentation inst, ActivityUtils activityUtils, ViewFetcher viewFetcher, Sleeper sleeper) {
        this.inst = inst;
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.sleeper = sleeper;
    }

    public void drag(float fromX, float toX, float fromY, float toY, int stepCount) {
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        float y = fromY;
        float x = fromX;
        float yStep = (toY - fromY) / (float)stepCount;
        float xStep = (toX - fromX) / (float)stepCount;
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)fromX, (float)fromY, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        for (int i = 0; i < stepCount; ++i) {
            eventTime = SystemClock.uptimeMillis();
            event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)2, (float)(x += xStep), (float)(y += yStep), (int)0);
            try {
                this.inst.sendPointerSync(event);
                continue;
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)toX, (float)toY, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
    }

    private boolean scrollScrollView(final ScrollView view, int direction) {
        if (view == null) {
            return false;
        }
        int height = view.getHeight();
        --height;
        int scrollTo = -1;
        if (direction == 0) {
            scrollTo = height;
        } else if (direction == 1) {
            scrollTo = -height;
        }
        int originalY = view.getScrollY();
        final int scrollAmount = scrollTo;
        this.inst.runOnMainSync(new Runnable(){

            public void run() {
                view.scrollBy(0, scrollAmount);
            }
        });
        return originalY != view.getScrollY();
    }

    public boolean scroll(int direction) {
        ArrayList<View> viewList = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getAllViews(true));
        ArrayList<View> views = RobotiumUtils.filterViewsToSet(new Class[]{ListView.class, ScrollView.class, GridView.class}, viewList);
        View view = this.viewFetcher.getFreshestView(views);
        if (view == null) {
            return false;
        }
        if (view instanceof AbsListView) {
            return this.scrollList((AbsListView)view, direction);
        }
        if (view instanceof ScrollView) {
            return this.scrollScrollView((ScrollView)view, direction);
        }
        return false;
    }

    public <T extends AbsListView> boolean scrollList(T absListView, int direction) {
        if (absListView == null) {
            return false;
        }
        if (direction == 0) {
            if (absListView.getLastVisiblePosition() >= absListView.getCount() - 1) {
                this.scrollListToLine(absListView, absListView.getLastVisiblePosition());
                return false;
            }
            if (absListView.getFirstVisiblePosition() != absListView.getLastVisiblePosition()) {
                this.scrollListToLine(absListView, absListView.getLastVisiblePosition());
            } else {
                this.scrollListToLine(absListView, absListView.getFirstVisiblePosition() + 1);
            }
        } else if (direction == 1) {
            if (absListView.getFirstVisiblePosition() < 2) {
                this.scrollListToLine(absListView, 0);
                return false;
            }
            int lines = absListView.getLastVisiblePosition() - absListView.getFirstVisiblePosition();
            int lineToScrollTo = absListView.getFirstVisiblePosition() - lines;
            if (lineToScrollTo == absListView.getLastVisiblePosition()) {
                --lineToScrollTo;
            }
            if (lineToScrollTo < 0) {
                lineToScrollTo = 0;
            }
            this.scrollListToLine(absListView, lineToScrollTo);
        }
        this.sleeper.sleep();
        return true;
    }

    private <T extends AbsListView> void scrollListToLine(final T view, int line) {
        final int lineToMoveTo = view instanceof GridView ? line + 1 : line;
        this.inst.runOnMainSync(new Runnable(){

            public void run() {
                view.setSelection(lineToMoveTo);
            }
        });
    }

    public void scrollToSide(Side side) {
        int screenHeight = this.activityUtils.getCurrentActivity().getWindowManager().getDefaultDisplay().getHeight();
        int screenWidth = this.activityUtils.getCurrentActivity(false).getWindowManager().getDefaultDisplay().getWidth();
        float x = (float)screenWidth / 2.0f;
        float y = (float)screenHeight / 2.0f;
        if (side == Side.LEFT) {
            this.drag(0.0f, x, y, y, 40);
        } else if (side == Side.RIGHT) {
            this.drag(x, 0.0f, y, y, 40);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        LEFT,
        RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP,
        DOWN;

    }
}

