/***********************************************************************************

	Copyright( C) 2009 Ahmet Öztürk( aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_UNDO_HEADER
#define LIFEOGRAPH_UNDO_HEADER


#include <deque>

#include <glibmm.h>


namespace LIFEO {

enum UndoableType
{
	UT_INSERT_TEXT,
	UT_ERASE_TEXT,
	UT_ADD_TAG,
	UT_REMOVE_TAG,
	UT_ADD_ENTRY,
	UT_REMOVE_ENTRY
};

// UNDOABLE ACTION PARENT
class Undoable {
	public:
									Undoable( const Glib::ustring&, UndoableType );

		glong						get_time_sec( void ) const
		{
			return m_time.tv_sec;
		}

		Glib::TimeVal				get_time( void ) const
		{
			return m_time;
		}

		UndoableType				get_type( void ) const
		{
			return m_type;
		}

	protected:
		virtual bool				can_merge( const Undoable* ) const = 0;
		virtual void				merge( Undoable* ) = 0;
		virtual void				undo( void ) = 0;
		virtual void				redo( void ) = 0;

		Glib::ustring				m_name;
		Glib::TimeVal				m_time;
		UndoableType				m_type;

	private:

	friend class UndoManager;
};

// UNDO MANAGER
class UndoManager {
	public:
									UndoManager( void );
		void						add_action( Undoable* );
		void						clear( void );

		bool						can_undo( void )
		{
			return(  m_stack_undo.size() > 0 );
		}

		bool						can_redo( void )
		{
			return(  m_stack_redo.size() > 0 );
		}

		bool						is_freezed( void )
		{
			return m_freezed;
		}

		void						undo( void );
		void						redo( void );
		void						freeze( void )
		{
			m_freezed = true;

		}
		void						thaw( void )
		{
			m_freezed = false;
		}

	protected:

	private:
		std::deque< Undoable* >		m_stack_undo;
		std::deque< Undoable* >		m_stack_redo;
		bool						m_freezed;
};

}

#endif

