#
# Generates include/licq/licqversion.h
#

# Licq version
set(LICQ_VERSION_MAJOR 1)          # 0 <= major   <= 64
set(LICQ_VERSION_MINOR 5)          # 0 <= minor   <= 99
set(LICQ_VERSION_RELEASE 0)        # 0 <= release <=  9
set(LICQ_VERSION_EXTRA "")         # Any string
set(LICQ_VERSION_PLUGIN_ABI 0)     # Increase when breaking plugin ABI

# When building from a svn working copy, set the extra version to the current
# revision, replacing any existing value.
find_package(Subversion QUIET)
if (Subversion_FOUND)
  if (NOT LICQ_VERSION_SOURCE_DIR)
    set(LICQ_VERSION_SOURCE_DIR ${PROJECT_SOURCE_DIR})
  endif (NOT LICQ_VERSION_SOURCE_DIR)

  # The subversion_wc_info macro prints an error if the dir isn't a working
  # copy. To avoid this, check if it is one before executing the macro.
  execute_process(
    COMMAND ${Subversion_SVN_EXECUTABLE} info ${LICQ_VERSION_SOURCE_DIR}
    RESULT_VARIABLE licq_svn_result
    OUTPUT_QUIET ERROR_QUIET)

  if (${licq_svn_result} EQUAL 0)
    # Work-around for old FindSubversion.cmake
    set(_Licq_SAVED_LC_ALL "$ENV{LC_ALL}")
    set(ENV{LC_ALL} C)

    subversion_wc_info(${LICQ_VERSION_SOURCE_DIR} Licq)
    set(LICQ_VERSION_EXTRA "-r${Licq_WC_LAST_CHANGED_REV}")

    # restore the previous LC_ALL
    set(ENV{LC_ALL} ${_Licq_SAVED_LC_ALL})    
  endif (${licq_svn_result} EQUAL 0)
endif (Subversion_FOUND)

# licqversion.h content
set(licq_version_file "${CMAKE_CURRENT_BINARY_DIR}/include/licq/licqversion.h")
set(licq_old_version "")
set(licq_new_version 
  "// Autogenerated by CMake. Do not edit, changes will be lost.
#ifndef LICQ_LICQVERSION_H
#define LICQ_LICQVERSION_H

#define LICQ_VERSION_MAJOR ${LICQ_VERSION_MAJOR}
#define LICQ_VERSION_MINOR ${LICQ_VERSION_MINOR}
#define LICQ_VERSION_RELEASE ${LICQ_VERSION_RELEASE}
#define LICQ_VERSION_EXTRA \"${LICQ_VERSION_EXTRA}\"
#define LICQ_VERSION_STRING \"${LICQ_VERSION_MAJOR}.${LICQ_VERSION_MINOR}.${LICQ_VERSION_RELEASE}${LICQ_VERSION_EXTRA}\"
#define LICQ_VERSION_PLUGIN_ABI ${LICQ_VERSION_PLUGIN_ABI}

#endif
")

# Read in the old file (if it exists)
if (EXISTS ${licq_version_file})
  file(READ ${licq_version_file} licq_old_version)
endif (EXISTS ${licq_version_file})

# Only write the file if the content has changed
string(COMPARE NOTEQUAL
  "${licq_old_version}" "${licq_new_version}"
  licq_update_version_file)

if (${licq_update_version_file})
  message(STATUS "Creating ${licq_version_file}")
  file(WRITE ${licq_version_file} ${licq_new_version})
endif (${licq_update_version_file})
