# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Jono Bacon <jono@ubuntu.com>
# Copyright (C) 2010 Michael Budde <mbudde@gmail.com>
#
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3, as published
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

# THIS IS Lernid CONFIGURATION FILE
# YOU CAN PUT THERE SOME GLOBAL VALUE
# Do not touch until you know what you're doing.
# you're warned :)

# where your project will head for your data (for instance, images and ui files)
# by default, this is ../data, relative your trunk layout
__lernid_data_directory__ = '../data/'


import os
import xdg.BaseDirectory

VERSION = '0.6'
DESCRIPTION = _('Connect to a world of online tutorials quickly and easily.')
WEBSITE = 'http://wiki.ubuntu.com/Lernid'
CONTRIBUTORS = [
    "Andrew Higginson <rugby471@gmail.com>",
    "Daniel Holbach <daniel.holbach@ubuntu.com>",
    "David Planella <david.planella@ubuntu.com>",
    "Jono Bacon <jono@ubuntu.com>",
    "Lucian Adrian Grijincu <lucian.grijincu@gmail.com>",
    "Methiue Comandon <strycore@gmail.com>",
    "Michael Budde <mbudde@gmail.com>",
    "Sanne Wouda <sanne@gruttepier.net>",
    "Sense Hofstede <sense@qense.nl>",
]
ARTISTS = [
    'K.Vishnoo Charan Reddy <foo.mac.v@gmail.com>'
]

LICENSE = """
This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but  WITHOUT ANY WARRANTY; without even the implied warranties of MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along  with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

class ProjectPathNotFound(Exception):
    pass

def get_data_path(*resource):
    """Retrieve lernid data path

    This path is by default <lernid_lib_path>/../data/ in trunk
    and /usr/share/lernid in an installed version but this path
    is specified at installation time.
    """

    # get pathname absolute or relative
    if __lernid_data_directory__.startswith('/'):
        pathname = __lernid_data_directory__
    else:
        pathname = os.path.join(os.path.dirname(__file__), __lernid_data_directory__)
    abs_data_path = os.path.abspath(pathname)
    if os.path.exists(abs_data_path):
        filepath = os.path.join(abs_data_path, *resource)
        if os.path.exists(filepath):
            return filepath
        else:
            return None
    else:
        raise ProjectPathNotFound

# Taken from xdg.BaseDirectory.save_data_path() to provide the same function
# $XDG_CACHE_HOME as well
def save_cache_path(*resource):
    """Ensure $XDG_CACHE_HOME/<resource>/ exists, and return its path.
    'resource' is the name of some shared resource. Use this when updating
    a shared (between programs) database. Use the xdg_data_dirs variable
    for loading."""
    resource = os.path.join(*resource)
    assert not resource.startswith('/')
    path = os.path.join(xdg.BaseDirectory.xdg_cache_home, resource)
    if not os.path.isdir(path):
        os.makedirs(path)
    return path
