/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */

/******************************************************************************

lcmaps_gridlist.h

Description:
    This header file contains the LCMAPS gridlist routines definitions

CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps-plugins-voms/src/gridlist/lcmaps_gridlist.h,v $
    $Date: 2010-02-19 06:01:37 $
    $Revision: 1.7 $
    $Author: okoeroo $

******************************************************************************/


#ifndef LCMAPS_GRIDLIST_H
#define LCMAPS_GRIDLIST_H

/******************************************************************************
                             Include header files
******************************************************************************/

/******************************************************************************
                               Define constants
******************************************************************************/

/******************************************************************************
                               Type definitions
******************************************************************************/

/******************************************************************************
                               Global variables
******************************************************************************/

/******************************************************************************
                              Function prototypes
******************************************************************************/

#ifndef LCMAPS_GRIDLIST_C
#define STORAGE_CLASS extern
#else
#define STORAGE_CLASS
#endif

STORAGE_CLASS int
lcmaps_gridlist(
    char *          globusidp,
    char **         useridp,
    char *          globusidfile,
    unsigned short  matching_type,
    char *          searchstr,
    const char *    dnsuffix
);

STORAGE_CLASS char *  gridmapdir_urlencode(char * rawstring);

#define MATCH_INCLUDE             ((unsigned short)0x0001)
#define MATCH_EXCLUDE             ((unsigned short)0x0000)
#define MATCH_WILD_CHARS          ((unsigned short)0x0002)
#define MATCH_NO_WILD_CHARS       ((unsigned short)0x0000)
#define OVERRIDE_INCONSISTANCY    ((unsigned short)0x0004)
#define MATCH_ONLY_DN             ((unsigned short)0x0008)
#define MATCH_STRICT_PREFIX_NUM   ((unsigned short)0x0010)
#define ONLY_USE_EXISTING_LEASE   ((unsigned short)0x0020)
#define INCLUDE    3
#define EXCLUDE    4

#endif /* LCMAPS_GRIDLIST_H */



