/* file_browser.c generated by valac 0.12.1, the Vala compiler
 * generated from file_browser.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksourceview.h>
#include <pango/pango.h>


#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;
typedef struct _FileBrowserPrivate FileBrowserPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;

#define FILE_BROWSER_TYPE_PARENT_DIR_COLUMN (file_browser_parent_dir_column_get_type ())

#define FILE_BROWSER_TYPE_FILE_COLUMN (file_browser_file_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block14Data Block14Data;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;

#define TYPE_DOC_TYPE (doc_type_get_type ())
#define _build_tools_unref0(var) ((var == NULL) ? NULL : (var = (build_tools_unref (var), NULL)))

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))

#define TYPE_BUILD_TOOL_RUNNER (build_tool_runner_get_type ())
#define BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunner))
#define BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))
#define IS_BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_RUNNER))
#define IS_BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_RUNNER))
#define BUILD_TOOL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))

typedef struct _BuildToolRunner BuildToolRunner;
typedef struct _BuildToolRunnerClass BuildToolRunnerClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _FileBrowser {
	GtkVBox parent_instance;
	FileBrowserPrivate * priv;
};

struct _FileBrowserClass {
	GtkVBoxClass parent_class;
};

struct _FileBrowserPrivate {
	MainWindow* main_window;
	BuildView* build_view;
	GtkListStore* parent_dir_store;
	GtkListStore* list_store;
	GtkTreeView* _list_view;
	GtkComboBox* combo_box;
	GFile* current_directory;
	GtkButton* parent_button;
	GSettings* settings;
	GSettings* latex_settings;
	guint timeout_id;
};

typedef enum  {
	FILE_BROWSER_PARENT_DIR_COLUMN_INDENT,
	FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF,
	FILE_BROWSER_PARENT_DIR_COLUMN_NAME,
	FILE_BROWSER_PARENT_DIR_COLUMN_FILE,
	FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS
} FileBrowserParentDirColumn;

typedef enum  {
	FILE_BROWSER_FILE_COLUMN_PIXBUF,
	FILE_BROWSER_FILE_COLUMN_NAME,
	FILE_BROWSER_FILE_COLUMN_IS_DIR,
	FILE_BROWSER_FILE_COLUMN_N_COLUMNS
} FileBrowserFileColumn;

struct _Block14Data {
	int _ref_count_;
	FileBrowser * self;
	GtkButton* jump_button;
};

typedef enum  {
	DOC_TYPE_DVI,
	DOC_TYPE_PDF,
	DOC_TYPE_PS,
	DOC_TYPE_LAST
} DocType;

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	gboolean must_succeed;
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean show;
	gboolean compilation;
	GList* jobs;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};


static gpointer file_browser_parent_class = NULL;

GType file_browser_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType build_view_get_type (void) G_GNUC_CONST;
#define FILE_BROWSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FILE_BROWSER, FileBrowserPrivate))
enum  {
	FILE_BROWSER_DUMMY_PROPERTY
};
static GType file_browser_parent_dir_column_get_type (void) G_GNUC_UNUSED;
static GType file_browser_file_column_get_type (void) G_GNUC_UNUSED;
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type, MainWindow* main_window);
BuildView* main_window_get_build_view (MainWindow* self);
static void file_browser_init_toolbar (FileBrowser* self);
static void file_browser_init_combo_box (FileBrowser* self);
static void file_browser_init_list (FileBrowser* self);
static void file_browser_init_settings (FileBrowser* self);
static void file_browser_fill_stores_with_dir (FileBrowser* self, GFile* dir);
void file_browser_refresh (FileBrowser* self);
static void _file_browser_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void file_browser_on_refresh (FileBrowser* self);
static void _file_browser_on_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static gboolean _lambda67_ (FileBrowser* self);
static gboolean __lambda67__gsource_func (gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
GtkButton* utils_get_toolbar_button (const gchar* stock_id);
static void _lambda60_ (FileBrowser* self);
static void __lambda60__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda61_ (FileBrowser* self);
static void __lambda61__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda62_ (FileBrowser* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
static void __lambda62__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda63_ (Block14Data* _data14_);
static void file_browser_update_jump_button_sensitivity (FileBrowser* self, GtkButton* jump_button);
static void _lambda64_ (Block14Data* _data14_);
static void __lambda64__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda63__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _file_browser_refresh_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda65_ (FileBrowser* self);
static void __lambda65__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static gint file_browser_on_sort (FileBrowser* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static void _lambda66_ (GtkTreePath* path, FileBrowser* self);
gpointer build_tools_ref (gpointer instance);
void build_tools_unref (gpointer instance);
GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_build_tools (GValue* value, gpointer v_object);
void value_take_build_tools (GValue* value, gpointer v_object);
gpointer value_get_build_tools (const GValue* value);
GType build_tools_get_type (void) G_GNUC_CONST;
BuildTools* build_tools_get_default (void);
gchar* utils_get_extension (const gchar* path);
GType doc_type_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
GType post_processor_type_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
BuildTool* build_tools_get_view_doc (BuildTools* self, DocType type);
GtkAction* main_window_get_action_stop_exec (MainWindow* self);
BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
GType build_tool_runner_get_type (void) G_GNUC_CONST;
static void __lambda66__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
void file_browser_refresh_for_document (FileBrowser* self, Document* doc);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
Project* document_get_project (Document* self);
static void file_browser_insert_file (FileBrowser* self, gboolean is_dir, const gchar* pixbuf, const gchar* basename);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void file_browser_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType file_browser_parent_dir_column_get_type (void) {
	static volatile gsize file_browser_parent_dir_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_parent_dir_column_type_id__volatile)) {
		static const GEnumValue values[] = {{FILE_BROWSER_PARENT_DIR_COLUMN_INDENT, "FILE_BROWSER_PARENT_DIR_COLUMN_INDENT", "indent"}, {FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, "FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_PARENT_DIR_COLUMN_NAME, "FILE_BROWSER_PARENT_DIR_COLUMN_NAME", "name"}, {FILE_BROWSER_PARENT_DIR_COLUMN_FILE, "FILE_BROWSER_PARENT_DIR_COLUMN_FILE", "file"}, {FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, "FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType file_browser_parent_dir_column_type_id;
		file_browser_parent_dir_column_type_id = g_enum_register_static ("FileBrowserParentDirColumn", values);
		g_once_init_leave (&file_browser_parent_dir_column_type_id__volatile, file_browser_parent_dir_column_type_id);
	}
	return file_browser_parent_dir_column_type_id__volatile;
}


static GType file_browser_file_column_get_type (void) {
	static volatile gsize file_browser_file_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_file_column_type_id__volatile)) {
		static const GEnumValue values[] = {{FILE_BROWSER_FILE_COLUMN_PIXBUF, "FILE_BROWSER_FILE_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_FILE_COLUMN_NAME, "FILE_BROWSER_FILE_COLUMN_NAME", "name"}, {FILE_BROWSER_FILE_COLUMN_IS_DIR, "FILE_BROWSER_FILE_COLUMN_IS_DIR", "is-dir"}, {FILE_BROWSER_FILE_COLUMN_N_COLUMNS, "FILE_BROWSER_FILE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType file_browser_file_column_type_id;
		file_browser_file_column_type_id = g_enum_register_static ("FileBrowserFileColumn", values);
		g_once_init_leave (&file_browser_file_column_type_id__volatile, file_browser_file_column_type_id);
	}
	return file_browser_file_column_type_id__volatile;
}


FileBrowser* file_browser_construct (GType object_type, MainWindow* main_window) {
	FileBrowser * self = NULL;
	BuildView* _tmp0_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (FileBrowser*) g_object_new (object_type, "spacing", 3, NULL);
	self->priv->main_window = main_window;
	_tmp0_ = main_window_get_build_view (main_window);
	_g_object_unref0 (self->priv->build_view);
	self->priv->build_view = _tmp0_;
	file_browser_init_toolbar (self);
	file_browser_init_combo_box (self);
	file_browser_init_list (self);
	file_browser_init_settings (self);
	gtk_widget_show_all ((GtkWidget*) self);
	file_browser_fill_stores_with_dir (self, NULL);
	return self;
}


FileBrowser* file_browser_new (MainWindow* main_window) {
	return file_browser_construct (TYPE_FILE_BROWSER, main_window);
}


static void _file_browser_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	file_browser_refresh (self);
}


static void _file_browser_on_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	file_browser_on_refresh (self);
}


static void file_browser_init_settings (FileBrowser* self) {
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.file-browser");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_signal_connect_object (self->priv->settings, "changed::show-all-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->settings, "changed::show-all-files-except", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->settings, "changed::show-hidden-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	g_signal_connect_object (self->priv->settings, "changed::file-extensions", (GCallback) _file_browser_on_refresh_g_settings_changed, self, 0);
	_tmp1_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	_g_object_unref0 (self->priv->latex_settings);
	self->priv->latex_settings = _tmp1_;
	g_signal_connect_object (self->priv->latex_settings, "changed::clean-extensions", (GCallback) _file_browser_on_refresh_g_settings_changed, self, 0);
}


static gboolean _lambda67_ (FileBrowser* self) {
	gboolean result = FALSE;
	self->priv->timeout_id = (guint) 0;
	file_browser_refresh (self);
	result = FALSE;
	return result;
}


static gboolean __lambda67__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda67_ (self);
	return result;
}


static void file_browser_on_refresh (FileBrowser* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id != 0) {
		g_source_remove (self->priv->timeout_id);
	}
	_tmp0_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, __lambda67__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->timeout_id = _tmp0_;
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_g_object_unref0 (_data14_->self);
		_g_object_unref0 (_data14_->jump_button);
		g_slice_free (Block14Data, _data14_);
	}
}


static void _lambda60_ (FileBrowser* self) {
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* home_dir;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	home_dir = _tmp1_;
	file_browser_fill_stores_with_dir (self, home_dir);
	_g_object_unref0 (home_dir);
}


static void __lambda60__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda60_ (self);
}


static void _lambda61_ (FileBrowser* self) {
	GFile* _tmp0_ = NULL;
	GFile* parent;
	_tmp0_ = g_file_get_parent (self->priv->current_directory);
	parent = _tmp0_;
	g_return_if_fail (parent != NULL);
	file_browser_fill_stores_with_dir (self, parent);
	_g_object_unref0 (parent);
}


static void __lambda61__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda61_ (self);
}


static void _lambda62_ (FileBrowser* self) {
	gboolean _tmp0_ = FALSE;
	DocumentTab* _tmp1_ = NULL;
	Document* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_;
	_tmp1_ = main_window_get_active_tab (self->priv->main_window);
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Document* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		_tmp2_ = main_window_get_active_document (self->priv->main_window);
		_tmp3_ = document_get_location (_tmp2_);
		_tmp0_ = _tmp3_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = main_window_get_active_document (self->priv->main_window);
	_tmp5_ = document_get_location (_tmp4_);
	_tmp6_ = g_file_get_parent (_tmp5_);
	_tmp7_ = _tmp6_;
	file_browser_fill_stores_with_dir (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
}


static void __lambda62__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda62_ (self);
}


static void _lambda64_ (Block14Data* _data14_) {
	FileBrowser * self;
	self = _data14_->self;
	file_browser_update_jump_button_sensitivity (self, _data14_->jump_button);
}


static void __lambda64__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda64_ (self);
}


static void _lambda63_ (Block14Data* _data14_) {
	FileBrowser * self;
	Document* _tmp0_ = NULL;
	self = _data14_->self;
	file_browser_update_jump_button_sensitivity (self, _data14_->jump_button);
	_tmp0_ = main_window_get_active_document (self->priv->main_window);
	if (_tmp0_ != NULL) {
		Document* _tmp1_ = NULL;
		_tmp1_ = main_window_get_active_document (self->priv->main_window);
		g_signal_connect_data ((GObject*) _tmp1_, "notify::location", (GCallback) __lambda64__g_object_notify, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	}
}


static void __lambda63__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda63_ (self);
}


static void _file_browser_refresh_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	file_browser_refresh (self);
}


static void file_browser_init_toolbar (FileBrowser* self) {
	Block14Data* _data14_;
	GtkHBox* _tmp0_ = NULL;
	GtkHBox* hbox;
	GtkButton* _tmp1_ = NULL;
	GtkButton* home_button;
	GtkButton* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkButton* refresh_button;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = (GtkHBox*) gtk_hbox_new (TRUE, 0);
	hbox = g_object_ref_sink (_tmp0_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp1_ = utils_get_toolbar_button (GTK_STOCK_HOME);
	home_button = _tmp1_;
	_tmp2_ = utils_get_toolbar_button (GTK_STOCK_GO_UP);
	_g_object_unref0 (self->priv->parent_button);
	self->priv->parent_button = _tmp2_;
	_tmp3_ = utils_get_toolbar_button (GTK_STOCK_JUMP_TO);
	_data14_->jump_button = _tmp3_;
	_tmp4_ = utils_get_toolbar_button (GTK_STOCK_REFRESH);
	refresh_button = _tmp4_;
	_tmp5_ = _ ("Go to the home directory");
	gtk_widget_set_tooltip_text ((GtkWidget*) home_button, _tmp5_);
	_tmp6_ = _ ("Go to the parent directory");
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->parent_button, _tmp6_);
	_tmp7_ = _ ("Go to the active document directory");
	gtk_widget_set_tooltip_text ((GtkWidget*) _data14_->jump_button, _tmp7_);
	_tmp8_ = _ ("Refresh");
	gtk_widget_set_tooltip_text ((GtkWidget*) refresh_button, _tmp8_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) home_button, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->parent_button, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) _data14_->jump_button, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) refresh_button, TRUE, TRUE, (guint) 0);
	g_signal_connect_object (home_button, "clicked", (GCallback) __lambda60__gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->parent_button, "clicked", (GCallback) __lambda61__gtk_button_clicked, self, 0);
	g_signal_connect_object (_data14_->jump_button, "clicked", (GCallback) __lambda62__gtk_button_clicked, self, 0);
	g_signal_connect_data ((GObject*) self->priv->main_window, "notify::active-document", (GCallback) __lambda63__g_object_notify, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	g_signal_connect_object (refresh_button, "clicked", (GCallback) _file_browser_refresh_gtk_button_clicked, self, 0);
	_g_object_unref0 (refresh_button);
	_g_object_unref0 (home_button);
	_g_object_unref0 (hbox);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}


static void file_browser_update_jump_button_sensitivity (FileBrowser* self, GtkButton* jump_button) {
	gboolean _tmp0_ = FALSE;
	DocumentTab* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (jump_button != NULL);
	_tmp1_ = main_window_get_active_tab (self->priv->main_window);
	if (_tmp1_ != NULL) {
		Document* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		_tmp2_ = main_window_get_active_document (self->priv->main_window);
		_tmp3_ = document_get_location (_tmp2_);
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	gtk_widget_set_sensitive ((GtkWidget*) jump_button, _tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda65_ (FileBrowser* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	_tmp1_ = gtk_combo_box_get_active_iter (self->priv->combo_box, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		GtkTreeModel* _tmp2_ = NULL;
		GtkTreeModel* _tmp3_;
		GtkTreeModel* model;
		GFile* file = NULL;
		gboolean _tmp4_;
		_tmp2_ = gtk_combo_box_get_model (self->priv->combo_box);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		model = _tmp3_;
		gtk_tree_model_get (model, &iter, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, &file, -1, -1);
		_tmp4_ = g_file_equal (file, self->priv->current_directory);
		if (!_tmp4_) {
			file_browser_fill_stores_with_dir (self, file);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (model);
	}
}


static void __lambda65__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	_lambda65_ (self);
}


static void file_browser_init_combo_box (FileBrowser* self) {
	GtkListStore* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	GtkCellRendererText* _tmp2_ = NULL;
	GtkCellRendererText* text_renderer;
	GtkCellRendererPixbuf* _tmp3_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_FILE);
	_g_object_unref0 (self->priv->parent_dir_store);
	self->priv->parent_dir_store = _tmp0_;
	_tmp1_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) self->priv->parent_dir_store);
	_g_object_unref0 (self->priv->combo_box);
	self->priv->combo_box = g_object_ref_sink (_tmp1_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->combo_box, FALSE, FALSE, (guint) 0);
	_tmp2_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text_renderer = g_object_ref_sink (_tmp2_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) text_renderer, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_PARENT_DIR_COLUMN_INDENT, NULL, NULL);
	_tmp3_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	pixbuf_renderer = g_object_ref_sink (_tmp3_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) pixbuf_renderer, "stock-id", FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, NULL, NULL);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (text_renderer);
	text_renderer = g_object_ref_sink (_tmp4_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combo_box, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_PARENT_DIR_COLUMN_NAME, NULL, NULL);
	g_object_set (text_renderer, "ellipsize-set", TRUE, NULL);
	g_object_set (text_renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	g_signal_connect_object (self->priv->combo_box, "changed", (GCallback) __lambda65__gtk_combo_box_changed, self, 0);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (text_renderer);
}


static gint _file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = file_browser_on_sort (self, model, a, b);
	return result;
}


static void _lambda66_ (GtkTreePath* path, FileBrowser* self) {
	GtkTreeModel* _tmp0_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* basename = NULL;
	gboolean is_dir = FALSE;
	GFile* _tmp3_ = NULL;
	GFile* file;
	BuildTools* _tmp4_ = NULL;
	BuildTools* build_tools;
	gchar* _tmp5_ = NULL;
	gchar* extension;
	DocType doc_type = 0;
	const gchar* _tmp6_;
	GQuark _tmp7_;
	static GQuark _tmp7__label0 = 0;
	static GQuark _tmp7__label1 = 0;
	static GQuark _tmp7__label2 = 0;
	BuildTool* _tmp10_ = NULL;
	BuildTool* tool;
	GtkAction* _tmp11_ = NULL;
	GtkAction* _tmp12_;
	BuildToolRunner* _tmp13_ = NULL;
	BuildToolRunner* _tmp14_;
	g_return_if_fail (path != NULL);
	_tmp0_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->list_store));
	model = _tmp0_;
	_tmp2_ = gtk_tree_model_get_iter (model, &_tmp1_, path);
	iter = _tmp1_;
	if (!_tmp2_) {
		_g_object_unref0 (model);
		return;
	}
	gtk_tree_model_get (model, &iter, FILE_BROWSER_FILE_COLUMN_NAME, &basename, FILE_BROWSER_FILE_COLUMN_IS_DIR, &is_dir, -1, -1);
	_tmp3_ = g_file_get_child (self->priv->current_directory, basename);
	file = _tmp3_;
	if (is_dir) {
		file_browser_fill_stores_with_dir (self, file);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		return;
	}
	_tmp4_ = build_tools_get_default ();
	build_tools = _tmp4_;
	_tmp5_ = utils_get_extension (basename);
	extension = _tmp5_;
	_tmp6_ = extension;
	_tmp7_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
	if (_tmp7_ == ((0 != _tmp7__label0) ? _tmp7__label0 : (_tmp7__label0 = g_quark_from_static_string (".dvi")))) {
		switch (0) {
			default:
			{
				doc_type = DOC_TYPE_DVI;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp7__label1) ? _tmp7__label1 : (_tmp7__label1 = g_quark_from_static_string (".pdf")))) {
		switch (0) {
			default:
			{
				doc_type = DOC_TYPE_PDF;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp7__label2) ? _tmp7__label2 : (_tmp7__label2 = g_quark_from_static_string (".ps")))) {
		switch (0) {
			default:
			{
				doc_type = DOC_TYPE_PS;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				DocumentTab* _tmp8_ = NULL;
				DocumentTab* _tmp9_;
				_tmp8_ = main_window_open_document (self->priv->main_window, file, TRUE);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (_tmp9_);
				_g_free0 (extension);
				_build_tools_unref0 (build_tools);
				_g_object_unref0 (file);
				_g_free0 (basename);
				_g_object_unref0 (model);
				return;
			}
		}
	}
	_tmp10_ = build_tools_get_view_doc (build_tools, doc_type);
	tool = _tmp10_;
	if (tool == NULL) {
		g_warning ("file_browser.vala:290: There is no build tool to view the file '%s'", basename);
		_build_tool_free0 (tool);
		_g_free0 (extension);
		_build_tools_unref0 (build_tools);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		return;
	}
	_tmp11_ = main_window_get_action_stop_exec (self->priv->main_window);
	_tmp12_ = _tmp11_;
	_tmp13_ = build_tool_runner_new (file, tool, self->priv->build_view, _tmp12_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (_tmp12_);
	_build_tool_free0 (tool);
	_g_free0 (extension);
	_build_tools_unref0 (build_tools);
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_object_unref0 (model);
}


static void __lambda66__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	_lambda66_ (path, self);
}


static void file_browser_init_list (FileBrowser* self) {
	GtkListStore* _tmp0_ = NULL;
	GtkTreeView* _tmp1_ = NULL;
	GtkTreeViewColumn* _tmp2_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererPixbuf* _tmp3_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp4_ = NULL;
	GtkCellRendererText* text_renderer;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* sw;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_FILE_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
	_g_object_unref0 (self->priv->list_store);
	self->priv->list_store = _tmp0_;
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self->priv->list_store, 0, _file_browser_on_sort_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self->priv->list_store, 0, GTK_SORT_ASCENDING);
	_tmp1_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->list_store);
	_g_object_unref0 (self->priv->_list_view);
	self->priv->_list_view = g_object_ref_sink (_tmp1_);
	gtk_tree_view_set_headers_visible (self->priv->_list_view, FALSE);
	_tmp2_ = gtk_tree_view_column_new ();
	column = g_object_ref_sink (_tmp2_);
	gtk_tree_view_append_column (self->priv->_list_view, column);
	_tmp3_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	pixbuf_renderer = g_object_ref_sink (_tmp3_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "stock-id", FILE_BROWSER_FILE_COLUMN_PIXBUF, NULL, NULL);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text_renderer = g_object_ref_sink (_tmp4_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_FILE_COLUMN_NAME, NULL, NULL);
	_tmp5_ = utils_add_scrollbar ((GtkWidget*) self->priv->_list_view);
	sw = _tmp5_;
	gtk_box_pack_start ((GtkBox*) self, sw, TRUE, TRUE, (guint) 0);
	g_signal_connect_object (self->priv->_list_view, "row-activated", (GCallback) __lambda66__gtk_tree_view_row_activated, self, 0);
	_g_object_unref0 (sw);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
}


void file_browser_refresh (FileBrowser* self) {
	g_return_if_fail (self != NULL);
	file_browser_fill_stores_with_dir (self, self->priv->current_directory);
}


void file_browser_refresh_for_document (FileBrowser* self, Document* doc) {
	Project* _tmp0_ = NULL;
	Project* project;
	GFile* _tmp7_;
	GFile* project_dir;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = document_get_project (doc);
	project = _tmp0_;
	if (project == NULL) {
		gboolean _tmp1_ = FALSE;
		GFile* _tmp2_ = NULL;
		_tmp2_ = document_get_location (doc);
		if (_tmp2_ != NULL) {
			GFile* _tmp3_ = NULL;
			GFile* _tmp4_ = NULL;
			GFile* _tmp5_;
			gboolean _tmp6_;
			_tmp3_ = document_get_location (doc);
			_tmp4_ = g_file_get_parent (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_file_equal (self->priv->current_directory, _tmp5_);
			_tmp1_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			file_browser_refresh (self);
		}
		_project_free0 (project);
		return;
	}
	_tmp7_ = _g_object_ref0 ((*project).directory);
	project_dir = _tmp7_;
	_tmp9_ = g_file_equal (self->priv->current_directory, project_dir);
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp10_;
		_tmp10_ = g_file_has_prefix (self->priv->current_directory, project_dir);
		_tmp8_ = _tmp10_;
	}
	if (_tmp8_) {
		file_browser_refresh (self);
	}
	_g_object_unref0 (project_dir);
	_project_free0 (project);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void file_browser_fill_stores_with_dir (FileBrowser* self, GFile* dir) {
	GFile* _tmp0_;
	GFile* directory;
	GFileEnumerator* _tmp11_ = NULL;
	GFileEnumerator* enumerator;
	gboolean _tmp12_;
	gboolean show_all;
	gboolean _tmp13_;
	gboolean show_all_except;
	gboolean _tmp14_ = FALSE;
	gboolean show_hidden;
	gchar* _tmp16_ = NULL;
	gchar* exts;
	gchar** _tmp17_;
	gchar** _tmp18_ = NULL;
	gchar** extensions;
	gint extensions_length1;
	gint _extensions_size_;
	gchar* _tmp19_ = NULL;
	gchar** _tmp20_;
	gchar** _tmp21_ = NULL;
	gchar** clean_extensions;
	gint clean_extensions_length1;
	gint _clean_extensions_size_;
	GList* parent_dirs;
	GFile* _tmp46_;
	GFile* _tmp47_;
	GFile* current_dir;
	GtkTreeIter _tmp51_ = {0};
	GtkTreeIter iter;
	gint i;
	GFile* _tmp65_;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_;
	GFile* _tmp68_ = NULL;
	GFile* _tmp69_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_list_store_clear (self->priv->list_store);
	gtk_list_store_clear (self->priv->parent_dir_store);
	gtk_tree_view_columns_autosize (self->priv->_list_view);
	_tmp0_ = _g_object_ref0 (dir);
	directory = _tmp0_;
	if (directory == NULL) {
		gchar* _tmp1_ = NULL;
		gchar* uri;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp1_ = g_settings_get_string (self->priv->settings, "current-directory");
		uri = _tmp1_;
		if (uri != NULL) {
			gint _tmp3_;
			_tmp3_ = strlen (uri);
			_tmp2_ = _tmp3_ > 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GFile* _tmp4_ = NULL;
			_tmp4_ = g_file_new_for_uri (uri);
			_g_object_unref0 (directory);
			directory = _tmp4_;
		}
		if (uri == NULL) {
			_tmp6_ = TRUE;
		} else {
			gint _tmp7_;
			_tmp7_ = strlen (uri);
			_tmp6_ = _tmp7_ == 0;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			gboolean _tmp8_;
			_tmp8_ = g_file_query_exists (directory, NULL);
			_tmp5_ = !_tmp8_;
		}
		if (_tmp5_) {
			const gchar* _tmp9_ = NULL;
			GFile* _tmp10_ = NULL;
			_tmp9_ = g_get_home_dir ();
			_tmp10_ = g_file_new_for_path (_tmp9_);
			_g_object_unref0 (directory);
			directory = _tmp10_;
		}
		_g_free0 (uri);
	}
	_tmp11_ = g_file_enumerate_children (directory, "standard::type,standard::display-name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	enumerator = _tmp11_;
	if (_inner_error_ != NULL) {
		goto __catch31_g_error;
	}
	_tmp12_ = g_settings_get_boolean (self->priv->settings, "show-all-files");
	show_all = _tmp12_;
	_tmp13_ = g_settings_get_boolean (self->priv->settings, "show-all-files-except");
	show_all_except = _tmp13_;
	if (show_all) {
		gboolean _tmp15_;
		_tmp15_ = g_settings_get_boolean (self->priv->settings, "show-hidden-files");
		_tmp14_ = _tmp15_;
	} else {
		_tmp14_ = FALSE;
	}
	show_hidden = _tmp14_;
	_tmp16_ = g_settings_get_string (self->priv->settings, "file-extensions");
	exts = _tmp16_;
	_tmp18_ = _tmp17_ = g_strsplit (exts, " ", 0);
	extensions = _tmp18_;
	extensions_length1 = _vala_array_length (_tmp17_);
	_extensions_size_ = _vala_array_length (_tmp17_);
	_tmp19_ = g_settings_get_string (self->priv->latex_settings, "clean-extensions");
	_g_free0 (exts);
	exts = _tmp19_;
	_tmp21_ = _tmp20_ = g_strsplit (exts, " ", 0);
	clean_extensions = _tmp21_;
	clean_extensions_length1 = _vala_array_length (_tmp20_);
	_clean_extensions_size_ = _vala_array_length (_tmp20_);
	{
		GFileInfo* _tmp22_ = NULL;
		GFileInfo* info;
		_tmp22_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
		info = _tmp22_;
		if (_inner_error_ != NULL) {
			clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
			extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exts);
			_g_object_unref0 (enumerator);
			goto __catch31_g_error;
		}
		{
			gboolean _tmp23_;
			_tmp23_ = TRUE;
			while (TRUE) {
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				gchar* basename;
				gboolean _tmp28_ = FALSE;
				gchar _tmp29_;
				GFileType _tmp30_;
				GFileType type;
				gchar* _tmp31_ = NULL;
				gchar* extension;
				gboolean _tmp32_ = FALSE;
				gboolean _tmp33_ = FALSE;
				gboolean _tmp34_ = FALSE;
				if (!_tmp23_) {
					GFileInfo* _tmp24_ = NULL;
					GFileInfo* _tmp25_;
					_tmp24_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
					_tmp25_ = _tmp24_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (info);
						clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
						extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (exts);
						_g_object_unref0 (enumerator);
						goto __catch31_g_error;
					}
					_g_object_unref0 (info);
					info = _tmp25_;
				}
				_tmp23_ = FALSE;
				if (!(info != NULL)) {
					break;
				}
				_tmp26_ = g_file_info_get_display_name (info);
				_tmp27_ = g_strdup (_tmp26_);
				basename = _tmp27_;
				_tmp29_ = string_get (basename, (glong) 0);
				if (_tmp29_ == '.') {
					_tmp28_ = !show_hidden;
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					_g_free0 (basename);
					continue;
				}
				_tmp30_ = g_file_info_get_file_type (info);
				type = _tmp30_;
				if (type == G_FILE_TYPE_DIRECTORY) {
					file_browser_insert_file (self, TRUE, GTK_STOCK_DIRECTORY, basename);
					_g_free0 (basename);
					continue;
				}
				_tmp31_ = utils_get_extension (basename);
				extension = _tmp31_;
				if (show_all) {
					_tmp34_ = !show_all_except;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					_tmp33_ = TRUE;
				} else {
					gboolean _tmp35_ = FALSE;
					if (show_all) {
						_tmp35_ = !_vala_string_array_contains (clean_extensions, clean_extensions_length1, extension);
					} else {
						_tmp35_ = FALSE;
					}
					_tmp33_ = _tmp35_;
				}
				if (_tmp33_) {
					_tmp32_ = TRUE;
				} else {
					_tmp32_ = _vala_string_array_contains (extensions, extensions_length1, extension);
				}
				if (_tmp32_) {
					gchar* pixbuf = NULL;
					const gchar* _tmp36_;
					GQuark _tmp37_;
					static GQuark _tmp37__label0 = 0;
					static GQuark _tmp37__label1 = 0;
					static GQuark _tmp37__label2 = 0;
					static GQuark _tmp37__label3 = 0;
					static GQuark _tmp37__label4 = 0;
					static GQuark _tmp37__label5 = 0;
					static GQuark _tmp37__label6 = 0;
					static GQuark _tmp37__label7 = 0;
					static GQuark _tmp37__label8 = 0;
					static GQuark _tmp37__label9 = 0;
					static GQuark _tmp37__label10 = 0;
					static GQuark _tmp37__label11 = 0;
					_tmp36_ = extension;
					_tmp37_ = (NULL == _tmp36_) ? 0 : g_quark_from_string (_tmp36_);
					if (_tmp37_ == ((0 != _tmp37__label0) ? _tmp37__label0 : (_tmp37__label0 = g_quark_from_static_string (".tex")))) {
						switch (0) {
							default:
							{
								gchar* _tmp38_;
								_tmp38_ = g_strdup (GTK_STOCK_EDIT);
								_g_free0 (pixbuf);
								pixbuf = _tmp38_;
								break;
							}
						}
					} else if (_tmp37_ == ((0 != _tmp37__label1) ? _tmp37__label1 : (_tmp37__label1 = g_quark_from_static_string (".pdf")))) {
						switch (0) {
							default:
							{
								gchar* _tmp39_;
								_tmp39_ = g_strdup ("view_pdf");
								_g_free0 (pixbuf);
								pixbuf = _tmp39_;
								break;
							}
						}
					} else if (_tmp37_ == ((0 != _tmp37__label2) ? _tmp37__label2 : (_tmp37__label2 = g_quark_from_static_string (".dvi")))) {
						switch (0) {
							default:
							{
								gchar* _tmp40_;
								_tmp40_ = g_strdup ("view_dvi");
								_g_free0 (pixbuf);
								pixbuf = _tmp40_;
								break;
							}
						}
					} else if ((_tmp37_ == ((0 != _tmp37__label3) ? _tmp37__label3 : (_tmp37__label3 = g_quark_from_static_string (".ps")))) || (_tmp37_ == ((0 != _tmp37__label4) ? _tmp37__label4 : (_tmp37__label4 = g_quark_from_static_string (".eps"))))) {
						switch (0) {
							default:
							{
								gchar* _tmp41_;
								_tmp41_ = g_strdup ("view_ps");
								_g_free0 (pixbuf);
								pixbuf = _tmp41_;
								break;
							}
						}
					} else if (((((((_tmp37_ == ((0 != _tmp37__label5) ? _tmp37__label5 : (_tmp37__label5 = g_quark_from_static_string (".png")))) || (_tmp37_ == ((0 != _tmp37__label6) ? _tmp37__label6 : (_tmp37__label6 = g_quark_from_static_string (".jpg"))))) || (_tmp37_ == ((0 != _tmp37__label7) ? _tmp37__label7 : (_tmp37__label7 = g_quark_from_static_string (".jpeg"))))) || (_tmp37_ == ((0 != _tmp37__label8) ? _tmp37__label8 : (_tmp37__label8 = g_quark_from_static_string (".gif"))))) || (_tmp37_ == ((0 != _tmp37__label9) ? _tmp37__label9 : (_tmp37__label9 = g_quark_from_static_string (".bmp"))))) || (_tmp37_ == ((0 != _tmp37__label10) ? _tmp37__label10 : (_tmp37__label10 = g_quark_from_static_string (".tif"))))) || (_tmp37_ == ((0 != _tmp37__label11) ? _tmp37__label11 : (_tmp37__label11 = g_quark_from_static_string (".tiff"))))) {
						switch (0) {
							default:
							{
								gchar* _tmp42_;
								_tmp42_ = g_strdup ("image");
								_g_free0 (pixbuf);
								pixbuf = _tmp42_;
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								gchar* _tmp43_;
								_tmp43_ = g_strdup (GTK_STOCK_FILE);
								_g_free0 (pixbuf);
								pixbuf = _tmp43_;
								break;
							}
						}
					}
					file_browser_insert_file (self, FALSE, pixbuf, basename);
					_g_free0 (pixbuf);
				}
				_g_free0 (extension);
				_g_free0 (basename);
			}
		}
		_g_object_unref0 (info);
	}
	gtk_tree_sortable_sort_column_changed ((GtkTreeSortable*) self->priv->list_store);
	clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (exts);
	_g_object_unref0 (enumerator);
	goto __finally31;
	__catch31_g_error:
	{
		GError * e;
		const gchar* _tmp44_ = NULL;
		GtkMessageDialog* _tmp45_ = NULL;
		GtkMessageDialog* dialog;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("file_browser.vala:431: %s", e->message);
		_tmp44_ = _ ("File Browser");
		_tmp45_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self->priv->main_window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_CLOSE, _tmp44_);
		dialog = g_object_ref_sink (_tmp45_);
		gtk_message_dialog_format_secondary_text (dialog, "%s", e->message, NULL);
		gtk_dialog_run ((GtkDialog*) dialog);
		gtk_object_destroy ((GtkObject*) dialog);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
		_g_object_unref0 (directory);
		return;
	}
	__finally31:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	parent_dirs = NULL;
	_tmp46_ = _g_object_ref0 (directory);
	parent_dirs = g_list_prepend (parent_dirs, _tmp46_);
	_tmp47_ = _g_object_ref0 (directory);
	current_dir = _tmp47_;
	while (TRUE) {
		GFile* _tmp48_ = NULL;
		GFile* parent;
		GFile* _tmp49_;
		GFile* _tmp50_;
		_tmp48_ = g_file_get_parent (current_dir);
		parent = _tmp48_;
		if (parent == NULL) {
			_g_object_unref0 (parent);
			break;
		}
		_tmp49_ = _g_object_ref0 (parent);
		parent_dirs = g_list_prepend (parent_dirs, _tmp49_);
		_tmp50_ = _g_object_ref0 (parent);
		_g_object_unref0 (current_dir);
		current_dir = _tmp50_;
		_g_object_unref0 (parent);
	}
	iter = _tmp51_;
	i = 0;
	{
		GList* current_collection;
		GList* current_it;
		current_collection = parent_dirs;
		for (current_it = current_collection; current_it != NULL; current_it = current_it->next) {
			GFile* _tmp52_;
			GFile* current;
			_tmp52_ = _g_object_ref0 ((GFile*) current_it->data);
			current = _tmp52_;
			{
				gchar* basename = NULL;
				gchar* _tmp56_ = NULL;
				gchar* indent;
				gchar* pixbuf = NULL;
				GtkTreeIter _tmp64_ = {0};
				if (i == 0) {
					const gchar* _tmp53_ = NULL;
					gchar* _tmp54_;
					_tmp53_ = _ ("File System");
					_tmp54_ = g_strdup (_tmp53_);
					_g_free0 (basename);
					basename = _tmp54_;
				} else {
					gchar* _tmp55_ = NULL;
					_tmp55_ = g_file_get_basename (current);
					_g_free0 (basename);
					basename = _tmp55_;
				}
				_tmp56_ = g_strnfill ((gsize) (i * 2), ' ');
				indent = _tmp56_;
				if (i == 0) {
					gchar* _tmp57_;
					_tmp57_ = g_strdup (GTK_STOCK_HARDDISK);
					_g_free0 (pixbuf);
					pixbuf = _tmp57_;
				} else {
					const gchar* _tmp58_ = NULL;
					gchar* _tmp59_ = NULL;
					gchar* _tmp60_;
					gboolean _tmp61_;
					_tmp58_ = g_get_home_dir ();
					_tmp59_ = g_file_get_path (current);
					_tmp60_ = _tmp59_;
					_tmp61_ = g_strcmp0 (_tmp58_, _tmp60_) == 0;
					_g_free0 (_tmp60_);
					if (_tmp61_) {
						gchar* _tmp62_;
						_tmp62_ = g_strdup (GTK_STOCK_HOME);
						_g_free0 (pixbuf);
						pixbuf = _tmp62_;
					} else {
						gchar* _tmp63_;
						_tmp63_ = g_strdup (GTK_STOCK_DIRECTORY);
						_g_free0 (pixbuf);
						pixbuf = _tmp63_;
					}
				}
				gtk_list_store_append (self->priv->parent_dir_store, &_tmp64_);
				iter = _tmp64_;
				gtk_list_store_set (self->priv->parent_dir_store, &iter, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, current, FILE_BROWSER_PARENT_DIR_COLUMN_INDENT, indent, FILE_BROWSER_PARENT_DIR_COLUMN_NAME, basename, FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, pixbuf, -1, -1);
				i++;
				_g_free0 (pixbuf);
				_g_free0 (indent);
				_g_free0 (basename);
				_g_object_unref0 (current);
			}
		}
	}
	_tmp65_ = _g_object_ref0 (directory);
	_g_object_unref0 (self->priv->current_directory);
	self->priv->current_directory = _tmp65_;
	_tmp66_ = g_file_get_uri (directory);
	_tmp67_ = _tmp66_;
	g_settings_set_string (self->priv->settings, "current-directory", _tmp67_);
	_g_free0 (_tmp67_);
	gtk_combo_box_set_active_iter (self->priv->combo_box, &iter);
	_tmp68_ = g_file_get_parent (directory);
	_tmp69_ = _tmp68_;
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->parent_button, _tmp69_ != NULL);
	_g_object_unref0 (_tmp69_);
	_g_object_unref0 (current_dir);
	__g_list_free__g_object_unref0_0 (parent_dirs);
	_g_object_unref0 (directory);
}


static void file_browser_insert_file (FileBrowser* self, gboolean is_dir, const gchar* pixbuf, const gchar* basename) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	g_return_if_fail (basename != NULL);
	gtk_list_store_append (self->priv->list_store, &_tmp0_);
	iter = _tmp0_;
	gtk_list_store_set (self->priv->list_store, &iter, FILE_BROWSER_FILE_COLUMN_IS_DIR, is_dir, FILE_BROWSER_FILE_COLUMN_PIXBUF, pixbuf, FILE_BROWSER_FILE_COLUMN_NAME, basename, -1, -1);
}


static gint file_browser_on_sort (FileBrowser* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	gboolean a_is_dir = FALSE;
	gboolean b_is_dir = FALSE;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	gtk_tree_model_get (model, a, FILE_BROWSER_FILE_COLUMN_IS_DIR, &a_is_dir, -1, -1);
	gtk_tree_model_get (model, b, FILE_BROWSER_FILE_COLUMN_IS_DIR, &b_is_dir, -1, -1);
	if (a_is_dir == b_is_dir) {
		gchar* a_name = NULL;
		gchar* b_name = NULL;
		gint _tmp0_;
		gtk_tree_model_get (model, a, FILE_BROWSER_FILE_COLUMN_NAME, &a_name, -1, -1);
		gtk_tree_model_get (model, b, FILE_BROWSER_FILE_COLUMN_NAME, &b_name, -1, -1);
		_tmp0_ = g_utf8_collate (a_name, b_name);
		result = _tmp0_;
		_g_free0 (b_name);
		_g_free0 (a_name);
		return result;
	}
	if (a_is_dir) {
		_tmp1_ = -1;
	} else {
		_tmp1_ = +1;
	}
	result = _tmp1_;
	return result;
}


static void file_browser_class_init (FileBrowserClass * klass) {
	file_browser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FileBrowserPrivate));
	G_OBJECT_CLASS (klass)->finalize = file_browser_finalize;
}


static void file_browser_instance_init (FileBrowser * self) {
	self->priv = FILE_BROWSER_GET_PRIVATE (self);
	self->priv->timeout_id = (guint) 0;
}


static void file_browser_finalize (GObject* obj) {
	FileBrowser * self;
	self = FILE_BROWSER (obj);
	_g_object_unref0 (self->priv->build_view);
	_g_object_unref0 (self->priv->parent_dir_store);
	_g_object_unref0 (self->priv->list_store);
	_g_object_unref0 (self->priv->_list_view);
	_g_object_unref0 (self->priv->combo_box);
	_g_object_unref0 (self->priv->current_directory);
	_g_object_unref0 (self->priv->parent_button);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->latex_settings);
	G_OBJECT_CLASS (file_browser_parent_class)->finalize (obj);
}


GType file_browser_get_type (void) {
	static volatile gsize file_browser_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FileBrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_browser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileBrowser), 0, (GInstanceInitFunc) file_browser_instance_init, NULL };
		GType file_browser_type_id;
		file_browser_type_id = g_type_register_static (GTK_TYPE_VBOX, "FileBrowser", &g_define_type_info, 0);
		g_once_init_leave (&file_browser_type_id__volatile, file_browser_type_id);
	}
	return file_browser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



