%%% an article-like class using memoir for typesetting documents especially in Korean.
%%%  KC 2007 version.
%%%
%%% (c) 2006,2007 Karnes Kim
%%%  public domain.
%%%
\ProvidesClass{oblivoir}
  [2007/07/05 v0.2.4a article-like class to typeset UTF-8 korean.]
\typeout{oblivoir requires memoir, dhucs, and memhangul. 2007/07/05.}

%%% Acknowledgements:
%%% Many thanks to
%%%   ischo who provided a computer, place and time for developing and testing.
%%%   smcho, ischo, synapse and beomsukhyun who requested functional improvements.
%%%   progress who wrote a nice introductory document.
%%%   and all the people who does or does not use this class.
%%%
%%% Options:
%%% nokorean : 영문용
%%% twoside : twoside
%%% openright
%%% kosection : 절 표제항의 한글화
%%% nobookmarks : 북마크 만들지 않음
%%% dvips : dvips 작업용 옵션
%%% 10.5pt : 10.5pt 본문 폰트 사이즈.
%%% footnote : 한글식 각주 모양 사용.
%%% tocentry : toc 등을 한 수준 위에서 처리.
%%% itemph : 강조를 itshape로 처리함.
%%% finemath : pass finemath option to dhucs. made default.
%%% nofinemath : no finemath.
%%% strictcharcheck : strictcharcheck to dhucs.
%%% microtype : load microtype and apply margin-kerning & font-expansion
%%% romanfixed : 10.5pt 옵션 사용시 영문 글꼴은 10pt로 고정.
%%% 기타 옵션 : memoir 옵션 사용.
%%% default는 oneside, openany, kosection false, pdfbookmark임.
%%% 
%%% 한글 폰트 관련:
%%% [dvips] : unfonts-type1 (ut**)
%%% pdftex : unfonts-type1 (ut**)
%%% latex -> dvipdfmx : unfonts (un**)
%%%
\newif\ifnokorean\nokoreanfalse
\DeclareOption{nokorean}{\nokoreantrue}
\newif\iftwosidedoc\twosidedocfalse
\DeclareOption{twoside}{\twosidedoctrue}
\newif\ifopenrightdoc\openrightdocfalse
\DeclareOption{openright}{\openrightdoctrue}
\newif\ifkosection\kosectionfalse
\DeclareOption{kosection}{\kosectiontrue}
\newif\ifnobookmarks\nobookmarksfalse
\DeclareOption{nobookmarks}{\nobookmarkstrue}
\newif\if@dvips\@dvipsfalse
\DeclareOption{dvips}{\@dvipstrue}
\newif\if@tendotfive\@tendotfivefalse
\DeclareOption{10.5pt}{\@tendotfivetrue}
\newif\if@koreanfn\@koreanfnfalse
\DeclareOption{footnote}{\@koreanfntrue}
\newif\if@toclofentry\@toclofentryfalse
\DeclareOption{tocentry}{\@toclofentrytrue}
\newif\if@itemph\@itemphfalse
\DeclareOption{itemph}{\@itemphtrue}
\newif\if@resizelatin\@resizelatintrue
\DeclareOption{romanfixed}{\@resizelatinfalse}
\newif\if@chapter\@chapterfalse
\DeclareOption{chapter}{\@chaptertrue\@toclofentrytrue}
\newif\if@finemath\@finemathtrue
\DeclareOption{finemath}{\@finemathtrue}
\DeclareOption{nofinemath}{\@finemathfalse}
\newif\if@microtype\@microtypefalse
\DeclareOption{microtype}{\@microtypetrue}
\DeclareOption{strictcharcheck}{\PassOptionsToPackage{\CurrentOption}{memhangul-ucs}}
\DeclareOption*{%
 \PassOptionsToClass{\CurrentOption}{memoir}%
}
\ProcessOptions

%%% dvips
\ifnokorean\else
\if@dvips
 \PassOptionsToPackage{dvips}{memhangul-ucs}
\fi\fi

%%% memoir/memhangul-ucs 로드.
\if@chapter
  \LoadClass[openany]{memoir}
\else
\iftwosidedoc
  \LoadClass[article,openany]{memoir}
\else
  \LoadClass[article,openany,oneside]{memoir}
\fi
\fi

%%%
\ifopenrightdoc\openright\fi
\newcommand\finemath@status{\if@finemath finemath\else\fi}
\ifnokorean\else
   \if@itemph
      \usepackage[nonfrench,interworddefault,hangulpagestyle,\finemath@status]{memhangul-ucs}
   \else
      \usepackage[nonfrench,interworddefault,hangulpagestyle,gremph,\finemath@status]{memhangul-ucs}
   \fi
\fi
\if@chapter\else
\counterwithout{section}{chapter}
\fi

%%% hfontspec
\ifnokorean\let\usehangulfontspec\@gobble\fi

%%% korean fontsettings
\ifnokorean\else
 \ifpdf
  \RequirePackage[ps]{hfontsel} % ut**를 기본 글꼴로
  \usehangulfontspec{obut}
  \pdfmapfile{=unttf-pdftex-dhucs.map} % 그래도 혹시 모르므로 
%%% dhucs-cmap은 여기서 로드한다.
  \RequirePackage{dhucs-cmap}  % ut**가 기본글꼴일 때는 disable?
  \input glyphtounicode\pdfgentounicode=1
 \else
  \if@dvips
   \RequirePackage[ps]{hfontsel} % ut**를 기본 글꼴로
   \usehangulfontspec{obut}
  \else
   \RequirePackage{hfontsel}   % 아무 옵션도 없다면 un**
   \usehangulfontspec{obun}
   \RequirePackage{dhucs-cmap} % un**일 때
  \fi
 \fi
\fi

%%% Gremph
\if@itemph\else
 \ifnokorean\else
  \ifpdf
   \SetGremphFonts{utgr}{utgt}
  \else 
   \if@dvips
    \SetGremphFonts{utgr}{utgt}
   \fi
  \fi
 \fi
\fi

%%% microtype
\ifpdf
 \if@microtype
  \RequirePackage[verbose=true]{microtype}
  \DeclareMicrotypeSet{dhucsmicro}{encoding=LUC}
  \UseMicrotypeSet[expansion]{dhucsmicro}
 \fi
\else
 \if@microtype
  \ClassWarningNoLine{oblivoir}{no pdflatex runs! microtype option is ignored.}{}
 \fi
\fi

%%% 기본 자간
\newdimen\ob@hu  % 1jw=.95em, 1hu=1/16jw. see hfontspec.oblivoir
\ifnokorean\ob@hu=\z@\else\ob@hu=\dhucs@hu\fi
% 기본 자간 설정은 hfontspec.obu{n/t}.
%%%\newdimen\ob@hangulglue\ob@hangulglue=-.55\ob@hu
%%%\interhchar{\ob@hangulglue}

\def\ob@DEFAULTskips{%
	\def\memucshangulskips{%
%		\interhchar{\ob@hangulglue}%
	}%
	\def\memucsinterwordskip{%
		\spaceskip = .390\BASE@FONTsize plus .1\BASE@FONTsize minus .1\BASE@FONTsize
		\if@nonfrench
		\xspaceskip = .432\BASE@FONTsize plus .11\BASE@FONTsize minus .1\BASE@FONTsize
		\fi
	}%
	\def\memucsinterwordchapterskip{%
		\spaceskip = .41\BASE@FONTsize plus .11\BASE@FONTsize minus .1\BASE@FONTsize
		\if@nonfrench
		\xspaceskip = .55\BASE@FONTsize plus .1\BASE@FONTsize minus .1\BASE@FONTsize
		\fi
	}%
}

\let\DEFAULTskips\ob@DEFAULTskips
\def\ob@thinthinspace{\hskip2\ob@hu}
\def\ob@onethirdspace{\hskip5\ob@hu}

\ifnokorean\else
\if@koreanfn
%%% footnote setting
%%% 99)에 해당하는 박스 길이를 구한 다음
\newsavebox\mytmpbox\sbox\mytmpbox{\footnotesize 99)\ }
%%% 각주 번호 박스를 길이에 대하여 오른쪽 정렬함. 두 자리
%%% 각주 번호 기준으로 오른쪽 정렬되도록 만든다.
\footmarkstyle{\makebox[\wd\mytmpbox][r]{#1)\ }}
\setlength\footmarksep{\wd\mytmpbox}
\setlength\footmarkwidth{0pt}
\setlength\footparindent{0pt}
%\ifnokorean\else
\SetFnmark{\textsuperscript}{\textsuperscript{)}}
%\fi
\fi\fi
%%% footnotes and floats. codes from memmanadd.pdf
\renewcommand*{\footnoterule}{\kern-3pt\vfill
  \hrule width 0.4\columnwidth \kern 2.6pt}
\setlength{\skip\footins}{1.3\onelineskip}

%%% toc 등의 레이아웃.
\if@chapter\else
\renewcommand\chaptitlefont{\Large\bfseries}
\renewcommand\printchapternonum{}
\renewcommand\printchaptertitle[1]{\chaptitlefont #1}
\renewcommand\afterchapskip{\onelineskip}
\renewcommand\beforechapskip{1.5\onelineskip}
\fi

\renewcommand\cftsectionindent{0pt}
\ifnokorean\else
\renewcommand\cftsectionnumwidth{1.8em}
\renewcommand\cftsubsectionindent{1.8em}
\renewcommand\cftsubsectionnumwidth{2.5em}
\fi
\if@chapter\else
\let\cftchapterindent\cftsectionindent
\let\cftchapternumwidth\cftsectionnumwidth
\let\cftbeforechapterskip\cftbeforesectionskip
\fi

\renewcommand\cftsectionpresnum{\hfill}
\renewcommand\cftsectionaftersnum{\hskip.8em}

%%% kscntformat
%%% HLaTeX의 \kscntformat 명령을 흉내냄
%%% \kscntformat{section}{제}{절} 형식으로 쓴다.
\newsavebox{\tmp@XXbox}
\newdimen\tmp@XXdim
\def\kscntformat#1#2#3{%
	\sbox{\tmp@XXbox}{#2\expandafter\number\csname c@#1\endcsname#3}%
	\setlength\tmp@XXdim{\wd\tmp@XXbox}\advance\tmp@XXdim by1em%
	\expandafter\def\csname the#1\endcsname{#2\expandafter\number\csname c@#1\endcsname#3}%
	\expandafter\renewcommand\csname cft#1numwidth\endcsname{\tmp@XXdim}%
	\expandafter\renewcommand\csname cft#1presnum\endcsname{}%
	\expandafter\renewcommand\csname cft#1aftersnum\endcsname{}%
}

\ifnokorean\else
\ifkosection
\kscntformat{section}{제\ob@onethirdspace}{\ob@onethirdspace 절}
\renewcommand\thesubsection{\arabic{section}.\arabic{subsection}}
\fi\fi

%%% misc settings
\raggedbottom
\ifnokorean
\renewcommand\sectionmark[1]{\markboth{\thetitle}{#1}}
\else
\renewcommand\sectionmark[1]{\markboth{\thetitle}{#1}}
\fi
%\renewcommand\subsectionmark[1]{\markright{#1}}
\ifnokorean
\newcommand*\MarkDocTitle{\markboth{\thetitle}{}}
\else
\newcommand*\MarkDocTitle{\markboth{\thetitle}{}}
\fi

%%% for bookmarks and hyperref
\def\CallHyperref{%
 \ifnobookmarks
   \@Call@Hyperref@Without@Bookmarks
 \else 
   \@Call@Hyperref@With@Bookmarks
 \fi
}

\def\@Call@Hyperref@Without@Bookmarks{%
 \ifpdf
  \usepackage[pdftex,unicode,bookmarks=false]{hyperref}
 \else
  \if@dvips
   \usepackage[dvips,unicode,bookmarks=false]{hyperref}
  \else
   \usepackage[dvipdfm,unicode,bookmarks=false]{hyperref}
  \fi
 \fi
}

\def\@Call@Hyperref@With@Bookmarks{%
 \ifpdf
  \usepackage[pdftex,unicode]{hyperref}
 \else
  \if@dvips
   \usepackage[dvips,unicode]{hyperref}
  \else
   \usepackage[dvipdfm,unicode]{hyperref}
  \fi
 \fi
}

\ifnokorean\relax\else\CallHyperref\fi

%%% \engtxt를 일일이 쓰기 귀찮고 space가 하나밖에 없을 때
%%% 쓰기 위한 \ensp 매크로.
\newskip\@ensp
\@ensp=.297em plus .02em minus .01em
\def\ensp{\hskip\@ensp}

%%% article의 pagestyle 기본값은 plain임.
\pagestyle{plain}

%%% 2006/09/01 \title, \author 문제. reported by IsCho
\AtBeginDocument{%
 \@ifundefined{thetitle}{\title{}}{\relax}
 \@ifundefined{theauthor}{\author{}}{\relax}
}

%%% 2006/09/05 [10.5pt] option, [romanfixed] 2006/10/22.
\if@tendotfive
  \RequirePackage{10_5}
  \if@resizelatin
    \RequirePackage{type1cm}
    \RequirePackage{type1ec}
  \fi
\fi

%%%% 2006/10/19. 현범석 님이 지적한 lof, toc 문제
\if@chapter\else
 \usepackage{ob-toclof}
\fi

%%% oblivoir-chapter (12/20)
\if@chapter
\newcommand\oblivoirchapterstyle[1]{%
 \chapterstyle{#1}
 \renewcommand{\chapterheadstart}{\clearforchapter\vspace*{\beforechapskip}}
}
\fi

%%%%%%%%%%%%% APPENDIX

\ifnokorean\def\appendixrefname{Appendix}\else\def\appendixrefname{부록}\fi
\def\appref#1{\appendixrefname~\ref{#1}}

\newif\if@AppendixTitleToToc\@AppendixTitleToTocfalse
\newif\if@AttachAppendixTitleToSecnum\@AttachAppendixTitleToSecnumfalse

\def\AppendixTitleToToc{%
 \@AppendixTitleToToctrue
}

\def\AttachAppendixTitleToSecnum{%
 \@AttachAppendixTitleToSecnumtrue
}

\def\AppendixTitle{%
 \chapter*{\appendixname}
}

\ifnokorean
\usepackage{ob-nokoreanappendix}
\else
\usepackage{ob-koreanappendix}
\fi

%%% modified from dhucs-enumerate.sty
\ifnokorean\else
\g@addto@macro\@enhook{%
  \ifx^^ea\@entemp  % 가,  
    \let\@memtempa\@dhucs@enumerate\else %%%%%
  \ifx^^e2\@entemp  % ①, ⑴, ⒜, ⓐ, ⅰ, Ⅰ
    \let\@memtempa\@dhucs@enumerate\else %%%%%
  \ifx^^e3\@entemp  % ㄱ, ㉠, ㉮, ㈀, ㈎
    \let\@memtempa\@dhucs@enumerate
  \fi\fi\fi}
\def\@dhucs@enumerate#1#2#3{%
  \bgroup\let\unihangulchar\@firstofone
    \xdef\@dhucs@enum@temp{#1#2#3}\egroup
  \ifnum\@dhucs@enum@temp=44032 \def\@tempa{\@enLabel\gana}\else
  \ifnum\@dhucs@enum@temp=8560  \def\@tempa{\@enLabel\hroman}\else
  \ifnum\@dhucs@enum@temp=8544  \def\@tempa{\@enLabel\hRoman}\else
  \ifnum\@dhucs@enum@temp=9372  \def\@tempa{\@enLabel\peng}\else
  \ifnum\@dhucs@enum@temp=9424  \def\@tempa{\@enLabel\oeng}\else
  \ifnum\@dhucs@enum@temp=9332  \def\@tempa{\@enLabel\pnum}\else
  \ifnum\@dhucs@enum@temp=9312  \def\@tempa{\@enLabel\onum}\else
  \ifnum\@dhucs@enum@temp=12814 \def\@tempa{\@enLabel\pgana}\else
  \ifnum\@dhucs@enum@temp=12910 \def\@tempa{\@enLabel\ogana}\else
  \ifnum\@dhucs@enum@temp=12896 \def\@tempa{\@enLabel\ojaso}\else
  \ifnum\@dhucs@enum@temp=12593 \def\@tempa{\@enLabel\jaso}\else
  \ifnum\@dhucs@enum@temp=12800 \def\@tempa{\@enLabel\pjaso}\else
    \PackageError{dhucs-enumerate}
      {You can't use `\unexpanded{#1#2#3}' as enum label}
      {Legal enum labels of hangul-ucs are: \MessageBreak\space\space
        \unexpanded{가, ㄱ, ㉠, ㉮, ㈀, ㈎, ①, ⑴, ⒜, ⓐ, ⅰ, Ⅰ}.}
  \fi\fi\fi\fi\fi \fi\fi\fi\fi\fi \fi\fi
  \@tempa\relax}
\fi

%%% subsection까지 항번을 붙이고 toc에 두자.
\maxtocdepth{subsection}
\maxsecnumdepth{subsection}

%%% oblivoirallowbreak
\ifx\oblivoirallowbreak\undefined
\def\oblivoirallowbreak{\hskip1sp\hskip-1sp}
\fi

\endinput

%%% ChangeLog:
%%% ver0.2.4a 2007/07/05 : add \pjaso to enumerate
%%% ver0.2.4 2007/07/01 : adopt dhucs-enumerate.sty, enumerate hook.
%%% ver0.2.3 2007/06/26 : strictcharcheck option introduced. cf. dhucs 4.0.6
%%% ver0.2.2 2007/06/16 : finemath setto default. [nofinemath] introduced. [microtype] introduces, which works only under pdflatex.
%%% ver0.2.1 2007/06/14 : dhucs 4.0.1, memhangul-ucs 1.5.1
%%% ver0.20c 2007/06/03 : pdfbookmark option to memhangul-ucs dropped.
%%% ver0.20a 2007/05/24 : \oblivoirallowbreak introduced
%%% ver0.20 2007/05/17 : dhucs 4.0, memhangul-ucs 1.5.0
%%% ver0.18a 2007/01/14 : slightly alter calling-hyperref method.
%%% ver0.17C.a 2006/12/20 : \chapter-compatible feature. (private version) : \oblivoirchapterstyle command added.
%%% ver0.17  2006/12/06 : \appendix+nokorean option bug fix (req. by Beomsuk Hyun)
%%% ver0.16  2006/11/23 : \appendix features added. (req. by Beomsuk Hyun)
%%% ver0.15  2006/11/01 : [nokorean] option \if..\fi pair bug fix (rep. by smcho)
%%% ver0.14  2006/10/22 : [itemph], [romanfixed] option introduced.
%%% ver0.13  2006/10/19 : [tocentry] option introduced. (req. by Beomsuk Hyun)
%%% ver0.12  2006/09/25 : \kscntformat bug fix
%%% ver0.11  2006/09/18 : article-like footnote style made default, [footnote] option introduced
%%% ver0.1   2006/09/13 : renamed to oblivoir (req. by ischo)
%%% ver0.014 2006/09/05 : introduce [10.5pt] option with 10_5.sty (req. by synapse)
%%% ver0.013 2006/09/03 : introduce hfontsel.sty. (req. by synapse)
%%% ver0.012 2006/09/01 : \thetitle, \theauthor undefined problem fixed. (rep. by IsCho)
%%% ver0.011 2006/05/02 : rename ksnamedef(false) to kscntformat
%%% ver0.01  2006/04/27 : introduce [nokorean] option requested by smcho.
%%% ver0.001 2006/03/11 : started this class, just for fun!
%%%
