# !Lietuviu,Lithuanian! -*-coding: iso-8859-13;-*-
#
# Lithuanian support by Kstutis Bilinas <kebil@kaunas.init.lt>, Jan 2004
#
# ---------------------------------------------------
# isNC() is a subroutine to check Native Character 
# Environment.
# ---------------------------------------------------
sub isNC($$$)
{
	my ($DISPLAY,$THIS, $OPT, $OPT_N, $FONT);
	$DISPLAY = $ENV{DISPLAY};
	$THIS = $_[0];
	$OPT = $_[1];
	$OPT_N = $_[2];

	if ($DISPLAY ne '' && !$OPT_N && ($FONT = &haveltfont)) {
		my ($TITLE, $BGC, $FGC);
		$TITLE = "Lithuanian Setup";
		$BGC = "lightgrey";
		$FGC = "black"; 
		if (&executable("wterm")) {
		    exec("wterm -fn '$FONT' -bg ${BGC} -fg ${FGC} -title '${TITLE}' ".
			 "-e $THIS -N -C $OPT");
		}
		if (&executable("rxvt")) {
		    	exec("rxvt -fn '$FONT' -bg ${BGC} -fg ${FGC} -title '${TITLE}' ".
			 "-e $THIS -N -C $OPT");
		}
#		if (&executable("xterm")) {
#		    exec("xterm -fn '$FONT' -bg ${BGC} -fg ${FGC} -title '${TITLE}' ".
#			 "-e $THIS -N -C $OPT");
#		}
		if (&executable("Eterm")) {
		    exec("Eterm --title '${TITLE}' -F '$FONT' -e $THIS -N -C $OPT");
		}
	}

	my $reply;
        print STDERR "\n                   \n";
        print STDERR "Ar matote lietuviskas raides eiluteje auksciau? [t/N] ";
        $reply = <>;
        if ($reply =~ /t|T/) {
                return 1;
        }
        return 0;
}

sub haveltfont() {
	my $i;
	open XSET, "xlsfonts|";
	while (defined($i=<XSET>)){
		if($i =~ /-iso8859-13$/ 
		   && $i =~ /^-[^-]*-fixed-medium-r-[^-]*-[^-]*-14-/) {
		    chomp($i);
		    close XSET;
		    return $i;
		}
    	}
	close XSET;
	return 0;
}

sub executable($) {
	my($WHICH);
	$WHICH = '/usr/bin/which';
	if (system("$WHICH $_[0] >/dev/null")==0) {
		return 1;
	}
	return 0;
}

# ---------------------------------------------------
# initialize() is a subroutine to initialize Sub:: 
# variables with/without dialog.
# Any variables in Sub:: package can be set here to
# be used in dot.*.pl files.
# ---------------------------------------------------
sub initialize()
{
	my ($LT_ENC, $ENC);

	$LT_ENC = &choose_encoding();
 
	if ($LT_ENC eq "UTF-8") {
		$ENC = "iso-10646-1";
		$FONTSET = "iso10646-1";
		$LOCALE = "lt_LT.UTF-8";
	}
	if ($LT_ENC eq "ISO8859-13") {
		$ENC = "iso-8859-13";
		$FONTSET = "iso8859-13";
		$LOCALE = "lt_LT";
	}

	$Sub::ENC = $ENC;

	$Sub::LT_ENC = $LT_ENC;

	$Sub::LOCALE = $LOCALE;

	$Sub::FONTSET = $FONTSET;


	&Sub::addlist("locales");
#	&Sub::addlist("fonty");

	if (&Sub::isinstalled("ispell")) {
		&Sub::addlist("ilithuanian");
	}
	if (&Sub::isinstalled("openoffice.org")) {
		&Sub::addlist("myspell-lt");
	}
	if (&Sub::isinstalled("kdebase")) {
		&Sub::addlist("kde-i18n-lt");
	}
	if (&Sub::isinstalled("xserver-.*")) {
		&Sub::addlist("xfonts-base-transcoded");
		&Sub::addlist("xfonts-75dpi-transcoded");
		&Sub::addlist("xfonts-100dpi-transcoded");
	}

	return 0;
}

sub choose_encoding() {
	my $ss;
	$ss=&Sub::select("
Prasau pasirinkti norima koduote:  
    1 = ISO-8859-13 (standartine koduote Lietuvoje)
    2 = UTF-8
", "
Praau pasirinkti norim koduot:  
    1 = ISO-8859-13 (standartin koduot Lietuvoje)
    2 = UTF-8
", 2, 1);
    if ($ss == 1) { return "ISO8859-13"; }
    if ($ss == 2) { return "UTF-8"; }
}

# ---------------------------------------------------
# sourceset2displayset() is a subroutine to convert a 
# string from Source Character Codeset into Display 
# Character Codeset.
# ---------------------------------------------------
sub sourceset2displayset ($)
{
	return $_[0];
}

# ---------------------------------------------------
# analcode() is a subroutine to guess the codeset of
# string given by a parameter.  The meaning of the
# result value is same to convcode().
# ---------------------------------------------------
sub analcode($)
{
	return 0;
}

# ---------------------------------------------------
# Convert the given string from its codeset into the
# given codeset.  The string is given by the 1st 
# parameter and the codeset is given by the 2nd 
# parameter.  The actual value of the 2nd parameter
# has to be the same as the return value of analcode
# subroutine.
# ---------------------------------------------------
sub convcode($$)
{
	return $_[0];
}

# ---------------------------------------------------
#  messages
# ---------------------------------------------------
%messages = (

# msgid
  "\nPush [Enter] key to End.\n" =>
  "\nPaspauskite [Enter] klavisa kad Baigti.\n\000".
  "\nPaspauskite [Enter] klavi kad Baigti.\n" ,

# msgid
  "Now obtaining package list...\n" =>
  "Dabar igyjamas paketu sarasas....\n\000".
  "Dabar gyjamas paket sraas...\n" ,

# msgid
  "Do setting? " =>
  "Ar atlikti nustatymus? " ,

# msgid
  "Setting is not done.\n" =>
  "Nustatymai neatlikti.\n" ,

# msgid
  "Do setting...\n" =>
  "Atliekami nustatymai...\n \n" ,

# msgid
  "Cannot read \"%s\".\n" =>
  "Negaliu perskaityti failo \"%s\".\n" ,

# msgid
  "Making a new file \"%s\"...\n" =>
  "Kuriamas naujas failas \"%s\"...\n" ,

# msgid
  "Cannot open \"%s\".\n" =>
  "Negaliu atidaryti failo \"%s\".\n" ,

# msgid
  "Cannot write to \"%s\".\n" =>
  "Negaliu irasyti i faila \"%s\".\n\000".
  "Negaliu rayti  fail\"%s\".\n" ,

# msgid
  "Cannot lock \"%s\".\n" =>
  "Negaliu uzrakinti failo \"%s\".\n\000".
  "Negaliu urakinti failo \"%s\".\n" ,

# msgid
  "Cannot close \"%s\".\n" =>
  "Negaliu uzdaryti failo \"%s\".\n\000".
  "Negaliu udaryti failo \"%s\".\n" ,

# msgid
  "Install the following packages.\n" =>
  "Idiekite sekancius paketus.\n\000".
  "diekite sekanius paketus.\n" ,

# msgid
  "   Setting is now done.  To activate these settings,\n".
  "logout and login.\n".
  "   Read each dotfile and confirm the modification.\n".
  "If you don't like the setting, modify directly or\n".
  "add overriding setting after 'language-env end' line.\n".
  "   Read /usr/share/doc/language-env/README.* for detail.\n" =>
# msgstr1 (ASCII)
  "   Nustatymai atlikti.  Sie nustatymai taps aktyvus, kai Jus\n".
  "issiloginsite ir vel isiloginsite.\n".
  "   Skaitykite kiekviena dot-faila ir paziurekekite pakeitimus.\n".
  "Jei nustatymai Jums nepatinka, modifikuokite juos tiesiogiai, ar\n".
  "pridekite virsesni nustatyma zemiau eilutes 'language-env end'.\n".
  "   Detaliau skaitykite /usr/share/doc/language-env/README.* .\n\000".
# msgstr2 (in Native Character Set)
  "   Nustatymai atlikti.  ie nustatymai taps aktyvs, kai Js\n".
  "isiloginsite ir vl siloginsite.\n".
  "   Skaitykite kiekvien dot-fail ir pairkekite pakeitimus.\n".
  "Jei nustatymai Jums nepatinka, modifikuokite juos tiesiogiai, ar\n".
  "pridkite viresn nustatym emiau eiluts 'language-env end'.\n".
  "   Detaliau skaitykite /usr/share/doc/language-env/README.* .\n" ,

# msgid
  "Usage: set-language-env [options]\n".
  "  -l language : Specify language (otherwise choose from menu)\n".
  "  -h          : This help message\n".
  "  -v          : 'verbose mode'\n".
  "  -s          : Display list of supported languages and exit\n".
  "  -r          : Remove all settings\n".
  "  -N          : Never fork another set-language-env (for internal use)\n".
  "  -c          : Don't use native character set (for internal use)\n".
  "  -C          : Use native character set (for internal use)\n".
  "  -E          : Setting for /etc/skel directory (root user only)\n" =>
# msgstr1 (ASCII)
  "Naudojimas: set-language-env [parametrai]\n".
  "  -l kalba    : Nurodykite kalba (kitaip pasirinksite is meniu)\n".
  "  -h          : Sis pagalbos pranesimas\n".
  "  -v          : 'daugiazodis' rezimas\n".
  "  -s          : Parodo sarasa palaikomu kalbu\n".
  "  -r          : Pasalina visus nustatymus\n".
  "  -N          : Draudzia vykdyti kita set-language-env (vidiniam naudojimui)\n".
  "  -c          : Nenaudoti gimtosios koduotes (vidiniam naudojimui)\\n".
  "  -C          : Naudoti gimtaja koduote (vidiniam naudojimui)\n".
  "  -E          : Nustatymai /etc/skel kataloge (tik root naudotojui)\n\000".
# msgstr2 (in Native Character Set)
  "Naudojimas: set-language-env [parametrai]\n".
  "  -l kalba    : Nurodykite kalb (kitaip pasirinksite i meniu)\n".
  "  -h          : is pagalbos praneimas\n".
  "  -v          : 'daugiaodis' reimas\n".
  "  -s          : Parodo sra palaikom kalb\n".
  "  -r          : Paalina visus nustatymus\n".
  "  -N          : Draudia vykdyti kit set-language-env (vidiniam naudojimui)\n".
  "  -c          : Nenaudoti gimtosios koduots (vidiniam naudojimui)\\n".
  "  -C          : Naudoti gimtj koduot (vidiniam naudojimui)\n".
  "  -E          : Nustatymai /etc/skel kataloge (tik root naudotojui)\n" ,

# msgid
  "Install the following locales.\n" =>
  "Idiekite sekancias locales.\n\000".
  "diekite sekanias lokales.\n" ,

# msgid
  "(Edit /etc/locale.gen and invoke locale-gen)\n" =>
  "(Pataisykite /etc/locale.gen ir paleiskite vykdyti locale-gen)\n" ,

# msgid
  "" =>
  "\000".
  ""
);

# ---------------------------------------------------
# yes and no
# ---------------------------------------------------
$yes_upper = "T";
$yes_lower = "t";
$no_upper = "N";
$no_lower = "n";

# ---------------------------------------------------
# This variable shows the needed locale.
# ---------------------------------------------------
$need_locale = 'lt_lt(lt_LT!ISO-8859-13) lt_LT.UTF-8(lt_LT.UTF-8!UTF-8)';
