/*
 *   LADCCA 
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define _GNU_SOURCE

#include "ac-config.h"

#include <unistd.h>

#include <ladcca/ladcca.h>

#include "synth.h"

#ifdef HAVE_GTK2
#include "interface.h"
#endif

void
save_data ()
{
  cca_config_t * config;
  
  config = cca_config_new_with_key ("modulation");
  cca_config_set_value_double (config, modulation);
  cca_send_config (cca_client, config);

  config = cca_config_new_with_key ("attack");
  cca_config_set_value_double (config, attack);
  cca_send_config (cca_client, config);

  config = cca_config_new_with_key ("decay");
  cca_config_set_value_double (config, decay);
  cca_send_config (cca_client, config);

  config = cca_config_new_with_key ("sustain");
  cca_config_set_value_double (config, sustain);
  cca_send_config (cca_client, config);

  config = cca_config_new_with_key ("release");
  cca_config_set_value_double (config, release);
  cca_send_config (cca_client, config);

  config = cca_config_new_with_key ("gain");
  cca_config_set_value_double (config, gain);
  cca_send_config (cca_client, config);

  config = cca_config_new_with_key ("harmonic");
  cca_config_set_value_int (config, harmonic);
  cca_send_config (cca_client, config);

  config = cca_config_new_with_key ("subharmonic");
  cca_config_set_value_int (config, subharmonic);
  cca_send_config (cca_client, config);

  config = cca_config_new_with_key ("transpose");
  cca_config_set_value_int (config, transpose);
  cca_send_config (cca_client, config);

}

void
restore_data (cca_config_t * config)
{
  const char * key;
  
  key = cca_config_get_key (config);
  
  if (strcmp (key, "modulation") == 0)
    {
      modulation = cca_config_get_value_double (config);
      return;
    }

  if (strcmp (key, "attack") == 0)
    {
      attack = cca_config_get_value_double (config);
      return;
    }

  if (strcmp (key, "decay") == 0)
    {
      decay = cca_config_get_value_double (config);
      return;
    }

  if (strcmp (key, "sustain") == 0)
    {
      sustain = cca_config_get_value_double (config);
      return;
    }

  if (strcmp (key, "release") == 0)
    {
      release = cca_config_get_value_double (config);
      return;
    }

  if (strcmp (key, "gain") == 0)
    {
      gain = cca_config_get_value_double (config);
      return;
    }

  if (strcmp (key, "harmonic") == 0)
    {
      harmonic = cca_config_get_value_int (config);
      return;
    }

  if (strcmp (key, "subharmonic") == 0)
    {
      subharmonic = cca_config_get_value_int (config);
      return;
    }

  if (strcmp (key, "transpose") == 0)
    {
      transpose = cca_config_get_value_int (config);
      return;
    }


}

int
cca_main ()
{
  cca_event_t * event;
  cca_config_t * config;
  
  while ( (event = cca_get_event (cca_client)) )
        {
          switch (cca_event_get_type (event))
            {
            case CCA_Quit:
              quit = 1;
              cca_event_destroy (event);
              break;
            case CCA_Restore_Data_Set:
              cca_send_event (cca_client, event);
              break;
            case CCA_Save_Data_Set:
              save_data ();
              cca_send_event (cca_client, event);
              break;
	    case CCA_Server_Lost:
	      return 1;
            default:
              printf ("%s: receieved unknown LADCCA event of type %d",
                      __FUNCTION__, cca_event_get_type (event));
              cca_event_destroy (event);
              break;
            }
        }
      
  while ( (config = cca_get_config (cca_client)) )
    {
      restore_data (config);
      cca_config_destroy (config);
    }

  return 0;
}

void *
cca_thread_main (void * data)
{
  printf ("LADCCA thread running\n");

  while (!cca_main ())
    usleep (1000);
  
  printf ("LADCCA thread finished\n");
  return NULL;
}

/* EOF */
