//LabPlot : DestinationDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qdatetime.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include "DestinationDialog.h"

using namespace std;

DestinationDialog::DestinationDialog(MainWin *mw, const char *name)
	: Dialog(mw, name)
{
	kdDebug()<<"DestinationDialog()"<<endl;
	setCaption(i18n("Destination for plots"));

	new QLabel(i18n("Destination for plots"),vbox); 
	sheetlist = new KComboBox(vbox);
	QWorkspace *ws = mw->getWorkspace();
	
	QWidgetList list = ws->windowList();
	for ( int i = 0;i < int(list.count());  i++ ) {
		sheetlist->insertItem(list.at(i)->caption());
	}
	sheetlist->insertItem(i18n("new Worksheet"));
	sheetlist->insertItem(i18n("new Spreadsheet"));
	sheetlist->setCurrentItem(list.count());

	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	save->setEnabled(false);
	
	setMinimumWidth(2*vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void DestinationDialog::apply_clicked() {
	kdDebug()<<"DestinationDialog::apply_clicked()"<<endl;
	
	int item = sheetlist->currentItem(), count = sheetlist->count();
	int res=item;
	if(item == count-2)
		res = -1;
	else if (item == count-1)
		res = -2;
	
//	kdDebug()<<"selected DESTINATION = "<<res<<endl;
	if(mw->activeSpreadsheet())
		mw->activeSpreadsheet()->setDestination(res);
}

void DestinationDialog::ok_clicked() {
	apply_clicked();
	accept();	
}
