/***************************************************************************
 *
 *  $Id: kzensearchline.cpp,v 1.9 2005/05/31 06:54:03 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <iostream>

#include <qcheckbox.h>
#include <qlayout.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <knuminput.h>
#include <klocale.h>
#include <kdebug.h>

#include <qlistbox.h>

#include <id3v1genres.h>

#include "kzensearchcondition.h"
#include "kzenratingwidget.h"
#include "kzenartist.h"
#include "kzenalbum.h"
#include "kzentrack.h"
#include "kzencategories.h"

#include "kzensearchline.h"

KZenSearchLine::KZenSearchLine(QWidget *parent, const char *name)
  :QHBox(parent,name)
{
  fBusy = true;

  setSpacing(5);

  fFieldBox = new KComboBox(this, "fields");
  fFieldBox->insertItem(i18n("Artist"));
  fFieldBox->insertItem(i18n("Album"));
  fFieldBox->insertItem(i18n("Title"));
  fFieldBox->insertItem(i18n("Tracknumber"));
  fFieldBox->insertItem(i18n("Genre"));
  fFieldBox->insertItem(i18n("Year"));
  fFieldBox->insertItem(i18n("Rating"));
  fFieldBox->insertItem(i18n("Category"));
  setStretchFactor(fFieldBox,0);
  connect(fFieldBox, SIGNAL(activated(int)),
	  this, SLOT(slotFieldChanged(int)));

  fTextSearch = new KZenTextSearch(this,"TextSearch");

  fCategorySearch = new KZenCategorySearch(this,"CategorySearch");
  fCategorySearch->hide();

  fNumberSearch = new KZenNumberSearch(this,"NumberSearch");
  fNumberSearch->hide();

  fRatingSearch = new KZenRatingSearch(this,"RatingSearch");
  fRatingSearch->hide();

  setStretchFactor(fTextSearch,1);
  setStretchFactor(fNumberSearch,1);
  setStretchFactor(fRatingSearch,1);

  fLastField = -1;
  
  fCondition = 0;
  
  fBusy = false;
}

KZenSearchLine::~KZenSearchLine()
{
  
}

void KZenSearchLine::setCondition(KZenSearchCondition * con)
{
  fCondition = con;
  
  int id = con->getField();
  fFieldBox->setCurrentItem(id);
  slotFieldChanged(id);
}

void KZenSearchLine::slotFieldChanged(int id)
{
  fBusy = true;

  fCondition->setField((KZenSearchCondition::FieldType)id);

  if (fLastField==-1) fTextSearch->hide();

  switch (id) {
  case KZenSearchCondition::FArtist:
    {
      if (fLastField==KZenSearchCondition::FTracknumber ||
	  fLastField==KZenSearchCondition::FYear ||
	  fLastField==KZenSearchCondition::FRating ||
	  fLastField==KZenSearchCondition::FCategory) {
	fCondition->setValue(QVariant(""));
	fCategorySearch->hide();
	fNumberSearch->hide();
	fRatingSearch->hide();
      }
      
      fTextSearch->show();
      fTextSearch->clear();
      fTextSearch->setItems(KZenArtist::getArtists());
      fTextSearch->setCondition(fCondition);
    }
    break;
  case KZenSearchCondition::FAlbum:
    {
      if (fLastField==KZenSearchCondition::FTracknumber ||
	  fLastField==KZenSearchCondition::FYear ||
	  fLastField==KZenSearchCondition::FRating ||
	  fLastField==KZenSearchCondition::FCategory) {
	fCondition->setValue(QVariant(""));
	fCategorySearch->hide();
	fNumberSearch->hide();
	fRatingSearch->hide();
      }
      
      fTextSearch->show();

      fTextSearch->clear();
      fTextSearch->setItems(KZenAlbum::getAlbums());

      fTextSearch->setCondition(fCondition);
    }
    break;
  case KZenSearchCondition::FTitle:
    {
      if (fLastField==KZenSearchCondition::FTracknumber ||
	  fLastField==KZenSearchCondition::FYear ||
	  fLastField==KZenSearchCondition::FRating ||
	  fLastField==KZenSearchCondition::FCategory) {
	fCondition->setValue(QVariant(""));
	fCategorySearch->hide();
	fNumberSearch->hide();
	fRatingSearch->hide();
      }
      
      fTextSearch->show();

      fTextSearch->clear();
      fTextSearch->setItems(KZenTrack::getTitles());

      fTextSearch->setCondition(fCondition);
    }
    break;
  case KZenSearchCondition::FGenre:
    {
      if (fLastField==KZenSearchCondition::FTracknumber ||
	  fLastField==KZenSearchCondition::FYear ||
	  fLastField==KZenSearchCondition::FRating ||
	  fLastField==KZenSearchCondition::FCategory) {
	fCondition->setValue(QVariant(""));
	fCategorySearch->hide();
	fNumberSearch->hide();
	fRatingSearch->hide();
      }
      
      fTextSearch->show();

      fTextSearch->clear();

      TagLib::StringList genres = TagLib::ID3v1::genreList();
      for (uint g=0;g<genres.size();g++) {
	fTextSearch->addItem(TStringToQString(genres[g]));
      }

      fTextSearch->setCondition(fCondition);
    }
    break;
  case KZenSearchCondition::FCategory:
    {
      if (fLastField==KZenSearchCondition::FTracknumber ||
	  fLastField==KZenSearchCondition::FYear ||
	  fLastField==KZenSearchCondition::FRating ||
	  fLastField==KZenSearchCondition::FArtist ||
	  fLastField==KZenSearchCondition::FAlbum ||
	  fLastField==KZenSearchCondition::FTitle ||
	  fLastField==KZenSearchCondition::FGenre) {
	fCondition->setValue(QVariant(""));
	fTextSearch->hide();
	fNumberSearch->hide();
	fRatingSearch->hide();
      }

      fCategorySearch->show();

      fCategorySearch->clear();
      fCategorySearch->setItems(gCategories->categories());

      fCategorySearch->setCondition(fCondition);
    }
    break;
  case KZenSearchCondition::FTracknumber:
  case KZenSearchCondition::FYear:
    {
      if (fLastField==KZenSearchCondition::FArtist ||
	  fLastField==KZenSearchCondition::FAlbum ||
	  fLastField==KZenSearchCondition::FTitle ||
	  fLastField==KZenSearchCondition::FGenre ||
	  fLastField==KZenSearchCondition::FCategory ||
	  fLastField==KZenSearchCondition::FRating) {
	fCondition->setValue(QVariant(0));
	fTextSearch->hide();
	fCategorySearch->hide();
	fRatingSearch->hide();
      }

      fNumberSearch->show();

      fNumberSearch->setCondition(fCondition);
    }
    break;
  case KZenSearchCondition::FRating:
    {
      if (fLastField==KZenSearchCondition::FArtist ||
	  fLastField==KZenSearchCondition::FAlbum ||
	  fLastField==KZenSearchCondition::FTitle ||
	  fLastField==KZenSearchCondition::FGenre ||
	  fLastField==KZenSearchCondition::FCategory ||
	  fLastField==KZenSearchCondition::FTracknumber ||
	  fLastField==KZenSearchCondition::FYear) {
	fCondition->setValue(QVariant(0));
	fTextSearch->hide();
	fCategorySearch->hide();
	fNumberSearch->hide();
      }

      fRatingSearch->show();

      fRatingSearch->setCondition(fCondition);
    }
    break;
  }

  fLastField = id;

  fBusy = false;
}

KZenTextSearch::KZenTextSearch(QWidget *parent, const char *name)
  :QHBox(parent,name)
{
  fOperationBox = new KComboBox(this, "OperationBox");
  fOperationBox->insertItem(i18n("is equal to"));
  fOperationBox->insertItem(i18n("is not equal to"));
  fOperationBox->insertItem(i18n("contains"));
  fOperationBox->insertItem(i18n("does not contain"));
  connect(fOperationBox, SIGNAL(activated(int)),
	  this, SLOT(slotOperationChanged(int)));

  fTextEdit = new KComboBox(this,"TextEdit"); 
  fTextEdit->setDuplicatesEnabled(false);
  fTextEdit->setEditable(true);
  connect(fTextEdit, SIGNAL(textChanged(const QString &)),
	  this, SLOT(slotTextChanged(const QString &)));

  fCaseSensitiveCheck = new QCheckBox("CS", this, "cs");
  connect(fCaseSensitiveCheck, SIGNAL(clicked()),
	  this, SLOT(slotCSChanged()));

  setStretchFactor(fOperationBox,0);
  setStretchFactor(fTextEdit,1);
  setStretchFactor(fCaseSensitiveCheck,0);

  fCondition = 0;
}

KZenTextSearch::~KZenTextSearch()
{

}

void KZenTextSearch::setCondition(KZenSearchCondition * con)
{
  fCondition = con;

  fCaseSensitiveCheck->setChecked(con->getCaseSensitive());
  fOperationBox->setCurrentItem((int)con->getOperation());
  fTextEdit->setCurrentText(con->getValue().asString());
}

void KZenTextSearch::clear()
{
  fTextEdit->clear();
}

void KZenTextSearch::setItems(const QStringList & sl)
{
  fTextEdit->insertItem("");
  fTextEdit->insertStringList(sl);
  fTextEdit->completionObject()->setItems(sl);
}

void KZenTextSearch::addItem(const QString & i)
{
  fTextEdit->insertItem(i);
  fTextEdit->completionObject()->addItem(i);
}

void KZenTextSearch::slotOperationChanged(int o)
{
  fCondition->setOperation((KZenSearchCondition::Operation)o);
}

void KZenTextSearch::slotTextChanged(const QString & t)
{
  if (fCondition && fCondition->getField()!=7) {
    fCondition->setValue(QVariant(t));
  }
}

void KZenTextSearch::slotCSChanged()
{
  if (fCondition)
    fCondition->setCaseSensitive(fCaseSensitiveCheck->isChecked());
}

KZenCategorySearch::KZenCategorySearch(QWidget *parent, const char *name)
  :QHBox(parent,name)
{
  fOperationBox = new KComboBox(this, "OperationBox");
  fOperationBox->insertItem(i18n("is equal to"));
  fOperationBox->insertItem(i18n("is not equal to"));
  fOperationBox->insertItem(i18n("contains"));
  fOperationBox->insertItem(i18n("does not contain"));
  connect(fOperationBox, SIGNAL(activated(int)),
	  this, SLOT(slotOperationChanged(int)));

  fTextEdit = new KComboBox(this,"TextEdit"); 
  fTextEdit->setDuplicatesEnabled(false);
  fTextEdit->setEditable(false);
  connect(fTextEdit, SIGNAL(activated(int)),
	  this, SLOT(slotItemChanged(int)));

  setStretchFactor(fOperationBox,0);
  setStretchFactor(fTextEdit,1);

  fCondition = 0;
}

KZenCategorySearch::~KZenCategorySearch()
{

}

void KZenCategorySearch::setCondition(KZenSearchCondition * con)
{
  fCondition = con;

  fOperationBox->setCurrentItem((int)con->getOperation());
  fTextEdit->setCurrentItem(con->getValue().asUInt());
}

void KZenCategorySearch::clear()
{
  fTextEdit->clear();
}

void KZenCategorySearch::setItems(const QStringList & sl)
{
  fTextEdit->insertStringList(sl);
  fTextEdit->completionObject()->setItems(sl);
}

void KZenCategorySearch::addItem(const QString & i)
{
  fTextEdit->insertItem(i);
  fTextEdit->completionObject()->addItem(i);
}

void KZenCategorySearch::slotOperationChanged(int o)
{
  fCondition->setOperation((KZenSearchCondition::Operation)o);
}

void KZenCategorySearch::slotItemChanged(int i)
{
  if (fCondition && fCondition->getField()==7) {
    fCondition->setValue(QVariant(i));
  }
}

KZenNumberSearch::KZenNumberSearch(QWidget *parent, const char *name)
  :QHBox(parent,name)
{
  fOperationBox = new KComboBox(this, "OperationBox");
  fOperationBox->insertItem(i18n("<"));
  fOperationBox->insertItem(i18n("<="));
  fOperationBox->insertItem(i18n(">"));
  fOperationBox->insertItem(i18n(">="));
  connect(fOperationBox, SIGNAL(activated(int)),
	  this, SLOT(slotOperationChanged(int)));

  fNumEdit = new KIntNumInput(this,"NumEdit");
  fNumEdit->setRange(0,2500,1,false);
  connect(fNumEdit, SIGNAL(valueChanged(int)),
	  this, SLOT(slotNumberChanged(int)));

  setStretchFactor(fOperationBox,0);
  setStretchFactor(fNumEdit,1);

  fCondition = 0;
}

KZenNumberSearch::~KZenNumberSearch()
{

}

void KZenNumberSearch::setCondition(KZenSearchCondition * con)
{
  fCondition = con; 

  fOperationBox->setCurrentItem((int)con->getOperation()-4);
  fNumEdit->setValue(fCondition->getValue().asUInt());
}

void KZenNumberSearch::slotOperationChanged(int o)
{
  if (fCondition) 
    fCondition->setOperation((KZenSearchCondition::Operation)(o+4));
}

void KZenNumberSearch::slotNumberChanged(int n)
{
  if (fCondition)
    fCondition->setValue(QVariant((uint)n));
}

KZenRatingSearch::KZenRatingSearch(QWidget *parent, const char *name)
  :QHBox(parent,name)
{
  fOperationBox = new KComboBox(this, "OperationBox");
  fOperationBox->insertItem(i18n("<"));
  fOperationBox->insertItem(i18n("<="));
  fOperationBox->insertItem(i18n(">"));
  fOperationBox->insertItem(i18n(">="));
  connect(fOperationBox, SIGNAL(activated(int)),
	  this, SLOT(slotOperationChanged(int)));

  fRatingEdit = new KZenRatingWidget(this,"RatingEdit");
  connect(fRatingEdit, SIGNAL(valueChanged(int)),
	  this, SLOT(slotRatingChanged(int)));

  setStretchFactor(fOperationBox,0);
  setStretchFactor(fRatingEdit,0);

  fCondition = 0;
}

KZenRatingSearch::~KZenRatingSearch()
{

}

void KZenRatingSearch::setCondition(KZenSearchCondition * con)
{
  fCondition = con;

  fOperationBox->setCurrentItem((int)con->getOperation()-4);
  fRatingEdit->setValue(con->getValue().asUInt());
}

void KZenRatingSearch::slotOperationChanged(int o)
{
  if (fCondition)
    fCondition->setOperation((KZenSearchCondition::Operation)(o+4));
}

void KZenRatingSearch::slotRatingChanged(int r)
{
  if (fCondition)
    fCondition->setValue(QVariant((uint)r));
}

#include "kzensearchline.moc"
