/***************************************************************************
 *
 *  $Id: kzenmediafiles.h,v 1.9 2005/06/29 00:05:27 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENMEDIAFILES_H
#define KZENMEDIAFILES_H

#include <kurl.h>

class KZenTrack;

/**
@author Andreas Mussgiller
*/
class KZenMediaFiles
{

 public:

  class Track {
   public:
    Track();
    ~Track();
    
    void readTag();

    QString fTitle;
    QString fArtist;
    QString fAlbum;
    KURL fURL;
    bool fTagRead;
    bool fExclude;
  };

  static bool                 isMediaFile(const KURL & url);
  static bool                 isPlaylistFile(const KURL & url);
  static bool                 isMP3(const KURL & url);
  static bool                 isWMA(const KURL & url);
  static bool                 isWAV(const KURL & url);
  static bool                 isDirectory(const KURL & url);

  static KZenTrack *          createTrackMP3(const KURL & url);

  static bool                 checkLibraryPath(const KURL & url);
  static KURL                 saveFilename(KZenTrack * track, const KURL & url, bool & valid, bool create = true);

  static void                 getMediaFiles(const KURL &, QPtrList<KZenMediaFiles::Track> &, bool exclude = false);
  static void                 getM3UList(const KURL &, QStringList &);
};

#endif
