/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>

using namespace std;

#include "tagenginewrapper.h"

extern rcdatei settingsfile;

#define OGG 1
#define MP3 2
#define NOTYPE 0

mediafile::mediafile(QString attachedfile)
{
  filetype=NOTYPE;
  readsuccess=FALSE;
  picturepossible=FALSE;
  isv2capable=FALSE;
  fileogg=NULL;
  filetaglib=NULL;
  fileid3lib=NULL;
  bitrate=0;
  //Choose right engine, depending on the filename (opening is always done by taglib-interface or ogg-interface)
  filename=attachedfile;
  if (filename.lower().endsWith(".ogg"))
    {
      filetype=OGG;
      fileogg=new oggfile(filename);
      if (fileogg->readsuccess)
        {
          bitrate=fileogg->bitrate;
          readsuccess=TRUE;
        }
    }
  else if(filename.lower().endsWith(".mp3"))
    {
      filetype=MP3;
      isv2capable=TRUE;
      filetaglib=new taglibfile(filename);
      if (filetaglib->readsuccess)
        {
          bitrate=filetaglib->bitrate;
          readsuccess=TRUE;
        }
    }
}

mediafile::~ mediafile()
{
  //check wich pointers hold an adress, and delete the object, on wich it is pointing
  if (fileogg)
    delete fileogg;
  if (filetaglib)
    delete filetaglib;
  if (fileid3lib)
    delete fileid3lib;
}

void mediafile::readTags()
{
  if (filetype==OGG)
    {
      fileogg->readTags();
      //copy the read tags to our classes tag
      if (fileogg->containsTag)
        {
          containsTag=TRUE;
          taginfo=fileogg->v1tag;
        }
      else
        containsTag=FALSE;
    }
  else if (filetype==MP3)
    {
      filetaglib->readTags();
      //Check if we have tags, and wich ones are found, and set are taginfo with them
      if (filetaglib->containsV1Tag||filetaglib->containsV2Tag)
        {
          //ok we have tags
          containsTag=TRUE;
          if (filetaglib->containsV1Tag&&!filetaglib->containsV2Tag)
            {
              /*only use v1tags, if the v2tags dont exist
               *there can be no picture if we have only v1tags*/
              taginfo=filetaglib->v1tag;
              picturepossible=FALSE;
            }
          else if (filetaglib->containsV2Tag)
            {
              picturepossible=TRUE;
              taginfo=filetaglib->v2tag;
            }
        }
    }
}

void mediafile::readPicture()
{
  if (picturepossible)
    //only mp3 with id3v2-tags can contain a picture, so make sure we don't try to read an other filetype
    filetaglib->readPicture();
  //set the picture in our taginfo, if we got one
  if (!filetaglib->v2tag.cdcover.isNull())
    taginfo.cdcover=filetaglib->v2tag.cdcover;
}

void mediafile::setTags(mediatag song)
{
  // check the tags for not needed spaces at the beginning and the end
  song.album=srtipUnwantedSpaces(song.album);
  song.artist=srtipUnwantedSpaces(song.artist);
  song.genre=srtipUnwantedSpaces(song.genre);
  song.title=srtipUnwantedSpaces(song.title);
  if (filetype==OGG)
    fileogg->setTags(song);
  if (filetype==MP3)
    {
      //since we want to save the tags, we have to choose wich tagversion we want to write
      if (settingsfile.tagversion==1||settingsfile.tagversion==2||settingsfile.tagversion==3)
        {
          fileid3lib=new id3libfile(filename);
          fileid3lib->setTags(song);
        }
      else if (settingsfile.tagversion==4||settingsfile.tagversion==8||settingsfile.tagversion==12)
        {
          //we already have a pointer to a fileid3lib-object, so we can use it
          filetaglib->setTags(song);
        }
    }
}


bool mediafile::saveFile()
{
  bool writeok=FALSE;
  if (filetype==OGG)
    {
      writeok=fileogg->saveFile();
    }
  else if (filetype==MP3)
    {
      //since we want to save the tags, we have to choose wich tagversion we want to write
      if (settingsfile.tagversion==1||settingsfile.tagversion==2||settingsfile.tagversion==3)
        {
          //everything in id3lib, id3lib-interface understands the tagversion right so we don't need to change the value
          writeok=fileid3lib->saveFile(settingsfile.tagversion);
        }
      else if (settingsfile.tagversion==4||settingsfile.tagversion==8||settingsfile.tagversion==12)
        {
          //everything in taglib, we need to get the mapped value taglib-interface understands
          writeok=filetaglib->saveFile((settingsfile.tagversion&12)>>2);
        }
    }
  return writeok;
}

QString mediafile::srtipUnwantedSpaces(QString tagtext)
{
  while (tagtext.endsWith(" "))
    tagtext=tagtext.left(tagtext.length()-1);
  while (tagtext.startsWith(" "))
    tagtext=tagtext.right(tagtext.length()-1);
  return tagtext;
}
