/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/



#ifndef _PASSWORDBOX_H_
#define _PASSWORDBOX_H_

#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qimage.h>

#include <klocale.h>
#include <kiconloader.h>

class passwordbox : public QDialog
{
    Q_OBJECT
public:
    passwordbox();
    ~passwordbox();
    QImage keyicon;
    QLabel *keylabel;
    QLabel *infolabel;
    QLabel *userlabel;
    QLabel *passlabel;
    QBoxLayout *vertikal;
    QBoxLayout *userlayout;
    QBoxLayout *passwordlayout;
    QBoxLayout *buttonslayout;
    QLineEdit *userledit;
    QLineEdit *passledit;
    QPushButton *okknopf;
    QPushButton *abbruchknopf;
private:
    QString username;
    QString password;
private slots:
    void okfreigeben();
    void okpressed();
    void abbrechenpressed();
signals:
    void abort();
    void success(QString,QString);

};

#endif //_PASSWORDBOX_
