/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

using namespace std;

#ifndef _MYSQLINTERFACE_H_
#define _MYSQLINTERFACE_H_

#include <iostream>

#include <qsqlcursor.h>
#include <qsqldatabase.h>
#include <qptrlist.h>
#include <qstringlist.h>
#include <qstring.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <klocale.h>
#include <qfileinfo.h>
#include <qdatetime.h>

#include "mediatag.h"
#include "passwordbox.h"
#include "rcdatei.h"
#include "progress.h"

//select database-driver, and connect-settings for database-server

#define DRIVER       "QMYSQL3"
#define DATABASE     "kyamo"
#define USER         "kyamo"
#define PASSWORD     "kyamo"
#define HOST         "localhost"

#define OLDDATABASE     "kmp3organizer"
#define OLDUSER         "kmp3organizer"
#define OLDPASSWORD     "kmp3organizer"


class mysqldatabase : public QObject
{
    Q_OBJECT
private:
    QSqlDatabase *databaseconnect;
    passwordbox *passbox;
    QString rootuser;
    QString rootpass;
    //Internal helperfunctions
    QString stripunwantedSigns(QString);
    long checkArtist(QString);
    long checkAlbum(QString,int,long);
    long checkGenre(QString);
    long checkTrack(QString,int,long,long,long);//Tracktitle,Tracknumber,Artistid,Albumid,Genreid
    long checkFile(QString,long);
public:
    mysqldatabase();
    ~mysqldatabase();
    bool oldmodelchecked;
    bool quit;
    void fillCombo(QComboBox *,QString,QString);
    void fillSortedCombo(QComboBox *,QString,QString,QString);
    void fillSortedCombo(QComboBox *,QString,QString,QString,QString);
    bool albumexists(long,long,QStringList *);
    long getyear(long);
    bool checkdiscid(QString,QComboBox *,QComboBox *);
    long translateartist(QString);
    QString translateartist(long);
    long translatealbum(QString);
    QString translatealbum(long);
    long translategenre(QString);
    QString translategenre(long);
    void gettrack(QComboBox *,long,long,int);
    void writetag(mediatag *);
    bool checkModified(QString);
    void writetag(mediatag *,QString);
    void updatetag(mediatag *,QString);
    void writealbum(QString,QString,QString,QString,long,QStringList *);
    void removefile(QString);
    bool createnewdb();
    bool importolddb();
    void generateArtisttable();
    void generateAlbumtable();
    void generateGenretable();
    void generateTracktable();
    void generateFiletable();
public slots:
    void fetchacountdata(QString,QString);
    void abort();
};

#endif //_MYSQLINTERFACE_
