/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//this file holds every classes and methods needed for the fileselector in tagger

using namespace std;

#ifndef _FILESELECTOR_H_
#define _FILESELECTOR_H_


#include <iostream>

#include <qstring.h>
#include <qsize.h>
#include <qlistview.h>
#include <qimage.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qptrlist.h>

#include <klocale.h>
#include <kiconloader.h>

#include "mediatag.h"

class fileselectoritem;

//fileselector is a tweaked qlistview, with extra functionality, we need for our fileinfos
class fileselector : public QListView
{
    Q_OBJECT
public:
    fileselector(QWidget *);
    ~fileselector();
    void setedited(fileselectoritem *);
    void setsaved(fileselectoritem *);
    //our pictures for the filetree
    QImage folderpic;
    QImage filepic;
    QImage savepic;
    QImage okpic;
    QImage editedpic;
    QPtrList<fileselectoritem> modifiedlist;
protected:
    void contentsMouseReleaseEvent(QMouseEvent *);
signals:
    void mousereleased();
};

//fileselectoritem is a tweaked qlistviewitem, with extra-information of tags and filestatus
class fileselectoritem : public QListViewItem
{
public:
    fileselectoritem(fileselector *,QString);
    fileselectoritem(fileselectoritem *,QString,QString,bool,fileselector *);
    ~fileselectoritem();
    bool isdirectory;
    bool tagloaded;
    bool tagchanged;
    bool picturepossible;
    mediatag taginfo;
    QString itemfilename;
private:
    fileselector *motherwidget;
};
#endif //_FILESELECTOR_H_
