/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <iostream>
using namespace std;

#include "choicebox2.h"

choicebox2::choicebox2(QStringList *choices,QString toptext,QString icontouse)
{
    selected=QString::null;
    this->setCaption(i18n("Available choices"));
    this->setModal(TRUE);
    choiceboxlayout=new QVBoxLayout(this);
    infobox=new QGroupBox(2,Qt::Vertical,QString::null,this,QString::null);
    choiceboxlayout->addWidget(infobox);
    questionicon=new QLabel(infobox);
    questionicon->setAlignment(Qt::AlignCenter);
    infotext=new QLabel(toptext,infobox);
    QSize listviewsize(500,200);
    choicelistbox=new QListView(this);
    choicelistbox->setSelectionMode(QListView::Single);
    choicelistbox->setRootIsDecorated(FALSE);
    choicelistbox->setResizeMode(QListView::AllColumns);
    choicelistbox->addColumn(i18n("Choices"),-1);
    choicelistbox->setMinimumSize(listviewsize);
    choiceboxlayout->addWidget(choicelistbox);
    buttonbox=new QGroupBox(2,Qt::Horizontal,QString::null,this,QString::null);
    choiceboxlayout->addWidget(buttonbox);
    okbutton=new QPushButton(i18n("Ok"),buttonbox);
    okbutton->setEnabled(FALSE);
    chancelbutton=new QPushButton(i18n("Cancel"),buttonbox);
    QStringList::Iterator index=choices->begin();
    KIconLoader *loader=new KIconLoader("KYamo");
    QString picname;
    picname=icontouse;
    serverpic=loader->loadIcon(picname,KIcon::NoGroup);
    serverpic=serverpic.smoothScale(16,16,QImage::ScaleFree);
    picname="ok.png";
    okpic=loader->loadIcon(picname,KIcon::NoGroup);
    QIconSet buttonset(okpic);
    okbutton->setIconSet(buttonset);
    picname="cancel.png";
    chancelpic=loader->loadIcon(picname,KIcon::NoGroup);
    buttonset=QIconSet(chancelpic);
    chancelbutton->setIconSet(buttonset);
    picname="messagebox_info.png";
    questionpic=loader->loadIcon(picname,KIcon::NoGroup);
    questionicon->setPixmap(questionpic);
    while(index!=choices->end())
    {
        //add all choices into listview
        QListViewItem *actualitem=new QListViewItem(choicelistbox,*index);
        actualitem->setPixmap(0,serverpic);
        index++;
    }
    this->show();
    connect (okbutton,SIGNAL(clicked()),SLOT(okslot()));
    connect (chancelbutton,SIGNAL(clicked()),SLOT(chancelslot()));
    connect (choicelistbox,SIGNAL(selectionChanged()),SLOT(activateok()));
}

choicebox2::choicebox2(QPtrList<guessfilter> *choices,QString toptext)
{
    selected=QString::null;
    this->setCaption(i18n("Available choices"));
    this->setModal(TRUE);
    choiceboxlayout=new QVBoxLayout(this);
    infobox=new QGroupBox(2,Qt::Vertical,QString::null,this,QString::null);
    choiceboxlayout->addWidget(infobox);
    questionicon=new QLabel(infobox);
    questionicon->setAlignment(Qt::AlignCenter);
    infotext=new QLabel(toptext,infobox);
    QSize listviewsize(500,200);
    choicelistbox=new QListView(this);
    choicelistbox->setSelectionMode(QListView::Single);
    choicelistbox->setRootIsDecorated(FALSE);
    choicelistbox->setResizeMode(QListView::AllColumns);
    choicelistbox->addColumn(i18n("Choices"),-1);
    choicelistbox->setMinimumSize(listviewsize);
    choiceboxlayout->addWidget(choicelistbox);
    buttonbox=new QGroupBox(2,Qt::Horizontal,QString::null,this,QString::null);
    choiceboxlayout->addWidget(buttonbox);
    okbutton=new QPushButton(i18n("Ok"),buttonbox);
    okbutton->setEnabled(FALSE);
    chancelbutton=new QPushButton(i18n("Cancel"),buttonbox);
    QPtrList<guessfilter>::Iterator index=choices->begin();
    //oad in all picture and set them
    KIconLoader *loader=new KIconLoader("KYamo");
    QString picname;
    picname="filter.png";
    filterpic=loader->loadIcon(picname,KIcon::NoGroup);
    filterpic=filterpic.smoothScale(16,16,QImage::ScaleFree);
    picname="wizard";
    newfilterpic=loader->loadIcon(picname,KIcon::NoGroup);
    newfilterpic=newfilterpic.smoothScale(16,16,QImage::ScaleFree);
    picname="ok.png";
    okpic=loader->loadIcon(picname,KIcon::NoGroup);
    QIconSet buttonset(okpic);
    okbutton->setIconSet(buttonset);
    picname="cancel.png";
    chancelpic=loader->loadIcon(picname,KIcon::NoGroup);
    buttonset=QIconSet(chancelpic);
    chancelbutton->setIconSet(buttonset);
    picname="messagebox_info.png";
    questionpic=loader->loadIcon(picname,KIcon::NoGroup);
    questionicon->setPixmap(questionpic);
    while(index!=choices->end())
    {
        //add all choices into listview
        QListViewItem *actualitem=new QListViewItem(choicelistbox,(*index)->filtertext);
        actualitem->setPixmap(0,filterpic);
        index++;
    }
    QListViewItem *actualitem=new QListViewItem(choicelistbox,"   --- new filter ---   ");
    actualitem->setPixmap(0,newfilterpic);
    this->show();
    connect (okbutton,SIGNAL(clicked()),SLOT(okslot()));
    connect (chancelbutton,SIGNAL(clicked()),SLOT(chancelslot()));
    connect (choicelistbox,SIGNAL(selectionChanged()),SLOT(activateok()));
}

choicebox2::~ choicebox2()
{
    cerr<<"choicebox2 destructor"<<endl;
    delete infotext;
    delete questionicon;
    delete infobox;
    delete okbutton;
    delete chancelbutton;
    delete buttonbox;
    delete choicelistbox;
    delete choiceboxlayout;
}

void choicebox2::activateok()
{
    if (choicelistbox->selectedItem())
    {
        selected=choicelistbox->selectedItem()->text(0);
        okbutton->setEnabled(TRUE);
    }
    else
    {
        selected=QString::null;
        okbutton->setEnabled(FALSE);
    }
}

void choicebox2::okslot()
{
    emit stringselected(selected);
}

void choicebox2::chancelslot()
{
    emit dialogcancelled();
}

void choicebox2::closeEvent(QCloseEvent *ce)
{
    ce->ignore();//we remove window on our own
    emit dialogcancelled();
}

